/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class OrderDetaile {
    private long OrderDetailsID;
    private long OrderID;
    private Date CreateTime;
    private Date StartTime;
    private Date FinishTime;
    private long ProductDepartmentID;
    private Date PreparationTime;
    private double Quantity;
    private double Price;
    private double Discount;
    private double PriceWithDiscount;
    private String Name;
    private Date preostaloVreme;
    private long ParentOrderDetaileID;
    private boolean additional = false;
    private boolean descriptional = false;

    public long getOrderDetailsID() {
        return this.OrderDetailsID;
    }

    public void setOrderDetailsID(long orderDetailsID) {
        this.OrderDetailsID = orderDetailsID;
    }

    public long getOrderID() {
        return this.OrderID;
    }

    public void setOrderID(long orderID) {
        this.OrderID = orderID;
    }

    public Date getCreateTime() {
        return this.CreateTime;
    }

    public void setCreateTime(Date createTime) {
        this.CreateTime = createTime;
    }

    public Date getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(Date startTime) {
        this.StartTime = startTime;
    }

    public Date getFinishTime() {
        return this.FinishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.FinishTime = finishTime;
    }

    public long getProductDepartmentID() {
        return this.ProductDepartmentID;
    }

    public void setProductDepartmentID(long productDepartmentID) {
        this.ProductDepartmentID = productDepartmentID;
    }

    public Date getPreparationTime() {
        return this.PreparationTime;
    }

    public void setPreparationTime(Date preparationTime) {
        this.PreparationTime = preparationTime;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public Date getPreostaloVreme() {
        return this.preostaloVreme;
    }

    public void setPreostaloVreme(Date preostaloVreme) {
        this.preostaloVreme = preostaloVreme;
    }

    public long getParentOrderDetaileID() {
        return this.ParentOrderDetaileID;
    }

    public void setParentOrderDetaileID(long parentOrderDetaileID) {
        this.ParentOrderDetaileID = parentOrderDetaileID;
    }

    public boolean isDescriptional() {
        return this.descriptional;
    }

    public void setDescriptional(boolean descriptional) {
        this.descriptional = descriptional;
    }

    public boolean isAdditional() {
        return this.additional;
    }

    public void setAdditional(boolean additional) {
        this.additional = additional;
    }

    public long insert(Connection connection) throws SQLException {
        long result = -1L;
        String query = "insert into orderdetails(OrderID,CreateTime,ProductDepartmentID,\t\t\t\t\t\t Quantity,Price,Discount,PriceWithDiscount, ParentOrderDetaileID) values(?,now(),?,?,?,?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.OrderID);
        ps.setLong(2, this.ProductDepartmentID);
        ps.setDouble(3, this.Quantity);
        ps.setDouble(4, this.Price);
        ps.setDouble(5, this.Discount);
        ps.setDouble(6, this.PriceWithDiscount);
        if (this.ParentOrderDetaileID > 0L) {
            ps.setDouble(7, this.ParentOrderDetaileID);
        } else {
            ps.setNull(7, -5);
        }
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.OrderDetailsID = result = rs.getLong(1);
        ps.close();
        rs.close();
        return result;
    }

    public static ObservableList<OrderDetaile> getList(long orderId, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select od.*,p.Name, pd.PreparationTime  from orderdetails od  left join productdepartment pd on pd.ProductDepartmentID = od.ProductDepartmentID  left join product p on pd.ProductID = p.ProductID where OrderID = ? and pd.KitchenDisplayID =?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, orderId);
            ps.setInt(2, controller.getSettings().getKitchenMonitorId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OrderDetaile orderDetaile = new OrderDetaile();
                orderDetaile.setOrderDetailsID(rs.getLong("OrderDetailsID"));
                orderDetaile.setOrderID(rs.getLong("OrderID"));
                orderDetaile.setCreateTime(rs.getTimestamp("CreateTime"));
                orderDetaile.setStartTime(rs.getTimestamp("StartTime"));
                orderDetaile.setFinishTime(rs.getTimestamp("FinishTime"));
                orderDetaile.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                orderDetaile.setQuantity(rs.getDouble("Quantity"));
                orderDetaile.setPrice(rs.getDouble("Price"));
                orderDetaile.setDiscount(rs.getDouble("Discount"));
                orderDetaile.setPriceWithDiscount(rs.getDouble("PriceWithDiscount"));
                orderDetaile.setParentOrderDetaileID(rs.getLong("ParentOrderDetaileID"));
                orderDetaile.setAdditional(orderDetaile.getParentOrderDetaileID() > 0L);
                if (!orderDetaile.isAdditional()) {
                    orderDetaile.setName(rs.getString("Name"));
                }
                if (orderDetaile.isAdditional()) {
                    orderDetaile.setName(" - " + rs.getString("Name"));
                }
                orderDetaile.setPreparationTime(rs.getTime("PreparationTime"));
                orderDetaile.setPreostaloVreme(rs.getTime("PreparationTime"));
                list.add((Object)orderDetaile);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<OrderDetaile> getListFP(long orderId, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select od.*,p.Name, pd.PreparationTime  from orderdetails od  left join productdepartment pd on pd.ProductDepartmentID = od.ProductDepartmentID  left join product p on pd.ProductID = p.ProductID where OrderID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, orderId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                OrderDetaile orderDetaile = new OrderDetaile();
                orderDetaile.setOrderDetailsID(rs.getLong("OrderDetailsID"));
                orderDetaile.setOrderID(rs.getLong("OrderID"));
                orderDetaile.setCreateTime(rs.getTimestamp("CreateTime"));
                orderDetaile.setStartTime(rs.getTimestamp("StartTime"));
                orderDetaile.setFinishTime(rs.getTimestamp("FinishTime"));
                orderDetaile.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                orderDetaile.setQuantity(rs.getDouble("Quantity"));
                orderDetaile.setPrice(rs.getDouble("Price"));
                orderDetaile.setDiscount(rs.getDouble("Discount"));
                orderDetaile.setPriceWithDiscount(rs.getDouble("PriceWithDiscount"));
                orderDetaile.setParentOrderDetaileID(rs.getLong("ParentOrderDetaileID"));
                orderDetaile.setAdditional(orderDetaile.getParentOrderDetaileID() > 0L);
                if (!orderDetaile.isAdditional()) {
                    orderDetaile.setName(rs.getString("Name"));
                }
                if (orderDetaile.isAdditional()) {
                    orderDetaile.setName("> " + rs.getString("Name"));
                }
                orderDetaile.setPreparationTime(rs.getTime("PreparationTime"));
                orderDetaile.setPreostaloVreme(rs.getTime("PreparationTime"));
                list.add((Object)orderDetaile);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void start(Connection connection) throws SQLException {
        String query = "update orderdetails set StartTime = now() where OrderDetailsID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.OrderDetailsID);
        ps.executeUpdate();
        ps.close();
    }

    public void finish(Connection connection) throws SQLException {
        String query = "update orderdetails set FinishTime = now() where OrderDetailsID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.OrderDetailsID);
        ps.executeUpdate();
        ps.close();
    }
}

