/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.document.OrderDetaile;

public class Order {
    private long OrderID;
    private int SaleTableID;
    private long DocumentID;
    long sysUserAddID;

    public Order() {
    }

    public Order(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getOrderID() {
        return this.OrderID;
    }

    public void setOrderID(long orderID) {
        this.OrderID = orderID;
    }

    public int getSaleTableID() {
        return this.SaleTableID;
    }

    public void setSaleTableID(int saleTableID) {
        this.SaleTableID = saleTableID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long insert(Connection connection) throws SQLException {
        long result = -1L;
        String query = "insert into `order`(SaleTableID,DocumentID,sysUserAddID) values (?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        if (this.SaleTableID > 1) {
            ps.setInt(1, this.SaleTableID);
        } else {
            ps.setNull(1, 4);
        }
        if (this.DocumentID > 1L) {
            ps.setLong(2, this.DocumentID);
        } else {
            ps.setNull(2, -5);
        }
        ps.setLong(3, this.sysUserAddID);
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.OrderID = result = rs.getLong(1);
        ps.close();
        rs.close();
        return result;
    }

    public static long insertOrder(Round round, long documentID, ScreensController controller) throws SQLException {
        Order order = new Order(controller.getUser().getUserID());
        order.setDocumentID(documentID);
        long orderId = order.insert(controller.getSettings().getConnection());
        for (RoundItem ri : round.getItemList()) {
            if (ri.getProductDepartment().getKitchenDisplayID() <= 0) continue;
            OrderDetaile od = new OrderDetaile();
            od.setOrderID(orderId);
            od.setProductDepartmentID(ri.getProductDepartment().getProductDepartmentID());
            od.setQuantity(ri.getQuantity());
            od.setPrice(ri.getProductDepartment().getProduct().getPrice());
            od.setDiscount(ri.getProductDepartment().getProduct().getDiscount());
            od.setPriceWithDiscount(ri.getProductDepartment().getProduct().getPrice() + ri.getProductDepartment().getProduct().getDiscount());
            od.insert(controller.getSettings().getConnection());
            for (RoundItem radd : ri.getAdditionalList()) {
                OrderDetaile odA = new OrderDetaile();
                odA.setAdditional(true);
                odA.setOrderID(orderId);
                odA.setProductDepartmentID(radd.getProductDepartment().getProductDepartmentID());
                odA.setQuantity(radd.getQuantity());
                odA.setPrice(radd.getProductDepartment().getProduct().getPrice());
                odA.setDiscount(radd.getProductDepartment().getProduct().getDiscount());
                odA.setPriceWithDiscount(radd.getProductDepartment().getProduct().getPrice() + radd.getProductDepartment().getProduct().getDiscount());
                odA.setParentOrderDetaileID(od.getOrderDetailsID());
                odA.insert(controller.getSettings().getConnection());
            }
        }
        return orderId;
    }

    public static ArrayList<Order> getList(ScreensController controller) {
        ArrayList<Order> list = new ArrayList<Order>();
        String query = "select *   from `order` where OrderID in (select od.OrderID                     from orderdetails od                     inner join productdepartment pd on pd.ProductDepartmentID = od.ProductDepartmentID                    \t\t\t\t\t\t\t\t\t\t    and pd.KitchenDisplayID = ?\t\t\t\t\t where od.FinishTime is null )";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, controller.getSettings().getKitchenMonitorId());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Order order = new Order();
                order.setOrderID(rs.getLong("OrderID"));
                order.setSaleTableID(rs.getInt("SaleTableID"));
                order.setDocumentID(rs.getLong("DocumentID"));
                order.setSysUserAddID(rs.getLong("sysUserAddID"));
                list.add(order);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

