/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;

public class NalogZaIspravku {
    private long DocumentID;
    private int Number;
    private Date Date;
    private Date DateFrom;
    private int DepartmentID;
    private User user;
    private String bi;
    private String ibfm;
    private String firstLastName;
    private String jmbg;
    private String Note;
    private boolean locked;

    public NalogZaIspravku(long DocumentID, int Number2, Date Date2, int DepartmentID, String ibfm, String firstLastName, String jmbg, Date DateFrom, String bi, String Note, User user, boolean locked) {
        this.DocumentID = DocumentID;
        this.Number = Number2;
        this.Date = Date2;
        this.DepartmentID = DepartmentID;
        this.ibfm = ibfm;
        this.firstLastName = firstLastName;
        this.jmbg = jmbg;
        this.DateFrom = DateFrom;
        this.bi = bi;
        this.user = user;
        this.locked = locked;
    }

    public NalogZaIspravku() {
    }

    public void setNote(String note) {
        this.Note = note;
    }

    public String getNote() {
        return this.Note;
    }

    public void setBi(String bi) {
        this.bi = bi;
    }

    public String getBi() {
        return this.bi;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public Date getDateFrom() {
        return this.DateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.DateFrom = dateFrom;
    }

    public String getIbfm() {
        return this.ibfm;
    }

    public void setIbfm(String ibfm) {
        this.ibfm = ibfm;
    }

    public String getFirstLastName() {
        return this.firstLastName;
    }

    public void setFirstLastName(String firstLastName) {
        this.firstLastName = firstLastName;
    }

    public String getJmbg() {
        return this.jmbg;
    }

    public void setJmbg(String jmbg) {
        this.jmbg = jmbg;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public static ObservableList<NalogZaIspravku> getlist(Department department, Date dateFrom, Date dateTo, long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.DocumentID,d.Date,d.Number,d.DepartmentID, d.Note, d.Name, d.FullNumber, d.AlternativeFullNumber, d.JMBG, d.DateFrom, d.sysUserAddID, d.documentLocked  from document d  where d.DocumentTypeID = 22   and d.DepartmentID = ? and DATE(d.Date) BETWEEN ? and ? and (-1 = ? OR d.sysUserAddID = ?) order by d.Number desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ps.setDate(2, new java.sql.Date(dateFrom.getTime()));
            ps.setDate(3, new java.sql.Date(dateTo.getTime()));
            ps.setLong(4, userID);
            ps.setLong(5, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new NalogZaIspravku(rs.getLong("DocumentID"), rs.getInt("Number"), new Date(rs.getTimestamp("Date").getTime()), rs.getInt("DepartmentID"), rs.getString("AlternativeFullNumber"), rs.getString("Name"), rs.getString("JMBG"), new Date(rs.getTimestamp("DateFrom").getTime()), rs.getString("FullNumber"), rs.getString("Note"), User.getUserByID(rs.getLong("sysUserAddID"), connection), rs.getBoolean("documentLocked")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<NalogZaIspravku> getlist(int docTypeId, Department department, Date dateFrom, Date dateTo, long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.DocumentID,d.Date,d.Number,d.DepartmentID, d.Note, d.Name, d.FullNumber, d.AlternativeFullNumber, d.JMBG, d.DateFrom, d.sysUserAddID, d.documentLocked  from document d  where d.DocumentTypeID = ?   and d.DepartmentID = ? and DATE(d.Date) BETWEEN ? and ? and (-1 = ? OR d.sysUserAddID = ?) order by d.Number desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, docTypeId);
            ps.setInt(2, department.getDepartmentID());
            ps.setDate(3, new java.sql.Date(dateFrom.getTime()));
            ps.setDate(4, new java.sql.Date(dateTo.getTime()));
            ps.setLong(5, userID);
            ps.setLong(6, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new NalogZaIspravku(rs.getLong("DocumentID"), rs.getInt("Number"), new Date(rs.getTimestamp("Date").getTime()), rs.getInt("DepartmentID"), rs.getString("AlternativeFullNumber"), rs.getString("Name"), rs.getString("JMBG"), new Date(rs.getTimestamp("DateFrom").getTime()), rs.getString("FullNumber"), rs.getString("Note"), User.getUserByID(rs.getLong("sysUserAddID"), connection), rs.getBoolean("documentLocked")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long insert(ScreensController controller) throws SQLException {
        Department department = Department.getById(this.getDepartmentID(), controller.getSettings().getConnection());
        Document document = new Document();
        document.setDocumentTypeID(22);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setNumber(Document.getNextNumber(22, department, controller, LocalDate.now()));
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        document.setName(this.firstLastName);
        document.setJmbg(this.jmbg);
        document.setFullNumber(this.bi);
        document.setAlternativeFullNumber(this.ibfm);
        document.setDateFrom(this.DateFrom);
        this.DocumentID = document.insert(controller);
        return document.getDocumentID();
    }

    public long insertRefund(ScreensController controller, InvoiceBody body, InvoiceResponse response, ObservableList<DocumentDetails> refundItems, PaymentMethod payment, InvoiceType invoiceType) throws SQLException {
        Department department = Department.getById(1, controller.getSettings().getConnection());
        Document document = new Document();
        if (controller.getSettings().isTrainingMode()) {
            document.setDocumentTypeID(34);
            document.setNumber(Document.getNextNumber(34, department, controller, LocalDate.now()));
        } else if (invoiceType == InvoiceType.REFUND_PROFORMA) {
            document.setDocumentTypeID(35);
            document.setNumber(Document.getNextNumber(35, department, controller, LocalDate.now()));
        } else {
            document.setDocumentTypeID(22);
            document.setNumber(Document.getNextNumber(22, department, controller, LocalDate.now()));
        }
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(department.getDepartmentID());
        document.setNote("");
        double sumWithDiscount = 0.0;
        for (Item item : body.getItems()) {
            sumWithDiscount += item.getTotalAmount();
        }
        document.setSumWithDiscount(sumWithDiscount);
        document.setName("");
        document.setJmbg("");
        document.setFullNumber("");
        document.setAlternativeFullNumber("");
        document.setDateFrom(new Date());
        document.setReferentNumber(response.getInvoiceNumber());
        document.setReferentDateTime(response.getSdcDateTime());
        document.setBuyerIdentification(body.getBuyerId());
        document.setPaymentMethodID(payment.getPaymentMethodID());
        document.setCurrencyDate(new Date());
        if (controller.getPointOfSale() != null && controller.getPointOfSale().getPointOfSaleID() != 0) {
            document.setPointOfSaleID(controller.getPointOfSale().getPointOfSaleID());
        }
        this.DocumentID = document.insert(controller);
        for (DocumentDetails detail : refundItems) {
            for (Item item : body.getItems()) {
                if (!item.getName().equals(detail.getProductName()) || item.getQuantity() != detail.getQuantity()) continue;
                detail.setClosed(true);
            }
            detail.setDocumentID(this.DocumentID);
            detail.insert(controller.getSettings().getConnection());
        }
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDocumentTypeID(22);
        document.setDocumentStatusID(1);
        document.setDate(this.Date);
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        document.setName(this.firstLastName);
        document.setJmbg(this.jmbg);
        document.setFullNumber(this.bi);
        document.setAlternativeFullNumber(this.ibfm);
        document.setDateFrom(this.DateFrom);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        Document d = Document.getByID(this.DocumentID, connection);
        DocumentDetails.deleteDetailes(d, connection);
        Document.delete(this.DocumentID, connection);
    }

    public void updateDocument(ScreensController controller, long documentID) {
        String query = "update documentdetails set closed=true where DocumentID= ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, documentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

