/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class DocumentType {
    private int DocumentTypeID;
    private String Name;
    private String Code;
    private int FirstNumber;
    private int Year;
    private int Stock;
    private int Finance;

    public int getDocumentTypeID() {
        return this.DocumentTypeID;
    }

    public void setDocumentTypeID(int documentTypeID) {
        this.DocumentTypeID = documentTypeID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public int getFirstNumber() {
        return this.FirstNumber;
    }

    public void setFirstNumber(int firstNumber) {
        this.FirstNumber = firstNumber;
    }

    public int getYear() {
        return this.Year;
    }

    public void setYear(int year) {
        this.Year = year;
    }

    public int getStock() {
        return this.Stock;
    }

    public void setStock(int stock) {
        this.Stock = stock;
    }

    public int getFinance() {
        return this.Finance;
    }

    public void setFinance(int finance) {
        this.Finance = finance;
    }

    public String toString() {
        return this.Name;
    }

    public static ObservableList<DocumentType> getList(Connection connection) {
        String query = "select * from documenttype";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentType dt = new DocumentType();
                dt.DocumentTypeID = rs.getInt("DocumentTypeID");
                dt.Name = rs.getString("Name");
                dt.Code = rs.getString("Code");
                dt.FirstNumber = rs.getInt("FirstNumber");
                dt.Year = rs.getInt("Year");
                dt.Stock = rs.getInt("Stock");
                dt.Finance = rs.getInt("Finance");
                list.add((Object)dt);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static DocumentType getById(int id, Connection connection) {
        String query = "select * from documenttype where DocumentTypeID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            DocumentType dt = new DocumentType();
            dt.DocumentTypeID = rs.getInt("DocumentTypeID");
            dt.Name = rs.getString("Name");
            dt.Code = rs.getString("Code");
            dt.FirstNumber = rs.getInt("FirstNumber");
            dt.Year = rs.getInt("Year");
            dt.Stock = rs.getInt("Stock");
            dt.Finance = rs.getInt("Finance");
            ps.close();
            rs.close();
            return dt;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static DocumentType getByCode(String code, Connection connection) {
        String query = "select * from documenttype where Code = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            rs.next();
            DocumentType dt = new DocumentType();
            dt.DocumentTypeID = rs.getInt("DocumentTypeID");
            dt.Name = rs.getString("Name");
            dt.Code = rs.getString("Code");
            dt.FirstNumber = rs.getInt("FirstNumber");
            dt.Year = rs.getInt("Year");
            dt.Stock = rs.getInt("Stock");
            dt.Finance = rs.getInt("Finance");
            ps.close();
            rs.close();
            return dt;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE documenttype SET FirstNumber = ? WHERE Code = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.FirstNumber);
            pStatement.setString(2, this.Code);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insert(ScreensController controller, String name, String code, int firstNumber, int year, int stock, int finance) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`documenttype` (`Name`, `Code`, `FirstNumber`, `Year`, `Stock`, `Finance`) VALUES ('" + name + "', '" + code + "', " + firstNumber + ", " + year + ", " + stock + ", " + finance + ");";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<DocumentType> getListByCodes(String codes, Connection connection) {
        String query = "select * from documenttype where FIND_IN_SET(Code, ?)";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, codes);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DocumentType dt = new DocumentType();
                dt.DocumentTypeID = rs.getInt("DocumentTypeID");
                dt.Name = rs.getString("Name");
                dt.Code = rs.getString("Code");
                dt.FirstNumber = rs.getInt("FirstNumber");
                dt.Year = rs.getInt("Year");
                dt.Stock = rs.getInt("Stock");
                dt.Finance = rs.getInt("Finance");
                list.add((Object)dt);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

