/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;

public class DocumentRelationship {
    private long DocumentRelationshipID;
    private int RelationshipTypeID;
    private long DocumentParentID;
    private long DocumentChildID;
    private boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;

    public long getDocumentRelationshipID() {
        return this.DocumentRelationshipID;
    }

    public void setDocumentRelationshipID(long documentRelationshipID) {
        this.DocumentRelationshipID = documentRelationshipID;
    }

    public int getRelationshipTypeID() {
        return this.RelationshipTypeID;
    }

    public void setRelationshipTypeID(int relationshipTypeID) {
        this.RelationshipTypeID = relationshipTypeID;
    }

    public long getDocumentParentID() {
        return this.DocumentParentID;
    }

    public void setDocumentParentID(long documentParentID) {
        this.DocumentParentID = documentParentID;
    }

    public long getDocumentChildID() {
        return this.DocumentChildID;
    }

    public void setDocumentChildID(long documentChildID) {
        this.DocumentChildID = documentChildID;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public void insert(Connection connection) {
        String query = "INSERT INTO documentrelationship( \tRelationshipTypeID,DocumentParentID, \tDocumentChildID,\tActive,\tsysDTCreated,\tsysDTEdit,\tsysUserAddID,\tsysUserEditID) VALUES (?,?,?,?,?,?,?,?);";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.RelationshipTypeID);
            ps.setLong(2, this.DocumentParentID);
            if (this.DocumentChildID != 0L) {
                ps.setLong(3, this.DocumentChildID);
            } else {
                ps.setNull(3, -5);
            }
            ps.setBoolean(4, this.Active);
            try {
                ps.setTimestamp(5, new Timestamp(this.sysDTCreated.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(5, new Timestamp(new Date().getTime()));
            }
            try {
                ps.setTimestamp(6, new Timestamp(this.sysDTEdit.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(6, 93);
            }
            ps.setLong(7, this.sysUserAddID);
            if (this.sysUserEditID != 0L) {
                ps.setLong(8, this.sysUserEditID);
            } else {
                ps.setNull(8, -5);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static long getChildID(long childId, ScreensController controller) {
        long broj = 0L;
        String query = "SELECT dr.DocumentChildID FROM documentrelationship dr WHERE dr.DocumentParentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, childId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            broj = rSet.getLong("DocumentChildID");
            pStatement.close();
            rSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return broj;
    }

    public static long getChildID(long childId, Connection connection) {
        long broj = 0L;
        String query = "SELECT dr.DocumentChildID FROM documentrelationship dr WHERE dr.DocumentParentID = ?";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, childId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            broj = rSet.getLong("DocumentChildID");
            pStatement.close();
            rSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return broj;
    }

    public static ObservableList<Long> getParentIDList(long childId, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT dr.DocumentParentID FROM documentrelationship dr WHERE dr.DocumentChildID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, childId);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                list.add((Object)rSet.getLong("DocumentParentID"));
            }
            pStatement.close();
            rSet.close();
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static long getParentID(long childId, ScreensController controller) {
        long broj = 0L;
        String query = "SELECT dr.DocumentParentID FROM documentrelationship dr WHERE dr.DocumentChildID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, childId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            broj = rSet.getLong("DocumentParentID");
            pStatement.close();
            rSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return broj;
    }

    public static long getParentID(long childId, Connection connection) {
        long broj = 0L;
        String query = "SELECT dr.DocumentParentID FROM documentrelationship dr WHERE dr.DocumentChildID = ?";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setLong(1, childId);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            broj = rSet.getLong("DocumentParentID");
            pStatement.close();
            rSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return broj;
    }

    public static void deleteByChildID(Document childID, ScreensController controller) {
        String query = "DELETE dr FROM documentrelationship dr WHERE dr.DocumentChildID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, childID.getDocumentID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAll(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dr FROM documentrelationship dr LEFT JOIN document d ON d.DocumentID = dr.DocumentParentID WHERE d.Date < ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllBills(WorkDay wDay, ScreensController controller) {
        String query = "DELETE dr FROM documentrelationship dr LEFT JOIN document d ON d.DocumentID = dr.DocumentParentID WHERE d.Date < ? AND d.DocumentTypeID IN (3,4,17)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

