/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Logger;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.User;

public class DocumentCorrection {
    private static final Logger LOGGER = Logger.getLogger("global");
    private long DocumentCorrectionID;
    private int CorrectionTypeID;
    private String FiscalPrinterID;
    private Date Date;
    private long DoucmentID;
    private long WorkDayID;
    private long UserCreated;
    private String ReciptNumber;
    private Date PrintTime;
    private long UserPrinted;
    private Date MoveTime;
    private long UserMoved;
    private long NewWorkDayID;

    public long getDocumentCorrectionID() {
        return this.DocumentCorrectionID;
    }

    public void setDocumentCorrectionID(long documentCorrectionID) {
        this.DocumentCorrectionID = documentCorrectionID;
    }

    public int getCorrectionTypeID() {
        return this.CorrectionTypeID;
    }

    public void setCorrectionTypeID(int correctionTypeID) {
        this.CorrectionTypeID = correctionTypeID;
    }

    public String getFiscalPrinterID() {
        return this.FiscalPrinterID;
    }

    public void setFiscalPrinterID(String fiscalPrinterID) {
        this.FiscalPrinterID = fiscalPrinterID;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public long getDoucmentID() {
        return this.DoucmentID;
    }

    public void setDoucmentID(long doucmentID) {
        this.DoucmentID = doucmentID;
    }

    public long getWorkDayID() {
        return this.WorkDayID;
    }

    public void setWorkDayID(long workDayID) {
        this.WorkDayID = workDayID;
    }

    public long getUserCreated() {
        return this.UserCreated;
    }

    public void setUserCreated(long userCreated) {
        this.UserCreated = userCreated;
    }

    public String getReciptNumber() {
        return this.ReciptNumber;
    }

    public void setReciptNumber(String reciptNumber) {
        this.ReciptNumber = reciptNumber;
    }

    public Date getPrintTime() {
        return this.PrintTime;
    }

    public void setPrintTime(Date printTime) {
        this.PrintTime = printTime;
    }

    public long getUserPrinted() {
        return this.UserPrinted;
    }

    public void setUserPrinted(long userPrinted) {
        this.UserPrinted = userPrinted;
    }

    public Date getMoveTime() {
        return this.MoveTime;
    }

    public void setMoveTime(Date moveTime) {
        this.MoveTime = moveTime;
    }

    public long getUserMoved() {
        return this.UserMoved;
    }

    public void setUserMoved(long userMoved) {
        this.UserMoved = userMoved;
    }

    public long getNewWorkDayID() {
        return this.NewWorkDayID;
    }

    public void setNewWorkDayID(long newWorkDayID) {
        this.NewWorkDayID = newWorkDayID;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public long insert(User user, Connection connection) throws SQLException {
        String query = "insert into documentcorrection(\tCorrectionTypeID,\tFiscalPrinterID,\tDate,\tDoucmentID,\tWorkDayID,\tUserCreated,\tReciptNumber,\tPrintTime,\tUserPrinted,\tMoveTime,\tUserMoved,\tNewWorkDayID) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.CorrectionTypeID);
        ps.setString(2, this.FiscalPrinterID);
        ps.setTimestamp(3, new Timestamp(this.Date.getTime()));
        ps.setLong(4, this.DoucmentID);
        ps.setLong(5, this.WorkDayID);
        ps.setLong(6, this.UserCreated);
        ps.setString(7, this.ReciptNumber);
        if (this.PrintTime != null) {
            ps.setTimestamp(8, new Timestamp(this.PrintTime.getTime()));
        } else {
            ps.setNull(8, 93);
        }
        if (this.UserPrinted > 0L) {
            ps.setLong(9, this.UserPrinted);
        } else {
            ps.setNull(9, -5);
        }
        if (this.MoveTime != null) {
            ps.setTimestamp(10, new Timestamp(this.MoveTime.getTime()));
        } else {
            ps.setNull(10, 93);
        }
        if (this.UserMoved > 0L) {
            ps.setLong(11, this.UserMoved);
        } else {
            ps.setNull(11, -5);
        }
        if (this.NewWorkDayID > 0L) {
            ps.setLong(12, this.NewWorkDayID);
        } else {
            ps.setNull(12, -5);
        }
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        if (rs.next()) {
            this.DocumentCorrectionID = rs.getLong(1);
        }
        switch (this.CorrectionTypeID) {
            case 1: {
                Log.writeLog(user, "Dodavanje ra\u010duna u bazu. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Dodavanje ra\u010duna u bazu. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
                break;
            }
            case 2: {
                Log.writeLog(user, "Ponovljena \u0161tampa fiskalnog ra\u010duna. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Ponovljena \u0161tampa fiskalnog ra\u010duna. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
                break;
            }
            case 3: {
                Log.writeLog(user, "Prenos ra\u010duna na otvoren dan. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Prenos ra\u010duna na otvoren dan. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
            }
        }
        rs.close();
        ps.close();
        return this.DocumentCorrectionID;
    }

    public void update(User user, Connection connection) throws SQLException {
        String query = "update documentcorrection set \tCorrectionTypeID = ?,\tFiscalPrinterID = ?,\tDate = ?,\tDoucmentID = ?,\tWorkDayID = ?,\tUserCreated = ?,\tReciptNumber = ?,\tPrintTime = ?,\tUserPrinted = ?,\tMoveTime = ?,\tUserMoved = ?,\tNewWorkDayID = ? where DocumentCorrectionID = ?";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.CorrectionTypeID);
        ps.setString(2, this.FiscalPrinterID);
        ps.setTimestamp(3, new Timestamp(this.Date.getTime()));
        ps.setLong(4, this.DoucmentID);
        ps.setLong(5, this.WorkDayID);
        ps.setLong(6, this.UserCreated);
        ps.setString(7, this.ReciptNumber);
        if (this.PrintTime != null) {
            ps.setTimestamp(8, new Timestamp(this.PrintTime.getTime()));
        } else {
            ps.setNull(8, 93);
        }
        if (this.UserPrinted > 0L) {
            ps.setLong(9, this.UserPrinted);
        } else {
            ps.setNull(9, -5);
        }
        if (this.MoveTime != null) {
            ps.setTimestamp(10, new Timestamp(this.MoveTime.getTime()));
        } else {
            ps.setNull(10, 93);
        }
        if (this.UserMoved > 0L) {
            ps.setLong(11, this.UserMoved);
        } else {
            ps.setNull(11, -5);
        }
        if (this.NewWorkDayID > 0L) {
            ps.setLong(12, this.NewWorkDayID);
        } else {
            ps.setNull(12, -5);
        }
        ps.setLong(13, this.DocumentCorrectionID);
        ps.executeUpdate();
        ps.close();
        switch (this.CorrectionTypeID) {
            case 1: {
                Log.writeLog(user, "Dodavanje ra\u010duna u bazu. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Dodavanje ra\u010duna u bazu. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
                break;
            }
            case 2: {
                Log.writeLog(user, "Ponovljena \u0161tampa fiskalnog ra\u010duna. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Ponovljena \u0161tampa fiskalnog ra\u010duna. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
                break;
            }
            case 3: {
                Log.writeLog(user, "Prenos ra\u010duna na otvoren dan. DocumentCorrectionID=" + this.DocumentCorrectionID, connection);
                LOGGER.info("Prenos ra\u010duna na otvoren dan. DocumentCorrectionID=" + this.DocumentCorrectionID + ", Korisnik: " + user.getUserName());
            }
        }
    }

    public static DocumentCorrection getDocument(long documentID, Connection connection) {
        String query = "select * from documentcorrection dc where dc.DoucmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, documentID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                DocumentCorrection dc = new DocumentCorrection();
                dc.DocumentCorrectionID = rs.getLong("DocumentCorrectionID");
                dc.CorrectionTypeID = rs.getInt("CorrectionTypeID");
                dc.FiscalPrinterID = rs.getString("FiscalPrinterID");
                dc.Date = rs.getTimestamp("Date");
                dc.DoucmentID = rs.getLong("DoucmentID");
                dc.WorkDayID = rs.getLong("WorkDayID");
                dc.UserCreated = rs.getLong("UserCreated");
                dc.ReciptNumber = rs.getString("ReciptNumber");
                dc.PrintTime = rs.getTimestamp("PrintTime");
                dc.UserPrinted = rs.getLong("UserPrinted");
                dc.MoveTime = rs.getTimestamp("MoveTime");
                dc.UserMoved = rs.getLong("UserMoved");
                dc.NewWorkDayID = rs.getLong("NewWorkDayID");
                return dc;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

