/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;

public class WorkDayClosing {
    private Connection connection;
    private WorkDay wd;
    private User user;
    private PointOfSale pos;

    public WorkDayClosing(ScreensController controller, WorkDay wd) {
        this.connection = controller.getSettings().getConnection();
        this.user = controller.getUser();
        this.pos = controller.getPointOfSale();
        this.wd = wd;
    }

    public void checkClosedDays() {
        Date wdDate = this.wd.getDate();
        Date openDate = this.getOpeningDate(wdDate, false);
        Date closeDate = this.getClosingDate(openDate);
        Date refDate = this.getOpeningDate(new Date(), true);
        while (openDate.before(refDate)) {
            this.openAndCloseWorkDay(openDate, closeDate);
            openDate = this.getOpeningDate(closeDate, false);
            closeDate = this.getClosingDate(openDate);
        }
        this.openWorkDay(openDate);
    }

    public void closeWorkDay() {
        Date closingDate = this.getClosingDate(this.wd.getDate());
        Timestamp closing = new Timestamp(closingDate.getTime());
        String query = "UPDATE workday wd SET wd.DateTo = ?, wd.sysUserEditID = ? WHERE\r\nwd.WorkDayID = ? AND wd.PointOfSaleID = ?";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setTimestamp(1, closing);
            ps.setLong(2, this.user.getUserID());
            ps.setLong(3, this.wd.getWorkDayID());
            ps.setInt(4, this.pos.getPointOfSaleID());
            ps.execute();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ps.close();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void openAndCloseWorkDay(Date openDate, Date closeDate) {
        java.sql.Date openingDateSql = new java.sql.Date(openDate.getTime());
        Timestamp opDate = new Timestamp(openDate.getTime());
        Timestamp clDate = new Timestamp(closeDate.getTime());
        String query = "insert into workday(PointOfSaleId,Date,DateFrom,DateTo,sysUserAddID,sysUserEditId)  values(?,?,?,?,?,?)";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.pos.getPointOfSaleID());
            ps.setDate(2, openingDateSql);
            ps.setTimestamp(3, opDate);
            ps.setTimestamp(4, clDate);
            ps.setLong(5, this.user.getUserID());
            ps.setLong(6, this.user.getUserID());
            ps.execute();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ps.close();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void openWorkDay(Date openDate) {
        java.sql.Date openingDateSql = new java.sql.Date(openDate.getTime());
        Timestamp openingDateFrom = new Timestamp(openDate.getTime());
        String query = "insert into workday(PointOfSaleId,Date,DateFrom,sysUserAddID)  values(?,?,?,?)";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.pos.getPointOfSaleID());
            ps.setDate(2, openingDateSql);
            ps.setTimestamp(3, openingDateFrom);
            ps.setLong(4, this.user.getUserID());
            ps.execute();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ps.close();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private Date getClosingDate(Date closingDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(closingDate);
        calendar.set(14, 0);
        calendar.set(13, 59);
        calendar.set(12, 59);
        calendar.set(11, 23);
        return calendar.getTime();
    }

    private Date getOpeningDate(Date openingDate, boolean now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(openingDate);
        if (!now) {
            calendar.add(5, 1);
        }
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }
}

