/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Unit {
    private int unitID;
    private String code;
    private String name;
    private boolean measurable;

    public int getUnitID() {
        return this.unitID;
    }

    public void setUnitID(int unitID) {
        this.unitID = unitID;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMeasurable() {
        return this.measurable;
    }

    public void setMeasurable(boolean measurable) {
        this.measurable = measurable;
    }

    public String toString() {
        return this.name;
    }

    public static ObservableList<Unit> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from unit order by Name";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Unit u = new Unit();
                u.setUnitID(rs.getInt("UnitID"));
                u.setCode(rs.getString("Code"));
                u.setName(rs.getString("Name"));
                u.setMeasurable(rs.getBoolean("Measurable"));
                list.add((Object)u);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Unit getUnitById(int unitID, Connection connection) {
        String query = "select * from unit u where u.UnitID = ?";
        Unit u = null;
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, unitID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            u = new Unit();
            u.setUnitID(rs.getInt("UnitID"));
            u.setCode(rs.getString("Code"));
            u.setName(rs.getString("Name"));
            u.setMeasurable(rs.getBoolean("Measurable"));
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return u;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`unit` (`Code`, `Name`, `Measurable`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.code);
            pStatement.setString(2, this.name);
            pStatement.setBoolean(3, this.measurable);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`unit` SET `Code`= ?, `Name`= ?, `Measurable`= ? WHERE  `UnitID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.code);
            pStatement.setString(2, this.name);
            pStatement.setBoolean(3, this.measurable);
            pStatement.setInt(4, this.unitID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`unit` WHERE  `UnitID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.unitID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

