/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import rs.petcom.enums.TerminalDataRow;

public class TerminalData {
    private final String fileName = "setup.cnf";

    public void checkAndAdjustTerminalData(TerminalDataRow[] missingContent) {
        String key = "";
        String value = "";
        try {
            for (TerminalDataRow row : missingContent) {
                key = row.getKey();
                value = row.getValue();
                if (!this.fileDoesNotContainsKey(key)) continue;
                String newContent = this.appendMissingContent(key, value);
                this.writeNewContentToFile(newContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean fileDoesNotContainsKey(String key) throws IOException {
        String line = "";
        FileInputStream fis = new FileInputStream("setup.cnf");
        InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            String[] splitted_line = this.getSplitedLine(line, "=");
            if (!this.keyExsists(splitted_line, key)) continue;
            br.close();
            return false;
        }
        br.close();
        return true;
    }

    private String appendMissingContent(String key, String value) throws IOException {
        StringBuilder sb = new StringBuilder();
        String fileContent = this.getFileContent();
        String missingContent = this.getMissingContent(key, value);
        sb.append(fileContent);
        sb.append(missingContent);
        return sb.toString();
    }

    private String getFileContent() throws IOException {
        String line = "";
        StringBuilder sb = new StringBuilder();
        FileInputStream fis = new FileInputStream("setup.cnf");
        InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        br.close();
        return sb.toString();
    }

    private String getMissingContent(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append("=");
        sb.append(value);
        sb.append("\r\n");
        return sb.toString();
    }

    private void writeNewContentToFile(String newContent) throws IOException {
        FileOutputStream os = new FileOutputStream("setup.cnf");
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(newContent);
        bw.close();
    }

    private boolean keyExsists(String[] splitted_line, String key) {
        return splitted_line[0].toLowerCase().equals(key.toLowerCase());
    }

    private String[] getSplitedLine(String line, String splitter) {
        return line.split(splitter);
    }
}

