/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Synchronization {
    private long synchronizationId;
    private String databaseName;
    private String ipAddress;
    private boolean active;

    public String toString() {
        return this.databaseName;
    }

    public long getSynchronizationId() {
        return this.synchronizationId;
    }

    public void setSynchronizationId(long synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static ObservableList<Synchronization> getList(ScreensController controller) {
        String query = "SELECT s.* FROM synchronization s ";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Synchronization synchronization = new Synchronization();
                synchronization.setSynchronizationId(rSet.getLong("SynchronizationID"));
                synchronization.setDatabaseName(rSet.getString("DatabaseName"));
                synchronization.setIpAddress(rSet.getString("IpAddress"));
                synchronization.setActive(rSet.getBoolean("Active"));
                list.add((Object)synchronization);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`synchronization` (`DatabaseName`, `IpAddress`, `Active`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.databaseName);
            pStatement.setString(2, this.ipAddress);
            pStatement.setBoolean(3, this.active);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`synchronization` SET `DatabaseName` = ?, `IpAddress` = ?, `Active` = ? WHERE  `SynchronizationID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.databaseName);
            pStatement.setString(2, this.ipAddress);
            pStatement.setBoolean(3, this.active);
            pStatement.setLong(4, this.synchronizationId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

