/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.product.Product;

public class Protel {
    private boolean success;
    private String ipAddress;

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void sendPOSTCloseInvoiceFromTMaster(Document document, ScreensController controller) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(document.getDate()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + new PointOfSale(document.getPointOfSaleID(), controller.getSettings().getConnection()).getCode() + "</Outlet>\r\n\t<User>" + String.valueOf(document.getSysUserAddID()) + "</User>\r\n\t<Invoice>" + document.getFullNumber() + "</Invoice>\r\n";
        for (DocumentDetails ddDetails : DocumentDetails.getObeservableList(document.getDocumentID(), controller.getSettings().getConnection())) {
            Product product = Product.getByID(ddDetails.getProductID(), controller);
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(ddDetails.getQuantity() * ddDetails.getPriceWithDiscount()) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + product.getShortName() + "</Text>\r\n\t\t<Productgroup>" + String.valueOf(1) + "</Productgroup>\r\n\t\t<TaxClassification>" + String.valueOf(ddDetails.getVatID()) + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(ddDetails.getPriceWithDiscount()) + "</SingleAmount>\r\n\t\t<Quantity>" + ddDetails.getQuantity() + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(document.getSumWithDiscount()) + "</TotalAmount>\r\n\t\t<Type>Payment</Type>\r\n\t\t<Payment>" + String.valueOf(document.getPaymentMethodID()) + "</Payment>\r\n\t</Item>\r\n</Body>";
        try {
            System.out.println(inputXML);
            System.out.println("http://" + this.ipAddress + "/CloseInvoice");
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", new PointOfSale(document.getPointOfSaleID(), controller.getSettings().getConnection()).getCode());
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void sendPOSTCloseInvoiceStorno(Document document, ScreensController controller) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(document.getDate()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + new PointOfSale(document.getPointOfSaleID(), controller.getSettings().getConnection()).getCode() + "</Outlet>\r\n\t<User>" + String.valueOf(document.getSysUserAddID()) + "</User>\r\n\t<Invoice>" + document.getNumber() + "</Invoice>\r\n";
        for (DocumentDetails ddDetails : DocumentDetails.getObeservableList(document.getDocumentID(), controller.getSettings().getConnection())) {
            Product product = Product.getByID(ddDetails.getProductID(), controller);
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(ddDetails.getQuantity() * ddDetails.getPriceWithDiscount() * -1.0) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + product.getShortName() + "</Text>\r\n\t\t<Productgroup>" + String.valueOf(1) + "</Productgroup>\r\n\t\t<TaxClassification>" + String.valueOf(ddDetails.getVatID()) + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(ddDetails.getPriceWithDiscount()) + "</SingleAmount>\r\n\t\t<Quantity>" + ddDetails.getQuantity() * -1.0 + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(document.getSumWithDiscount() * -1.0) + "</TotalAmount>\r\n\t\t<Type>Payment</Type>\r\n\t\t<Payment>" + String.valueOf(document.getPaymentMethodID()) + "</Payment>\r\n\t</Item>\r\n</Body>";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", new PointOfSale(document.getPointOfSaleID(), controller.getSettings().getConnection()).getCode());
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }
}

