/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Printer {
    private int PrinterID;
    private String Name;
    private String ServerName;
    private int Paperwidth;
    private boolean Wraptext;
    private String SystemPrinterName;
    private boolean Active;
    private int Copies;
    private int Codepage;
    private String Path;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private int numOfCharacters;

    public int getPrinterID() {
        return this.PrinterID;
    }

    public void setPrinterID(int printerID) {
        this.PrinterID = printerID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getServerName() {
        return this.ServerName;
    }

    public void setServerName(String serverName) {
        this.ServerName = serverName;
    }

    public int getPaperwidth() {
        return this.Paperwidth;
    }

    public void setPaperwidth(int paperwidth) {
        this.Paperwidth = paperwidth;
    }

    public boolean isWraptext() {
        return this.Wraptext;
    }

    public void setWraptext(boolean wraptext) {
        this.Wraptext = wraptext;
    }

    public String getSystemPrinterName() {
        return this.SystemPrinterName;
    }

    public void setSystemPrinterName(String systemPrinterName) {
        this.SystemPrinterName = systemPrinterName;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public int getCopies() {
        return this.Copies;
    }

    public void setCopies(int copies) {
        this.Copies = copies;
    }

    public int getCodepage() {
        return this.Codepage;
    }

    public void setCodepage(int codepage) {
        this.Codepage = codepage;
    }

    public String getPath() {
        return this.Path;
    }

    public void setPath(String path) {
        this.Path = path;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public String toString() {
        return this.Name;
    }

    public int getNumOfCharacters() {
        return this.numOfCharacters;
    }

    public void setNumOfCharacters(int numOfCharacters) {
        this.numOfCharacters = numOfCharacters;
    }

    public static ObservableList<Printer> getAllActivePrinter(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM printer WHERE Active IS NOT NULL";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Printer p = new Printer();
                p.PrinterID = rs.getInt("PrinterId");
                p.Name = rs.getString("Name");
                p.ServerName = rs.getString("ServerName");
                p.Paperwidth = rs.getInt("Paperwidth");
                p.Wraptext = rs.getBoolean("Wraptext");
                p.SystemPrinterName = rs.getString("SystemPrinterName");
                p.Active = rs.getBoolean("Active");
                p.Copies = rs.getInt("Copies");
                p.Codepage = rs.getInt("Codepage");
                p.Path = rs.getString("path");
                p.sysDTCreated = rs.getDate("sysDTCreated");
                p.sysDTEdit = rs.getDate("sysDTEdit");
                p.sysUserAddID = rs.getLong("sysUserAddID");
                p.sysUserEditID = rs.getLong("sysUserEditID");
                p.numOfCharacters = rs.getInt("numOfCharacters");
                list.add((Object)p);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Printer> getProductToPrinter(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT p.*  FROM printer p JOIN producttoprinter ptp ON ptp.Printer = p.PrinterID WHERE ptp.Product = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Printer p = new Printer();
                p.PrinterID = rs.getInt(1);
                p.Name = rs.getString(2);
                p.ServerName = rs.getString(3);
                p.Paperwidth = rs.getInt(4);
                p.Wraptext = rs.getBoolean(5);
                p.SystemPrinterName = rs.getString(6);
                p.Active = rs.getBoolean(7);
                p.Copies = rs.getInt(8);
                p.Codepage = rs.getInt(9);
                p.Path = rs.getString(10);
                p.sysDTCreated = rs.getDate(11);
                p.sysDTEdit = rs.getDate(12);
                p.sysUserAddID = rs.getLong(13);
                p.sysUserEditID = rs.getLong(14);
                list.add((Object)p);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insertPrinter(Connection connection) {
        String query = "INSERT INTO printer (`PrinterId`,`Name`, `ServerName`, `Active`, `Copies`, `sysDTCreated`, `sysUserAddID`,`numOfCharacters`,`Paperwidth`) VALUES (1, ?, ?, ?, ?, now(), 1,?,?);";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setString(1, this.Name);
            ps.setString(2, this.ServerName);
            ps.setBoolean(3, this.Active);
            if (this.Copies == 0) {
                ps.setInt(4, 1);
            } else {
                ps.setInt(4, this.Copies);
            }
            ps.setInt(5, this.numOfCharacters);
            ps.setInt(6, this.Paperwidth);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            rs.getLong(1);
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePrinter(Connection connection) {
        String query = "UPDATE printer p SET p.Name = ?, p.ServerName = ?, p.Paperwidth = ?, p.Copies = ?,\r\np.numOfCharacters = ? WHERE p.PrinterID = ?";
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, this.Name);
            ps.setString(2, this.ServerName);
            ps.setInt(3, this.Paperwidth);
            ps.setInt(4, this.Copies);
            ps.setInt(5, this.numOfCharacters);
            ps.setLong(6, this.PrinterID);
            ps.executeUpdate();
            ps.close();
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void deletePrinter(int printerID, Connection connection) {
        String query = "DELETE FROM printer WHERE  PrinterID = ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, printerID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

