/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.product.Product;

public class PriceListDetailes {
    private long PriceListDetailsID;
    private long PriceListID;
    private long ProductID;
    private double Price;
    private double PreviousPrice;
    private double Discount;
    private String Code;
    private String Name;
    private Date Date;
    private boolean Nivelation;
    private double quantity;
    private Product product;
    private static final Logger LOGGER = Logger.getLogger("global");

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public Long getPriceListDetailsID() {
        return this.PriceListDetailsID;
    }

    public void setPriceListDetailsID(Long priceListDetailsID) {
        this.PriceListDetailsID = priceListDetailsID;
    }

    public Long getPriceListID() {
        return this.PriceListID;
    }

    public void setPriceListID(Long priceListID) {
        this.PriceListID = priceListID;
    }

    public Long getProductID() {
        return this.ProductID;
    }

    public void setProductID(Long productID) {
        this.ProductID = productID;
    }

    public Double getPrice() {
        return this.Price;
    }

    public void setPrice(Double price) {
        this.Price = price;
    }

    public Double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(Double discount) {
        this.Discount = discount;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public void setPreviousPrice(double newPrice) {
        this.PreviousPrice = newPrice;
    }

    public double getPreviousPrice() {
        return this.PreviousPrice;
    }

    public boolean isNivelation() {
        return this.Nivelation;
    }

    public void setNivelation(boolean nivelation) {
        this.Nivelation = nivelation;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof PriceListDetailes) {
            PriceListDetailes that = (PriceListDetailes)obj;
            if (this.ProductID == that.ProductID) {
                return true;
            }
        }
        return false;
    }

    public long insert(Connection connection) {
        long result = 0L;
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`, `Date`) values(?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.PriceListID);
            ps.setLong(2, this.ProductID);
            ps.setDouble(3, this.Price);
            ps.setDouble(4, this.Discount);
            ps.setTimestamp(5, new Timestamp(this.Date.getTime()));
            System.out.println(ps);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            result = rs.getLong(1);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public long insertFromServer(Connection connection) {
        long result = 0L;
        String query = "insert into pricelistdetails(`PriceListDetailsID`, `PriceListID`,`ProductID`,`Price`,`Discount`, `Date`) values(?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.PriceListDetailsID);
            ps.setLong(2, this.PriceListID);
            ps.setLong(3, this.ProductID);
            ps.setDouble(4, this.Price);
            ps.setDouble(5, this.Discount);
            try {
                ps.setTimestamp(6, new Timestamp(this.Date.getTime()));
            }
            catch (NullPointerException e) {
                ps.setTimestamp(6, new Timestamp(new Date().getTime()));
            }
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            result = rs.getLong(1);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void insertProductPrice(long productID, double price, Connection connection) {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`) values(?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, 1L);
            ps.setLong(2, productID);
            ps.setDouble(3, price);
            ps.setDouble(4, 0.0);
            LOGGER.info(ps.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            LOGGER.info(e.getMessage());
        }
    }

    public static void insertProductPrice(long productID, double price, long documentId, ScreensController controller) {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`,`Date`,`documentID`) values(?,?,?,?,?,?)";
        Connection connection = controller.getSettings().getConnection();
        PriceList activePriceListId = PriceList.getActive(Settings.LocalDateTimefromDate(Settings.fromLocalDate(LocalDate.now())), controller.getObject().getObjectID(), connection);
        Document d = Document.getByID(documentId, connection);
        Timestamp ts = new Timestamp(d.getDate().getTime());
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, activePriceListId.getPriceListID());
            ps.setLong(2, productID);
            ps.setDouble(3, price);
            ps.setDouble(4, 0.0);
            ps.setTimestamp(5, ts);
            ps.setLong(6, documentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Problem sa insertom price list detailsom");
        }
    }

    public static void insertProductPriceFromPrijemnica(long productID, double price, LocalDateTime datum, ScreensController controller) {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`,`Date`) values(?,?,?,?,?)";
        PriceList activePriceListId = PriceList.getActive(Settings.LocalDateTimefromDate(Settings.fromLocalDate(LocalDate.now())), controller.getObject().getObjectID(), controller.getSettings().getConnection());
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setLong(1, activePriceListId.getPriceListID());
            ps.setLong(2, productID);
            ps.setDouble(3, price);
            ps.setDouble(4, 0.0);
            ps.setTimestamp(5, new Timestamp(Settings.DatefromLocalDateTime(datum).getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertProductPriceTrgovina(PriceList priceList, long productID, double price, Connection connection) throws SQLException {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`,`Date`)  values(?,?,?,?,now())";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, priceList.getPriceListID());
        ps.setLong(2, productID);
        ps.setDouble(3, price);
        ps.setDouble(4, 0.0);
        ps.executeUpdate();
        ps.close();
    }

    public static void insertProductPriceTrgovinaYesterday(PriceList priceList, long productID, double price, Connection connection) throws SQLException {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`,`Date`)  values(?,?,?,?, DATE_SUB(Now(), INTERVAL 1 DAY))";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, priceList.getPriceListID());
        ps.setLong(2, productID);
        ps.setDouble(3, price);
        ps.setDouble(4, 0.0);
        ps.executeUpdate();
        ps.close();
    }

    public static void insertProductPriceTrgovinaFirst(PriceList priceList, long productID, double price, Connection connection) throws SQLException {
        String query = "insert into pricelistdetails(`PriceListID`,`ProductID`,`Price`,`Discount`,`Date`)  values(?,?,?,?,(SELECT pl.DateFrom FROM pricelist pl order BY pl.DateFrom  LIMIT 1))";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, priceList.getPriceListID());
        ps.setLong(2, productID);
        ps.setDouble(3, price);
        ps.setDouble(4, 0.0);
        ps.executeUpdate();
        ps.close();
    }

    public static void getChangedPrice(Connection connection) {
    }

    public void update(Connection connection) {
        String query = "update pricelistdetails set \tPriceListID = ?, ProductID = ?, Price = ?, Discount = ?, Date = ?  where PriceListDetailsID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.PriceListID);
            ps.setLong(2, this.ProductID);
            ps.setDouble(3, this.Price);
            ps.setDouble(4, this.Discount);
            ps.setTimestamp(5, new Timestamp(this.Date.getTime()));
            ps.setLong(6, this.PriceListDetailsID);
            System.out.println(ps);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateNivelation(Connection connection) {
        String query = "update pricelistdetails pld set pld.Nivelation = 1 where pld.PriceListDetailsID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.PriceListDetailsID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updatePrice(double price, long productID, int priceListID, Connection connection) {
        String query = "update pricelistdetails set \tPrice = ? where ProductID = ? and PriceListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDouble(1, price);
            ps.setLong(2, productID);
            ps.setLong(3, priceListID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        if (this.PriceListDetailsID > 0L) {
            String query = "delete from pricelistdetails where PriceListDetailsID = ?";
            try {
                PreparedStatement ps = connection.prepareStatement(query);
                ps.setLong(1, this.PriceListDetailsID);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteALLByPriceListID(Connection connection) {
        String query = "delete from pricelistdetails where PriceListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.PriceListID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static ObservableList<PriceListDetailes> getLastPriceList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT pld.*, p.Code, p.Name  FROM pricelistdetails pld  LEFT JOIN product p ON p.ProductID = pld.ProductID LEFT JOIN barcode br ON br.ProductID = p.ProductID WHERE pld.Date = (SELECT max(pld1.Date) FROM pricelistdetails pld1  WHERE pld1.ProductID = pld.ProductID)";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            Statement createStatement = connection.createStatement();
            ResultSet rs = createStatement.executeQuery(upit);
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setDiscount(rs.getDouble("Discount"));
                pld.setDate(rs.getTimestamp("Date"));
                pld.setCode(rs.getString("Code"));
                list.add((java.lang.Object)pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PriceListDetailes> getList(PriceList priceList, String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT pld.*, p.Code, p.Name  FROM pricelistdetails pld  LEFT JOIN product p ON p.ProductID = pld.ProductID LEFT JOIN barcode br ON br.ProductID = p.ProductID WHERE pld.PriceListID = ?  AND pld.Date IN (SELECT pld1.Date FROM pricelistdetails pld1  WHERE pld1.PriceListID = ? AND pld1.ProductID = pld.ProductID) AND (p.Code LIKE ? OR p.Name LIKE ? OR p.ShortName LIKE ? OR br.BarCode LIKE ?) ORDER BY pld.Date DESC";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, priceList.getPriceListID());
            ps.setLong(2, priceList.getPriceListID());
            ps.setString(3, "%" + filter + "%");
            ps.setString(4, "%" + filter + "%");
            ps.setString(5, "%" + filter + "%");
            ps.setString(6, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setDiscount(rs.getDouble("Discount"));
                pld.setDate(rs.getTimestamp("Date"));
                list.add((java.lang.Object)pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PriceListDetailes> getRedovanList(PriceList priceList, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pld.* FROM pricelistdetails pld ORDER BY pld.date DESC";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setDiscount(rs.getDouble("Discount"));
                pld.setDate(rs.getTimestamp("Date"));
                Product product = Product.getByID(pld.getProductID(), controller);
                product.setPrice(pld.getPrice());
                product.setPriceListDate(pld.getDate());
                product.setPriceListDetailsId(pld.getPriceListDetailsID());
                product.setBarcode(Barcode.getBarCode(product.getProductID(), controller.getSettings().getConnection()));
                pld.setProduct(product);
                list.add((java.lang.Object)pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static PriceListDetailes getByID(long productID, Connection connection) {
        String upit = "SELECT * FROM pricelistdetails pld WHERE pld.PriceListDetailsID = ?";
        PriceListDetailes pld = new PriceListDetailes();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setDiscount(rs.getDouble("Discount"));
                pld.setDate(rs.getTimestamp("Date"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pld;
    }

    public static LocalDateTime getLastDate(Connection connection) {
        LocalDateTime datum = null;
        String upit = "SELECT pld.*, MAX(pld.Date) AS Datum FROM pricelistdetails pld ORDER BY pld.Date";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ResultSet rs = ps.executeQuery();
            rs.next();
            datum = Settings.LocalDateTimefromDate(rs.getTimestamp("Datum"));
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return datum;
    }

    public static ArrayList<PriceListDetailes> getChangedPriceServer(int departmentId, LocalDateTime from, Connection connection) {
        ArrayList<PriceListDetailes> list = new ArrayList<PriceListDetailes>();
        String upit = "SELECT pld.* FROM pricelistdetails pld WHERE pld.Date > ? AND pld.Date < NOW() AND pld.PriceListID = 1";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setTimestamp(1, Timestamp.valueOf(from));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setDate(rs.getTimestamp("Date"));
                pld.setDiscount(rs.getDouble("Discount"));
                list.add(pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PriceListDetailes> getChangedPrice(int departmentId, LocalDateTime from, LocalDateTime to, Connection connection) {
        ArrayList<PriceListDetailes> list = new ArrayList<PriceListDetailes>();
        String upit = "select pld.*   from pricelistdetails pld INNER JOIN product p ON p.ProductID = pld.ProductID AND p.ProductTypeID = 1 where pld.Date BETWEEN ? AND ? and pld.PriceListID = ? and p.productCategoryId !=2  ORDER BY pld.ProductID ";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setTimestamp(1, Timestamp.valueOf(from));
            ps.setTimestamp(2, Timestamp.valueOf(to));
            ps.setLong(3, 1L);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setDate(rs.getTimestamp("Date"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setPreviousPrice(PriceListDetailes.getPreviousPrice(pld.getPriceListID(), pld.getProductID(), pld.getDate(), connection));
                pld.setDiscount(rs.getDouble("Discount"));
                if (!(pld.getPreviousPrice() > 0.0) || pld.getPrice().doubleValue() == pld.getPreviousPrice()) continue;
                list.add(pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getCountOfPriceListBYPriceListDetailsID(Connection connection, long priceListDetailsID, LocalDateTime from, LocalDateTime to) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM pricelistdetails pld  WHERE pld.Date BETWEEN ? AND ? AND pld.PriceListID = ? ORDER BY pld.PriceListID";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setTimestamp(1, Timestamp.valueOf(from));
            pStatement.setTimestamp(2, Timestamp.valueOf(to));
            pStatement.setLong(3, priceListDetailsID);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setProductID(rs.getLong("ProductID"));
                list.add((java.lang.Object)pld);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list.size();
    }

    public static ArrayList<PriceListDetailes> getChangedPriceBetweenPriceList(int departmentId, LocalDateTime from, LocalDateTime to, Connection connection) {
        PriceList activePriceList = PriceList.getActive(LocalDateTime.now(), Object.getByDep(departmentId, connection).getObjectID(), connection);
        PriceList regularPriceList = PriceList.getRegular(LocalDateTime.now(), Object.getByDep(departmentId, connection).getObjectID(), connection);
        ArrayList<PriceListDetailes> listRegular = new ArrayList<PriceListDetailes>();
        String upitRegular = "CALL `nivelacija_izmedju_cenovnika`(DATE(?), DATE(?), ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(upitRegular);
            ps.setTimestamp(1, Timestamp.valueOf(from));
            ps.setTimestamp(2, Timestamp.valueOf(to));
            if (Settings.LocalDateTimefromDate(activePriceList.getDateTo()).isBefore(LocalDateTime.now())) {
                ps.setLong(3, regularPriceList.getPriceListID());
                ps.setLong(4, activePriceList.getPriceListID());
            } else {
                ps.setLong(3, regularPriceList.getPriceListID());
                ps.setLong(4, activePriceList.getPriceListID());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetails_ID"));
                pld.setProductID(rs.getLong("Product_ID"));
                pld.setDate(rs.getTimestamp("Datum"));
                pld.setPrice(rs.getDouble("PriceNova"));
                pld.setPreviousPrice(rs.getDouble("PriceStara"));
                listRegular.add(pld);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return listRegular;
    }

    public static double getPreviousPrice(long priceListID, long productID, Date date, Connection connection) {
        String upit = "SELECT COALESCE(pld.Price,0) AS Price FROM pricelistdetails pld  WHERE pld.PriceListID = ?   AND pld.Date < ? AND pld.ProductID = ? ORDER BY pld.Date DESC LIMIT 1";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, priceListID);
            ps.setTimestamp(2, new Timestamp(date.getTime()));
            ps.setLong(3, productID);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getDouble("Price");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public static ArrayList<PriceListDetailes> getChangedPrice(WorkDay workDay, ScreensController controller) {
        ArrayList<PriceListDetailes> list = new ArrayList<PriceListDetailes>();
        String upit = "SELECT pld.`*`, current_price_before_date(pld.ProductID, ?, 1) AS Cena FROM pricelistdetails pld LEFT JOIN product p ON p.ProductID = pld.ProductID AND p.ProductTypeID = 1 \r\nWHERE pld.Date BETWEEN ? AND ? AND pld.PriceListID = 1 ORDER BY pld.ProductID DESC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(upit);
            pStatement.setTimestamp(1, new Timestamp(workDay.getDateTo().getTime()));
            pStatement.setTimestamp(2, new Timestamp(workDay.getDateFrom().getTime()));
            pStatement.setTimestamp(3, new Timestamp(workDay.getDateTo().getTime()));
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                PriceListDetailes pld = new PriceListDetailes();
                pld.setPriceListDetailsID(rs.getLong("PriceListDetailsID"));
                pld.setPriceListID(rs.getLong("PriceListID"));
                pld.setProductID(rs.getLong("ProductID"));
                pld.setDate(rs.getTimestamp("Date"));
                pld.setPrice(rs.getDouble("Price"));
                pld.setPreviousPrice(PriceListDetailes.getPreviousPrice(pld.getPriceListID(), pld.getProductID(), pld.getDate(), controller.getSettings().getConnection()));
                pld.setDiscount(rs.getDouble("Discount"));
                list.add(pld);
            }
            rs.close();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void deleteFromPriceListDetailsByDocumentID(long documentID, ScreensController controller) {
        String query = "DELETE from pricelistdetails where documentID = ?";
        Connection connection = controller.getSettings().getConnection();
        PreparedStatement ps = null;
        try {
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setLong(1, documentID);
            ps.executeUpdate();
            connection.commit();
            connection.setAutoCommit(true);
            LOGGER.info("BRISANJE pricelistdetails" + connection.getAutoCommit());
            ps.close();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                connection.setAutoCommit(true);
                LOGGER.info("BRISANJE pricelistdetails" + e.getMessage());
                ps.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String toString() {
        return "PriceListDetailes [PriceListDetailsID=" + this.PriceListDetailsID + ", PriceListID=" + this.PriceListID + ", ProductID=" + this.ProductID + ", Price=" + this.Price + ", PreviousPrice=" + this.PreviousPrice + ", Discount=" + this.Discount + ", Code=" + this.Code + ", Name=" + this.Name + ", Date=" + this.Date + ", Nivelation=" + this.Nivelation + ", quantity=" + this.quantity + ", product=" + this.product + "]";
    }
}

