/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.renameconnection.ChangeConnection;

public class PosMenu {
    int PosMenuID;
    long UserID;
    int sort;
    String Code;
    String Title;
    int ParentPosMenuID;
    boolean IsCommand;
    boolean isMenu;
    boolean Selected;

    public PosMenu() {
    }

    public PosMenu(int PosMenuID, String Title) {
        this.PosMenuID = PosMenuID;
        this.Title = Title;
    }

    public int getPosMenuID() {
        return this.PosMenuID;
    }

    public void setPosMenuID(int posMenuID) {
        this.PosMenuID = posMenuID;
    }

    public long getUserID() {
        return this.UserID;
    }

    public void setUserID(long userID) {
        this.UserID = userID;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public int getParentPosMenuID() {
        return this.ParentPosMenuID;
    }

    public void setParentPosMenuID(int parentPosMenuID) {
        this.ParentPosMenuID = parentPosMenuID;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setTitle(String title) {
        this.Title = title;
    }

    public boolean isIsCommand() {
        return this.IsCommand;
    }

    public void setIsCommand(boolean isCommand) {
        this.IsCommand = isCommand;
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public void setMenu(boolean isMenu) {
        this.isMenu = isMenu;
    }

    public boolean isSelected() {
        return this.Selected;
    }

    public void setSelected(boolean selected) {
        this.Selected = selected;
    }

    public String toString() {
        return this.Title;
    }

    public static ArrayList<PosMenu> getList(Long userId, Connection connection) {
        ArrayList<PosMenu> list = new ArrayList<PosMenu>();
        try {
            PreparedStatement ps = connection.prepareStatement("select m.*   from posmenuuser mu  left join posmenu m on m.PosMenuID = mu.PosMenuID  where m.ParentPosMenuID is null   and mu.UserID = ?  order by sort");
            ps.setLong(1, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add(pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PosMenu> getLightList(Long userId, Connection connection) {
        ArrayList<PosMenu> list = new ArrayList<PosMenu>();
        try {
            PreparedStatement ps = connection.prepareStatement("select m.*   from posmenuuser mu  left join posmenu m on m.PosMenuID = mu.PosMenuID  where m.ParentPosMenuID is null AND m.PosMenuID IN(14,19,21,23,81,82)   and mu.UserID = ?  order by sort");
            ps.setLong(1, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add(pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PosMenu> getList(int PosMenuID, Long userId, Connection connection) {
        ArrayList<PosMenu> list = new ArrayList<PosMenu>();
        try {
            PreparedStatement ps = connection.prepareStatement("select distinct m.*   from posmenuuser mu  left join posmenu m on m.PosMenuID = mu.PosMenuID  where m.ParentPosMenuID = ?    and  mu.UserID = ?  order by sort");
            ps.setInt(1, PosMenuID);
            ps.setLong(2, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add(pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<PosMenu> getListLight(int PosMenuID, Long userId, Connection connection) {
        ArrayList<PosMenu> list = new ArrayList<PosMenu>();
        try {
            PreparedStatement ps = connection.prepareStatement("select distinct m.*   from posmenuuser mu  left join posmenu m on m.PosMenuID = mu.PosMenuID  where m.ParentPosMenuID = ?  AND m.PosMenuID IN(24,35,38,48,50,63,82,83,102,114,117)   and  mu.UserID = ?  order by sort");
            ps.setInt(1, PosMenuID);
            ps.setLong(2, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add(pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PosMenu> getFullPosMenuList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM posmenu");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.sort = rs.getInt("sort");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.ParentPosMenuID = rs.getInt("ParentPosMenuID");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add((Object)pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PosMenu> getFullList(Connection connection, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM posmenu" + filter + " order by sort ");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.sort = rs.getInt("sort");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.ParentPosMenuID = rs.getInt("ParentPosMenuID");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add((Object)pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PosMenu> getLightList(Connection connection, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM posmenu" + filter + " order by sort ");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.sort = rs.getInt("sort");
                pm.Code = rs.getString("Code");
                pm.Title = rs.getString("Title");
                pm.ParentPosMenuID = rs.getInt("ParentPosMenuID");
                pm.IsCommand = rs.getBoolean("IsCommand");
                pm.isMenu = rs.getBoolean("isMenu");
                list.add((Object)pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PosMenu> getFullListID(long userID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT upos.* FROM posmenuuser upos  JOIN posmenu pm ON pm.PosMenuID = upos.PosMenuID  WHERE upos.UserID = ? ORDER BY pm.PosMenuID");
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PosMenu pm = new PosMenu();
                pm.PosMenuID = rs.getInt("PosMenuID");
                pm.UserID = rs.getLong("UserID");
                list.add((Object)pm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static PosMenu getByPosMenuCode(String code, Connection connection) {
        PosMenu pm = new PosMenu();
        String sql = "SELECT * FROM posmenu WHERE Code = ? ";
        try {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, code.trim());
            ResultSet rs = statement.executeQuery();
            rs.next();
            pm.setPosMenuID(rs.getInt("PosMenuID"));
            pm.setCode(rs.getString("Code"));
            pm.setTitle(rs.getString("Title"));
            pm.setParentPosMenuID(rs.getInt("ParentPosMenuID"));
            pm.setIsCommand(rs.getBoolean("IsCommand"));
            pm.setMenu(rs.getBoolean("isMenu"));
        }
        catch (SQLException ex) {
            pm = null;
        }
        return pm;
    }

    public static PosMenu getByPosMenuTitle(String code, Connection connection) {
        PosMenu pm = new PosMenu();
        String sql = "SELECT * FROM posmenu WHERE Title = ? ";
        try {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, code.trim());
            ResultSet rs = statement.executeQuery();
            rs.next();
            pm.setPosMenuID(rs.getInt("PosMenuID"));
            pm.setCode(rs.getString("Code"));
            pm.setTitle(rs.getString("Title"));
            pm.setParentPosMenuID(rs.getInt("ParentPosMenuID"));
            pm.setIsCommand(rs.getBoolean("IsCommand"));
            pm.setMenu(rs.getBoolean("isMenu"));
        }
        catch (SQLException ex) {
            pm = null;
        }
        return pm;
    }

    public static PosMenu getByPosMenuName(String name, Connection connection) {
        PosMenu pm = new PosMenu();
        String sql = "SELECT * FROM posmenu WHERE Title = ? ";
        try {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, name.trim());
            ResultSet rs = statement.executeQuery();
            rs.next();
            pm.setPosMenuID(rs.getInt("PosMenuID"));
            pm.setCode(rs.getString("Code"));
            pm.setTitle(rs.getString("Title"));
            pm.setParentPosMenuID(rs.getInt("ParentPosMenuID"));
            pm.setIsCommand(rs.getBoolean("IsCommand"));
            pm.setMenu(rs.getBoolean("isMenu"));
        }
        catch (SQLException ex) {
            pm = null;
        }
        return pm;
    }

    public boolean equals(Object obj) {
        return obj instanceof PosMenu ? ((PosMenu)obj).getPosMenuID() == this.PosMenuID : false;
    }

    private static int getNextSort(ScreensController controller, int parendID) {
        int sort = 0;
        String query = "SELECT max(pm.sort) FROM posmenu pm WHERE pm.ParentPosMenuID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, parendID);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            sort = rSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sort + 1;
    }

    private static int getNextSortMenu(ScreensController controller, int parendID) {
        int sort = 0;
        String query = "SELECT max(pm.sort) FROM posmenu pm WHERE pm.ParentPosMenuID is null";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            sort = rSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sort + 1;
    }

    public static void insertMenu(ScreensController controller, String code, String title, int parentID) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`posmenu` (`sort`, `Code`, `Title`, `isMenu`) VALUES (" + PosMenu.getNextSortMenu(controller, parentID) + ", '" + code.trim() + "', '" + title.trim() + "', b'1');";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insert(ScreensController controller, String code, String title, int parentID) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`posmenu` (`sort`, `Code`, `Title`, `ParentPosMenuID`, `IsCommand`) VALUES (" + PosMenu.getNextSort(controller, parentID) + ", '" + code.trim() + "', '" + title.trim() + "', " + parentID + ", b'1');";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query, 1);
            pStatement.execute();
            ResultSet rs = pStatement.getGeneratedKeys();
            rs.next();
            int posMenuId = rs.getInt(1);
            PosMenu.insertUserIntoPosMenuUser(1L, posMenuId, controller.getSettings().getConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void edit(ScreensController controller, String code, String title) {
        String query = "Update posmenu set title = ? where code = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, title);
            pStatement.setString(2, code);
            pStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void updateTitle(String naziv, String noviNaziv, Connection connection) {
        String query = "UPDATE posmenu p SET p.Title = ? WHERE p.PosMenuID = ?";
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setString(1, noviNaziv);
            pStatement.setLong(2, PosMenu.getByPosMenuCode(naziv, connection).getPosMenuID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void delete(String posCode, ScreensController controller) {
        PreparedStatement pStatement;
        ChangeConnection.getConnectionAdmin(controller);
        String query = "DELETE FROM posmenuuser WHERE PosMenuID = ?";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, PosMenu.getByPosMenuCode(posCode, controller.getSettings().getConnection()).getPosMenuID());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            ChangeConnection.getConnectionUser(controller);
            e.printStackTrace();
        }
        query = "DELETE FROM posmenu WHERE Code = ?";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, posCode);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            ChangeConnection.getConnectionUser(controller);
            e.printStackTrace();
        }
        ChangeConnection.getConnectionUser(controller);
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `posmenu` SET `Code` = ?, `Title` = ?, `ParentPosMenuID` = ?, `IsCommand` = ?, `isMenu` = ? WHERE  `PosMenuID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.Code);
            pStatement.setString(2, this.Title);
            pStatement.setLong(3, this.ParentPosMenuID);
            pStatement.setBoolean(4, this.isIsCommand());
            pStatement.setBoolean(5, this.isMenu);
            pStatement.setLong(6, this.PosMenuID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static void deleteAllPosMenuUserByUserID(long userId, ScreensController controller) {
        ChangeConnection.getConnectionAdmin(controller);
        String query = "DELETE FROM posmenuuser WHERE UserID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, userId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            ChangeConnection.getConnectionUser(controller);
            e.printStackTrace();
        }
        ChangeConnection.getConnectionUser(controller);
    }

    public static void insertUserIntoPosMenuUser(long userID, int posID, Connection connection) {
        String query = "INSERT INTO posmenuuser (UserID, PosMenuID) VALUES (?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setInt(2, posID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

