/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.WorkDay;

public class PaymentRecord {
    private long paymentRecordID;
    private long documentID;
    private Date sysCreateDate;
    private String note;
    private double paidAmount;

    public long getPaymentRecordID() {
        return this.paymentRecordID;
    }

    public void setPaymentRecordID(long paymentRecordID) {
        this.paymentRecordID = paymentRecordID;
    }

    public long getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(long documentID) {
        this.documentID = documentID;
    }

    public Date getSysCreateDate() {
        return this.sysCreateDate;
    }

    public void setSysCreateDate(Date sysCreateDate) {
        this.sysCreateDate = sysCreateDate;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public double getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(double paidAmount) {
        this.paidAmount = paidAmount;
    }

    public static ObservableList<PaymentRecord> getListByDocumentId(ScreensController controller, long documentId) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT pr.* FROM paymentrecord pr WHERE pr.DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentId);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                PaymentRecord paymentRecord = new PaymentRecord();
                paymentRecord.setDocumentID(rSet.getLong("DocumentID"));
                paymentRecord.setSysCreateDate(new Date(rSet.getTimestamp("SysCreateDate").getTime()));
                paymentRecord.setNote(rSet.getString("Note"));
                paymentRecord.setPaidAmount(rSet.getDouble("PaidAmount"));
                list.add((Object)paymentRecord);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static double getPaidAmountSum(long documentID, ScreensController controller) {
        double suma = 0.0;
        String query = "SELECT SUM(pr.PaidAmount) AS 'PaidAmount' FROM paymentrecord pr WHERE pr.DocumentID = ? AND pr.Realized IS FALSE";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentID);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            suma = rSet.getDouble("PaidAmount");
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return suma;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`paymentrecord` (`DocumentID`, `Note`, `PaidAmount`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.documentID);
            pStatement.setString(2, this.note);
            pStatement.setDouble(3, this.paidAmount);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAll(WorkDay wDay, ScreensController controller) {
        String query = "DELETE pr FROM paymentrecord pr LEFT JOIN document d ON d.DocumentID = pr.DocumentID WHERE d.Date > ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteByDocumentID(long documentID, ScreensController controller) {
        String query = "DELETE pr FROM paymentrecord pr WHERE pr.DocumentID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, documentID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllBills(WorkDay wDay, ScreensController controller) {
        String query = "DELETE pr FROM paymentrecord pr LEFT JOIN document d ON d.DocumentID = pr.DocumentID WHERE d.Date < ? AND d.DocumentTypeID IN (3,4,17)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setTimestamp(1, new Timestamp(wDay.getDate().getTime()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

