/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class PayCard {
    private long payCardId;
    private String name;
    private double percent;
    private boolean active;

    public long getPayCardId() {
        return this.payCardId;
    }

    public void setPayCardId(long payCardId) {
        this.payCardId = payCardId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static ObservableList<PayCard> getList(ScreensController controller, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM paycard pc WHERE pc.Name LIKE ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                PayCard payCard = new PayCard();
                payCard.setPayCardId(rSet.getLong("payCardID"));
                payCard.setName(rSet.getString("Name"));
                payCard.setPercent(rSet.getDouble("Percent"));
                payCard.setActive(rSet.getBoolean("Active"));
                list.add((Object)payCard);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<PayCard> getListActive(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM paycard pc WHERE pc.Active IS TRUE";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                PayCard payCard = new PayCard();
                payCard.setPayCardId(rSet.getLong("payCardID"));
                payCard.setName(rSet.getString("Name"));
                payCard.setPercent(rSet.getDouble("Percent"));
                payCard.setActive(rSet.getBoolean("Active"));
                list.add((Object)payCard);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`paycard` WHERE  `PayCardID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.payCardId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDocumentPayCard(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`documentpaycard` WHERE  `PayCardID`=?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.payCardId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`paycard` SET `Name` = ?, `Percent` = ?, `Active` = ?  WHERE  `PayCardIDID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.percent);
            pStatement.setBoolean(3, this.active);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(ScreensController controller) throws SQLException {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`paycard` (`Name`, `Percent`, `Active`) VALUES (?, ?, ?)";
        PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
        pStatement.setString(1, this.name);
        pStatement.setDouble(2, this.percent);
        pStatement.setBoolean(3, this.active);
        pStatement.executeUpdate();
    }

    public static PayCard getByName(ScreensController controller, String filter) {
        String query = "SELECT * FROM paycard pc WHERE pc.Name LIKE ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            PayCard payCard = new PayCard();
            payCard.setPayCardId(rSet.getLong("payCardID"));
            payCard.setName(rSet.getString("Name"));
            payCard.setPercent(rSet.getDouble("Percent"));
            payCard.setActive(rSet.getBoolean("Active"));
            return payCard;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PayCard getById(long id, ScreensController controller) {
        String query = "SELECT * FROM paycard pc WHERE pc.PayCardID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            PayCard payCard = new PayCard();
            payCard.setPayCardId(rSet.getLong("payCardID"));
            payCard.setName(rSet.getString("Name"));
            payCard.setPercent(rSet.getDouble("Percent"));
            payCard.setActive(rSet.getBoolean("Active"));
            return payCard;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

