/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DatabaseCheck;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.person.Address;

public class Object {
    private int ObjectID;
    private String Name;
    private String Code;
    private long CompanyConfigID;
    private int ObjectVatTypeID;
    private String PIB;
    private String MB;
    private long RegionID;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private boolean Active;
    private long AddressID;
    private long productID;
    private String apiKey;
    private String idCompany;
    private String bank;
    private String bankAccount;
    private Address address;

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getIdCompany() {
        return this.idCompany;
    }

    public void setIdCompany(String idCompany) {
        this.idCompany = idCompany;
    }

    public Object() {
    }

    public Object(int id, String name) {
        this.ObjectID = id;
        this.Name = name;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getCode() {
        return this.Code;
    }

    public void setCode(String code) {
        this.Code = code;
    }

    public long getRegionID() {
        return this.RegionID;
    }

    public long getCompanyConfigID() {
        return this.CompanyConfigID;
    }

    public void setCompanyConfigID(long companyConfigID) {
        this.CompanyConfigID = companyConfigID;
    }

    public int getObjectVatTypeID() {
        return this.ObjectVatTypeID;
    }

    public void setObjectVatTypeID(int objectVatTypeID) {
        this.ObjectVatTypeID = objectVatTypeID;
    }

    public String getPIB() {
        return this.PIB;
    }

    public long getProductID() {
        return this.productID;
    }

    public void setProductID(long productID) {
        this.productID = productID;
    }

    public void setPIB(String pIB) {
        this.PIB = pIB;
    }

    public String getMB() {
        return this.MB;
    }

    public void setMB(String mB) {
        this.MB = mB;
    }

    public void setRegionID(long regionID) {
        this.RegionID = regionID;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public long getAddressID() {
        return this.AddressID;
    }

    public void setAddressID(long addressID) {
        this.AddressID = addressID;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String toString() {
        return this.Name;
    }

    public static Object getById(int id, ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("select * from object where ObjectID = ? ");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Object object = new Object();
            object.ObjectID = rs.getInt("ObjectID");
            object.Name = rs.getString("Name");
            object.Code = rs.getString("Code");
            try {
                object.CompanyConfigID = rs.getLong("CompanyConfigID");
            }
            catch (SQLException e) {
                String upit = "UPDATE `object` SET `CompanyName`='1' WHERE  `ObjectID`=1;";
                PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `region` DROP FOREIGN KEY `region_ibfk_1`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `object` CHANGE COLUMN `CompanyName` `CompanyConfigID` BIGINT(11) NULL DEFAULT NULL AFTER `Active`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `companyconfig` CHANGE COLUMN `CompanyConfigID` `CompanyConfigID` BIGINT(20) NOT NULL AUTO_INCREMENT FIRST;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `companyconfig` ADD COLUMN `AddressID` BIGINT NULL DEFAULT '1' AFTER `ImagePath`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `object` ADD CONSTRAINT `object_ibfk_5` FOREIGN KEY (`CompanyConfigID`) REFERENCES `companyconfig` (`CompanyConfigID`) ON UPDATE CASCADE ON DELETE NO ACTION;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `object` ADD COLUMN `bank` VARCHAR(50) NULL DEFAULT NULL AFTER `AddressID`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `object` ADD COLUMN `bankAccount` VARCHAR(50) NULL DEFAULT NULL AFTER `bank`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `document`\tADD COLUMN `CashBuyersID` BIGINT(20) NULL DEFAULT NULL AFTER `PersonID`;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "ALTER TABLE `region` ADD CONSTRAINT `region_ibfk_1` FOREIGN KEY (`CompanyConfigID`) REFERENCES `companyconfig` (`CompanyConfigID`) ON UPDATE CASCADE ON DELETE NO ACTION;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
                upit = "UPDATE `object` SET `AddressID`=1 WHERE  `ObjectID`=1;";
                pStatement = controller.getSettings().getConnection().prepareStatement(upit);
                pStatement.executeUpdate();
            }
            try {
                object.ObjectVatTypeID = rs.getInt("ObjectVatTypeID");
            }
            catch (Exception e) {
                DatabaseCheck databaseCheck = new DatabaseCheck();
                databaseCheck.createColumnObjectVatTypeID(controller);
            }
            object.PIB = rs.getString("PIB");
            object.MB = rs.getString("MB");
            object.RegionID = rs.getLong("RegionID");
            object.sysDTCreated = rs.getDate("sysDTCreated");
            object.sysDTEdit = rs.getDate("sysDTEdit");
            object.sysUserAddID = rs.getLong("sysUserAddID");
            object.sysUserEditID = rs.getLong("sysUserEditID");
            object.Active = rs.getBoolean("Active");
            object.AddressID = rs.getLong("AddressID");
            object.bank = rs.getString("bank");
            object.bankAccount = rs.getString("bankAccount");
            object.idCompany = rs.getString("idCompany");
            object.apiKey = rs.getString("apiKey");
            if (object.AddressID != 1L) {
                // empty if block
            }
            object.setAddress(Address.getByID(object.AddressID, controller.getSettings().getConnection()));
            return object;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object get(Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from object");
            ResultSet rs = ps.executeQuery();
            rs.next();
            Object object = new Object();
            object.ObjectID = rs.getInt("ObjectID");
            object.Name = rs.getString("Name");
            object.Code = rs.getString("Code");
            object.CompanyConfigID = rs.getLong("CompanyConfigID");
            object.ObjectVatTypeID = rs.getInt("ObjectVatTypeID");
            object.PIB = rs.getString("PIB");
            object.MB = rs.getString("MB");
            object.RegionID = rs.getLong("RegionID");
            object.sysDTCreated = rs.getDate("sysDTCreated");
            object.sysDTEdit = rs.getDate("sysDTEdit");
            object.sysUserAddID = rs.getLong("sysUserAddID");
            object.sysUserEditID = rs.getLong("sysUserEditID");
            object.Active = rs.getBoolean("Active");
            object.AddressID = rs.getLong("AddressID");
            object.bank = rs.getString("bank");
            object.bankAccount = rs.getString("bankAccount");
            object.apiKey = rs.getString("apiKey");
            object.idCompany = rs.getString("idCompany");
            return object;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static Object getByDep(int departmentId, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from object o join department d on d.ObjectID = o.ObjectID where d.DepartmentID = ?");
            ps.setLong(1, departmentId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Object object = new Object();
            object.ObjectID = rs.getInt("ObjectID");
            object.Name = rs.getString("Name");
            object.Code = rs.getString("Code");
            object.CompanyConfigID = rs.getLong("CompanyConfigID");
            object.ObjectVatTypeID = rs.getInt("ObjectVatTypeID");
            object.PIB = rs.getString("PIB");
            object.MB = rs.getString("MB");
            object.RegionID = rs.getLong("RegionID");
            object.sysDTCreated = rs.getDate("sysDTCreated");
            object.sysDTEdit = rs.getDate("sysDTEdit");
            object.sysUserAddID = rs.getLong("sysUserAddID");
            object.sysUserEditID = rs.getLong("sysUserEditID");
            object.Active = rs.getBoolean("Active");
            object.AddressID = rs.getLong("AddressID");
            object.bank = rs.getString("bank");
            object.bankAccount = rs.getString("bankAccount");
            object.apiKey = rs.getString("apiKey");
            object.idCompany = rs.getString("idCompany");
            return object;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void update(ScreensController controller) {
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement("UPDATE object SET  \t\t`Name` = ?,\t\t`Code` = ?,\t\t`RegionID` = ?,\t\t`sysDTEdit` = ?,\t\t`sysUserEditID` = ?,\t\t`Active` = ?,\t\t`CompanyConfigID` = ?,\t\t`ObjectVatTypeID` = ?,\t\t`PIB` = ?,\t\t`MB` = ?,\t\t`AddressID` = ?, `bank` = ?,  `bankAccount` = ? , `apiKey` = ? , `idCompany` = ?  WHERE `ObjectID` = ?");
            ps.setString(1, this.Name);
            ps.setString(2, this.Code);
            ps.setLong(3, this.RegionID);
            ps.setDate(4, new java.sql.Date(Settings.DatefromLocalDateTime(LocalDateTime.now()).getTime()));
            ps.setLong(5, controller.getUser().getUserID());
            ps.setBoolean(6, this.Active);
            ps.setLong(7, this.CompanyConfigID);
            ps.setInt(8, this.ObjectVatTypeID);
            ps.setString(9, this.PIB);
            ps.setString(10, this.MB);
            ps.setLong(11, this.AddressID);
            ps.setString(12, this.bank);
            ps.setString(13, this.bankAccount);
            ps.setString(14, this.apiKey);
            ps.setString(15, this.idCompany);
            ps.setInt(16, this.ObjectID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<Object> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from object order by name");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Object object = new Object();
                object.ObjectID = rs.getInt("ObjectID");
                object.Name = rs.getString("Name");
                object.Code = rs.getString("Code");
                object.CompanyConfigID = rs.getLong("CompanyConfigID");
                object.ObjectVatTypeID = rs.getInt("ObjectVatTypeID");
                object.PIB = rs.getString("PIB");
                object.MB = rs.getString("MB");
                object.RegionID = rs.getLong("RegionID");
                object.sysDTCreated = rs.getDate("sysDTCreated");
                object.sysDTEdit = rs.getDate("sysDTEdit");
                object.sysUserAddID = rs.getLong("sysUserAddID");
                object.sysUserEditID = rs.getLong("sysUserEditID");
                object.Active = rs.getBoolean("Active");
                object.AddressID = rs.getLong("AddressID");
                object.bank = rs.getString("bank");
                object.bankAccount = rs.getString("bankAccount");
                object.apiKey = rs.getString("apiKey");
                object.idCompany = rs.getString("idCompany");
                list.add((java.lang.Object)object);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Object> getFilteredList(long productId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("select o.*, d.Name from object o join department d on d.ObjectID = o.ObjectID join productdepartment pd on pd.DepartmentID = d.DepartmentID join product p on p.ProductID = pd.ProductID where pd.ProductID = ?");
            ps.setLong(1, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Object object = new Object();
                object.ObjectID = rs.getInt("ObjectID");
                object.Name = rs.getString("Name");
                object.Code = rs.getString("Code");
                object.CompanyConfigID = rs.getLong("CompanyConfigID");
                object.ObjectVatTypeID = rs.getInt("ObjectVatTypeID");
                object.PIB = rs.getString("PIB");
                object.MB = rs.getString("MB");
                object.RegionID = rs.getLong("RegionID");
                object.sysDTCreated = rs.getDate("sysDTCreated");
                object.sysDTEdit = rs.getDate("sysDTEdit");
                object.sysUserAddID = rs.getLong("sysUserAddID");
                object.sysUserEditID = rs.getLong("sysUserEditID");
                object.Active = rs.getBoolean("Active");
                object.AddressID = rs.getLong("AddressID");
                object.bank = rs.getString("bank");
                object.bankAccount = rs.getString("bankAccount");
                list.add((java.lang.Object)object);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public int getPosCount(Connection connection) {
        return SQLHelper.QueryToInt("select count(*) from pointofsale where ObjectID = " + this.ObjectID, connection, 0);
    }

    public int getDepartmentID(int objectID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("select d.DepartmentID from department d where ObjectID = ? ");
            int departmentID = 0;
            ps.setInt(1, objectID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            departmentID = rs.getInt(1);
            return departmentID;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    public Department getDepartment(int objectID, Connection connection) {
        Department d = new Department();
        try {
            PreparedStatement ps = connection.prepareStatement("select d.* from department d where d.ObjectID = ? ");
            ps.setInt(1, objectID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            d.setDepartmentID(rs.getInt("DepartmentID"));
            d.setName(rs.getString("Name"));
            d.setShortName(rs.getString("ShortName"));
            d.setCode(rs.getString("Code"));
            d.setActive(rs.getBoolean("Active"));
            d.setPrinterID(rs.getInt("PrinterID"));
            d.setObjectID(rs.getInt("ObjectID"));
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return d;
    }

    public static int getByPos(long posID, Connection connection) {
        return SQLHelper.QueryToInt("select pos.ObjectID from pointofsale pos where pos.PointOfSaleID = 1", connection, 0);
    }
}

