/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import java.util.logging.Logger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.CsvImportType;
import rs.petcom.master.dal.DatabaseCheck;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PosMenu;
import rs.petcom.master.dal.PriceListType;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.RelationshipType;
import rs.petcom.master.dal.Role;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyGroup;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonVatType;
import rs.petcom.removers.CashBuyerRemover;

public class MasterDbRefresh {
    ScreensController controller;
    Connection connection;
    private static final Logger LOGGER = Logger.getLogger("global");

    public MasterDbRefresh(ScreensController controller) {
        PosMenu predracun;
        PosMenu terminal;
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
        DatabaseCheck databaseCheck = new DatabaseCheck();
        CashBuyerRemover remover = new CashBuyerRemover(controller);
        String word_day_off = "BEGIN\r\n\tDECLARE result DATETIME DEFAULT NULL;\r\n\r\n\tSELECT wd.DateTo\r\n\t\tFROM workday wd\r\n\t\tWHERE wd.Date in (SELECT MAX(w.Date)\r\n\t\t\t\t\t\t\t\tFROM workday w\r\n\t\t\t\t\t\t\t\tWHERE w.Date = i_date\r\n\t\t\t\t\t\t\t\t\t\t\tAND w.PointOfSaleID in (SELECT PointOfSaleID \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFROM pointofsaledepartment\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWHERE DepartmentID = i_department_id))\r\n\t\tAND wd.PointOfSaleID in (SELECT PointOfSaleID \r\n\t\t\t\t\t\t\t\t\t\t\tFROM pointofsaledepartment\r\n\t\t\t\t\t\t\t\t\t\t\tWHERE DepartmentID = i_department_id)\r\n\t\tORDER BY wd.WorkDayID DESC LIMIT 1\r\n\tINTO result;\r\n\tRETURN COALESCE(result, i_date);\r\nEND";
        String productCard_GetString = "BEGIN\n\tDECLARE result DECIMAL(15,4) DEFAULT 0;\n\tDECLARE PocetnoStanje DECIMAL(15,4) DEFAULT productCard_getInitialStockColumn(i_product_id, i_date_from, i_department_id);\n\tDECLARE start_of_period DATETIME DEFAULT workday_start_v5(i_department_id, i_date_from);\n\tDECLARE end_of_period DATETIME DEFAULT workday_end_v4(i_department_id, i_date_to);\n\tDECLARE d_Type INT DEFAULT 0;\n\tDECLARE d_Datum DATETIME DEFAULT NULL;\n\tDECLARE d_Ulaz DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_Izlaz DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_Stanje DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_NabavnaCena DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_NabavnaVrednost DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_ProdajnaCena DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_ProdajnaVrednost DECIMAL(15,4) DEFAULT 0;\n\tDECLARE d_Naziv_Dokumenta VARCHAR(256) DEFAULT 0;\n\tDECLARE d_Stanje_Trenutno DECIMAL(15,4) DEFAULT 0;\n\tDECLARE v_Count INT DEFAULT 0;\n\tDECLARE done INT DEFAULT FALSE;\n\tDECLARE cursor1 CURSOR FOR\n\t\tSELECT\n\t\t\tTip,\n\t\t\tDatum,\n\t\t\tUlaz,\n            Izlaz,\n            Stanje,\n            NabavnaCena,\n            NabavnaVrednost,\n            ProdajnaCena,\n            ProdajnaVrednost,\n            NazivDokumenta\n\t\tFROM temp_productCard\n        ORDER BY Datum;\n\tDECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;\n\tDROP TABLE IF EXISTS temp_productCard;\n    CREATE TABLE temp_productCard(\n    \tTip INT DEFAULT 0,\n\t\tDatum TIMESTAMP,\n\t\tUlaz DECIMAL(15,4) DEFAULT 0,\n\t\tIzlaz DECIMAL(15,4) DEFAULT 0,\n      Stanje DECIMAL(15,4) DEFAULT 0,\n\t\tNabavnaCena DECIMAL(15,4) DEFAULT 0,\n\t\tNabavnaVrednost DECIMAL(15,4) DEFAULT 0,\n\t\tProdajnaCena DECIMAL(15,4) DEFAULT 0,\n\t\tProdajnaVrednost DECIMAL(15,4) DEFAULT 0,\n\t\tNazivDokumenta VARCHAR(255)\n        );\n\tDROP TABLE IF EXISTS temp_productCard_pom;\n    CREATE TABLE temp_productCard_pom(\n    \tTip INT DEFAULT 0,\n\t\tDatum TIMESTAMP,\n\t\tUlaz DECIMAL(15,4) DEFAULT 0,\n\t\tIzlaz DECIMAL(15,4) DEFAULT 0,\n      Stanje DECIMAL(15,4) DEFAULT 0,\n\t\tNabavnaCena DECIMAL(15,4) DEFAULT 0,\n\t\tNabavnaVrednost DECIMAL(15,4) DEFAULT 0,\n\t\tProdajnaCena DECIMAL(15,4) DEFAULT 0,\n\t\tProdajnaVrednost DECIMAL(15,4) DEFAULT 0,\n\t\tNazivDokumenta VARCHAR(255)\n        );\n\tINSERT INTO temp_productCard \n    SELECT \n    \t\t0 AS Tip,\n\t\t\tDATE(i_date_from) AS Datum,\n\t\t\tCASE\n\t\t\t\tWHEN (PocetnoStanje > 0)\n\t\t\t\t\tTHEN\n\t\t\t\t\t\tPocetnoStanje\n\t\t\t\t\tELSE\n\t\t\t\t\t\t0\n\t\t\t\t\tEND\n\t\t\tAS Ulaz,\t\n\t\t\tCASE\n\t\t\t\tWHEN (PocetnoStanje < 0)\n\t\t\t\t\tTHEN\n\t\t\t\t\t\tPocetnoStanje*(-1)\n\t\t\t\t\tELSE\n\t\t\t\t\t\t0\n\t\t\t\t\tEND\n\t\t\tAS Izlaz,\n\t \t\tPocetnoStanje AS Stanje,\n\t \t\tproduct_last_input_price_before_date(i_product_id, i_date_from, i_department_id) AS NabavnaCena,\n\t \t\t(SELECT (Stanje * NabavnaCena)) AS NabavnaVrednost,\n\t \t\t0 As ProdajnaCena,\n\t \t\t0 AS ProdajnaVrednost,\n\t\t\tCONCAT('Pocetno stanje na dan ', DATE_FORMAT(DATE(i_date_from),'%d.%m.%Y.')) AS NazivDokumenta\n\t\tFROM product p\n\t\t\tLEFT JOIN unit u \n\t\t\t\tON u.UnitID = p.UnitID\n\t\t WHERE (p.ProductID = i_product_id);\n\tINSERT INTO temp_productCard \n\t\tSELECT\n\t\t\t\tdd.DocumentID AS Tip,\n\t\t\t\tIF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) AS Datum,\n\t\t\t\tSUM(dd.Quantity * dt.Stock) AS Ulaz,\n\t\t\t\t0 AS Izlaz,\n\t\t\t\t0 AS Stanje,\n\t\t\t\tdd.PriceWithDiscount AS NabavnaCena,\n\t\t\t\t(SELECT SUM(dd.Quantity * dt.Stock * dd.PriceWithDiscount)) AS NabavnaVrednost,\n\t\t\t\tCOALESCE(dd.NewPrice, 0) AS ProdajnaCena,\n\t\t\t\t(SELECT SUM(dd.Quantity * dt.Stock * ProdajnaCena)) AS ProdajnaVrednost,\n\t\t\t\tCONCAT(dt.Name, ' br. ', d.Number, ' od ', DATE_FORMAT(DATE(IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date)),'%d.%m.%Y.')) AS NazivDokumenta\n\t\t\tFROM documentdetails dd \n\t\t\t\tINNER JOIN document d\n\t\t\t\t\tON d.DocumentID = dd.DocumentID \n\t\t\tINNER JOIN documenttype dt\n\t\t\t\tON dt.DocumentTypeID = d.DocumentTypeID\n\t\t\tWHERE dd.ProductID = i_product_id\n\t\t\t\tAND d.DocumentTypeID IN (1, 12, 13, 16, 19, 22) \n\t\t\t\tAND d.DocumentStatusID=1\n\t\t\t\tAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= start_of_period\n\t\t\t\tAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) <= end_of_period\n\t\t\t\tAND d.DepartmentID = i_department_id\n group BY dd.DocumentID\t\tUNION\n\t\tSELECT\n\t\t\t\tdd.DocumentID AS Tip,\n        \t\td.Date AS Datum,\n\t\t\t\t0 AS Ulaz,\n\t\t\t\tif(d.DocumentTypeID = 3, \n\t\t\t\t\t(select SUM(dd1.Quantity) \n\t\t\t\t\t\tfrom documentdetails dd1 \n\t\t\t\t\t\twhere dd1.ProductID = i_product_id\n\t\t\t\t\t\tand dd1.DocumentID in (select d1.DocumentID from document d1 where d1.WorkDayID = d.WorkDayID \n\t\t\t\t\t\tand d1.DocumentTypeID = 3 and d1.DocumentStatusID =1 )), if(d.DocumentTypeID = 6, \n\t\t\t\t\t(select SUM(dd1.Quantity) \n\t\t\t\t\t\tfrom documentdetails dd1 \n\t\t\t\t\t\twhere dd1.ProductID = i_product_id\n\t\t\t\t\t\tand dd1.DocumentID in (select d1.DocumentID from document d1 where d1.WorkDayID = d.WorkDayID \n\t\t\t\t\t\tand d1.DocumentTypeID = 6 and d1.DocumentStatusID = 1 )), dd.Quantity)) AS Izlaz,\n\t\t\t\t0 AS Stanje,\n\t\t\t\t0 AS NabavnaCena,\n\t\t\t\t(SELECT + Izlaz * NabavnaCena) AS NabavnaVrednost,\n\t\t\t\t(SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= d.Date ORDER BY pld.ProductID DESC LIMIT 1) AS ProdajnaCena,\n\t\t\t\t(SELECT + Izlaz * ProdajnaCena) AS ProdajnaVrednost,\n\t\t\t\tCONCAT(IF(dt.DocumentTypeID = 3, CONCAT(\"Dnevni promet\",' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = d.PointOfSaleID), ')'), dt.Name), ' za ', DATE_FORMAT(DATE(d.Date),'%d.%m.%Y.')) AS NazivDokumenta\n\t\t\tFROM documentdetails dd \n\t\t\t\tLEFT JOIN document d\n\t\t\t\t\tON d.DocumentID = dd.DocumentID \n\t\t\t\tLEFT JOIN documenttype dt\n\t\t\t\t\tON dt.DocumentTypeID = d.DocumentTypeID\n\t\t\tWHERE dd.ProductID = i_product_id and d.DocumentStatusID = 1 \n\t\t\t\tAND dt.Stock = -1\n\t\t\t\tAND dt.DocumentTypeID NOT IN (SELECT dtt.DocumentTypeID FROM documenttype dtt WHERE dtt.Code = 'RE')\n\t\t\t\tAND dt.DocumentTypeID NOT IN (SELECT dtt.DocumentTypeID FROM documenttype dtt WHERE dtt.Code = 'F')\n\t\t\t\t\n\t\t\t\tAND d.Date BETWEEN start_of_period AND end_of_period\n\t\t\t\tAND (CASE \n\t\t\t\t\t\t\tWHEN COALESCE(d.DepartmentID, 0) = 0\n\t\t\t\t\t\t\tTHEN d.PointOfSaleID IN (SELECT PointOfSaleID\n\t\t\t\t\t\t\t\t\t\t\t\tFROM pointofsaledepartment\n\t\t\t\t\t\t\t\t\t\t\t\tWHERE DepartmentID = i_department_id)\n\t\t\t\t\t\t\tELSE d.DepartmentID = i_department_id\n\t\t\t\t\t\tEND)\n\tGROUP BY d.DocumentTypeID, IF(d.WorkDayID IS NOT NULL, d.WorkDayID, DATE(d.Date))\n\tORDER BY Datum;\n\tOPEN cursor1;\n\tread_loop: LOOP\n\t\tFETCH cursor1\n\t\t\tINTO d_Type, d_Datum, d_Ulaz, d_Izlaz, d_Stanje, d_NabavnaCena, d_NabavnaVrednost, d_ProdajnaCena, d_ProdajnaVrednost, d_Naziv_Dokumenta;\n\t\tIF done THEN\n\t\t\tLEAVE read_loop;\n\t\tEND IF;\n\t\tSET d_Stanje_Trenutno = d_Stanje_Trenutno + d_Ulaz - d_Izlaz;\n\t\t\tINSERT \n\t\t\t\tINTO temp_productCard_pom \n\t\t\t\tVALUES (\n\t\t\t\t\t d_Type,\n                d_Datum, \n                d_Ulaz,\n                d_Izlaz,\n                d_Stanje_Trenutno,\n                d_NabavnaCena, \n                d_NabavnaVrednost,\n\t\t\t\t\t d_ProdajnaCena,\n\t\t\t\t\t d_ProdajnaVrednost,\n                d_Naziv_Dokumenta\n                );\n\tEND LOOP;\n\tCLOSE cursor1;\n    SELECT * FROM temp_productCard_pom;\n\tDROP TABLE temp_productCard_pom;\n\tDROP TABLE temp_productCard;\nEND";
        String donosProcedure = "BEGIN \r\n\tDECLARE last_pocetno_stanje DATETIME DEFAULT poslednji_popis_department_pre_datuma_v5(i_department_id, i_date);\r\n\tDECLARE end_of_workday DATETIME DEFAULT workday_end_v4(i_department_id, i_date);\r\n\tDECLARE datum TIMESTAMP DEFAULT workday_start_v5(i_department_id, i_date);\r\n\tDECLARE donos_zaduzenja DECIMAL(15,2) DEFAULT 0;\r\n\tDECLARE donos_razduzenja DECIMAL(15,2) DEFAULT 0;\r\n\tDECLARE donos_nivelacija DECIMAL(15,2) DEFAULT 0;\r\n\tDECLARE donos_sum DECIMAL(15,2) DEFAULT 0;\r\n\tDECLARE donos_pocetno_stanje INTEGER;\r\n\tDECLARE daily_report INTEGER DEFAULT (SELECT COUNT(*) FROM dailyturnover dt WHERE dt.DailyTurnoverWorkDayID IN (SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = i_date));\r\n\tSELECT d.DocumentTypeID FROM document d\r\n\tWHERE d.DocumentTypeID = 11\r\n\tAND DATE(d.Date) = i_date\r\n\tINTO donos_pocetno_stanje;\r\n\tCASE \r\n      WHEN donos_pocetno_stanje = 11 THEN \r\n\t\t\tSELECT COALESCE(SUM(dd.Quantity * (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= datum ORDER BY pld.ProductID DESC LIMIT 1)),0) AS Zaduzenje\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE d.DocumentTypeID = 11\r\n\t\t\tAND DATE(d.Date) = DATE(i_date)\r\n\t\t\tORDER BY dd.ProductID\r\n\t\t\tINTO donos_zaduzenja;\r\n      ELSE       \t\t\t\t\r\n\t\t\tSELECT COALESCE(SUM(dd.Quantity * IF(d.DocumentTypeID = 1, (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= datum ORDER BY pld.ProductID DESC LIMIT 1),\r\n\t\t\tIF(d.DocumentTypeID = 11, (SELECT pld.Price FROM pricelistdetails pld WHERE pld.ProductID = dd.ProductID AND pld.Date <= datum ORDER BY pld.ProductID DESC LIMIT 1), dd.PriceWithDiscount))),0) AS Zaduzenje\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID \r\n\t\t\tLEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID\r\n\t\t\tWHERE if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= last_pocetno_stanje\r\n\t\t\tAND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) < datum\r\n\t\t\tAND dt.DocumentTypeID NOT IN (3, 15, 17, 20, 22)\r\n\t\t\tORDER BY dd.ProductID\r\n\t\t\tINTO donos_zaduzenja;\r\n    END CASE;\r\n    CASE \r\n      WHEN donos_pocetno_stanje = 11 THEN \r\n\t\t\tSELECT 0\r\n\t\t\tINTO donos_razduzenja;\r\n      ELSE       \t\t\t\t\r\n\t\t\tSELECT COALESCE(ROUND(SUM(dd.Quantity * IF(d.DocumentTypeID = 22, (-1) * dd.Price, dd.PriceWithDiscount)),4),0) AS Razduzenje\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tINNER JOIN document d ON d.DocumentID = dd.DocumentID\r\n\t\t\tWHERE d.DocumentTypeID IN (SELECT dt.DocumentTypeID FROM documenttype dt WHERE dt.DocumentTypeID = 3 OR dt.DocumentTypeID = 22)\r\n\t\t\tAND d.Date >= last_pocetno_stanje\r\n\t\t\tAND d.Date < datum\r\n\t\t\tORDER BY dd.ProductID\r\n\t\tINTO donos_razduzenja;\r\n    END CASE;\r\n\tCASE \r\n      WHEN donos_pocetno_stanje = 11 THEN \r\n\t\t\tSELECT 0\r\n\t\t\tINTO donos_nivelacija;\r\n      ELSE       \t\t\t\t\r\n\t\t\tSELECT COALESCE(ROUND(SUM(dd.Quantity * (dd.NewPrice - dd.Price)),4),0) AS Nivelacija\r\n\t\t\tFROM documentdetails dd\r\n\t\t\tINNER JOIN document d ON d.DocumentID = dd.DocumentID\r\n\t\t\tAND d.Date >= last_pocetno_stanje\r\n\t\t\tWHERE d.Date < datum\r\n\t\t\tAND d.DocumentTypeID = 15\r\n\t\t\tORDER BY dd.ProductID\r\n\t\t\tINTO donos_nivelacija;\r\n    END CASE;\t\r\n\tDROP TABLE IF EXISTS temp_donos;\r\n\tCREATE TABLE temp_donos(\r\n\t\tNazivDokumenta\tVARCHAR (50),\t\r\n\t\tVrednostPoDokumentu DECIMAL (15,2) DEFAULT 0,\r\n\t\tBrojDokumenta INT DEFAULT 0,\r\n\t\tDatumDokumenta DATE DEFAULT 0,\r\n\t\tTipDokumenta INT Default 0,\r\n\t\tStock INT Default 0,\r\n\t\tDonosZaduzenja DECIMAL (15,2) DEFAULT 0,\r\n\t\tDonosRazduzenja DECIMAL (15,2) DEFAULT 0,\r\n\t\tDonosSum DECIMAL (15,2) DEFAULT 0,\r\n\t\tSumZaduzenje DECIMAL (15,2) DEFAULT 0,\r\n\t\tSumRazduzenje DECIMAL (15,2) DEFAULT 0,\r\n\t\tSumPrenos DECIMAL (15,2) DEFAULT 0,\r\n\t\tDobavljac VARCHAR (128)\r\n\t\t);\r\n\tINSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos) VALUES (NULL, 0, -1, NULL, -1, 0, donos_zaduzenja + donos_nivelacija, donos_razduzenja, donos_zaduzenja + donos_nivelacija - donos_razduzenja, 0, 0, 0);\r\n\tINSERT INTO temp_donos\r\n\tSELECT\r\n\t(SELECT dt.Name\r\n\tFROM documenttype dt\r\n\tWHERE dt.DocumentTypeID = d.DocumentTypeID),\r\n\tSUM(ROUND(COALESCE(dd.Quantity *(IF( d.DocumentTypeID = 22, (-1 * dd.Price), IF(d.DocumentTypeID = 15,(dd.NewPrice - dd.Price), if(d.DocumentTypeID = 7, dd.NewPrice, \r\n\tIF(d.DocumentTypeID = 1, dd.NewPrice, dd.PriceWithDiscount))))),0),4)),\r\n\t(SELECT MIN(d1.Number)\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)),\r\n\t(SELECT (if(d.DocumentTypeID = 1, d1.DeliveryDate, d1.Date)) \r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)\r\n\t\tLIMIT 1),\r\n\t(SELECT MIN(d1.DocumentTypeID)\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)),\r\n\t(SELECT dt1.Stock FROM documenttype dt1 WHERE dt1.DocumentTypeID = d.DocumentTypeID),\r\n \t0,\r\n\t0,\r\n\t0,\r\n\t0,\r\n\t0,\r\n\t0,\r\n\t(SELECT (if(d.DocumentTypeID = 1, (SELECT CONCAT(p.Name, \", \", p.Address, \", \" , p.ZIP, \" \", p.City) FROM person p WHERE p.PersonID = d1.PersonID), 0))\r\n\t\tFROM documentdetails dd1\r\n\t\tJOIN document d1 ON d1.DocumentID = dd1.DocumentID\r\n\t\tWHERE d1.DocumentID in (d.DocumentID)\r\n\t\tLIMIT 1)\r\n\tFROM documentdetails dd\r\n\tJOIN document d ON d.DocumentID = dd.DocumentID \r\n\t  \t\t\t\t\t\t\t\tAND d.DocumentTypeID IN (SELECT dt1.DocumentTypeID \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFROM documenttype dt1\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWHERE dt1.DocumentTypeID <> 3 AND dt1.DocumentTypeID <> 11 AND dt1.DocumentTypeID <> 19 AND dt1.DocumentTypeID <> 17)\r\n\t\t\t\t\t\t\t\t\tAND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) > datum\r\n\t\t\t\t\t\t\t\t\tAND if(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) <= end_of_workday\r\n\t\t\t\t\t\t\t\t\tAND if(d.DocumentTypeID IN (6,17), d.PointOfSaleID IN \r\n\t\t\t\t\t\t\t\t\t(SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = i_department_id), \r\n\t\t\t\t\t\t\t\t\td.DepartmentID =  i_department_id)\r\n\tGROUP BY d.DocumentID;\r\n\tCASE \r\n      WHEN daily_report = 0 THEN \r\n      INSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos)\r\n      \tSELECT CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = d.PointOfSaleID),')'), SUM(dd.Quantity * dd.PriceWithDiscount), DAYOFYEAR(i_date) AS Number, wd.Date, 17, 0,0,0,0,0,0,0\r\n\t\t\t\tFROM documentdetails dd \r\n \t\t\t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID  \r\n \t\t\t\tLEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID \r\n\t\t\t\tWHERE d.DocumentTypeID = 3\r\n\t\t\t\tAND wd.Date = i_date \r\n\t\t\t\tGROUP BY d.PointOfSaleID;\r\n      ELSE      \r\n\t\t \t\tINSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumRazduzenje, SumZaduzenje, SumPrenos)\r\n\tSELECT CONCAT('Dnevni promet',' (', (SELECT pos.Name FROM pointofsale pos WHERE pos.PointOfSaleID = wd.PointOfSaleID),')'), (SELECT SUM(dd.Quantity * dd.PriceWithDiscount) \r\n \t\tFROM documentdetails dd \r\n \t\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID  \r\n \t\tLEFT JOIN workday wd ON wd.WorkDayID = d.WorkDayID \r\n \t\tWHERE wd.WorkDayID = dt.DailyTurnoverWorkDayID AND d.DocumentTypeID = 3), dt.DailyTurnoverNumber, DATE(dt.DailyTurnoverDate), 17, 0,0,0,0,0,0,0\r\n\t\tFROM dailyturnover dt \r\n\t\tLEFT JOIN workday wd ON wd.WorkDayID = dt.DailyTurnoverWorkDayID\r\n\t\tWHERE wd.Date = i_date GROUP BY wd.PointOfSaleID;\t\t\r\n    END CASE;\r\n\tINSERT INTO temp_donos (NazivDokumenta, VrednostPoDokumentu, BrojDokumenta, DatumDokumenta, TipDokumenta, Stock, DonosZaduzenja, DonosRazduzenja, DonosSum, SumZaduzenje, SumRazduzenje, SumPrenos) \r\n\tSELECT NULL, 0, -1, NULL, -1, 0, 0, 0, 0, \r\n\tSUM(IF(td.TipDokumenta = 17, 0, IF(td.TipDokumenta IN (22), 0, td.VrednostPoDokumentu))) + DonosZaduzenja, SUM(IF(td.TipDokumenta = 17, td.VrednostPoDokumentu, IF(td.TipDokumenta IN (22), td.VrednostPoDokumentu, 0))) + DonosRazduzenja, 0\r\n\tFROM temp_donos td;\r\n\tUPDATE temp_donos SET SumPrenos = SumZaduzenje - SumRazduzenje;\r\n\tSELECT * FROM temp_donos;\r\n\tDROP TABLE IF EXISTS temp_donos; \r\nEND";
        String stock_by_Product = "BEGIN\r\n\tDECLARE curren_stock DECIMAL (15,4);\r\n\t\r\n\tSELECT\r\n\tSUM(IF(d.DocumentTypeID=11, dd.Quantity, dd.Quantity * dt.Stock)) AS Stanje \r\n\tFROM documentdetails dd \r\n\tLEFT JOIN product p ON dd.ProductID = p.ProductID \r\n\tLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\n\tLEFT JOIN document d ON d.DocumentID = dd.DocumentID\r\n\tLEFT JOIN documenttype dt ON dt.DocumentTypeID = d.DocumentTypeID \r\n\tWHERE d.DocumentStatusID IN (1,2) \r\n\tAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) BETWEEN date_from AND date_to\r\n\tAND p.ProductTypeID = 1  \r\n\tAND (d.DepartmentID = 1 OR d.PointOfSaleID IN (SELECT posd.PointOfSaleID FROM pointofsaledepartment posd WHERE posd.DepartmentID = 1)) \r\n\tAND p.ProductID = product_id \r\n\tAND bc.BarCode = (SELECT bc1.BarCode FROM barcode bc1 WHERE bc1.ProductID = p.ProductID GROUP BY p.ProductID)  \r\n\tGROUP BY bc.ProductID  \r\n\tORDER BY CAST(TRIM(LEADING '0' FROM p.Code) AS DECIMAL(15,0)) ASC\r\n\t\r\n\tINTO curren_stock;\t\t\r\n\t\r\n\tRETURN COALESCE(curren_stock, 0);\r\nEND";
        if (User.getFromDb("928374", controller.getSettings().getConnection()) == null) {
            User admin = new User();
            admin.setActive(true);
            admin.setUserName("admin");
            admin.setPassword("928374");
            long id = admin.newUser(controller.getSettings().getConnection());
            for (PointOfSale pos : PointOfSale.getPosList(controller.getObject(), controller.getSettings().getConnection())) {
                User.insertUserIntoUserPOS(id, pos.getPointOfSaleID(), true, controller.getSettings().getConnection());
            }
            for (Role role : Role.getRoleList(controller.getSettings().getConnection())) {
                User.insertUserRole(id, role.getRoleID(), controller.getSettings().getConnection());
            }
        }
        System.out.println("dodavanje kolone update");
        if (databaseCheck.chechTable("document", "RefExternalNumber", controller)) {
            System.out.println("usao u if za dodavanje kolone update RefExternalNumber");
            databaseCheck.alterRefNumberExternal(controller);
        }
        databaseCheck.deleteFOREIGN(controller);
        databaseCheck.alterObject(controller);
        if (!productCard_GetString.equals(databaseCheck.getProcedureBody("productCard_get", controller))) {
            databaseCheck.dropProcedure("productCard_get", controller);
            databaseCheck.createFunctionProductCardGet(productCard_GetString, controller);
        }
        if (!databaseCheck.checkGrant(controller)) {
            databaseCheck.grantToDocumentDetails(controller);
            System.out.println("Grant je setovan");
        }
        if (PosMenu.getFullListID(User.getFromDb("928374", controller.getSettings().getConnection()).getUserID(), controller.getSettings().getConnection()).size() != PosMenu.getFullPosMenuList(controller.getSettings().getConnection()).size()) {
            PosMenu.deleteAllPosMenuUserByUserID(User.getFromDb("928374", controller.getSettings().getConnection()).getUserID(), controller);
            for (PosMenu posMenu : PosMenu.getFullPosMenuList(controller.getSettings().getConnection())) {
                PosMenu.insertUserIntoPosMenuUser(User.getFromDb("928374", controller.getSettings().getConnection()).getUserID(), posMenu.getPosMenuID(), controller.getSettings().getConnection());
            }
        }
        try {
            String sql = "SET GLOBAL sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''));";
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(sql);
            pStatement.executeUpdate();
            System.out.println("Izvrsen upit");
        }
        catch (Exception e) {
            System.out.println("Problem sa izvrsenjem upita za group by");
            e.printStackTrace();
        }
        if (databaseCheck.chechTable("documentpayment", "tax", controller)) {
            databaseCheck.createColumnWriteOffTax("documentpayment", "tax", controller);
        }
        if (databaseCheck.chechTable("companyconfig", "datum", controller)) {
            databaseCheck.createColumnDatum("companyconfig", "datum", controller);
        }
        if (databaseCheck.chechTable("document", "FullNumber1", controller)) {
            databaseCheck.createColumnFullNumber1("document", "FullNumber1", controller);
        }
        if (databaseCheck.chechTable("person", "efaktura", controller)) {
            databaseCheck.createColumnPerson("person", "efaktura", controller);
        }
        if (databaseCheck.chechTable("companyconfig", "licenca", controller)) {
            databaseCheck.createColumnLicenca("companyconfig", "licenca", controller);
        }
        if (RelationshipType.getByName(controller, "Racun - Gotovisnki racun") == null) {
            RelationshipType.insert(controller, "Racun - Gotovisnki racun");
        }
        if (RelationshipType.getByName(controller, "Racun - Rezervacija") == null) {
            RelationshipType.insert(controller, "Racun - Rezervacija");
        }
        if (RelationshipType.getByName(controller, "Rezervacija - Porudzbenica") == null) {
            RelationshipType.insert(controller, "Rezervacija - Porudzbenica");
        }
        if (RelationshipType.getByName(controller, "Profaktura - Rezervacija") == null) {
            RelationshipType.insert(controller, "Profaktura - Rezervacija");
        }
        if (!PriceListType.getByTitle(controller, "Cenovnik").booleanValue()) {
            PriceListType.insertTitle(controller, "Cenovnik");
        }
        if (!PriceListType.getByTitle(controller, "Akcija").booleanValue()) {
            PriceListType.insertTitle(controller, "Akcija");
        }
        if (PaymentMethod.getByCode("Voucher", controller.getSettings().getConnection()) == null) {
            PaymentMethod.insertPM(controller, "Voucher", "Vau\u010der", true);
        }
        if (PaymentMethod.getByCode("MobileMoney", controller.getSettings().getConnection()) == null) {
            PaymentMethod.insertPM(controller, "MobileMoney", "Instant pla\u0107anje", true);
        }
        if (PaymentMethod.getByCode("Other", controller.getSettings().getConnection()) == null) {
            PaymentMethod.insertPM(controller, "Other", "Ostalo", true);
        }
        if (PaymentMethod.getByNameMethod("WireTransfer", controller.getSettings().getConnection()).getName() != null) {
            PaymentMethod.updateName(controller, "WireTransfer", "Prenos na ra\u010dun", true);
        }
        if (PaymentMethod.getByNameMethod("CARD", controller.getSettings().getConnection()).getName() != null) {
            PaymentMethod.updateName(controller, "CARD", "Platna Kartica(K)", true);
        }
        if (PersonCategory.getByName("Interna-firma", controller.getSettings().getConnection()) == null) {
            PersonCategory.insertNewCategory("Interna-firma", true, false, controller);
        }
        if (PersonCategory.getByName("Kupac", controller.getSettings().getConnection()) == null) {
            if (PersonCategory.getByName("Rezervacija", controller.getSettings().getConnection()) == null) {
                PersonCategory.insertNewCategory("Rezervacija", true, false, controller);
                PersonCategory.updateCategory("Kupac", PersonCategory.getByName("Rezervacija", controller.getSettings().getConnection()).getPersonCategoryID(), controller);
            } else {
                PersonCategory.updateCategory("Kupac", PersonCategory.getByName("Rezervacija", controller.getSettings().getConnection()).getPersonCategoryID(), controller);
            }
        }
        if (Role.getRole("vise.racuna", controller) == null) {
            Role.insertRoleMasterDB(controller);
        }
        if (Role.getRole("zabrani.izmenu.prijemnice", controller) == null) {
            Role.insertRoleMasterDB(controller, "zabrani.izmenu.prijemnice", "Zabrana izmene prijemnice");
        }
        if (PosMenu.getByPosMenuCode("ODPL", controller.getSettings().getConnection()) == null) {
            PosMenu.insertMenu(controller, "ODPL", "Odlo\u017eeno pla\u0107anje", 1);
        }
        if (PosMenu.getByPosMenuCode("KEPK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "KEPK", "KEP", 6);
        }
        if (PosMenu.getByPosMenuName("Kupci", controller.getSettings().getConnection()) != null) {
            PosMenu.updateTitle("SIKU", "Kupci (pravna lica)", controller.getSettings().getConnection());
        }
        if (PosMenu.getByPosMenuCode("SIKUF", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SIKUF", "Kupci (fizi\u010dka lica)", PosMenu.getByPosMenuName((String)"\u0160ifarnici", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuName("Dodatna polja", controller.getSettings().getConnection()) != null) {
            PosMenu.updateTitle("SIDP", "Dodatne grupe", controller.getSettings().getConnection());
        }
        if (PosMenu.getByPosMenuCode("LOYAL", controller.getSettings().getConnection()) == null) {
            PosMenu.insertMenu(controller, "LOYAL", "Lojaliti", 1);
        }
        if (PosMenu.getByPosMenuCode("IZPRO", controller.getSettings().getConnection()) == null) {
            PosMenu.insertMenu(controller, "IZPRO", "Izve\u0161taji prodaje", 1);
        }
        if (PosMenu.getByPosMenuCode("PROART", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "PROART", "Prodati artikli", PosMenu.getByPosMenuName((String)"Izve\u0161taji prodaje", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("EXCTAX", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "EXCTAX", "Promet po PDV i akcizama", PosMenu.getByPosMenuName((String)"Izve\u0161taji prodaje", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("PRODODPO", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "PRODODPO", "Prodaja po dodatnim poljima", PosMenu.getByPosMenuName((String)"Izve\u0161taji prodaje", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("LOYGR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "LOYGR", "Loyaliti grupe", PosMenu.getByPosMenuName((String)"Lojaliti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("FIPO", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "FIPO", "Finansijski popust", PosMenu.getByPosMenuName((String)"Lojaliti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SOPO", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOPO", "Pode\u0161avanje objekta", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("AKCZ", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "AKCZ", "Akcize", PosMenu.getByPosMenuCode((String)"SIFR", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("ODPLU", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "ODPLU", "Uplate", PosMenu.getByPosMenuCode((String)"ODPL", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (DocumentType.getByCode("AVANS", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "AVANS", "AVANS", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("avans-refundacija", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "avans-refundacija", "avans-refundacija", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (PosMenu.getByPosMenuCode("IZPC", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZPC", "Izvestaj platnih kartica", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("RUC", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "RUC", "Razlika u ceni", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZSPK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZSPK", "Specifikacija dokumenata", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("NAPL", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "NAPL", "Na\u010din pla\u0107anja", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DNEVNIK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DNEVNIK", "Pregled dnevnika", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("PVFP", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "PVFP", "Promena vremena (FP)", 1);
        }
        if (PosMenu.getByPosMenuCode("GROFR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "GROFR", "Front grupe artikala", PosMenu.getByPosMenuName((String)"\u0160ifarnici", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SOPK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOPK", "Platne kartice", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZSKR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZSKR", "Loyaliti izve\u0161taji", PosMenu.getByPosMenuCode((String)"LOYAL", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("ADMKU", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "ADMKU", "Administracija kupaca", PosMenu.getByPosMenuCode((String)"ODPL", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("ADMBP", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "ADMBP", "Ci\u0161\u0107enje baze", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("KD", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "KD", "Kraj dana", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SOJM", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOJM", "Pode\u0161avanje jedinice mere", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOTP", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOTP", "Pregled otpremnica", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("STACE", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "STACE", "\u0160tampa cenovnika", PosMenu.getByPosMenuCode((String)"SIFR", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("BLKUIK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "BLKUIK", "Kartica komitenata", PosMenu.getByPosMenuName((String)"Blagajna", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SEOP", controller.getSettings().getConnection()) == null) {
            PosMenu.insertMenu(controller, "SEOP", "Servisne operacije", 1);
        }
        if (PosMenu.getByPosMenuCode("IZVPRPODANIMA", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZVPRPODANIMA", "Promet po danima", 6);
        }
        if (PosMenu.getByPosMenuCode("SOCI", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOCI", "Import CSV", PosMenu.getByPosMenuCode((String)"SEOP", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SICK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SICK", "Cenovnici komitenata", PosMenu.getByPosMenuCode((String)"SIFR", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SEPS", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SEPS", "Poreske stope", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZPPU", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZPPU", "Pregled prometa usluga", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOVPF", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOVPF", "VP faktura", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOVPFCM", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOVPFCM", "VP faktura magacin", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOIWR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOIWR", "Web racun", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOPRIJTCM", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOPRIJTCM", "Prijemnice skladiste", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SOSKL", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOSKL", "Podesavanje skladista", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("OTPIS", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "OTPIS", "Otpis", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZSZB", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZSZB", "Lager lista", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("PS", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "PS", "Pregled storna", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZSZB", controller.getSettings().getConnection()) == null) {
            PosMenu.updateTitle("IZSZB", "Lager lista", controller.getSettings().getConnection());
        }
        if (PosMenu.getByPosMenuCode("IZLLS", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZLLS", "Lager lista skladista", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("IZLPR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "IZLPR", "Lista Prodaje", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DIOTPW", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DIOTPW", "Interna otpremnica skladista", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DOIPRW", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DOIPRW", "Interna prijemnica skladista", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("RESER", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "RESER", "Rezervacija", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("ORDER", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "ORDER", "Porud\u017ebenica", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("BLGKI", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "BLGKI", "Knjiga izlaza", PosMenu.getByPosMenuName((String)"Blagajna", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("BLGKU", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "BLGKU", "Knjiga ulaza", PosMenu.getByPosMenuName((String)"Blagajna", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("BRART", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "BRART", "Brzi artikli", PosMenu.getByPosMenuName((String)"\u0160ifarnici", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("DORK", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "DORK", "Robna kartica", PosMenu.getByPosMenuName((String)"Izve\u0161taji", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if ((terminal = PosMenu.getByPosMenuCode("SOSU", controller.getSettings().getConnection())) == null) {
            PosMenu.insert(controller, "SOSU", "Podesavanje terminala", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        } else if (terminal.getTitle() != "Podesavanje terminala") {
            PosMenu.edit(controller, "SOSU", "Podesavanje terminala");
        }
        PosMenu NI = PosMenu.getByPosMenuCode("DONA", controller.getSettings().getConnection());
        if (NI.getTitle() != "Nalog za ispravku - refundacija") {
            PosMenu.edit(controller, "DONA", "Nalog za ispravku - refundacija");
        }
        if ((predracun = PosMenu.getByPosMenuCode("DOPROF", controller.getSettings().getConnection())).getTitle() != "Predracun - pregled") {
            PosMenu.edit(controller, "DOPROF", "Predracun - pregled");
        }
        if (PosMenu.getByPosMenuCode("SOSU", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOSU", "Podesavanje setup-a", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SOSB", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "SOSB", "Sinhronizacija baza", PosMenu.getByPosMenuName((String)"Servisne operacije", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (PosMenu.getByPosMenuCode("SILO", controller.getSettings().getConnection()) != null) {
            PosMenu posMenu = PosMenu.getByPosMenuCode("SILO", controller.getSettings().getConnection());
            posMenu.setTitle("Loyalti kupci");
            posMenu.update(controller);
        }
        if (PosMenu.getByPosMenuCode("INACTIVEDOIR", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "INACTIVEDOIR", "Stornirani ra\u010duni", PosMenu.getByPosMenuName((String)"Dokumenti", (Connection)controller.getSettings().getConnection()).PosMenuID);
        }
        if (databaseCheck.chechTable("printer", "numOfCharacters", controller)) {
            databaseCheck.createColumnNumOfCharacters("printer", "numOfCharacters", "Paperwidth", controller);
        }
        if (databaseCheck.chechTable("person", "JBKJS", controller)) {
            databaseCheck.createColumnJBKJSI("person", "JBKJS", controller);
        }
        if (databaseCheck.chechTable("object", "apiKey", controller)) {
            databaseCheck.createColumnObject("object", "apiKey", controller);
        }
        if (databaseCheck.chechTable("object", "idCompany", controller)) {
            databaseCheck.createColumnObject("object", "idCompany", controller);
        }
        if (PosMenu.getByPosMenuCode("PRINT", controller.getSettings().getConnection()) == null) {
            PosMenu.insert(controller, "PRINT", "Pode\u0161avanje \u0161tampa\u010da", PosMenu.getByPosMenuName((String)"Administracija", (Connection)controller.getSettings().getConnection()).PosMenuID);
            Printer printer = new Printer();
            printer.setName("Pos Printer 57 mm");
            printer.setServerName("POS");
            printer.setNumOfCharacters(36);
            printer.setCopies(1);
            printer.setPaperwidth(57);
            printer.setActive(true);
            printer.insertPrinter(this.connection);
        }
        if (PosMenu.getByPosMenuCode("IZLLS", controller.getSettings().getConnection()) != null) {
            PosMenu.delete("IZLLS", controller);
        }
        if (DocumentType.getByCode("WR", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Web racun", "WR", 1, Calendar.getInstance().get(1), -1, -1);
        }
        if (DocumentType.getByCode("GR", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Gotovinski racun", "GR", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("IPW", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Interna prijemnica skladista", "IPW", 1, Calendar.getInstance().get(1), 1, 1);
        }
        if (DocumentType.getByCode("IOW", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Interna otpremnica skladista", "IOW", 1, Calendar.getInstance().get(1), -1, -1);
        }
        if (DocumentType.getByCode("VPF", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Veleprodajna faktura", "VPF", 1, Calendar.getInstance().get(1), -1, -1);
        }
        if (DocumentType.getByCode("RE", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Rezervacija", "RE", 1, Calendar.getInstance().get(1), -1, 1);
        }
        if (DocumentType.getByCode("POR", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Porud\u017ebenica", "POR", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("RACKOP", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Ra\u010dun-kopija", "RACKOP", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("RACTRE", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Ra\u010dun-trening", "RACTRE", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("REFKOP", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Refundacija-kopija", "REFKOP", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("REFTRE", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Refundacija-trening", "REFTRE", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (DocumentType.getByCode("REFPRED", controller.getSettings().getConnection()) == null) {
            DocumentType.insert(controller, "Refundacija-predra\u010dun", "REFPRED", 1, Calendar.getInstance().get(1), 0, 0);
        }
        if (controller.getSettings().getRow("rezervacija.front.vidljivo.dugme")) {
            controller.getSettings().insert("rezervacija.front.vidljivo.dugme", "false");
        }
        if (controller.getSettings().getRow("24h.radno.vreme")) {
            controller.getSettings().insert("24h.radno.vreme", "false");
        }
        if (controller.getSettings().getRow("scale.button.is.visible")) {
            controller.getSettings().insert("scale.button.is.visible", "false");
        }
        if (controller.getSettings().getRow("barkod.vidljiv.izlazni.dokumenti")) {
            controller.getSettings().insert("barkod.vidljiv.izlazni.dokumenti", "false");
        }
        if (controller.getSettings().getRow("protel.active")) {
            controller.getSettings().insert("protel.active", "false");
        }
        if (controller.getSettings().getRow("documentLock.active")) {
            controller.getSettings().insert("documentLock.active", "false");
        }
        if (controller.getSettings().getRow("protel.connection.path")) {
            controller.getSettings().insert("protel.connection.path", "");
        }
        if (controller.getSettings().getRow("KWS.aktivan")) {
            controller.getSettings().insert("KWS.aktivan", "false");
        }
        if (controller.getSettings().getRow("barcode.front.slova")) {
            controller.getSettings().insert("barcode.front.slova", "false");
        }
        if (controller.getSettings().getRow("fifo_nabavna_cena")) {
            controller.getSettings().insert("fifo_nabavna_cena", "false");
        }
        if (controller.getSettings().getRow("company.memorandum.boolean")) {
            controller.getSettings().insert("company.memorandum.boolean", "true");
        }
        if (controller.getSettings().getRow("napomena.web.racun")) {
            controller.getSettings().insert("napomena.web.racun", "");
        }
        if (controller.getSettings().getRow("napomena.vp.faktura")) {
            controller.getSettings().insert("napomena.vp.faktura", "");
        }
        if (controller.getSettings().getRow("automatska.stampa.faktura")) {
            controller.getSettings().insert("automatska.stampa.faktura", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.faktura")) {
            controller.getSettings().insert("broj.kopija.faktura", "2");
        }
        if (controller.getSettings().getRow("automatska.stampa.veleprodajnefaktura")) {
            controller.getSettings().insert("automatska.stampa.veleprodajnefaktura", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.veleprodajnefaktura")) {
            controller.getSettings().insert("broj.kopija.veleprodajnefaktura", "2");
        }
        if (controller.getSettings().getRow("automatska.stampa.profaktura")) {
            controller.getSettings().insert("automatska.stampa.profaktura", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.profaktura")) {
            controller.getSettings().insert("broj.kopija.profaktura", "2");
        }
        if (controller.getSettings().getRow("automatska.stampa.otpremnica")) {
            controller.getSettings().insert("automatska.stampa.otpremnica", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.otpremnica")) {
            controller.getSettings().insert("broj.kopija.otpremnica", "2");
        }
        if (controller.getSettings().getRow("automatska.stampa.gotovinski")) {
            controller.getSettings().insert("automatska.stampa.gotovinski", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.gotovinski")) {
            controller.getSettings().insert("broj.kopija.gotovinski", "1");
        }
        if (controller.getSettings().getRow("automatska.stampa.web.racuna")) {
            controller.getSettings().insert("automatska.stampa.web.racuna", "true");
        }
        if (controller.getSettings().getRow("broj.kopija.web.racuna")) {
            controller.getSettings().insert("broj.kopija.web.racuna", "2");
        }
        if (controller.getSettings().getRow("dnevni.izvestaj.aktivan")) {
            controller.getSettings().insert("dnevni.izvestaj.aktivan", "false");
        }
        if (controller.getSettings().getRow("otpremnica.uska-stampa.detalji.firme")) {
            controller.getSettings().insert("otpremnica.uska-stampa.detalji.firme", "false");
        }
        if (controller.getSettings().getRow("excel.microcer")) {
            controller.getSettings().insert("excel.microcer", "false");
        }
        if (controller.getSettings().getRow("excel.microcer.bills")) {
            controller.getSettings().insert("excel.microcer.bills", "false");
        }
        if (controller.getSettings().getRow("loyalty.point.action")) {
            controller.getSettings().insert("loyalty.point.action", "false");
        }
        if (controller.getSettings().getRow("excel.microcer.folder")) {
            controller.getSettings().insert("excel.microcer.folder", "");
        }
        if (controller.getSettings().getRow("got.bill.print")) {
            controller.getSettings().insert("got.bill.print", "true");
        }
        if (controller.getSettings().getRow("tmaster.light")) {
            controller.getSettings().insert("tmaster.light", "false");
        }
        if (controller.getSettings().getRow("print.A4")) {
            controller.getSettings().insert("print.A4", "false");
        }
        if (controller.getSettings().getRow("invoice.A4")) {
            controller.getSettings().insert("invoice.A4", "true");
        }
        if (controller.getSettings().getRow("zd.automatski")) {
            controller.getSettings().insert("zd.automatski", "false");
        }
        if (controller.getSettings().getRowLike("zd.automatski.vreme")) {
            controller.getSettings().insert("zd.automatski.vreme.23:59:59", "true");
        }
        if (databaseCheck.chechTable("offerprice", "FirstPrice", controller)) {
            databaseCheck.createColumnFirstPriceInOfferPrice(controller);
        }
        if (databaseCheck.chechTable("offerprice", "RoundActive", controller)) {
            databaseCheck.createColumnRoundActiveInOfferPrice(controller);
        }
        if (databaseCheck.chechTable("offerprice", "PriceListTypeID", controller)) {
            databaseCheck.createColumnOPriceListTypeIDInOfferPrice(controller);
        }
        if (databaseCheck.chechTable("buyerofferprice", "PriceListTypeID", controller)) {
            databaseCheck.createColumnOPriceListTypeIDInBuyerOfferPrice(controller);
        }
        if (databaseCheck.chechTable("financialdiscount", controller)) {
            databaseCheck.createFinancialDiscountTable(controller);
        }
        if (databaseCheck.chechTable("loyaltyfinancialdiscount", controller)) {
            databaseCheck.createLoyaltyFinancialDiscountTable(controller);
        }
        if (databaseCheck.chechTable("loyaltygroup", controller)) {
            databaseCheck.createLoyaltyGroupTable(controller);
        }
        if (databaseCheck.chechTable("dailyturnover", controller)) {
            databaseCheck.createDailyTurnoverTable(controller);
        }
        if (databaseCheck.chechTable("groupproduct", controller)) {
            databaseCheck.createGroupProductTable(controller);
        }
        if (databaseCheck.chechTable("paycard", controller)) {
            databaseCheck.createPayCardTable(controller);
        }
        if (databaseCheck.chechTable("synchronization", controller)) {
            databaseCheck.createSynchronizationTable(controller);
        }
        if (databaseCheck.chechTable("present", controller)) {
            databaseCheck.createPresentTable(controller);
        }
        if (databaseCheck.chechTable("loyaltylimit", controller)) {
            databaseCheck.createLoyaltyLimitTable(controller);
        }
        if (databaseCheck.chechTable("documentpaycard", controller)) {
            databaseCheck.createDocumentPayCardTable(controller);
        }
        if (databaseCheck.chechTable("excise", controller)) {
            databaseCheck.createExciseTable(controller);
        }
        if (databaseCheck.chechTable("billcancellation", controller)) {
            databaseCheck.createTablePonistavanjeFiskalnog(controller);
        }
        if (databaseCheck.chechTable("exciseproduct", controller)) {
            databaseCheck.createExciseProductTable(controller);
        }
        if (databaseCheck.chechTable("deferred", controller)) {
            databaseCheck.createDeferredTable(controller);
        }
        if (databaseCheck.chechTable("deferredrecord", controller)) {
            databaseCheck.createDeferredRecordTable(controller);
        }
        if (databaseCheck.chechTable("quickgroup", controller)) {
            databaseCheck.createQuickGroupTable(controller);
        }
        if (databaseCheck.chechTable("person", "DetailsPrintNumber", controller)) {
            databaseCheck.createColumnDetailsPrintNumberInPerson("person", "DetailsPrintNumber", controller);
        }
        if (databaseCheck.chechTable("person", "Phone", controller)) {
            databaseCheck.createColumnPhoneInPerson("person", "Phone", controller);
        }
        if (databaseCheck.chechTable("person", "Email", controller)) {
            databaseCheck.createColumnEmailInPerson("person", "Email", controller);
        }
        if (databaseCheck.chechTable("person", "TaxExempt", controller)) {
            databaseCheck.createColumnTaxExamptInPerson("person", "TaxExempt", controller);
        }
        if (databaseCheck.chechTable("loyality", "Points", controller)) {
            databaseCheck.deleteLoyalityTable(controller);
            databaseCheck.createLoyalityTable(controller);
        }
        if (databaseCheck.chechTable("loyality", "VIPLoyaltyPrice", controller)) {
            databaseCheck.createColumnVIPLoyaltyPriceInLoyality("loyality", "VIPLoyaltyPrice", controller);
        }
        if (databaseCheck.chechTable("loyality", "Note", controller)) {
            databaseCheck.createColumnNoteInLoyality("loyality", "Note", controller);
        }
        if (databaseCheck.chechTable("document", "Note2", controller)) {
            databaseCheck.createColumnNote2InDocument("document", "Note2", "Note", controller);
        }
        if (databaseCheck.chechTable("giftcard", "Name", controller)) {
            databaseCheck.createColumnNote2InDocument("giftcard", "Name", "Code", controller);
        }
        if (databaseCheck.chechTable("loyality", "LoyaltyGroupID", controller)) {
            databaseCheck.createColumnLoyaltyGroupIDInLoyality("loyality", "LoyaltyGroupID", controller);
            LoyaltyGroup loyaltyGroup = new LoyaltyGroup();
            loyaltyGroup.setName("Stalni kupac");
            loyaltyGroup.setDefaultDiscount(0.0);
            long id = loyaltyGroup.insert(controller);
            for (Loyality loyality : Loyality.getLoyList(controller)) {
                loyality.setLoyaltyGroupId(id);
                loyality.update(controller.getSettings().getConnection());
            }
        }
        if (databaseCheck.chechTable("loyality", "PeriodDays", controller)) {
            databaseCheck.createColumnPeriodDaysInLoyality("loyality", "PeriodDays", controller);
        }
        if (databaseCheck.chechTable("pricelistdetails", "documentId", controller)) {
            databaseCheck.createColumnDocumentIdInPriceListDetails(controller);
        }
        if (databaseCheck.chechTable("document", "documentLocked", controller)) {
            databaseCheck.createDocumentLockedInDocument(controller);
        }
        if (databaseCheck.chechTable("document", "invoiceId", controller)) {
            databaseCheck.createColumnDocument("document", "invoiceId", controller);
        }
        if (databaseCheck.chechTable("document", "salesInvoiceId", controller)) {
            databaseCheck.createColumnDocument("document", "salesInvoiceId", controller);
        }
        if (databaseCheck.chechTable("document", "purchaseInvoiceId", controller)) {
            databaseCheck.createColumnDocument("document", "purchaseInvoiceId", controller);
        }
        if (databaseCheck.chechTable("document", "buyerCostCenterId", controller)) {
            databaseCheck.createDocumenbuyerCostCenterId(controller);
        }
        if (databaseCheck.chechTable("unit", "Measurable", controller)) {
            databaseCheck.createColumnMeasurableUnit("unit", "Measurable", controller);
        }
        if (databaseCheck.chechTable("object", "bank", controller)) {
            databaseCheck.createColumnObjectBankAndBankAccount("object", "bank", controller);
        }
        if (databaseCheck.chechTable("object", "ObjectVatTypeID", controller)) {
            databaseCheck.createColumnObjectVatTypeID(controller);
        }
        if (databaseCheck.chechTable("document", "PayCardSlipNumber", controller)) {
            databaseCheck.createColumnDocumentPayCardSlipNumber("document", "PayCardSlipNumber", controller);
        }
        if (databaseCheck.chechTable("productdepartment", "AverageValue", controller)) {
            databaseCheck.createColumnAverageValueInPD("productdepartment", "AverageValue", controller);
        }
        if (databaseCheck.chechTable("productcategory", "UtrosciPrikaz", controller)) {
            databaseCheck.createColumnUtrosciPrikaz("productcategory", "UtrosciPrikaz", controller);
        }
        if (databaseCheck.chechTableColumn("offerprice", "Quantity", controller)) {
            databaseCheck.deleteColumn("offerprice", "Quantity", controller);
        }
        if (databaseCheck.chechTable("group", "Color", controller)) {
            databaseCheck.createColumnColorGroup("group", "Color", controller);
        }
        if (databaseCheck.chechTable("groupproduct", "Color", controller)) {
            databaseCheck.createColumnColorGroupProduct("groupproduct", "Color", controller);
        }
        if (!databaseCheck.chechTableColumn("documentdetails", "productName", controller)) {
            databaseCheck.createColumnProductNameInDocumentDetail("documentdetails", "productName", controller);
            databaseCheck.fillColumnProductNameInDocumentDetail(controller);
        }
        if (!databaseCheck.chechTableColumn("document", "ReferentNumber", controller)) {
            databaseCheck.createStringColumn("document", "ReferentNumber", "fullNumber", 30, controller);
        }
        if (!databaseCheck.chechTableColumn("document", "ReferentDateTime", controller)) {
            databaseCheck.createStringColumn("document", "ReferentDateTime", "documentLocked", 50, controller);
        }
        if (!databaseCheck.chechTableColumn("document", "BuyerIdentification", controller)) {
            databaseCheck.createStringColumn("document", "BuyerIdentification", "ReferentDateTime", 50, controller);
        }
        if (!databaseCheck.chechTableColumn("documentdetails", "refundQuantity", controller)) {
            databaseCheck.createDoubleColumn("documentdetails", "refundQuantity", "Quantity", 7, controller);
            if (databaseCheck.chechFunction("productCard_getWarehouse", controller)) {
                databaseCheck.createFunctionProductCardGetWarehouse(controller);
            }
            if (databaseCheck.chechFunction("productCard_get", controller)) {
                databaseCheck.createFunctionProductCardGet(productCard_GetString, controller);
            }
            if (databaseCheck.chechFunction("sold_items_workday", controller)) {
                databaseCheck.createFunctionSoldItemsWorkday(controller);
            }
            if (databaseCheck.chechFunction("stock_by_product", controller)) {
                databaseCheck.createFunctionStockByProduct(controller, stock_by_Product);
            }
            if (databaseCheck.chechFunction("donos", controller)) {
                databaseCheck.createFunctionDonos(controller);
            }
            if (!databaseCheck.getProcedureBody("donos", controller).equals(donosProcedure)) {
                databaseCheck.dropProcedure("donos", controller);
                databaseCheck.createFunctionDonos(controller);
            }
            if (!databaseCheck.getFunctionBody("stock_by_product", controller).equals(stock_by_Product)) {
                databaseCheck.dropFunction("stock_by_product", controller);
                databaseCheck.createFunctionStockByProduct(controller, stock_by_Product);
            }
            if (!databaseCheck.getFunctionBody("workday_end_v4", controller).equals(word_day_off)) {
                databaseCheck.dropFunction("workday_end_v4", controller);
                databaseCheck.createFunctionWorkday_end_v4(controller, word_day_off);
            }
            if (databaseCheck.chechFunction("filter", controller)) {
                databaseCheck.createProceduteFilter(controller);
            }
            if (databaseCheck.chechTable("cashbuyers", controller)) {
                databaseCheck.createCashBuyersTable(controller);
            }
            if (databaseCheck.chechTable("cashbuyers", controller)) {
                databaseCheck.createCashBuyersTable(controller);
            }
            if (databaseCheck.chechTable("cashbuyers", "MB", controller)) {
                databaseCheck.createColumnMB("cashbuyers", "cashbuyers", controller);
            }
            if (databaseCheck.chechTable("buyerofferprice", controller)) {
                databaseCheck.createBuyerOfferPriceTable(controller);
            }
            if (databaseCheck.chechTable("buyerofferpricedetails", controller)) {
                databaseCheck.createBuyerOfferPriceDetailsTable(controller);
            }
            if (databaseCheck.chechConstraintName(controller, "buyerofferpricedetails", "fk_buyerofferprice_id")) {
                databaseCheck.createConstraintNameFkBuyyerOfferPriceId(controller);
            }
            if (databaseCheck.chechTable("paymentrecord", controller)) {
                databaseCheck.createPaymentRecordTable(controller);
            }
            if (databaseCheck.chechTable("offerprice", controller)) {
                databaseCheck.createOfferPriceTable(controller);
            }
            if (databaseCheck.chechTable("csvimporttype", controller)) {
                databaseCheck.createCsvImportType(controller);
            }
            if (databaseCheck.chechTable("csvimport", controller)) {
                databaseCheck.createCsvImport(controller);
            }
            if (databaseCheck.chechTable("images", controller)) {
                databaseCheck.createImages(controller);
            }
            if (databaseCheck.chechTable("offerpricedetails", controller)) {
                databaseCheck.createOfferPriceDetailsTable(controller);
            }
            if (databaseCheck.chechTable("offerpricedetails", "Quantity", controller)) {
                databaseCheck.createColumnOfferPriceDetailsQuantity("offerpricedetails", "Quantity", controller);
            }
            if (databaseCheck.chechTable("product", "DiscountAllowed", controller)) {
                databaseCheck.createDiscountAllowed("product", "", controller);
            }
            if (databaseCheck.chechTable("document", "Realized", controller)) {
                databaseCheck.createRealized("document", "", controller);
            }
            if (databaseCheck.chechTable("document", "Reservated", controller)) {
                databaseCheck.createReservated("document", "", controller);
            }
            if (databaseCheck.chechTable("product", "WriteOff", controller)) {
                databaseCheck.createColumnWriteOff("product", "WriteOff", controller);
            }
            if (databaseCheck.chechTable("document", "CashBuyersID", controller)) {
                databaseCheck.createColumnCashBuyersID("document", "", controller);
            }
            if (databaseCheck.chechTable("document", "DependentExpenses", controller)) {
                databaseCheck.createColumnDependentExpenses("document", "", controller);
            }
            if (databaseCheck.chechTable("document", "Name", controller)) {
                databaseCheck.createColumnName("document", "", controller);
            }
            if (databaseCheck.chechTable("document", "JMBG", controller)) {
                databaseCheck.createColumnJMBG("document", "", controller);
            }
            if (!databaseCheck.chechTable("cashbuyers", "addressId", controller)) {
                databaseCheck.deleteAddressID(controller);
            }
            if (databaseCheck.chechTable("cashbuyers", "address", controller)) {
                databaseCheck.createAddressCashbuyers("cashbuyers", "address", controller);
            }
            if (databaseCheck.chechTable("cashbuyers", "city", controller)) {
                databaseCheck.createCityCashbuyers("cashbuyers", "city", controller);
            }
            if (databaseCheck.chechTable("cashbuyers", "ZIP", controller)) {
                databaseCheck.createZIPCashbuyers("cashbuyers", "ZIP", controller);
            }
            if (!databaseCheck.chechTable("buyerofferpricedetails", "Quantity", controller)) {
                databaseCheck.deleteColumnBuyerOfferPriceDetailsQuantity("buyerofferpricedetails", "Quantity", controller);
            }
            if (databaseCheck.chechTable("person", "CurrencyPaymentDays", controller)) {
                databaseCheck.createColumnCurrencyPaymentDaysInPerson("person", "CurrencyPaymentDays", controller);
            }
            if (databaseCheck.chechTable("person", "BuyerOfferPriceID", controller)) {
                databaseCheck.createColumnBuyerOfferPriceIDInPerson("person", "BuyerOfferPriceID", controller);
            }
            if (databaseCheck.chechFunction("current_price_before_date_prijemnica", controller)) {
                databaseCheck.createFunctionCurrent_price_before_date_prijemnica(controller);
            }
            if (databaseCheck.chechFunction("current_price_before_date_prijemnica_centralni_magacin", controller)) {
                databaseCheck.createFunctionCurrent_price_before_date_prijemnica_centralni_magacin(controller);
            }
            if (databaseCheck.chechFunction("getFakturaIDDokumenta", controller)) {
                databaseCheck.createFunctionGetFakturaIDDokumenta(controller);
            }
            if (databaseCheck.chechFunction("productCard_getInitialStockColumn", controller)) {
                databaseCheck.createFunctionProductCard_getInitialStockColumn(controller);
            }
            if (!databaseCheck.isColumnUnique("giftcard", "Code", controller)) {
                databaseCheck.makeColumnUnique("giftcard", "Code", controller);
            }
            if (CsvImportType.getByName(controller, "Cenovnik") == null) {
                long id = CsvImportType.insert(controller, "Cenovnik");
                CsvImport.insert(controller, id, "Cena", "price");
                CsvImport.insert(controller, id, "Bar Kod", "barcode");
            }
            if (CsvImportType.getByName(controller, "Cenovnik Akcija") == null) {
                long id = CsvImportType.insert(controller, "Cenovnik Akcija");
                CsvImport.insert(controller, id, "Akcijska Cena", "Akcijska cena");
                CsvImport.insert(controller, id, "Bar Kod", "Bar kod");
                CsvImport.insert(controller, id, "Popust", "Popust");
                CsvImport.insert(controller, id, "Kolicina", "Kolicina");
            }
            if (CsvImportType.getByName(controller, "Prijemnica") == null) {
                long id = CsvImportType.insert(controller, "Prijemnica");
                CsvImport.insert(controller, id, "Cena", "price");
                CsvImport.insert(controller, id, "Bar Kod", "barcode");
            }
            if (CsvImportType.getByName(controller, "Pocetno stanje") == null) {
                long id = CsvImportType.insert(controller, "Pocetno stanje");
                CsvImport.insert(controller, id, "Bar Kod", "barcode");
                CsvImport.insert(controller, id, "Kolicina", "qty");
            }
            if (CsvImportType.getByName(controller, "Popis") == null) {
                long id = CsvImportType.insert(controller, "Popis");
                CsvImport.insert(controller, id, "Bar Kod", "barcode");
                CsvImport.insert(controller, id, "Kolicina", "qty");
            }
            if (CsvImportType.getByName(controller, "Otpis") == null) {
                long id = CsvImportType.insert(controller, "Otpis");
                CsvImport.insert(controller, id, "Bar Kod", "barcode");
                CsvImport.insert(controller, id, "Kolicina", "qty");
            }
            Person.addNoteColumnToPerson(this.connection);
            PersonVatType.checkPersonVatType(this.connection, "Poljoprivredno gazdinstvo");
        }
    }
}

