/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class MailingList {
    private long mailingListID;
    private String name;
    private String eMail;
    private String report;
    private InputStream reportFileInput;
    private long mailingListTypeID;

    public long getMailingListID() {
        return this.mailingListID;
    }

    public void setMailingListID(long mailingListID) {
        this.mailingListID = mailingListID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public InputStream getReportFileInput() {
        return this.reportFileInput;
    }

    public void setReportFileInput(InputStream reportFileInput) {
        this.reportFileInput = reportFileInput;
    }

    public long getMailingListTypeID() {
        return this.mailingListTypeID;
    }

    public void setMailingListTypeID(long mailingListTypeID) {
        this.mailingListTypeID = mailingListTypeID;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `mailinglist` (`Name`, `Email`, `Report`, `ReportFile`, `MailingListTypeID`) VALUES (?, ?, ?, ?, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setString(2, this.eMail);
            pStatement.setString(3, this.report);
            pStatement.setBlob(4, this.reportFileInput);
            pStatement.setLong(5, 1L);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<MailingList> getListByEmail(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT m.Email FROM mailinglist m";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                MailingList mList = new MailingList();
                mList.seteMail(rSet.getString("Email"));
                list.add((Object)mList);
            }
            ps.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<MailingList> getListByName(ScreensController controller, String name) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM mailinglist m WHERE m.Email = '" + name + "'";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                MailingList mList = new MailingList();
                mList.setMailingListID(rSet.getLong("MailingListID"));
                mList.setName(rSet.getString("Name"));
                mList.seteMail(rSet.getString("Email"));
                mList.setReport(rSet.getString("Report"));
                mList.setReportFileInput(rSet.getBinaryStream("ReportFile"));
                list.add((Object)mList);
            }
            ps.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<MailingList> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM mailinglist m";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                MailingList mList = new MailingList();
                mList.setMailingListID(rSet.getLong("MailingListID"));
                mList.setName(rSet.getString("Name"));
                mList.seteMail(rSet.getString("Email"));
                mList.setReport(rSet.getString("Report"));
                mList.setReportFileInput(rSet.getBinaryStream("ReportFile"));
                list.add((Object)mList);
            }
            ps.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<MailingList> getReportNumber(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT m.Report FROM mailinglist m GROUP BY m.Report";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                MailingList mList = new MailingList();
                mList.setReport(rSet.getString("Report"));
                list.add((Object)mList);
            }
            ps.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

