/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IdCard {
    private int idCardID;
    private long userID;
    private String code;
    private boolean active;

    public int getIdCardID() {
        return this.idCardID;
    }

    public void setIdCardID(int idCardID) {
        this.idCardID = idCardID;
    }

    public long getUserID() {
        return this.userID;
    }

    public void setUserID(long userID) {
        this.userID = userID;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static void insertUserIdCard(long userID, String code, Connection connection) {
        String query = "INSERT INTO idcard (UserID, Code) VALUES (?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.setString(2, code);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String getCode(long userID, Connection connection) {
        String query = "SELECT ic.Code FROM idcard ic WHERE ic.UserID = ?";
        IdCard ic = new IdCard();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            ic.code = rs.getString("Code");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ic.code;
    }

    public static void updateCode(long userID, String code, Connection connection) {
        String query = "UPDATE idcard SET Code = ? WHERE UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, code);
            ps.setLong(2, userID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteIdCardByUserId(long userID, Connection connection) {
        String query = "DELETE FROM idcard WHERE UserID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static IdCard getByUserID(long userID, Connection connection) {
        String query = "SELECT * FROM idcard ic WHERE ic.UserID = ?";
        IdCard ic = new IdCard();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, userID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            ic.idCardID = rs.getInt("IdCardID");
            ic.userID = rs.getLong("UserID");
            ic.code = rs.getString("Code");
            ic.active = rs.getBoolean("Active");
        }
        catch (SQLException e) {
            return null;
        }
        return ic;
    }
}

