/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Excise {
    private long exciseId;
    private String name;
    private double value;

    public long getExciseId() {
        return this.exciseId;
    }

    public void setExciseId(long exciseId) {
        this.exciseId = exciseId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return this.name;
    }

    public static ObservableList<Excise> getList(ScreensController controller, String filter) {
        ObservableList lista = FXCollections.observableArrayList();
        String query = "SELECT * FROM excise e WHERE e.Name LIKE ? ORDER BY e.Name";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Excise excise = new Excise();
                excise.setExciseId(rSet.getLong("ExciseID"));
                excise.setName(rSet.getString("Name"));
                excise.setValue(rSet.getDouble("value"));
                lista.add((Object)excise);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public static Excise getById(ScreensController controller, long id) {
        String query = "SELECT * FROM excise e WHERE e.ExciseID = ? ORDER BY e.Name";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            Excise excise = new Excise();
            excise.setExciseId(rSet.getLong("ExciseID"));
            excise.setName(rSet.getString("Name"));
            excise.setValue(rSet.getDouble("value"));
            return excise;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`excise` (`Name`, `Value`) VALUES (?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.value);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`excise` SET `Name` = ?, `Value` = ? WHERE  `ExciseID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setDouble(2, this.value);
            pStatement.setLong(3, this.exciseId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`excise` WHERE  `ExciseID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.exciseId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

