/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Deferred;

public class DeferredRecord {
    private long deferredRecordId;
    private long deferredId;
    private Date dateRecive;
    private double amount;

    public long getDeferredRecordId() {
        return this.deferredRecordId;
    }

    public void setDeferredRecordId(long deferredRecordId) {
        this.deferredRecordId = deferredRecordId;
    }

    public long getDeferredId() {
        return this.deferredId;
    }

    public void setDeferredId(long deferredId) {
        this.deferredId = deferredId;
    }

    public Date getDateRecive() {
        return this.dateRecive;
    }

    public void setDateRecive(Date dateRecive) {
        this.dateRecive = dateRecive;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public static ObservableList<DeferredRecord> getDeferredsRecordList(ScreensController controller, Deferred deferred) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * from deferredrecord dr WHERE dr.DeferredID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, deferred.getDeferredId());
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                DeferredRecord deferredRecord = new DeferredRecord();
                deferredRecord.setDeferredRecordId(rSet.getLong("DeferredRecordID"));
                deferredRecord.setDeferredId(rSet.getLong("DeferredID"));
                deferredRecord.setDateRecive(rSet.getTimestamp("DateRecive"));
                deferredRecord.setAmount(rSet.getDouble("Amount"));
                list.add((Object)deferredRecord);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `masterdb`.`deferredrecord` (`DeferredID`, `DateRecive`, `Amount`) VALUES (?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.deferredId);
            pStatement.setTimestamp(2, new Timestamp(this.dateRecive.getTime()));
            pStatement.setDouble(3, this.amount);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

