/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DeferredRecord;

public class Deferred {
    private long deferredId;
    private String name;
    private String surname;
    private String address;
    private String city;
    private String phoneNumber;
    private String eMail;
    private double currentAmount;
    private double maxAmount;
    private int maxDaysDeferred;
    private boolean blocked;
    private double amountRecord;
    DeferredRecord deferredRecord;

    public double getAmountRecord() {
        return this.amountRecord;
    }

    public void setAmountRecord(double amountRecord) {
        this.amountRecord = amountRecord;
    }

    public long getDeferredId() {
        return this.deferredId;
    }

    public void setDeferredId(long deferredId) {
        this.deferredId = deferredId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public double getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(double maxAmount) {
        this.maxAmount = maxAmount;
    }

    public int getMaxDaysDeferred() {
        return this.maxDaysDeferred;
    }

    public void setMaxDaysDeferred(int maxDaysDeferred) {
        this.maxDaysDeferred = maxDaysDeferred;
    }

    public DeferredRecord getDeferredRecord() {
        return this.deferredRecord;
    }

    public void setDeferredRecord(DeferredRecord deferredRecord) {
        this.deferredRecord = deferredRecord;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void delete(long deferredId, ScreensController controller) {
    }

    public static ObservableList<Deferred> getDeferredsList(ScreensController controller, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM deferred d WHERE (d.Name LIKE ? OR d.Surname LIKE ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            pStatement.setString(2, "%" + filter + "%");
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Deferred deferred = new Deferred();
                deferred.setDeferredId(rSet.getLong("DeferredID"));
                deferred.setName(rSet.getString("Name"));
                deferred.setSurname(rSet.getString("Surname"));
                deferred.setAddress(rSet.getString("Address"));
                deferred.setCity(rSet.getString("City"));
                deferred.setPhoneNumber(rSet.getString("PhoneNumber"));
                deferred.seteMail(rSet.getString("Email"));
                deferred.setCurrentAmount(rSet.getDouble("CurrentAmount"));
                deferred.setMaxAmount(rSet.getDouble("MaxAmount"));
                deferred.setMaxDaysDeferred(rSet.getInt("MaxDaysDeferred"));
                deferred.setBlocked(rSet.getBoolean("Blocked"));
                list.add((Object)deferred);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Deferred> getDeferredsReciveList(ScreensController controller, String filter) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.*, COALESCE(SUM(dr.Amount), 0) AS AmountRecived FROM deferred d LEFT JOIN deferredrecord dr ON dr.DeferredID = d.DeferredID  WHERE (d.Name LIKE ? OR d.Surname LIKE ?) GROUP BY dr.DeferredID";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, "%" + filter + "%");
            pStatement.setString(2, "%" + filter + "%");
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Deferred deferred = new Deferred();
                deferred.setDeferredId(rSet.getLong("DeferredID"));
                deferred.setName(rSet.getString("Name"));
                deferred.setSurname(rSet.getString("Surname"));
                deferred.setAddress(rSet.getString("Address"));
                deferred.setCity(rSet.getString("City"));
                deferred.setPhoneNumber(rSet.getString("PhoneNumber"));
                deferred.seteMail(rSet.getString("Email"));
                deferred.setCurrentAmount(rSet.getDouble("CurrentAmount"));
                deferred.setMaxAmount(rSet.getDouble("MaxAmount"));
                deferred.setMaxDaysDeferred(rSet.getInt("MaxDaysDeferred"));
                deferred.setBlocked(rSet.getBoolean("Blocked"));
                deferred.setAmountRecord(rSet.getDouble("AmountRecived"));
                list.add((Object)deferred);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`deferred` (`Name`, `Surname`, `Address`, `City`, `PhoneNumber`, `Email`, `MaxAmount`, `MaxDaysDeferred`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setString(2, this.surname);
            pStatement.setString(3, this.address);
            pStatement.setString(4, this.city);
            pStatement.setString(5, this.phoneNumber);
            pStatement.setString(6, this.eMail);
            pStatement.setDouble(7, this.maxAmount);
            pStatement.setInt(8, this.maxDaysDeferred);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`deferred` SET `Name` = ?, `Surname` = ?, `Address` = ?, `City` = ?, `PhoneNumber` = ?, `Email` = ?, `MaxAmount` = ?, `MaxDaysDeferred` = ?, `Blocked` = ? WHERE  `DeferredID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.setString(2, this.surname);
            pStatement.setString(3, this.address);
            pStatement.setString(4, this.city);
            pStatement.setString(5, this.phoneNumber);
            pStatement.setString(6, this.eMail);
            pStatement.setDouble(7, this.maxAmount);
            pStatement.setInt(8, this.maxDaysDeferred);
            pStatement.setBoolean(9, this.blocked);
            pStatement.setLong(10, this.deferredId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentAmount(ScreensController controller) {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`deferred` SET  `CurrentAmount` = ? WHERE  `DeferredID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setDouble(1, this.currentAmount);
            pStatement.setLong(2, this.deferredId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

