/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.ScriptRunner;
import rs.petcom.master.queries.Queries;
import rs.petcom.master.queries.QueryName;

public class DatabaseCheck {
    private String table_name;
    private String tabel_column;
    private static final Logger LOGGER = Logger.getLogger("global");

    public String getTable_name() {
        return this.table_name;
    }

    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    public String getTabel_column() {
        return this.tabel_column;
    }

    public void setTabel_column(String tabel_column) {
        this.tabel_column = tabel_column;
    }

    public boolean chechTable(String table, String column, ScreensController controller) {
        String query = "SELECT COUNT(*) As brr FROM information_schema.COLUMNS  WHERE TABLE_SCHEMA = '" + controller.getSettings().getDatabase() + "'  AND table_name = ? AND column_name = ?";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, table);
            pStatement.setString(2, column);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) == 0) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }

    public boolean checkGrant(ScreensController screensController) {
        LOGGER.info("sELECT * FROM `settings` where settings.actual like'%grant%");
        String query = "Select user from mysql.user; ";
        boolean grant = false;
        try {
            PreparedStatement ps = screensController.getSettings().getConnection().prepareStatement(query);
            ps.execute();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                LOGGER.info("grant postoji");
                if (!rs.getString("user").equals("petcom")) continue;
                grant = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return grant;
    }

    public boolean chechTableColumn(String table, String column, ScreensController controller) {
        String query = "SELECT COUNT(*) As brr FROM information_schema.COLUMNS  WHERE TABLE_SCHEMA = '" + controller.getSettings().getDatabase() + "'  AND table_name = ? AND column_name = ?";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, table);
            pStatement.setString(2, column);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) != 0) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }

    public boolean chechConstraintName(ScreensController controller, String table, String constraintName) {
        String query = "SELECT COUNT(*) As brr\r\nFROM information_schema.REFERENTIAL_CONSTRAINTS\r\nWHERE CONSTRAINT_SCHEMA = '" + controller.getSettings().getDatabase() + "'\r\nAND TABLE_NAME = '" + table + "'\r\nAND CONSTRAINT_NAME = '" + constraintName + "'";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) == 0) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }

    public void createConstraintNameFkBuyyerOfferPriceId(ScreensController controller) {
        String query = "ALTER TABLE `buyerofferpricedetails`\r\n\tADD CONSTRAINT `fk_buyerofferprice_id` FOREIGN KEY (`BuyerOfferPriceID`) REFERENCES `buyerofferprice` (`BuyerOfferPriceID`) ON UPDATE CASCADE;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteFOREIGN(ScreensController controller) {
        String query = "ALTER TABLE document DROP FOREIGN KEY document_ibfk_8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void grantToDocumentDetails(ScreensController controller) {
        String sql = "GRANT SELECT, INSERT, UPDATE, CREATE, DROP, RELOAD, SHUTDOWN, PROCESS, FILE, \nREFERENCES, INDEX, ALTER, SHOW DATABASES, SUPER, CREATE TEMPORARY TABLES, CREATE VIEW, EVENT, TRIGGER, SHOW VIEW, CREATE ROUTINE,execute, ALTER ROUTINE ON *.* TO 'petcom'@'localhost' WITH GRANT OPTION;\n";
        String sqlDatabase = "CREATE USER 'petcom'@'localhost' IDENTIFIED BY '928374';";
        System.out.printf("pokusaj setovanja granta", new Object[0]);
        try {
            LOGGER.info("dodat grant");
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(sqlDatabase);
            pStatement.executeUpdate();
            pStatement = controller.getSettings().getConnection().prepareStatement(sql);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.info("GRESKA GRANT");
            e.printStackTrace();
        }
    }

    public boolean chechTable(String table, ScreensController controller) {
        String query = "SELECT COUNT(*) As brr FROM information_schema.COLUMNS  WHERE TABLE_SCHEMA = '" + controller.getSettings().getDatabase() + "'  AND table_name = ?";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, table);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) == 0) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }

    public boolean chechFunction(String functionName, ScreensController controller) {
        String query = "SELECT count(*) AS brr FROM mysql.proc WHERE db = '" + controller.getSettings().getDatabase() + "' AND name = ?";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, functionName);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) == 0) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }

    public void createFunctionCurrent_price_before_date_prijemnica(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` FUNCTION `current_price_before_date_prijemnica`(\t`i_product_id` BIGINT,\t`i_datetime` DATETIME,\t`i_department_id` INT) RETURNS decimal(15,2)    READS SQL DATA BEGIN\tDECLARE result DECIMAL (15,2); DECLARE result1 DECIMAL (15,2) DEFAULT 0;\tDECLARE v_object_id INT; select dep.ObjectID\tfrom department dep where dep.DepartmentID = i_department_id\tinto v_object_id; select pld.Price from pricelistdetails pld\tjoin pricelist pl on pl.PriceListID = pld.PriceListID\t\t\t\t\t\t\t\tand pl.PriceListTypeID = 1\t\t\t\t\t\t\t\tand pl.Active = true\t\t\t\t\t\t\t\tand pl.DateFrom <= i_datetime\t\t\t\t\t\t\t\tand (pl.DateTo is null or pl.DateTo >= i_datetime)\t\t\t\t\t\t\t\tand (pl.ObjectID = v_object_id or pl.ObjectID is null) where pld.ProductID = i_product_id and pld.Date <= i_datetime order by pld.Date desc limit 1 \tINTO result; if(result is null)\tthen\t select coalesce(pld.Price,0) from pricelistdetails pld\tjoin pricelist pl on pl.PriceListID = pld.PriceListID\t\t\t\t\t\t\tand pl.PriceListTypeID = 1\t\t\t\t\t\t\tand (pl.Active = true\t\t\t\t\t\t\tand pl.DateFrom <= i_datetime\t\t\t\t\t\t\tand (pl.DateTo is null) or (pl.DateTo >= i_datetime)\t\t\t\t\t\t\tand (pl.ObjectID = v_object_id or pl.ObjectID is null)) \twhere pld.ProductID = i_product_id and pld.Date > i_datetime \torder by pld.Date desc limit 1\t INTO result1;  end if; RETURN coalesce(result,result1); END";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionProductCardGet(String body, ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` PROCEDURE `productCard_get`(IN `i_product_id` BIGINT, IN `i_date_from` DATE, IN `i_date_to` DATE, IN `i_department_id` INT\r\n\r\n)\r\n    READS SQL DATA\r\n    DETERMINISTIC\r\n" + body;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionProductCardGetWarehouse(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` PROCEDURE `productCard_getWarehouse`(IN `i_product_id` BIGINT, IN `i_date_from` DATE, IN `i_date_to` DATE, IN `i_warehouse_id` INT\r\n)\r\n    READS SQL DATA\r\n    DETERMINISTIC\r\nBEGIN\r\n\tDECLARE result DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_Type INT DEFAULT 0;\r\n\tDECLARE d_Datum DATETIME DEFAULT NULL;\r\n\tDECLARE d_Ulaz DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_Izlaz DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_Stanje DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_NabavnaCena DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_NabavnaVrednost DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_ProdajnaCena DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_ProdajnaVrednost DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE d_Naziv_Dokumenta VARCHAR(256) DEFAULT 0;\r\n\tDECLARE d_Stanje_Trenutno DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE v_Count INT DEFAULT 0;\r\n\tDECLARE done INT DEFAULT FALSE;\r\n\tDECLARE cursor1 CURSOR FOR\r\n\t\tSELECT\r\n\t\t\tTip,\r\n\t\t\tDatum,\r\n\t\t\tUlaz,\r\n            Izlaz,\r\n            Stanje,\r\n            NabavnaCena,\r\n            NabavnaVrednost,\r\n            ProdajnaCena,\r\n            ProdajnaVrednost,\r\n            NazivDokumenta\r\n\t\tFROM temp_productCard\r\n        ORDER BY Datum;\r\n\tDECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;\r\n\tDROP TABLE IF EXISTS temp_productCard;\r\n    CREATE TABLE temp_productCard(\r\n    \tTip INT DEFAULT 0,\r\n\t\tDatum TIMESTAMP,\r\n\t\tUlaz DECIMAL(15,4) DEFAULT 0,\r\n\t\tIzlaz DECIMAL(15,4) DEFAULT 0,\r\n      Stanje DECIMAL(15,4) DEFAULT 0,\r\n\t\tNabavnaCena DECIMAL(15,4) DEFAULT 0,\r\n\t\tNabavnaVrednost DECIMAL(15,4) DEFAULT 0,\r\n\t\tProdajnaCena DECIMAL(15,4) DEFAULT 0,\r\n\t\tProdajnaVrednost DECIMAL(15,4) DEFAULT 0,\r\n\t\tNazivDokumenta VARCHAR(255)\r\n        );\r\n\tDROP TABLE IF EXISTS temp_productCard_pom;\r\n    CREATE TABLE temp_productCard_pom(\r\n    \tTip INT DEFAULT 0,\r\n\t\tDatum TIMESTAMP,\r\n\t\tUlaz DECIMAL(15,4) DEFAULT 0,\r\n\t\tIzlaz DECIMAL(15,4) DEFAULT 0,\r\n      Stanje DECIMAL(15,4) DEFAULT 0,\r\n\t\tNabavnaCena DECIMAL(15,4) DEFAULT 0,\r\n\t\tNabavnaVrednost DECIMAL(15,4) DEFAULT 0,\r\n\t\tProdajnaCena DECIMAL(15,4) DEFAULT 0,\r\n\t\tProdajnaVrednost DECIMAL(15,4) DEFAULT 0,\r\n\t\tNazivDokumenta VARCHAR(255)\r\n\t\t);\r\n\tINSERT INTO temp_productCard \r\n\t\tSELECT\r\n\t\t\t\tdd.DocumentID AS Tip,\r\n\t\t\t\tIF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) AS Datum,\r\n\t\t\t\tdd.Quantity * dt.Stock AS Ulaz,\r\n\t\t\t\t0 AS Izlaz,\r\n\t\t\t\t0 AS Stanje,\r\n\t\t\t\tdd.PriceWithDiscount AS NabavnaCena,\r\n\t\t\t\t(SELECT Ulaz * NabavnaCena) AS NabavnaVrednost,\r\n\t\t\t\t0 AS ProdajnaCena,\r\n\t\t\t\t0 AS ProdajnaVrednost,\r\n\t\t\t\tCONCAT(dt.Name, ' br. ', d.Number, ' od ', DATE_FORMAT(DATE(IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date)),'%d.%m.%Y.')) AS NazivDokumenta\r\n\t\t\tFROM documentdetails dd \r\n\t\t\t\tINNER JOIN document d\r\n\t\t\t\t\tON d.DocumentID = dd.DocumentID \r\n\t\t\tINNER JOIN documenttype dt\r\n\t\t\t\tON dt.DocumentTypeID = d.DocumentTypeID\r\n\t\t\tWHERE dd.ProductID = i_product_id\r\n\t\t\t\tAND dt.Stock = 1\r\n\t\t\t\tAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) >= '2018-01-01 08:00:00'\r\n\t\t\t\tAND IF(d.DocumentTypeID = 1, d.DeliveryDate, d.Date) <= now()\r\n\t\t\t\tAND d.WarehouseID = i_warehouse_id\r\n\t\tUNION\r\n\t\tSELECT\r\n\t\t\t\tdd.DocumentID AS Tip,\r\n        \t\td.Date AS Datum,\r\n\t\t\t\t0 AS Ulaz,\r\n\t\t\t\tdd.Quantity AS Izlaz,\r\n\t\t\t\t0 AS Stanje,\r\n\t\t\t\tproduct_last_input_price_before_date(i_product_id, dd.sysDTCreated, i_warehouse_id) AS NabavnaCena,\r\n\t\t\t\t(SELECT + Izlaz * NabavnaCena) AS NabavnaVrednost,\r\n\t\t\t\tcurrent_price_before_date(i_product_id, dd.sysDTCreated, i_warehouse_id) AS ProdajnaCena,\r\n\t\t\t\t(SELECT + Izlaz * ProdajnaCena) AS ProdajnaVrednost,\r\n\t\t\t\tCONCAT(dt.Name, ' za ', DATE_FORMAT(DATE(d.Date),'%d.%m.%Y.')) AS NazivDokumenta\r\n\t\t\tFROM documentdetails dd \r\n\t\t\t\tINNER JOIN document d\r\n\t\t\t\t\tON d.DocumentID = dd.DocumentID \r\n\t\t\t\tINNER JOIN workday w \r\n\t\t\t\t\tON w.WorkDayID = d.WorkDayID \r\n\t\t\t\tINNER JOIN documenttype dt\r\n\t\t\t\t\tON dt.DocumentTypeID = d.DocumentTypeID\r\n\t\t\tWHERE dd.ProductID = i_product_id\r\n\t\t\t\tAND dt.Stock = -1\r\n\t\t\t\tAND d.DocumentTypeID NOT IN (3,18)\r\n\t\t\t\tAND w.DateFrom >= '2018-01-01 08:00:00'\r\n\t\t\t\tAND w.Date <= now()\r\n\t\t\t\tAND d.WarehouseID = i_warehouse_id\r\n\t\tORDER BY Datum;\r\n\tOPEN cursor1;\r\n\tread_loop: LOOP\r\n\t\tFETCH cursor1\r\n\t\t\tINTO d_Type, d_Datum, d_Ulaz, d_Izlaz, d_Stanje, d_NabavnaCena, d_NabavnaVrednost, d_ProdajnaCena, d_ProdajnaVrednost, d_Naziv_Dokumenta;\r\n\t\tIF done THEN\r\n\t\t\tLEAVE read_loop;\r\n\t\tEND IF;\r\n\t\tSET d_Stanje_Trenutno = d_Stanje_Trenutno + d_Ulaz - d_Izlaz;\r\n\t\t\tINSERT \r\n\t\t\t\tINTO temp_productCard_pom \r\n\t\t\t\tVALUES (\r\n\t\t\t\t\t d_Type,\r\n                d_Datum, \r\n                d_Ulaz,\r\n                d_Izlaz,\r\n                d_Stanje_Trenutno,\r\n                d_NabavnaCena, \r\n                d_NabavnaVrednost,\r\n\t\t\t\t\t d_ProdajnaCena,\r\n\t\t\t\t\t d_ProdajnaVrednost,\r\n                d_Naziv_Dokumenta\r\n                );\r\n\tEND LOOP;\r\n\tCLOSE cursor1;\r\n    SELECT * FROM temp_productCard_pom;\r\n\tDROP TABLE temp_productCard_pom;\r\n\tDROP TABLE temp_productCard;\r\nEND";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionCurrent_price_before_date_prijemnica_centralni_magacin(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` FUNCTION `current_price_before_date_prijemnica_centralni_magacin`(\t`i_product_id` BIGINT,\t`i_datetime` DATETIME,\t`i_object_id` INT) RETURNS decimal(15,2)    READS SQL DATA BEGIN\tDECLARE result DECIMAL (15,2); DECLARE result1 DECIMAL (15,2) DEFAULT 0; select pld.Price from pricelistdetails pld\tjoin pricelist pl on pl.PriceListID = pld.PriceListID\t\t\t\t\t\t\t\tand pl.PriceListTypeID = 1\t\t\t\t\t\t\t\tand pl.Active = true\t\t\t\t\t\t\t\tand pl.DateFrom <= i_datetime\t\t\t\t\t\t\t\tand (pl.DateTo is null or pl.DateTo >= i_datetime)\t\t\t\t\t\t\t\tand (pl.ObjectID = i_object_id or pl.ObjectID is null) where pld.ProductID = i_product_id and pld.Date <= i_datetime order by pld.Date desc limit 1 \tINTO result; if(result is null)\tthen\t select coalesce(pld.Price,0) from pricelistdetails pld\tjoin pricelist pl on pl.PriceListID = pld.PriceListID\t\t\t\t\t\t\tand pl.PriceListTypeID = 1\t\t\t\t\t\t\tand (pl.Active = true\t\t\t\t\t\t\tand pl.DateFrom <= i_datetime\t\t\t\t\t\t\tand (pl.DateTo is null) or (pl.DateTo >= i_datetime)\t\t\t\t\t\t\tand (pl.ObjectID = i_object_id or pl.ObjectID is null)) \twhere pld.ProductID = i_product_id and pld.Date > i_datetime \torder by pld.Date desc limit 1\t INTO result1;  end if; RETURN coalesce(result,result1); END";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionGetFakturaIDDokumenta(ScreensController controller) {
        String query = "CREATE FUNCTION `getFakturaIDDokumenta`(`i_DokumentID` BIGINT) RETURNS int(11)\r\nBEGIN\r\n\tDECLARE Result INTEGER;\r\n    \r\n\tSELECT d.DocumentID\r\n\t\tFROM document d\r\n\t\tINNER JOIN documentrelationship dr\r\n\t\t\tON d.DocumentID = dr.DocumentChildID\r\n\t\tWHERE dr.DocumentParentID = i_DokumentID\r\n\t\t\tAND d.DocumentTypeID = 4\r\n\tINTO Result;\r\n\r\nRETURN Result;\r\nEND";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionProductCard_getInitialStockColumn(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` FUNCTION `productCard_getInitialStockColumn`(`i_product_id` BIGINT, `i_date` DATE, `i_department_id` INT) RETURNS decimal(15,4)\r\n    READS SQL DATA\r\nBEGIN\r\n\tDECLARE result DECIMAL(15,4) DEFAULT 0;\r\n \tDECLARE last_pocetno_stanje DATETIME DEFAULT poslednji_popis_department_pre_datuma_v5(i_department_id, i_date);\r\n\tDECLARE start_of_workday DATETIME DEFAULT workday_start_v4(i_department_id, i_date);\r\n\r\n\tDECLARE umanjenje INT DEFAULT 0;\r\n\r\n\tDECLARE pocetno_stanje DECIMAL(15,4) DEFAULT 0;\r\n\tDECLARE productType INT DEFAULT 0;\r\n\r\n\r\n\t\t-- Pocetno stanje\r\n\t\tSELECT sum(dd.Quantity)\r\n\t\t\tFROM documentdetails dd INNER JOIN document d\r\n\t\t\t\tON d.DocumentID = dd.DocumentID \r\n\t\t\tWHERE dd.ProductID = i_product_id\r\n\t\t\t\tAND d.DocumentTypeID = 11\r\n\t\t\t\tAND d.Date = last_pocetno_stanje\r\n\t\t\t\tAND d.DepartmentID = i_department_id\r\n\t\tINTO pocetno_stanje;\r\n  \r\n\tSET result =  coalesce(pocetno_stanje,0);\r\n\r\n\tRETURN result;\r\nEND";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionDonos(ScreensController controller) {
        String query = Queries.QUERIES.get((Object)QueryName.DONOS);
        ScriptRunner runner = new ScriptRunner(controller.getSettings().getConnection(), false, true);
        System.out.println(query);
        try {
            runner.runScript(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(query), "UTF-8")));
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void createProceduteFilter(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` PROCEDURE `filter`(IN `i_product` VARCHAR(50), IN `i_active` TINYINT, IN `i_department_id` INT, IN `i_group` INT\r\n, IN `i_filter_type` VARCHAR(50)\r\n)\r\n    READS SQL DATA\r\nBEGIN\r\nIF i_department_id = 0 THEN\r\n\t\tIF i_filter_type = \"Sve\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere (p.Code like i_product or p.Name like i_product or b.BarCode = i_product) and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\r\n\t\tIF i_filter_type = \"Sifra\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere p.Code LIKE i_product and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\r\n\t\tIF i_filter_type = \"Barkod\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere b.BarCode = i_product and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(b.BarCode), b.BarCode ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\r\n\t\tIF i_filter_type = \"Naziv\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere p.Name like i_product and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Name), p.Name ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\t\t\t\r\nELSE\r\n\t\tIF i_group = 0 THEN\r\n\t\t\tIF i_filter_type = \"Sve\" THEN\r\n\t\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\t\tfrom product p \r\n\t\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\t\twhere (p.Code like i_product or p.Name like i_product or b.BarCode = i_product) and p.Active = i_active and pd.DepartmentID = i_department_id\r\n\t\t\t\tgroup by pd.ProductID\r\n\t\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\t\tlimit 30;\r\n\t\t\tEND IF;\r\n\t\t\tIF i_filter_type = \"Sifra\" THEN\r\n\t\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\t\tfrom product p \r\n\t\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\t\twhere p.Code LIKE i_product and p.Active = i_active and pd.DepartmentID = i_department_id\r\n\t\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\t\tlimit 30;\r\n\t\t\tEND IF;\r\n\t\t\tIF i_filter_type = \"Barkod\" THEN\r\n\t\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\t\tfrom product p \r\n\t\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\t\twhere b.BarCode = i_product and p.Active = i_active and pd.DepartmentID = i_department_id\r\n\t\t\t\tgroup by pd.ProductID\r\n\t\t\t\torder by LENGTH(b.BarCode), b.BarCode ASC\r\n\t\t\t\tlimit 30;\r\n\t\t\tEND IF;\r\n\t\t\tIF i_filter_type = \"Naziv\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere p.Name like i_product and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Name), p.Name ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\t\r\nELSE\r\n\t\tIF i_filter_type = \"Sve\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere (p.Code like i_product or p.Name like i_product or b.BarCode = i_product) and p.Active = i_active and pd.DepartmentID = i_department_id and g.GroupID = i_group\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\t\r\n\t\tIF i_filter_type = \"Sifra\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere p.Code LIKE i_product and p.Active = i_active and pd.DepartmentID = i_department_id and g.GroupID = i_group\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Code), p.Code ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\t\r\n\t\tIF i_filter_type = \"Barkod\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere b.BarCode = i_product and p.Active = i_active and pd.DepartmentID = i_department_id and g.GroupID = i_group\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(b.BarCode), b.BarCode ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\r\n\t\tIF i_filter_type = \"Naziv\" THEN\r\n\t\t\tselect distinct p.`*`, u.Name as UnitName, pd.`*`\r\n\t\t\tfrom product p \r\n\t\t\tleft join productdepartment pd on pd.ProductID = p.ProductID\r\n\t\t\tleft join unit u on u.UnitID = p.UnitID \r\n\t\t\tleft join barcode b on b.ProductID = p.ProductID\r\n\t\t\twhere p.Name like i_product and p.Active = i_active\r\n\t\t\tgroup by pd.ProductID\r\n\t\t\torder by LENGTH(p.Name), p.Name ASC\r\n\t\t\tlimit 30;\r\n\t\tEND IF;\t\r\n\tEND IF;\t\r\nEND IF;\r\nEND";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createOfferPriceTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `offerprice` (\r\n  `OfferPriceID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `ObjectID` int(11) DEFAULT NULL,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Quantity` int(11) NOT NULL DEFAULT '2',\r\n  `DateFrom` datetime NOT NULL,\r\n  `DateTo` datetime NOT NULL,\r\n  `Active` bit(1) NOT NULL,\r\n  `FirstPrice` bit(1) NOT NULL DEFAULT b'0',\r\n  `RoundActive` bit(1) NOT NULL DEFAULT b'0',\r\n  PRIMARY KEY (`OfferPriceID`),\r\n  KEY `FK_offerprice_object` (`ObjectID`),\r\n  CONSTRAINT `FK_offerprice_object` FOREIGN KEY (`ObjectID`) REFERENCES `object` (`ObjectID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createPaymentRecordTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `paymentrecord` (\r\n  `PaymentRecordID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `DocumentID` bigint(20) NOT NULL,\r\n  `SysCreateDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n  `Note` varchar(100) NOT NULL,\r\n  `PaidAmount` double(15,4) NOT NULL,\r\n  `Realized` bit(1) NOT NULL DEFAULT b'0',\r\n  PRIMARY KEY (`PaymentRecordID`),\r\n  KEY `fk_documentID` (`DocumentID`),\r\n  CONSTRAINT `fk_documentID` FOREIGN KEY (`DocumentID`) REFERENCES `document` (`DocumentID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createCsvImport(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `csvimport` (\r\n  `CsvImportID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `CsvName` varchar(50) NOT NULL,\r\n  `CsvValue` varchar(50) NOT NULL,\r\n  `CsvImportTypeID` bigint(20) NOT NULL,\r\n  PRIMARY KEY (`CsvImportID`),\r\n  KEY `fk1_csv_import_type_id` (`CsvImportTypeID`),\r\n  CONSTRAINT `fk1_csv_import_type_id` FOREIGN KEY (`CsvImportTypeID`) REFERENCES `csvimporttype` (`CsvImportTypeID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
            query = "INSERT INTO `csvimport` (`CsvImportID`, `CsvName`, `CsvValue`, `CsvImportTypeID`) VALUES (1, 'Cena', 'price', 1), (2, 'Bar Kod', 'barcode', 1), (3, 'Akcijska Cena', 'offerprice', 1), (4, 'Cena', 'unit_price', 2), (5, 'Bar Kod', 'substitutecode', 2), (6, 'Kolicina', 'qty', 2);";
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createCsvImportType(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `csvimporttype` (\r\n  `CsvImportTypeID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Active` bit(1) NOT NULL DEFAULT b'1',\r\n  PRIMARY KEY (`CsvImportTypeID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
            query = "INSERT INTO `csvimporttype` (`CsvImportTypeID`, `Name`, `Active`) VALUES  (1, 'Cenovnik', b'1'), (2, 'Prijemnica', b'1');";
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createOfferPriceDetailsTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `offerpricedetails` (\r\n  `OfferPriceDetailsID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `ProductID` bigint(20) NOT NULL,\r\n  `Price` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `Discount` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `OfferPriceID` bigint(20) NOT NULL,\r\n  `Quantity` decimal(15,0) NOT NULL,\r\n  PRIMARY KEY (`OfferPriceDetailsID`,`OfferPriceID`),\r\n  KEY `FK_offerpricedetails_product` (`ProductID`),\r\n  CONSTRAINT `FK_offerpricedetails_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createBuyerOfferPriceTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `buyerofferprice` (\r\n  `BuyerOfferPriceID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `ObjectID` int(11) DEFAULT NULL,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Quantity` int(11) NOT NULL DEFAULT '0',\r\n  `DateFrom` datetime NOT NULL,\r\n  `DateTo` datetime NOT NULL,\r\n  `Active` bit(1) NOT NULL,\r\n  PRIMARY KEY (`BuyerOfferPriceID`),\r\n  KEY `FK_buyerofferprice_object` (`ObjectID`),\r\n  CONSTRAINT `FK_buyerofferprice_object` FOREIGN KEY (`ObjectID`) REFERENCES `object` (`ObjectID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createBuyerOfferPriceDetailsTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `buyerofferpricedetails` (\r\n  `BuyerOfferPriceDetailsID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `ProductID` bigint(20) NOT NULL,\r\n  `Price` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `Discount` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `BuyerOfferPriceID` bigint(20) NOT NULL,\r\n  `Quantity` decimal(15,0) NOT NULL,\r\n  PRIMARY KEY (`BuyerOfferPriceDetailsID`,`BuyerOfferPriceID`),\r\n  KEY `FK_buyerofferpricedetails_product` (`ProductID`),\r\n  CONSTRAINT `FK_buyerofferpricedetails_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createQuickGroupTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `quickgroup` (\r\n  `QuickGroupID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL,\r\n  `ProductID` bigint(20) DEFAULT NULL,\r\n  `ParentID` bigint(20) DEFAULT NULL,\r\n  PRIMARY KEY (`QuickGroupID`),\r\n  UNIQUE KEY `Index 2` (`Name`),\r\n  KEY `FK_quickgroup_product` (`ProductID`),\r\n  CONSTRAINT `FK_quickgroup_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createLoyalityTable(ScreensController controller) {
        String query = "\t-- Dumping structure for table masterdb.loyality\r\n\tCREATE TABLE IF NOT EXISTS `loyality` (\r\n\t  `LoyalityID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n\t  `PersonID` bigint(20) NOT NULL,\r\n\t  `CardNumber` varchar(50) DEFAULT NULL,\r\n\t  `Discount` decimal(5,2) NOT NULL DEFAULT '0.00',\r\n\t  `Active` bit(1) NOT NULL DEFAULT b'1',\r\n\t  `sysDTCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n\t  `sysDTEdit` datetime DEFAULT NULL,\r\n\t  `sysUserAddID` bigint(20) NOT NULL,\r\n\t  `sysUserEditID` bigint(20) DEFAULT NULL,\r\n\t  `Points` double NOT NULL DEFAULT '0',\r\n\t  `BuyingPointsValue` double NOT NULL DEFAULT '2000',\r\n\t  `SellingPointsValue` double NOT NULL DEFAULT '100',\r\n\t  `NumberEntry` int(11) NOT NULL DEFAULT '0',\r\n\t  `CurrentNumberEntry` int(11) NOT NULL DEFAULT '1',\r\n\t  `DiscountEntry` decimal(5,2) NOT NULL DEFAULT '0.00',\r\n\t  `VIPLoyaltyPrice` bit(1) NOT NULL DEFAULT b'1',\r\n\t  PRIMARY KEY (`LoyalityID`),\r\n\t  KEY `PersonID` (`PersonID`),\r\n\t  KEY `sysUserAddID` (`sysUserAddID`),\r\n\t  KEY `sysUserEditID` (`sysUserEditID`),\r\n\t  CONSTRAINT `loyality_ibfk_1` FOREIGN KEY (`PersonID`) REFERENCES `person` (`PersonID`) ON UPDATE CASCADE,\r\n\t  CONSTRAINT `loyality_ibfk_2` FOREIGN KEY (`sysUserAddID`) REFERENCES `user` (`UserID`) ON UPDATE CASCADE,\r\n\t  CONSTRAINT `loyality_ibfk_3` FOREIGN KEY (`sysUserEditID`) REFERENCES `user` (`UserID`) ON UPDATE CASCADE\r\n\t) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createLoyalitySettingsTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `loyalitysettings` (\r\n  `LoyalitySettingsID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `LoyalitySettingsActual` varchar(255) NOT NULL,\r\n  `LoyalitySettingsName` varchar(255) NOT NULL,\r\n  `ParentLoyalitySettingsID` bigint(20) DEFAULT NULL,\r\n  `PointOfSaleID` int(11) DEFAULT NULL,\r\n  PRIMARY KEY (`LoyalitySettingsID`),\r\n  KEY `fk_pointofsale` (`PointOfSaleID`),\r\n  CONSTRAINT `fk_pointofsale` FOREIGN KEY (`PointOfSaleID`) REFERENCES `pointofsale` (`PointOfSaleID`) ON DELETE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;\r\n";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
            query = "INSERT INTO `loyalitysettings` (`LoyalitySettingsID`, `LoyalitySettingsActual`, `LoyalitySettingsName`, `ParentLoyalitySettingsID`, `PointOfSaleID`) VALUES\t(1, '4', 'bill.no.discount.numbers', 3, NULL),\t(2, '100', 'bill.no.discount.percent', 3, NULL),\t(3, 'false', 'bill.number.discount.active', NULL, NULL),\t(4, 'true', 'point.value.round', NULL, NULL),\t(5, '100', 'value.loyality.sales.point', 4, NULL),\t(6, '2000', 'value.loyality.buying.point', 4, NULL),\t(7, 'false', 'point.value.round.bill', NULL, NULL),\t(8, '1000', 'minimum.value.buying', 4, NULL),\t(9, '10000', 'maximum.value.buying', 4, NULL),\t(10, 'true', 'loyalty.limit', NULL, NULL),\t(11, '60000', 'loyalty.limit.value', 10, NULL);";
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumn(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` BIT(1) NOT NULL DEFAULT b'1' AFTER `IsWeight`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnWriteOff(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` DECIMAL(5,2) NULL DEFAULT '0'";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnWriteOffTax(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` DECIMAL(15,2) NULL DEFAULT '0'";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnCurrencyPaymentDaysInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `CurrencyPaymentDays` INT NULL DEFAULT '0' AFTER `Discount`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnBuyerOfferPriceIDInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `BuyerOfferPriceID` BIGINT NULL DEFAULT NULL AFTER `CurrencyPaymentDays`,\tADD INDEX `BuyerOfferPriceID` (`BuyerOfferPriceID`),  ADD CONSTRAINT `person_ibfk_5` FOREIGN KEY (`BuyerOfferPriceID`) REFERENCES `buyerofferprice` \t(`BuyerOfferPriceID`) ON UPDATE CASCADE";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnCashBuyersID(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `CashBuyersID` BIGINT(20) NULL DEFAULT NULL AFTER `PersonID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `efaktura` bit(1)  DEFAULT NULL ;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDatum(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `datum` varchar(200)  DEFAULT NULL ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnFullNumber1(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `FullNumber1` varchar(200)  DEFAULT NULL ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDependentExpenses(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `DependentExpenses` decimal(15,4) NOT NULL DEFAULT '0.00' AFTER `DepartmentID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnName(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `Name` varchar(50) DEFAULT NULL AFTER `DependentExpenses`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnObject(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN " + column + " varchar(50) DEFAULT NULL;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDocument(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN " + column + " BIGINT DEFAULT NULL;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnJMBG(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `JMBG` varchar(50) DEFAULT NULL AFTER `Name`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnOfferPriceDetailsQuantity(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` int(11) NOT NULL DEFAULT '1' AFTER `OfferPriceID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteColumnBuyerOfferPriceDetailsQuantity(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE " + table + " DROP COLUMN " + column;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnObjectBankAndBankAccount(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `bank` VARCHAR(50) NULL AFTER `AddressID`,\tADD COLUMN `bankAccount` VARCHAR(30) NULL AFTER `bank`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnObjectVatTypeID(ScreensController controller) {
        PreparedStatement pStatement;
        String dataBase = controller.getSettings().getDatabase();
        String query = "ALTER TABLE `object` ADD COLUMN `ObjectVatTypeID` INT NOT NULL AFTER `RegionID`;";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        query = "UPDATE `" + dataBase + "`.`object` SET `ObjectVatTypeID`=1 WHERE  `ObjectID`=1;\t";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        query = "ALTER TABLE `object` ADD INDEX `ObjectVatTypeID` (`ObjectVatTypeID`);";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        query = "ALTER TABLE `object` ADD CONSTRAINT `object_vat_fk` FOREIGN KEY (`ObjectVatTypeID`) REFERENCES `personvattype` (`PersonVatTypeID`) ON UPDATE NO ACTION ON DELETE NO ACTION;";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnMeasurableUnit(String table, String column, ScreensController controller) {
        PreparedStatement pStatement;
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` BIT NOT NULL DEFAULT b'0' AFTER `Name`;";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`unit` SET `Measurable`=b'1' WHERE  `UnitID`=3;";
        try {
            pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDetailsPrintNumberInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` INT NULL DEFAULT '0' AFTER `BuyerOfferPriceID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnPhoneInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `person`\r\n\tADD COLUMN `Phone` VARCHAR(50) NULL DEFAULT NULL AFTER `DetailsPrintNumber`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnEmailInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `person`\r\n\tADD COLUMN `Email` VARCHAR(128) NULL DEFAULT NULL AFTER `Phone`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnTaxExamptInPerson(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `person`\r\n\tADD COLUMN `TaxExempt` BIT NULL DEFAULT b'0' AFTER `Email`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnVIPLoyaltyPriceInLoyality(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` BIT NOT NULL DEFAULT b'0' AFTER `DiscountEntry`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnNote2InDocument(String table, String column, String after, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(128) NOT NULL DEFAULT '' AFTER `" + after + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnNumOfCharacters(String table, String column, String after, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` INT(11) AFTER `" + after + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnNoteInLoyality(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(128) NOT NULL DEFAULT '\"\"' AFTER `VIPLoyaltyPrice`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnJBKJSI(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `JBKJS` VARCHAR(128)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnLoyaltyGroupIDInLoyality(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `loyality`\r\n\tADD COLUMN `LoyaltyGroupID` BIGINT NULL DEFAULT NULL AFTER `Note`,\r\n\tADD CONSTRAINT `loyality_ibfk_4` FOREIGN KEY (`LoyaltyGroupID`) REFERENCES `loyaltygroup` (`LoyaltyGroupID`) ON UPDATE CASCADE;\r\n";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnPeriodDaysInLoyality(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `loyality`\r\n\tADD COLUMN `PeriodDays` VARCHAR(30) NULL AFTER `LoyaltyGroupID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDocumentIdInPriceListDetails(ScreensController controller) {
        String query = "ALTER TABLE pricelistdetails ADD COLUMN documentID BIGINT,\r\nADD FOREIGN KEY doc_key(documentID) REFERENCES document(documentID) ON UPDATE CASCADE ON DELETE CASCADE";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDocumentLockedInDocument(ScreensController controller) {
        String query = "ALTER TABLE document ADD COLUMN documentLocked TINYINT(1) DEFAULT 0 ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDocumenbuyerCostCenterId(ScreensController controller) {
        String query = "ALTER TABLE document ADD buyerCostCenterId varchar(100) NULL ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnDocumentPayCardSlipNumber(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\r\n\tADD COLUMN `" + column + "` VARCHAR(50) NULL DEFAULT NULL AFTER `FullNumber`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDiscountAllowed(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `DiscountAllowed` BIT(1) NULL DEFAULT b'1';";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createRealized(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `Realized` BIT(1) NULL DEFAULT b'0' AFTER `JMBG`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createReservated(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `Reservated` BIT(1) NULL DEFAULT b'0' AFTER `Realized`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createAddressCashbuyers(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `" + column + "` varchar(200) NOT NULL AFTER `PIB`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createCityCashbuyers(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `" + column + "` varchar(50) NOT NULL AFTER `address`";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createZIPCashbuyers(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `" + column + "` varchar(10) NOT NULL AFTER `city`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteAddressID(ScreensController screensController) {
        String query1 = "ALTER TABLE `cashbuyers` DROP FOREIGN KEY `FK_addressId`;";
        String query = "ALTER TABLE `cashbuyers` DROP COLUMN `addressId`;";
        try {
            PreparedStatement pStatement = screensController.getSettings().getConnection().prepareStatement(query1);
            pStatement.executeUpdate();
            pStatement = screensController.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createCashBuyersTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `cashbuyers` (\r\n  `cashBuyerID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `name` varchar(200) DEFAULT NULL,\r\n  `PIB` varchar(20) NOT NULL,\r\n  `MB` varchar(20) NOT NULL,\r\n  `address` varchar(200) NOT NULL,\r\n  `city` varchar(50) NOT NULL,\r\n  `ZIP` varchar(10) NOT NULL,\r\n  `sysDTCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n  `sysUserAddID` bigint(20) NOT NULL,\r\n  PRIMARY KEY (`cashBuyerID`),\r\n  UNIQUE KEY `idxPibUnique` (`PIB`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDeferredTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `deferred` (\r\n  `DeferredID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Surname` varchar(50) NOT NULL,\r\n  `Address` varchar(100) NOT NULL,\r\n  `City` varchar(50) NOT NULL,\r\n  `PhoneNumber` varchar(50) NOT NULL,\r\n  `Email` varchar(50) NOT NULL,\r\n  `CurrentAmount` decimal(10,2) NOT NULL DEFAULT '0.00',\r\n  `MaxAmount` decimal(10,2) NOT NULL DEFAULT '0.00',\r\n  `MaxDaysDeferred` int(11) NOT NULL DEFAULT '1',\r\n  `Blocked` bit(1) NOT NULL DEFAULT b'0',\r\n  PRIMARY KEY (`DeferredID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDeferredRecordTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `deferredrecord` (\r\n  `DeferredRecordID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `DeferredID` bigint(20) NOT NULL,\r\n  `DateRecive` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n  `Amount` decimal(10,2) NOT NULL DEFAULT '0.00',\r\n  PRIMARY KEY (`DeferredRecordID`),\r\n  KEY `fk_deferred_id` (`DeferredID`),\r\n  CONSTRAINT `fk_deferred_id` FOREIGN KEY (`DeferredID`) REFERENCES `deferred` (`DeferredID`) ON DELETE CASCADE ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createExciseTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `excise` (\r\n  `ExciseID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Value` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  PRIMARY KEY (`ExciseID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createTablePonistavanjeFiskalnog(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS billcancellation (\r\n\tid BIGINT(20) auto_increment NOT NULL,\n\tnameProduct varchar(100) NOT NULL,\n\tcode varchar(100) NOT NULL,\n\tquantity INT NOT NULL,\n\tdiscount decimal(15,2) NOT NULL DEFAULT '0.00',\n\tprice decimal(15,2) NOT NULL DEFAULT '0.00',\n   datetimesys datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ,\n PRIMARY KEY (id)\r\n)\n ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createExciseProductTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `exciseproduct` (\r\n  `ExciseProductID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `ExciseID` bigint(20) NOT NULL,\r\n  `ProductID` bigint(20) NOT NULL,\r\n  `Value` decimal(15,2) NOT NULL DEFAULT '0',\r\n  PRIMARY KEY (`ExciseProductID`),\r\n  UNIQUE KEY `unique_product_id` (`ProductID`),\r\n  KEY `fk1_excise_id` (`ExciseID`),\r\n  KEY `fk2_product_id` (`ProductID`),\r\n  CONSTRAINT `fk1_excise_id` FOREIGN KEY (`ExciseID`) REFERENCES `excise` (`ExciseID`) ON DELETE NO ACTION ON UPDATE CASCADE,\r\n  CONSTRAINT `fk2_product_id` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON DELETE NO ACTION ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnUtrosciPrikaz(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` BIT NOT NULL DEFAULT b'1' AFTER `Name`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnColorGroup(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(50) NULL DEFAULT '#A0A0A0' AFTER `sysUserEditID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnColorGroupProduct(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(50) NULL DEFAULT '#A0A0A0' AFTER `Active`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnProductNameInDocumentDetail(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(300) NULL DEFAULT '' AFTER `ProductID`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createStringColumn(String table, String column, String after, int charLimit, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` VARCHAR(" + charLimit + ") NULL DEFAULT '' AFTER `" + after + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDoubleColumn(String table, String column, String after, int charLimit, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` DECIMAL(" + charLimit + ") NOT NULL DEFAULT 0 AFTER `" + after + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void fillColumnProductNameInDocumentDetail(ScreensController controller) {
        String query = "UPDATE documentdetails dd SET dd.productName = \r\n(SELECT p.name FROM product p WHERE p.ProductID = dd.ProductID)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createPayCardTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `paycard` (\r\n  `PayCardID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL,\r\n  `Percent` decimal(5,2) NOT NULL DEFAULT '0.00',\r\n  `Active` bit(1) NOT NULL DEFAULT b'1',\r\n  PRIMARY KEY (`PayCardID`),\r\n  UNIQUE KEY `unique` (`Name`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createSynchronizationTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `synchronization` (\r\n\t`SynchronizationID` BIGINT(20) NOT NULL AUTO_INCREMENT,\r\n\t`DatabaseName` VARCHAR(50) NOT NULL,\r\n\t`IpAddress` VARCHAR(50) NOT NULL,\r\n\t`Active` BIT(1) NOT NULL DEFAULT b'0',\r\n\tPRIMARY KEY (`SynchronizationID`)\r\n)\r\nENGINE=InnoDB\r\n;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createDocumentPayCardTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `documentpaycard` (\r\n  `DocumentPayCardID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `DocumentID` bigint(20) NOT NULL DEFAULT '0',\r\n  `PayCardID` bigint(20) NOT NULL DEFAULT '0',\r\n  `Value` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  PRIMARY KEY (`DocumentPayCardID`),\r\n  KEY `fk_document_id` (`DocumentID`),\r\n  KEY `fk_paycard_id` (`PayCardID`),\r\n  CONSTRAINT `fk_document_id` FOREIGN KEY (`DocumentID`) REFERENCES `document` (`DocumentID`) ON UPDATE CASCADE,\r\n  CONSTRAINT `fk_paycard_id` FOREIGN KEY (`PayCardID`) REFERENCES `paycard` (`PayCardID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionStockByProduct(ScreensController controller, String stockString) {
        String query = "CREATE DEFINER=`root`@`localhost` FUNCTION `stock_by_product`(`product_id` BIGINT, `department_id` BIGINT, `date_from` TIMESTAMP, `date_to` TIMESTAMP) RETURNS decimal(15,4)\r\n    READS SQL DATA\r\n" + stockString;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionWorkday_end_v4(ScreensController controller, String stockString) {
        String query = "CREATE DEFINER=`root`@`localhost` FUNCTION `workday_end_v4`(\r\n\t`i_department_id` INT,\r\n\t`i_date` DATETIME\r\n\r\n\r\n)\r\nRETURNS datetime\r\nLANGUAGE SQL\r\nNOT DETERMINISTIC\r\nREADS SQL DATA\r\nSQL SECURITY DEFINER\r\nCOMMENT ''\r\n" + stockString;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnAverageValueInPD(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\r\n\t\tADD COLUMN `" + column + "` DECIMAL(15,4) NOT NULL DEFAULT '0' AFTER `PreparationTime`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFunctionSoldItemsWorkday(ScreensController controller) {
        String query = "CREATE DEFINER=`root`@`localhost` PROCEDURE `sold_items_workday`(IN `i_workday_id` BIGINT, IN `i_workday_date` DATE\r\n\t\t\t\t)\r\n\t\t\t\t    READS SQL DATA\r\n\t\t\t\t    DETERMINISTIC\r\n\t\t\t\tBEGIN\r\n\t\t\t\t\tSELECT SUM(dd.Quantity) AS SumQuantity, dd.*  \r\n\t\t\t\t  \t  FROM documentdetails dd\r\n\t\t\t\t  \t  INNER JOIN document d ON d.DocumentID = dd.DocumentID AND d.DocumentTypeID IN (3,18)\r\n\t\t\t\t  \t  INNER JOIN workday w ON w.WorkDayID = d.WorkDayID AND w.WorkDayID = i_workday_id \r\n\t\t\t\t \t WHERE d.Date > i_workday_date\r\n\t\t\t\t \t   AND (d.DocumentID NOT IN (SELECT dr.DocumentParentID \r\n\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t FROM documentrelationship dr \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\tWHERE dr.RelationshipTypeID = 2))\r\n\t\t\t\t\t\t \t OR\r\n\t\t\t\t\t\t \t (d.DocumentID IN (SELECT dr.DocumentParentID \r\n\t\t\t\t \t\t\t\t\t\t\t\t\t   FROM documentrelationship dr \r\n\t\t\t\t\t\t\t\t\t\t\t\t     WHERE dr.RelationshipTypeID = 2)\r\n\t\t\t\t\t\t\t\t\t\t\t  AND (SELECT ProductTypeID \r\n\t\t\t\t\t\t\t\t\t\t\t\t  \t   FROM Product \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t  WHERE ProductID = dd.ProductID) = 1)\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t  GROUP BY dd.ProductID, dd.PriceWithDiscount;\r\n\t\t\t\tEND";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createLoyaltyLimitTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `loyaltylimit` (\r\n  `LoyaltyLimitID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `LoyaltyID` bigint(20) NOT NULL,\r\n  `CurrentValue` double(15,2) NOT NULL DEFAULT '0.00',\r\n  `LimitValue` double(15,2) NOT NULL DEFAULT '0.00',\r\n  `DateTo` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n  `NumberOfDates` int(11) NOT NULL DEFAULT '0',\r\n  `Active` bit(1) NOT NULL DEFAULT b'0',\r\n  PRIMARY KEY (`LoyaltyLimitID`),\r\n  KEY `fk_loyalty_id` (`LoyaltyID`),\r\n  CONSTRAINT `fk_loyalty_id` FOREIGN KEY (`LoyaltyID`) REFERENCES `loyality` (`LoyalityID`) ON DELETE NO ACTION ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteColumn(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` DROP COLUMN `" + column + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createGroupProductTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `groupproduct` (\r\n  `GroupProductID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `GroupID` int(11) NOT NULL,\r\n  `ProductID` bigint(20) NOT NULL,\r\n  `Active` bit(1) NOT NULL DEFAULT b'1',\r\n  PRIMARY KEY (`GroupProductID`),\r\n  KEY `ProductID` (`ProductID`),\r\n  KEY `groupproduct_ibfk_1_idx` (`GroupID`),\r\n  CONSTRAINT `groupproduct_ibfk_2` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createPresentTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `present` (\r\n\t`PresentID` BIGINT(20) NOT NULL AUTO_INCREMENT,\r\n\t`BillSumFrom` DECIMAL(15,2) NOT NULL,\r\n\t`BillSumTo` DECIMAL(15,2) NOT NULL,\r\n\t`DiscountPercent` DECIMAL(15,2) NOT NULL,\r\n\t`DiscountMonay` DECIMAL(15,2) NOT NULL,\r\n\t`Message` VARCHAR(1024) NOT NULL,\r\n\t`ActivePresent` BIT(1) NOT NULL DEFAULT b'0',\r\n\t`ActiveDiscount` BIT(1) NOT NULL DEFAULT b'0',\r\n\tPRIMARY KEY (`PresentID`)\r\n)\r\nCOLLATE='utf8_general_ci'\r\nENGINE=InnoDB\r\n;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createImages(ScreensController controller) {
        String query = Queries.QUERIES.get((Object)QueryName.INSERT_IMAGES);
        ScriptRunner runner = new ScriptRunner(controller.getSettings().getConnection(), false, true);
        try {
            runner.runScript(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(query), "UTF-8")));
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    public static void resetDatabase(ScreensController controller) throws SQLException {
    }

    public void createDailyTurnoverTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `dailyturnover` (\r\n  `DailyTurnoverID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `DailyTurnoverDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,\r\n  `DailyTurnoverWorkDayID` bigint(20) NOT NULL,\r\n  `DailyTurnoverValue` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `DailyTurnoverNumber` int(11) NOT NULL DEFAULT '0',\r\n  `DailyTurnoverPos` int(11) NOT NULL,\r\n  PRIMARY KEY (`DailyTurnoverID`),\r\n  KEY `workday_fk` (`DailyTurnoverWorkDayID`),\r\n  KEY `pointofsale_fk` (`DailyTurnoverPos`),\r\n  CONSTRAINT `pointofsale_fk` FOREIGN KEY (`DailyTurnoverPos`) REFERENCES `pointofsale` (`PointOfSaleID`) ON DELETE NO ACTION ON UPDATE CASCADE,\r\n  CONSTRAINT `workday_fk` FOREIGN KEY (`DailyTurnoverWorkDayID`) REFERENCES `workday` (`WorkDayID`) ON DELETE NO ACTION ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteLoyalityTable(ScreensController controller) {
        String query = "SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;DROP TABLE `loyality`;SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getProcedureBody(String procedure, ScreensController controller) {
        String dataBase = controller.getSettings().getDatabase();
        String query = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA = '" + dataBase + "' AND ROUTINE_TYPE = 'PROCEDURE' AND ROUTINE_NAME = '" + procedure + "'";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getString("ROUTINE_DEFINITION");
        }
        catch (SQLException e) {
            return "";
        }
    }

    public String getFunctionBody(String procedure, ScreensController controller) {
        String dataBase = controller.getSettings().getDatabase();
        String query = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA = '" + dataBase + "' AND ROUTINE_TYPE = 'FUNCTION' AND ROUTINE_NAME = '" + procedure + "'";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getString("ROUTINE_DEFINITION");
        }
        catch (SQLException e) {
            return "";
        }
    }

    public void dropProcedure(String name, ScreensController controller) {
        String query = "DROP PROCEDURE `" + name + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(pStatement);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void dropFunction(String name, ScreensController controller) {
        String query = "DROP FUNCTION `" + name + "`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createFinancialDiscountTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `financialdiscount` (\r\n  `FinancialDiscountID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL DEFAULT '',\r\n  `Value` decimal(15,2) NOT NULL DEFAULT '0.00',\r\n  `Discount` DECIMAL(15,2) NOT NULL DEFAULT '0.00',\r\n  `Active` bit(1) NOT NULL DEFAULT b'0',\r\n  PRIMARY KEY (`FinancialDiscountID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createLoyaltyFinancialDiscountTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `loyaltyfinancialdiscount` (\r\n  `LoyaltyFinancialDiscountID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `FinancialDiscountID` bigint(20) NOT NULL,\r\n  `LoyaltyID` bigint(20) NOT NULL,\r\n  PRIMARY KEY (`LoyaltyFinancialDiscountID`) USING BTREE,\r\n  KEY `fk_1` (`FinancialDiscountID`),\r\n  KEY `fk_2` (`LoyaltyID`),\r\n  CONSTRAINT `fk_1` FOREIGN KEY (`FinancialDiscountID`) REFERENCES `financialdiscount` (`FinancialDiscountID`) ON DELETE CASCADE ON UPDATE CASCADE,\r\n  CONSTRAINT `fk_2` FOREIGN KEY (`LoyaltyID`) REFERENCES `loyality` (`LoyalityID`) ON UPDATE CASCADE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createLoyaltyGroupTable(ScreensController controller) {
        String query = "CREATE TABLE IF NOT EXISTS `loyaltygroup` (\r\n  `LoyaltyGroupID` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `Name` varchar(50) NOT NULL DEFAULT '',\r\n  `DefaultDiscount` decimal(5,2) NOT NULL DEFAULT '0.00' '',\r\n  PRIMARY KEY (`LoyaltyGroupID`)\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnFirstPriceInOfferPrice(ScreensController controller) {
        String quString = "ALTER TABLE `offerprice`\r\n\tADD COLUMN `FirstPrice` BIT(1) NOT NULL AFTER `Active`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(quString);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnRoundActiveInOfferPrice(ScreensController controller) {
        String quString = "ALTER TABLE `offerprice`\r\n\tADD COLUMN `RoundActive` BIT(1) NOT NULL AFTER `FirstPrice`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(quString);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnOPriceListTypeIDInOfferPrice(ScreensController controller) {
        String quString = "ALTER TABLE `offerprice`\r\n\tADD COLUMN `PriceListTypeID` INT NOT NULL DEFAULT '6' AFTER `RoundActive`,\r\n\tADD CONSTRAINT `FK_offerprice_pricelisttype` FOREIGN KEY (`PriceListTypeID`) REFERENCES `pricelisttype` (`TypeID`);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(quString);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnOPriceListTypeIDInBuyerOfferPrice(ScreensController controller) {
        String quString = "ALTER TABLE `buyerofferprice`\r\n\tADD COLUMN `PriceListTypeID` INT NOT NULL DEFAULT '5' AFTER `Active`,\r\n\tADD CONSTRAINT `FK_buyerofferprice_pricelisttype` FOREIGN KEY (`PriceListTypeID`) REFERENCES `pricelisttype` (`TypeID`);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(quString);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createColumnMB(String string, String string2, ScreensController controller) {
        String query = "ALTER TABLE `cashbuyers`\r\n\tADD COLUMN `MB` VARCHAR(20) NOT NULL AFTER `PIB`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isColumnUnique(String table, String column, ScreensController controller) {
        String query = "SHOW INDEXES FROM " + table + " WHERE Column_name='" + column + "' AND NOT Non_unique";
        try {
            Connection conn = controller.getSettings().getConnection();
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void makeColumnUnique(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE " + table + "  ADD UNIQUE (" + column + ")";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    void createColumnInvoice(String table, String column, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "` ADD COLUMN `" + column + "` varchar NOT NULL DEFAULT b'0' AFTER `Name`;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void alterObject(ScreensController controller) {
        String sql = "ALTER TABLE `object` MODIFY COLUMN bankAccount varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL NULL";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(sql);
            pStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void alterRefNumberExternal(ScreensController controller) {
        String sql = "ALTER TABLE `document` ADD COLUMN RefExternalNumber varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL NULL";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(sql);
            pStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void createColumnLicenca(String table, String licenca, ScreensController controller) {
        String query = "ALTER TABLE `" + table + "`\tADD COLUMN `licenca` varchar(200)  DEFAULT NULL ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

