/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;

public class DailyTurnover {
    private long dailyTurnoverId;
    private Date dailyTurnoverDate;
    private double dailyTurnoverValue;
    private int dailyTurnoverNumber;
    private int dailyTurnoverPos;
    private long dailyTurnoverWorkDayId;

    public long getDailyTurnoverId() {
        return this.dailyTurnoverId;
    }

    public void setDailyTurnoverId(long dailyTurnoverId) {
        this.dailyTurnoverId = dailyTurnoverId;
    }

    public Date getDailyTurnoverDate() {
        return this.dailyTurnoverDate;
    }

    public void setDailyTurnoverDate(Date dailyTurnoverDate) {
        this.dailyTurnoverDate = dailyTurnoverDate;
    }

    public double getDailyTurnoverValue() {
        return this.dailyTurnoverValue;
    }

    public void setDailyTurnoverValue(double dailyTurnoverValue) {
        this.dailyTurnoverValue = dailyTurnoverValue;
    }

    public int getDailyTurnoverNumber() {
        return this.dailyTurnoverNumber;
    }

    public void setDailyTurnoverNumber(int dailyTurnoverNumber) {
        this.dailyTurnoverNumber = dailyTurnoverNumber;
    }

    public int getDailyTurnoverPos() {
        return this.dailyTurnoverPos;
    }

    public void setDailyTurnoverPos(int dailyTurnoverPos) {
        this.dailyTurnoverPos = dailyTurnoverPos;
    }

    public long getDailyTurnoverWorkDayId() {
        return this.dailyTurnoverWorkDayId;
    }

    public void setDailyTurnoverWorkDayId(long dailyTurnoverWorkDayId) {
        this.dailyTurnoverWorkDayId = dailyTurnoverWorkDayId;
    }

    public long insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`dailyturnover` (`DailyTurnoverDate`, `DailyTurnoverWorkDayID`, `DailyTurnoverValue`, `DailyTurnoverNumber`, `DailyTurnoverPos`)  VALUES (?, ?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query, 1);
            pStatement.setTimestamp(1, new Timestamp(this.dailyTurnoverDate.getTime()));
            pStatement.setLong(2, this.dailyTurnoverWorkDayId);
            pStatement.setDouble(3, this.dailyTurnoverValue);
            pStatement.setInt(4, this.dailyTurnoverNumber);
            pStatement.setInt(5, this.dailyTurnoverPos);
            pStatement.executeUpdate();
            ResultSet rs = pStatement.getGeneratedKeys();
            rs.next();
            this.dailyTurnoverId = rs.getLong(1);
            rs.close();
            pStatement.close();
            return this.dailyTurnoverId;
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    public static DailyTurnover getLast(ScreensController controller, Document document) {
        String query = "SELECT * FROM dailyturnover dt WHERE dt.DailyTurnoverPos = ? AND dt.DailyTurnoverWorkDayID IS NOT NULL ORDER BY dt.DailyTurnoverID DESC LIMIT 1";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, document.getPointOfSaleID());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            DailyTurnover dailyTurnover = new DailyTurnover();
            dailyTurnover.setDailyTurnoverId(rSet.getLong("DailyTurnoverID"));
            dailyTurnover.setDailyTurnoverDate(rSet.getTimestamp("DailyTurnoverDate"));
            dailyTurnover.setDailyTurnoverNumber(rSet.getInt("DailyTurnoverNumber"));
            dailyTurnover.setDailyTurnoverPos(rSet.getInt("DailyTurnoverPos"));
            dailyTurnover.setDailyTurnoverValue(rSet.getDouble("DailyTurnoverValue"));
            dailyTurnover.setDailyTurnoverWorkDayId(rSet.getLong("DailyTurnoverWorkDayID"));
            return dailyTurnover;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static DailyTurnover getByID(ScreensController controller, long id) {
        String query = "SELECT * FROM dailyturnover dt WHERE dt.DailyTurnoverID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            DailyTurnover dailyTurnover = new DailyTurnover();
            dailyTurnover.setDailyTurnoverId(rSet.getLong("DailyTurnoverID"));
            dailyTurnover.setDailyTurnoverDate(rSet.getTimestamp("DailyTurnoverDate"));
            dailyTurnover.setDailyTurnoverNumber(rSet.getInt("DailyTurnoverNumber"));
            dailyTurnover.setDailyTurnoverPos(rSet.getInt("DailyTurnoverPos"));
            dailyTurnover.setDailyTurnoverValue(rSet.getDouble("DailyTurnoverValue"));
            dailyTurnover.setDailyTurnoverWorkDayId(rSet.getLong("DailyTurnoverWorkDayID"));
            return dailyTurnover;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static int getLastDaileyTurnoverNumber(ScreensController controller) {
        String query = "SELECT * FROM dailyturnover dto WHERE dto.DailyTurnoverPos=? order BY dto.DailyTurnoverID desc LIMIT 1";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, controller.getPointOfSale().getPointOfSaleID());
            ResultSet resultSet = pStatement.executeQuery();
            resultSet.next();
            return resultSet.getInt("DailyTurnoverNumber");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static double getDaileyTurnoverValue(ScreensController controller) {
        String query = "SELECT SUM(d.SumWithDiscount) AS DaileyTurnoverValue  FROM document d WHERE d.WorkDayID=? AND d.PointOfSaleID=? ";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, WorkDay.getFromDbZatvorenDan(controller.getPointOfSale(), controller.getSettings().getConnection()).getWorkDayID());
            pStatement.setInt(2, controller.getPointOfSale().getPointOfSaleID());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            return rSet.getDouble("DaileyTurnoverValue");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static long insertMC(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`dailyturnover` ( `DailyTurnoverWorkDayID`, `DailyTurnoverValue`, `DailyTurnoverNumber`, `DailyTurnoverPos`)  VALUES ( ?, ?, ?, ?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query, 1);
            pStatement.setLong(1, WorkDay.getFromDbZatvorenDan(controller.getPointOfSale(), controller.getSettings().getConnection()).getWorkDayID());
            pStatement.setDouble(2, DailyTurnover.getDaileyTurnoverValue(controller));
            pStatement.setInt(3, DailyTurnover.getLastDaileyTurnoverNumber(controller) + 1);
            pStatement.setInt(4, controller.getPointOfSale().getPointOfSaleID());
            pStatement.executeUpdate();
            ResultSet rSet = pStatement.getGeneratedKeys();
            rSet.next();
            long id = rSet.getLong(1);
            rSet.close();
            pStatement.close();
            return id;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

