/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.DPUList;
import rs.petcom.master.dal.Object;

public class DPULIstData {
    private int DPUListDataID;
    private int DPUListID;
    private int Type;
    private String Number;
    private double Sum;
    private double Cash;
    private double Card;
    private double NonFiscal;

    public int getDPUListDataID() {
        return this.DPUListDataID;
    }

    public void setDPUListDataID(int dPUListDataID) {
        this.DPUListDataID = dPUListDataID;
    }

    public int getDPUListID() {
        return this.DPUListID;
    }

    public void setDPUListID(int DPUListID) {
        this.DPUListID = DPUListID;
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int type) {
        this.Type = type;
    }

    public String getNumber() {
        return this.Number;
    }

    public void setNumber(String number) {
        this.Number = number;
    }

    public double getSum() {
        return this.Sum;
    }

    public void setSum(double sum) {
        this.Sum = sum;
    }

    public double getCash() {
        return this.Cash;
    }

    public void setCash(double cash) {
        this.Cash = cash;
    }

    public double getCard() {
        return this.Card;
    }

    public void setCard(double card) {
        this.Card = card;
    }

    public double getNonFiscal() {
        return this.NonFiscal;
    }

    public void setNonFiscal(double nonFiscal) {
        this.NonFiscal = nonFiscal;
    }

    public int insert(Connection connection) {
        int result = -1;
        String query = "insert into dpulistdata(DPUListID,Number,Type,Cash,Card,NonFiscal) values(?,?,?,?,?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, this.DPUListID);
            ps.setString(2, this.Number);
            ps.setInt(3, this.Type);
            ps.setDouble(4, this.Cash);
            ps.setDouble(5, this.Card);
            ps.setDouble(6, this.NonFiscal);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.DPUListDataID = rs.getInt(1);
            rs.close();
            ps.close();
            return this.DPUListDataID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return result;
        }
    }

    public void update(Connection connection) {
        String query = "update dpulistdata set \tDPUListID = ?,\tNumber = ?,\tType = ?,\tCash = ?,\tCard = ?,\tNonFiscal = ? where DPUListDataID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.DPUListID);
            ps.setString(2, this.Number);
            ps.setInt(3, this.Type);
            ps.setDouble(4, this.Cash);
            ps.setDouble(5, this.Card);
            ps.setDouble(6, this.NonFiscal);
            ps.setInt(7, this.DPUListDataID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "delete from dpulistdata where DPUListDataID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, this.DPUListDataID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void delete(int dpulistID, Connection connection) {
        String query = "delete from dpulistdata where DPUListID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, dpulistID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<DPULIstData> getList(DPUList dpuList, int type, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from dpulistdata dd  where dd.DPUListID = ?   and dd.`Type` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, dpuList.getDPUListID());
            ps.setInt(2, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DPULIstData dpuData = new DPULIstData();
                dpuData.setDPUListDataID(rs.getInt("DPUListDataID"));
                dpuData.setDPUListID(rs.getInt("DPUListID"));
                dpuData.setType(rs.getInt("Type"));
                dpuData.setNumber(rs.getString("Number"));
                dpuData.setCash(rs.getDouble("Cash"));
                dpuData.setCard(rs.getDouble("Card"));
                dpuData.setNonFiscal(rs.getDouble("NonFiscal"));
                dpuData.setSum(dpuData.getCash() + dpuData.getCard() + dpuData.getNonFiscal());
                list.add((java.lang.Object)dpuData);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DPULIstData> getNiList(Date date, int objectId, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "CALL dpu_specifikacija_ni(?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(date.getTime()));
            ps.setInt(2, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DPULIstData dpuData = new DPULIstData();
                dpuData.setDPUListDataID(0);
                dpuData.setDPUListID(0);
                dpuData.setType(2);
                dpuData.setNumber(rs.getString("Number"));
                dpuData.setCash(rs.getDouble("Cash"));
                dpuData.setCard(rs.getDouble("Card"));
                dpuData.setNonFiscal(rs.getDouble("NonFiscal"));
                dpuData.setSum(dpuData.getCash() + dpuData.getCard() + dpuData.getNonFiscal());
                if (dpuData.getNumber().equals("")) continue;
                list.add((java.lang.Object)dpuData);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<DPULIstData> getRfList(Date date, Object object, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "call dpu_specifikacija_rpr(?,?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(date.getTime()));
            ps.setInt(2, object.getObjectID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DPULIstData dpuData = new DPULIstData();
                dpuData.setDPUListDataID(0);
                dpuData.setDPUListID(0);
                dpuData.setType(2);
                dpuData.setNumber(rs.getString("Number"));
                dpuData.setCash(rs.getDouble("Cash"));
                dpuData.setCard(rs.getDouble("Card"));
                dpuData.setNonFiscal(rs.getDouble("NonFiscal"));
                dpuData.setSum(dpuData.getCash() + dpuData.getCard() + dpuData.getNonFiscal());
                if (dpuData.getNumber().equals("")) continue;
                list.add((java.lang.Object)dpuData);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }
}

