/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.OfferPriceDetailes;

public class BuyerOfferPrice {
    private Long BuyerOfferPriceID;
    private int ObjectID;
    private String Name;
    private Date DateFrom;
    private Date DateTo;
    private boolean Active;
    private int priceListTypeID;
    private ArrayList<OfferPriceDetailes> offerPriceDetailsList;

    public Long getBuyerOfferPriceID() {
        return this.BuyerOfferPriceID;
    }

    public void setBuyerOfferPriceID(Long buyerOfferPriceID) {
        this.BuyerOfferPriceID = buyerOfferPriceID;
    }

    public int getObjectID() {
        return this.ObjectID;
    }

    public void setObjectID(int objectID) {
        this.ObjectID = objectID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public Date getDateFrom() {
        return this.DateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.DateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.DateTo;
    }

    public void setDateTo(Date dateTo) {
        this.DateTo = dateTo;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public int getPriceListTypeID() {
        return this.priceListTypeID;
    }

    public void setPriceListTypeID(int priceListTypeID) {
        this.priceListTypeID = priceListTypeID;
    }

    public ArrayList<OfferPriceDetailes> getOfferPriceDetailsList() {
        return this.offerPriceDetailsList;
    }

    public void setOfferPriceDetailsList(ArrayList<OfferPriceDetailes> offerPriceDetailsList) {
        this.offerPriceDetailsList = offerPriceDetailsList;
    }

    public String toString() {
        return this.Name;
    }

    public long insert(Connection connection) {
        String query = "INSERT INTO `buyerofferprice` (`ObjectID`, `Name`, `DateFrom`, `DateTo`, `Active`, `PriceListTypeID`)  VALUES (?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setInt(1, this.ObjectID);
            ps.setString(2, this.Name);
            ps.setTimestamp(3, new Timestamp(this.DateFrom.getTime()));
            try {
                ps.setTimestamp(4, new Timestamp(this.DateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(4, 91);
            }
            ps.setBoolean(5, this.Active);
            ps.setInt(6, 5);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.setBuyerOfferPriceID(rs.getLong(1));
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.getBuyerOfferPriceID();
    }

    public void update(Connection connection) {
        String query = "UPDATE `buyerofferprice` SET `ObjectID` = ?, `Name` = ?, `DateFrom` = ?, `DateTo` = ?, `Active` = ?, `PriceListTypeID` = ? WHERE  `BuyerOfferPriceID` = ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (this.ObjectID > 0) {
                ps.setInt(1, this.ObjectID);
            } else {
                ps.setNull(1, 4);
            }
            ps.setString(2, this.Name);
            ps.setTimestamp(3, new Timestamp(this.DateFrom.getTime()));
            try {
                ps.setTimestamp(4, new Timestamp(this.DateTo.getTime()));
            }
            catch (NullPointerException e) {
                ps.setNull(4, 91);
            }
            ps.setBoolean(5, this.Active);
            ps.setInt(6, this.priceListTypeID);
            ps.setLong(7, this.BuyerOfferPriceID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ObservableList<BuyerOfferPrice> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT bop.* FROM buyerofferprice bop";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(upit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerOfferPrice op = new BuyerOfferPrice();
                op.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
                list.add((Object)op);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<BuyerOfferPrice> getList(int objectID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String upit = "SELECT bop.* FROM buyerofferprice bop WHERE bop.ObjectID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setInt(1, objectID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BuyerOfferPrice op = new BuyerOfferPrice();
                op.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
                list.add((Object)op);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static BuyerOfferPrice getOfferPrice(long buyerofferPriceId, Connection connection) {
        String upit = "SELECT * FROM buyerofferprice bop WHERE bop.BuyerOfferPriceID = ? ";
        BuyerOfferPrice op = new BuyerOfferPrice();
        try {
            PreparedStatement ps = connection.prepareStatement(upit);
            ps.setLong(1, buyerofferPriceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                op.setBuyerOfferPriceID(rs.getLong("BuyerOfferPriceID"));
                try {
                    op.setObjectID(rs.getInt("ObjectID"));
                }
                catch (NullPointerException e) {
                    op.setObjectID(-1);
                }
                op.setName(rs.getString("Name"));
                op.setDateFrom(new Date(rs.getTimestamp("DateFrom").getTime()));
                op.setDateTo(new Date(rs.getTimestamp("DateTo").getTime()));
                op.setActive(rs.getBoolean("Active"));
                op.setPriceListTypeID(rs.getInt("PriceListTypeID"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return op;
    }

    public void delete(Connection connection) {
        String query = "DELETE FROM `buyerofferprice` WHERE  `BuyerOfferPriceID` = ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.getBuyerOfferPriceID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

