/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.trgovina;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import functions.rfc.sap.document.sap_com.ZRETAIL_SALE_ITEMS_LINE;
import functions.rfc.sap.document.sap_com.client.SaleClient;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import javax.print.PrintService;
import javax.xml.rpc.holders.StringHolder;
import rs.petcom.enums.FiscalPrinterDriver;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.CustomerDispaly;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.DocumentPayCard;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.PayCard;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Present;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.Protel;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.TaxExampt;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.document.ReportMapModel;
import rs.petcom.master.dal.person.Loyality;
import rs.petcom.master.dal.person.LoyaltyLimit;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonVatType;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.fical.FiscalPrintFLink;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.master.fical.Izvestaji;
import rs.petcom.master.fical.XmlBill;
import rs.petcom.master.invoice.dto.Invoice;
import rs.petcom.master.invoice.dto.InvoiceApi;
import rs.petcom.master.newFiscalization.badrequest.BadRequestHandler;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceRequest;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Payment;
import rs.petcom.master.newFiscalization.print.A4PrintUtils;
import rs.petcom.master.newFiscalization.print.BillFooter;
import rs.petcom.master.newFiscalization.print.BillPrint;
import rs.petcom.master.newFiscalization.print.JasperPrintBill;
import rs.petcom.master.newFiscalization.print.JasperStarter;
import rs.petcom.master.utility.NPrintUtil;

public class PaymentTrgovinaController
implements ControlledScreen {
    private static final Logger LOGGER = Logger.getLogger("global");
    private ScreensController controller;
    private String stringValue = "";
    private Timeline timerSat;
    private DecimalFormat numberFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
    private final SimpleDateFormat formatClock = new SimpleDateFormat("HH:mm:ss");
    private double ukupno = 0.0;
    private double uplaceno = 0.0;
    private double discount = 0.0;
    private double gotovina = 0.0;
    private double kartica = 0.0;
    private double cek = 0.0;
    private double faktura = 0.0;
    private double vaucer = 0.0;
    private double instant = 0.0;
    private double ostalo = 0.0;
    private double virman = 0.0;
    private double ostatak = 0.0;
    private double prenos = 0.0;
    String BI = "";
    String payCardSlipNumber = "";
    double g;
    private int selectedPaymentMethod = -1;
    private Bill currentActiveBill;
    private HashMap<Integer, Object> hm;
    boolean odpl = false;
    private ArrayList<RoundItem> averageListItems = new ArrayList();
    private SaleClient saleClient = new SaleClient();
    ArrayList<Product> productsForSAP = new ArrayList();
    String receiptDocumentFromSAP = "";
    private Boolean efaktura = false;
    private ToggleGroup paymentMethodToggleGroup = new ToggleGroup();
    private ToggleGroup payCardToggleGroup = new ToggleGroup();
    private FiscalPrinterDriver fpd;
    private InvoiceRequest request;
    private InvoiceResponse response;
    private InvoiceBody body;
    private InvoiceType invoiceType;
    private String tin;
    private String ukupanIznosAvansa;
    private String refNumber;
    private String predracun;
    String avanstin;
    private String passport;
    private String identification;
    private boolean printA4;
    private boolean inoiceA4;
    private boolean profakturaA4;
    private boolean KWSActive;
    private String napomenaSettings;
    private String brojKopijaRacuna;
    boolean selectedPredracun;
    boolean selectedAvans = false;
    @FXML
    BorderPane rootPane;
    @FXML
    ToggleButton paymentButton0;
    @FXML
    ToggleButton paymentButton1;
    @FXML
    ToggleButton paymentButton2;
    @FXML
    ToggleButton paymentButton3;
    @FXML
    ToggleButton paymentButton4;
    @FXML
    ToggleButton paymentButton5;
    @FXML
    ToggleButton paymentButton6;
    @FXML
    ToggleButton paymentButton7;
    @FXML
    ToggleButton paymentButton8;
    @FXML
    ToggleButton paymentButton9;
    @FXML
    ToggleButton cPaymentButton0;
    @FXML
    ToggleButton cPaymentButton1;
    @FXML
    ToggleButton cPaymentButton2;
    @FXML
    ToggleButton cPaymentButton3;
    @FXML
    ToggleButton refaction;
    @FXML
    ToggleButton cPaymentButton5;
    @FXML
    ToggleButton cPaymentButton6;
    @FXML
    ToggleButton cPaymentButton7;
    @FXML
    ToggleButton cPaymentButton8;
    @FXML
    ToggleButton cPaymentButton9;
    @FXML
    ToggleButton combinedButton;
    @FXML
    ToggleButton stampaGotovinskog;
    @FXML
    ToggleButton proforma;
    @FXML
    ToggleButton avans;
    @FXML
    Button numpad0;
    @FXML
    Button numpad1;
    @FXML
    Button numpad2;
    @FXML
    Button numpad3;
    @FXML
    Button numpad4;
    @FXML
    Button numpad5;
    @FXML
    Button numpad6;
    @FXML
    Button numpad7;
    @FXML
    Button numpad8;
    @FXML
    Button numpad9;
    @FXML
    Button numpadDecimal;
    @FXML
    Button numpadDel;
    @FXML
    Button cancelButton;
    @FXML
    Button postButton;
    @FXML
    VBox combinedPane;
    @FXML
    Label clockLabel;
    @FXML
    Label lokacijaLabel;
    @FXML
    Label userLabel;
    @FXML
    Label labelUplaceno;
    @FXML
    Label labelKusur;
    @FXML
    Label labelUkupno;
    @FXML
    Label labelPerson;
    @FXML
    Label labelDiscount;
    @FXML
    Label labelGotovina;
    @FXML
    Label labelGotovinaValue;
    @FXML
    Label labelPrenosValue;
    @FXML
    Label Value;
    @FXML
    Label labelKarticaValue;
    @FXML
    Label labelCek;
    @FXML
    Label labelCekValue;
    @FXML
    Label labelVirman;
    @FXML
    Label labelVoucherValue;
    @FXML
    Label labelInstantValue;
    @FXML
    Label labelOtherValue;
    @FXML
    Label labelOstatak;
    @FXML
    Label labelOstatakValue;
    @FXML
    Label printBillLabel;
    @FXML
    GridPane gridPane;
    @FXML
    GridPane gridPaneToggleButton;
    @FXML
    GridPane cToggleButtonGridPane;
    @FXML
    ProgressIndicator billProgressIndicator;
    int selectedToggleButton = 0;
    EventHandler<KeyEvent> eventHandlerPayment = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent key) {
            switch (key.getCode()) {
                case ENTER: {
                    break;
                }
                case P: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case G: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case K: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case C: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case F: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case O: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case UP: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case DOWN: {
                    PaymentTrgovinaController.this.selectToggleButton(key);
                    break;
                }
                case BACK_SPACE: {
                    PaymentTrgovinaController.this.keyboardNumClick(key);
                    break;
                }
                case DECIMAL: {
                    PaymentTrgovinaController.this.keyboardNumClick(key);
                    break;
                }
                case PERIOD: {
                    PaymentTrgovinaController.this.keyboardNumClick(key);
                    break;
                }
                case COMMA: {
                    PaymentTrgovinaController.this.keyboardNumClick(key);
                    break;
                }
                default: {
                    if (!key.getCode().isDigitKey()) break;
                    PaymentTrgovinaController.this.keyboardNumClick(key);
                }
            }
        }
    };
    private long documentId;
    private PayCard payCard;
    Stage taskUpdateStage;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
        this.KWSActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("KWS.aktivan"));
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        this.selectedToggleButton = 0;
        this.BI = "";
        this.payCardSlipNumber = "";
        this.g = 0.0;
        this.timerSat = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PaymentTrgovinaController.this.clockLabel.setText(PaymentTrgovinaController.this.formatClock.format(new Date()));
            }
        }, new KeyValue[0])});
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setGroupingUsed(true);
        this.invoiceType = this.controller.getSettings().isTrainingMode() ? InvoiceType.SALE_TRAINING : InvoiceType.SALE_NORMAL;
        this.fpd = this.controller.getSettings().getFpDriver();
        this.ukupno = 0.0;
        this.uplaceno = 0.0;
        this.discount = 0.0;
        this.gotovina = 0.0;
        this.kartica = 0.0;
        this.cek = 0.0;
        this.faktura = 0.0;
        this.vaucer = 0.0;
        this.instant = 0.0;
        this.ostalo = 0.0;
        this.virman = 0.0;
        this.ostatak = 0.0;
        this.stringValue = "";
        this.prenos = 0.0;
        LOGGER.info("Prenos je " + this.prenos);
        try {
            this.currentActiveBill = this.controller.getBillList().get(this.controller.getActiveBill());
        }
        catch (IndexOutOfBoundsException e) {
            this.currentActiveBill = this.controller.getBillList().get(0);
        }
        this.printA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4"));
        this.inoiceA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("invoice.A4"));
        this.profakturaA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("profaktura.A4"));
        this.napomenaSettings = Settings.getValue(this.controller, "napomena.faktura");
        this.brojKopijaRacuna = Settings.getValue(this.controller, "broj.kopija.otpremnica");
        this.fillPaymentMethodButtons();
        this.fillPayCardButtons();
        this.discount = this.getDiscountInRSD(this.currentActiveBill.getRoundList().get(0).getItemList()) / this.currentActiveBill.getSumWithDiscout();
        this.ukupno = this.currentActiveBill.getFinalSumWithDiscout();
        this.labelUkupno.setText(this.numberFormat.format(this.ukupno));
        this.labelKusur.setText(this.numberFormat.format(this.ostatak));
        if ("true".equals(this.controller.getSettings().getLCD())) {
            CustomerDispaly customerDispaly = new CustomerDispaly();
            customerDispaly.setName("Ukupno: " + this.labelUkupno.getText());
            customerDispaly.setChange("Kusur: " + this.labelKusur.getText());
            CustomerDispaly.call(customerDispaly);
        }
        this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
        this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
        this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
        this.labelCekValue.setText(this.numberFormat.format(this.cek));
        this.labelVoucherValue.setText(this.numberFormat.format(this.vaucer));
        this.labelInstantValue.setText(this.numberFormat.format(this.instant));
        this.labelOtherValue.setText(this.numberFormat.format(this.ostalo));
        this.labelPrenosValue.setText(this.numberFormat.format(this.prenos));
        try {
            this.labelPerson.setText(this.currentActiveBill.getPerson().getFirstLastName());
        }
        catch (NullPointerException e) {
            this.labelPerson.setText("");
        }
        this.labelDiscount.setText(this.numberFormat.format(this.currentActiveBill.getDiscountBillPercent()) + " %");
        this.userLabel.setText(this.controller.getUser().getUserName());
        this.lokacijaLabel.setText(this.controller.getPointOfSale().getName());
        this.clockLabel.setText(this.formatClock.format(new Date()));
        if (this.currentActiveBill.getPaymentMethod() == null) {
            this.currentActiveBill.setPaymentMethod(PaymentMethod.getByCode("CASH", this.controller.getSettings().getConnection()));
            this.paymentButton0.setSelected(true);
        }
        if (this.paymentButton0.isSelected()) {
            this.selectedPaymentMethod = 0;
            this.labelGotovinaValue.getStyleClass().add((Object)"backGroundGreen");
        }
        this.combinedButton.setSelected(false);
        this.combinedPane.setVisible(false);
        this.insertToggleButtonForSelection();
        this.gridPane.removeEventHandler(KeyEvent.KEY_PRESSED, this.eventHandlerPayment);
        this.gridPane.addEventHandler(KeyEvent.KEY_PRESSED, this.eventHandlerPayment);
    }

    private void insertToggleButtonForSelection() {
        this.hm = new HashMap();
        this.hm.put(0, this.paymentButton0);
        this.hm.put(1, this.paymentButton1);
        this.hm.put(2, this.paymentButton2);
        this.hm.put(3, this.paymentButton3);
        this.hm.put(4, this.paymentButton4);
        this.hm.put(5, this.paymentButton5);
        this.hm.put(6, this.paymentButton6);
        this.hm.put(7, this.paymentButton7);
        this.hm.put(8, this.paymentButton8);
        this.hm.put(9, this.paymentButton9);
    }

    private double getDiscountInRSD(ArrayList<RoundItem> ri) {
        this.discount = 0.0;
        for (int i = 0; i < ri.size(); ++i) {
            double pPrice = ri.get(i).getProductDepartment().getProduct().getPrice();
            double pDiscount = ri.get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
            double pQuantity = ri.get(i).getQuantity();
            this.discount += pPrice * pDiscount * pQuantity;
        }
        return Settings.round(this.discount, 2);
    }

    public void selectToggleButton(KeyEvent key) {
        PaymentMethod pm;
        ToggleButton tb;
        for (Integer inter : this.hm.keySet()) {
            PaymentMethod pm2;
            boolean selectPM = false;
            ToggleButton tb2 = (ToggleButton)this.hm.get(inter);
            if (key.getCode().equals((Object)KeyCode.K)) {
                pm2 = PaymentMethod.getByCode("CARD", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                }
                this.uplaceno = this.ukupno;
                this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
            }
            if (key.getCode().equals((Object)KeyCode.G)) {
                pm2 = PaymentMethod.getByCode("CASH", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                }
            }
            if (key.getCode().equals((Object)KeyCode.F)) {
                pm2 = PaymentMethod.getByCode("WireTransfer", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                }
                this.uplaceno = this.ukupno;
                this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
            }
            if (key.getCode().equals((Object)KeyCode.P)) {
                pm2 = PaymentMethod.getByCode("PROF", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                    this.uplaceno = this.ukupno;
                    this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
                }
            }
            if (key.getCode().equals((Object)KeyCode.C)) {
                pm2 = PaymentMethod.getByCode("CHECK", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                    this.uplaceno = this.ukupno;
                    this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
                }
            }
            if (key.getCode().equals((Object)KeyCode.O)) {
                pm2 = PaymentMethod.getByCode("OTP", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm2);
                if (tb2.getText().trim().equals(pm2.getName().trim())) {
                    selectPM = true;
                }
            }
            tb2.setSelected(selectPM);
        }
        if (key.getCode().equals((Object)KeyCode.UP) && this.selectedToggleButton < this.hm.size() - 1) {
            ++this.selectedToggleButton;
            tb = (ToggleButton)this.hm.get(this.selectedToggleButton);
            pm = PaymentMethod.getByName(tb.getText(), this.controller.getSettings().getConnection());
            if (pm.getCode().equals("ODPL")) {
                this.odpl = true;
                PaymentMethod pm1 = PaymentMethod.getByCode("CHECK", this.controller.getSettings().getConnection());
                this.controller.getCurrentBill().setPaymentMethod(pm1);
            } else {
                this.controller.getCurrentBill().setPaymentMethod(pm);
                this.odpl = false;
            }
            tb.setSelected(true);
        }
        if (key.getCode().equals((Object)KeyCode.DOWN) && this.selectedToggleButton > 0) {
            --this.selectedToggleButton;
            tb = (ToggleButton)this.hm.get(this.selectedToggleButton);
            pm = PaymentMethod.getByName(tb.getText(), this.controller.getSettings().getConnection());
            this.controller.getCurrentBill().setPaymentMethod(pm);
            tb.setSelected(true);
        }
        key.consume();
        this.gridPane.requestFocus();
    }

    private void keyboardNumClick(KeyEvent key) {
        boolean isDecimalTyped;
        String decSep = "" + this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator();
        String[] red = decSep.equals(".") ? this.stringValue.split("\\" + decSep) : this.stringValue.split(decSep);
        boolean bl = isDecimalTyped = key.getCode().equals((Object)KeyCode.DECIMAL) || key.getCode().equals((Object)KeyCode.PERIOD) || key.getCode().equals((Object)KeyCode.COMMA);
        if (red.length == 1 || red.length > 1) {
            if (this.stringValue.equals("0" + decSep + "00")) {
                this.stringValue = "";
            }
            if ((key.getCode().isDigitKey() || isDecimalTyped) && this.combinedButton.isSelected() && this.selectedPaymentMethod >= 0 || !this.combinedButton.isSelected()) {
                if (red.length > 1 && red[1].length() >= 2 && !this.stringValue.isEmpty()) {
                    return;
                }
                if (isDecimalTyped) {
                    if (!this.stringValue.endsWith(decSep)) {
                        this.stringValue = this.stringValue + decSep;
                    }
                } else {
                    this.stringValue = this.stringValue + key.getText();
                }
            }
        }
        System.out.println("stringValue.length() " + this.stringValue.length());
        System.out.println("stringValue " + this.stringValue);
        if (key.getCode() == KeyCode.BACK_SPACE && this.stringValue.length() > 0) {
            this.stringValue = red.length > 1 && red[1].length() >= 2 ? (red[1].equals("00") ? this.stringValue.substring(0, this.stringValue.length() - 4) : this.stringValue.substring(0, this.stringValue.length() - 1)) : (this.stringValue.endsWith(".") ? this.stringValue.substring(0, this.stringValue.length() - 2) : this.stringValue.substring(0, this.stringValue.length() - 1));
            if (this.stringValue.endsWith(decSep)) {
                this.stringValue = this.stringValue.substring(0, this.stringValue.length() - 1);
            }
        }
        if (!this.combinedButton.isSelected()) {
            try {
                this.uplaceno = this.numberFormat.parse(this.stringValue).doubleValue();
            }
            catch (ParseException e) {
                try {
                    this.uplaceno = this.numberFormat.parse("0,00").doubleValue();
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
            this.labelKusur.setText(this.numberFormat.format(this.uplaceno - this.ukupno));
        }
        if (this.selectedPaymentMethod == 0) {
            block46: {
                try {
                    this.gotovina = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                    try {
                        if (this.controller.getCurrentBill().getGiftCard().getAmount() != new BigDecimal(0)) {
                            this.ostatak = this.uplaceno - this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
                            break block46;
                        }
                        this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
                    }
                    catch (NullPointerException e) {
                        this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
                    }
                }
                catch (ParseException e) {
                    Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                    LOGGER.severe(e.getMessage());
                }
            }
            if (this.combinedButton.isSelected()) {
                this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
            }
        }
        if (this.selectedPaymentMethod == 1) {
            try {
                this.kartica = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
            }
        }
        if (this.selectedPaymentMethod == 6) {
            try {
                this.prenos = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelPrenosValue.setText(this.numberFormat.format(this.prenos));
            }
            LOGGER.info("U selectedPaymentMethod");
        }
        if (this.selectedPaymentMethod == 2) {
            try {
                this.cek = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelCekValue.setText(this.numberFormat.format(this.cek));
            }
        }
        if (this.selectedPaymentMethod == 3) {
            try {
                this.vaucer = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelVoucherValue.setText(this.numberFormat.format(this.vaucer));
            }
        }
        if (this.selectedPaymentMethod == 4) {
            try {
                this.instant = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelInstantValue.setText(this.numberFormat.format(this.instant));
            }
        }
        if (this.selectedPaymentMethod == 5) {
            try {
                this.ostalo = this.stringValue.equals("") ? this.numberFormat.parse("0,00").doubleValue() : this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelInstantValue.setText(this.numberFormat.format(this.ostalo));
            }
        }
        if (this.selectedPaymentMethod > 0) {
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        }
    }

    @FXML
    private void numButtonClick(ActionEvent event) {
        String decSep = String.valueOf(this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator());
        String[] red = decSep.equals(".") ? this.stringValue.split("\\" + decSep) : this.stringValue.split(decSep);
        if (red.length == 1 || red.length > 1) {
            if (this.stringValue.equals("0" + decSep + "00")) {
                this.stringValue = "";
            }
            if (this.combinedButton.isSelected() && this.selectedPaymentMethod >= 0 || !this.combinedButton.isSelected()) {
                if ((Button)event.getSource() != this.numpadDel && red.length > 1 && red[1].length() >= 2 && !this.stringValue.isEmpty()) {
                    return;
                }
                if ((Button)event.getSource() == this.numpad0) {
                    this.stringValue = this.stringValue + "0";
                }
                if ((Button)event.getSource() == this.numpad1) {
                    this.stringValue = this.stringValue + "1";
                }
                if ((Button)event.getSource() == this.numpad2) {
                    this.stringValue = this.stringValue + "2";
                }
                if ((Button)event.getSource() == this.numpad3) {
                    this.stringValue = this.stringValue + "3";
                }
                if ((Button)event.getSource() == this.numpad4) {
                    this.stringValue = this.stringValue + "4";
                }
                if ((Button)event.getSource() == this.numpad5) {
                    this.stringValue = this.stringValue + "5";
                }
                if ((Button)event.getSource() == this.numpad6) {
                    this.stringValue = this.stringValue + "6";
                }
                if ((Button)event.getSource() == this.numpad7) {
                    this.stringValue = this.stringValue + "7";
                }
                if ((Button)event.getSource() == this.numpad8) {
                    this.stringValue = this.stringValue + "8";
                }
                if ((Button)event.getSource() == this.numpad9) {
                    this.stringValue = this.stringValue + "9";
                }
                if ((Button)event.getSource() == this.numpadDecimal) {
                    this.stringValue = this.stringValue + decSep;
                }
            }
        }
        if ((Button)event.getSource() == this.numpadDel && this.stringValue.length() > 0) {
            this.stringValue = red.length > 1 && red[1].length() >= 2 ? (red[1].equals("00") ? this.stringValue.substring(0, this.stringValue.length() - 4) : this.stringValue.substring(0, this.stringValue.length() - 1)) : (this.stringValue.endsWith(".") ? this.stringValue.substring(0, this.stringValue.length() - 2) : this.stringValue.substring(0, this.stringValue.length() - 1));
            if (this.stringValue.endsWith(decSep)) {
                this.stringValue = this.stringValue.substring(0, this.stringValue.length() - 1);
            }
        }
        if (this.stringValue.equals("")) {
            this.stringValue = "0";
        }
        if (!this.combinedButton.isSelected()) {
            try {
                this.uplaceno = this.numberFormat.parse(this.stringValue).doubleValue();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
            this.labelKusur.setText(this.numberFormat.format(this.uplaceno - this.ukupno));
        }
        if (this.selectedPaymentMethod == 0) {
            try {
                this.gotovina = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
            }
        }
        if (this.selectedPaymentMethod == 1) {
            try {
                this.kartica = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
        }
        if (this.selectedPaymentMethod == 2) {
            try {
                this.cek = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelCekValue.setText(this.numberFormat.format(this.cek));
            }
        }
        if (this.selectedPaymentMethod == 3) {
            try {
                this.vaucer = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelVoucherValue.setText(this.numberFormat.format(this.vaucer));
            }
        }
        if (this.selectedPaymentMethod == 4) {
            try {
                this.instant = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelInstantValue.setText(this.numberFormat.format(this.instant));
            }
        }
        if (this.selectedPaymentMethod == 5) {
            try {
                this.ostalo = this.numberFormat.parse(this.stringValue).doubleValue();
                this.ostatak = this.ukupno - this.gotovina - this.kartica - this.cek - this.vaucer - this.instant - this.ostalo - this.prenos;
            }
            catch (ParseException e) {
                Log.writeLog(this.controller.getUser(), "Error: " + e.getMessage(), this.controller.getSettings().getConnection());
                LOGGER.severe(e.getMessage());
            }
            if (this.combinedButton.isSelected()) {
                this.labelOtherValue.setText(this.numberFormat.format(this.ostalo));
            }
        }
        if (this.selectedPaymentMethod > 0) {
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
        }
    }

    @FXML
    private void gotovinaClicked() {
        if (this.kartica != 0.0 || this.cek != 0.0 || this.vaucer != 0.0 || this.instant != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.gotovina = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelGotovinaValue.setText(this.numberFormat.format(this.gotovina));
            this.selectedPaymentMethod = 0;
            this.stringValue = this.numberFormat.format(this.gotovina);
            this.unselectCombined();
            this.labelGotovinaValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelGotovinaValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 0;
            this.unselectCombined();
            this.labelGotovinaValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelGotovinaValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    private void karticaClicked() {
        if (this.gotovina != 0.0 || this.cek != 0.0 || this.vaucer != 0.0 || this.instant != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.kartica = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelKarticaValue.setText(this.numberFormat.format(this.kartica));
            this.selectedPaymentMethod = 1;
            this.stringValue = this.numberFormat.format(this.kartica);
            this.unselectCombined();
            this.labelKarticaValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelKarticaValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 1;
            this.unselectCombined();
            this.labelKarticaValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelKarticaValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    private void cekClicked() {
        if (this.kartica != 0.0 || this.gotovina != 0.0 || this.vaucer != 0.0 || this.instant != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.cek = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelCekValue.setText(this.numberFormat.format(this.cek));
            this.selectedPaymentMethod = 2;
            this.stringValue = this.labelCekValue.getText();
            this.unselectCombined();
            this.labelCekValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelCekValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 2;
            this.unselectCombined();
            this.labelCekValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelCekValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    private void voucherClicked() {
        if (this.kartica != 0.0 || this.cek != 0.0 || this.gotovina != 0.0 || this.instant != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.vaucer = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelVoucherValue.setText(this.numberFormat.format(this.vaucer));
            this.selectedPaymentMethod = 3;
            this.stringValue = this.labelVoucherValue.getText();
            this.unselectCombined();
            this.labelVoucherValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelVoucherValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 3;
            this.unselectCombined();
            this.labelVoucherValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelVoucherValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    private void instantClicked() {
        if (this.kartica != 0.0 || this.cek != 0.0 || this.gotovina != 0.0 || this.vaucer != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.instant = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelInstantValue.setText(this.numberFormat.format(this.instant));
            this.selectedPaymentMethod = 4;
            this.stringValue = this.labelInstantValue.getText();
            this.unselectCombined();
            this.labelInstantValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelInstantValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 4;
            this.unselectCombined();
            this.labelInstantValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelInstantValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    private void otherClicked() {
        if (this.kartica != 0.0 || this.cek != 0.0 || this.gotovina != 0.0 || this.vaucer != 0.0 || this.instant != 0.0) {
            if (this.ostatak != 0.0) {
                this.ostalo = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelOtherValue.setText(this.numberFormat.format(this.ostalo));
            this.selectedPaymentMethod = 5;
            this.stringValue = this.labelOtherValue.getText();
            this.unselectCombined();
            this.labelOtherValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelOtherValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 5;
            this.unselectCombined();
            this.labelOtherValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelOtherValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    private void unselectCombined() {
        this.labelGotovinaValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelPrenosValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelKarticaValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelCekValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelVoucherValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelInstantValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelOtherValue.getStyleClass().remove((Object)"backGroundGreen");
        this.labelPrenosValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelGotovinaValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelKarticaValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelCekValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelVoucherValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelInstantValue.getStyleClass().add((Object)"backGroundTransparent");
        this.labelOtherValue.getStyleClass().add((Object)"backGroundTransparent");
    }

    @FXML
    public void logout() {
        Log.logOut(this.controller.getUser().getUserID(), this.controller.getPointOfSale().getPointOfSaleID(), this.controller.getSettings().getConnection());
        this.paymentMethodToggleGroup.getSelectedToggle().setSelected(false);
        this.unselectCombined();
        this.controller.setUser(null);
        this.controller.setBillList(new ArrayList<Bill>());
        this.controller.getScreen(ScreensController.SCREEN_LOGIN, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
    }

    @FXML
    public void toggleButtonPayCardClick(ActionEvent event) {
        ToggleButton button = (ToggleButton)event.getSource();
        button.setSelected(true);
        this.payCard = PayCard.getByName(this.controller, button.getText().trim());
        HashMap<String, Object> hMap = new HashMap<String, Object>();
        if (this.payCardSlipNumber == null || this.payCardSlipNumber.equals("")) {
            hMap.put("controller", this.controller);
            hMap.put("title", "Broj slipa");
            hMap.put("notice", "Unesite broj slipa: ");
            int result = this.controller.showModalDialog("payCardSlipNumber", ScreensController.DIALOG_SLIP_NUMBER_INPUT, hMap, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.payCardSlipNumber = (String)hMap.get("slipNumber");
            } else {
                button.setSelected(false);
            }
        }
    }

    @FXML
    public void toggleButtonClick(ActionEvent event) {
        ToggleButton button = (ToggleButton)event.getSource();
        button.setSelected(true);
        try {
            if (!button.getText().equals("")) {
                PaymentMethod pm = PaymentMethod.getByName(button.getText(), this.controller.getSettings().getConnection());
                System.out.println("pm.getCode() " + pm.getCode());
                switch (pm.getCode()) {
                    case "CASH": {
                        this.selectedPaymentMethod = 0;
                        this.labelGotovinaValue.getStyleClass().add((Object)"backGroundGreen");
                        break;
                    }
                    case "CARD": {
                        this.selectedPaymentMethod = 1;
                        this.labelKarticaValue.getStyleClass().add((Object)"backGroundGreen");
                        break;
                    }
                    case "CHECK": {
                        this.selectedPaymentMethod = 2;
                        this.labelCekValue.getStyleClass().add((Object)"backGroundGreen");
                        break;
                    }
                    case "WireTransfer": {
                        this.selectedPaymentMethod = 6;
                        this.labelPrenosValue.getStyleClass().add((Object)"backGroundGreen");
                        break;
                    }
                    case "Voucher": {
                        this.selectedPaymentMethod = 3;
                        this.labelVoucherValue.getStyleClass().add((Object)"backGroundGreen");
                        this.proforma.setSelected(false);
                        break;
                    }
                    case "MobileMoney": {
                        this.selectedPaymentMethod = 4;
                        this.labelInstantValue.getStyleClass().add((Object)"backGroundGreen");
                        this.proforma.setSelected(false);
                        break;
                    }
                    case "Other": {
                        this.selectedPaymentMethod = 5;
                        this.labelInstantValue.getStyleClass().add((Object)"backGroundGreen");
                        this.proforma.setSelected(false);
                        break;
                    }
                }
                if (!pm.getCode().equals("CASH")) {
                    this.uplaceno = this.ukupno;
                    this.labelUplaceno.setText(this.numberFormat.format(this.uplaceno));
                    this.labelKusur.setText(this.numberFormat.format(0L));
                    this.stringValue = "";
                    this.cToggleButtonGridPane.setDisable(false);
                } else {
                    this.uplaceno = 0.0;
                    this.labelUplaceno.setText(this.numberFormat.format(0.0));
                    this.labelKusur.setText(this.numberFormat.format(this.ukupno));
                }
                if (pm.getCode().trim().equals("ODPL")) {
                    this.odpl = true;
                    PaymentMethod pm1 = PaymentMethod.getByCode("CHECK", this.controller.getSettings().getConnection());
                    this.controller.getCurrentBill().setPaymentMethod(pm1);
                } else {
                    this.odpl = false;
                    this.controller.getCurrentBill().setPaymentMethod(pm);
                }
                if (pm.getCode().trim().equals("PON")) {
                    this.controller.getCurrentBill().setPaymentMethod(pm);
                }
                if (!pm.getCode().equals("WireTransfer") && !pm.getCode().equals("PROF")) {
                    this.paymentMethodToggleGroup.getSelectedToggle().setSelected(false);
                } else {
                    this.paymentButton0.setSelected(false);
                    this.paymentButton1.setSelected(false);
                    this.paymentButton3.setSelected(false);
                    this.paymentButton4.setSelected(false);
                    this.paymentButton5.setSelected(false);
                    this.paymentButton6.setSelected(false);
                    this.paymentButton7.setSelected(false);
                    this.paymentButton8.setSelected(false);
                    this.paymentButton9.setSelected(false);
                }
                if (pm.isComplex()) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    hm.put("controller", this.controller);
                    this.controller.showModalDialog("Izbor na\u010dina pla\u0107anja", ScreensController.SCREEN_PAYMENT_METHOD_SELECTION_TRGOVINA, hm, this.rootPane.getScene().getWindow());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    void refactionClicked(ActionEvent event) {
        this.stampaGotovinskog.setSelected(false);
        this.proforma.setSelected(false);
        this.avans.setSelected(false);
    }

    @FXML
    void proformaSelected(ActionEvent event) {
        this.stampaGotovinskog.setSelected(false);
        this.refaction.setSelected(false);
        this.avans.setSelected(false);
        this.selectedPredracun = this.proforma.isSelected();
    }

    @FXML
    public void stampaGotovinskogClicked() {
        this.proforma.setSelected(false);
        this.refaction.setSelected(false);
        this.avans.setSelected(false);
        if (this.stampaGotovinskog.isSelected()) {
            // empty if block
        }
    }

    @FXML
    public void combinedButtonClick() {
        this.combinedPane.setVisible(this.combinedButton.isSelected());
        if (this.combinedButton.isSelected()) {
            this.ostatak = this.ukupno;
            this.gotovina = 0.0;
            this.kartica = 0.0;
            this.cek = 0.0;
            this.virman = 0.0;
            this.prenos = 0.0;
            this.stringValue = "0" + this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator() + "00";
            this.labelGotovinaValue.setText(this.numberFormat.format(0.0));
            this.labelPrenosValue.setText(this.numberFormat.format(0.0));
            this.labelKarticaValue.setText(this.numberFormat.format(0.0));
            this.labelCekValue.setText(this.numberFormat.format(0.0));
            this.labelVoucherValue.setText(this.numberFormat.format(0.0));
            this.labelInstantValue.setText(this.numberFormat.format(0.0));
            this.labelOtherValue.setText(this.numberFormat.format(0.0));
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.controller.getCurrentBill().setPaymentMethod(PaymentMethod.getByCode("COMBINED", this.controller.getSettings().getConnection()));
        } else {
            this.stringValue = "0" + this.numberFormat.getDecimalFormatSymbols().getDecimalSeparator() + "00";
        }
    }

    @FXML
    public void cancelButton() {
        this.unselectCombined();
        if (this.paymentMethodToggleGroup.getSelectedToggle() != null) {
            this.paymentMethodToggleGroup.getSelectedToggle().setSelected(false);
        }
        this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT);
    }

    /*
     * Unable to fully structure code
     */
    @FXML
    public void postButtonClick() {
        block202: {
            block203: {
                block204: {
                    block208: {
                        block206: {
                            block207: {
                                block205: {
                                    person1 = null;
                                    eInvoice = false;
                                    hmTemp = null;
                                    personTemp = null;
                                    this.tin = null;
                                    personID = -1L;
                                    if (this.combinedButton.isSelected() && this.ostatak != 0.0) {
                                        this.controller.alert("Neispravan unos kombinovanog pla\u0107anja.", "Izabrano je kombinovano pla\u0107anje, a suma na\u010dina pla\u0107anja nije jednaka sumi ra\u010duna.", this.rootPane.getScene().getWindow());
                                        return;
                                    }
                                    if (this.controller.getSettings().getUplacenIznos() == 1 && this.controller.getUser().hasRole("uplacen.iznos.neophodan") && !this.controller.getCurrentBill().getPaymentMethod().isExactAmountDefault() && !this.combinedButton.isSelected() && this.ukupno > this.uplaceno) {
                                        this.controller.alert("Neispravan uneti napla\u0107eni iznos.", "Ukupan napla\u0107eni iznos NE MO\u017dE biti manji od ukupnog iznosa ra\u010duna", this.rootPane.getScene().getWindow());
                                        return;
                                    }
                                    if (this.stampaGotovinskog.isSelected()) {
                                        note = "";
                                        taxExamptMessage = "";
                                        message = "";
                                        hashMap = new HashMap<String, Object>();
                                        hashMap.put("controller", this.controller);
                                        hashMap.put("headLine", "Unesite PIB");
                                        if (this.controller.getCurrentBill().getPerson() == null) {
                                            res = this.controller.showModalDialog("Izbor gotovinskog kupca", ScreensController.SCREEN_BACKOFFICE_TIN_INSERT, hashMap, this.rootPane.getScene().getWindow());
                                            if (res == ScreensController.MODAL_RESULT_OK) {
                                                this.tin = (String)hashMap.get("tin");
                                                this.predracun = (String)hashMap.get("predracun");
                                                this.identification = (String)hashMap.get("identification");
                                            } else {
                                                return;
                                            }
                                        }
                                    }
                                    if (this.avans.isSelected()) {
                                        note = "";
                                        taxExamptMessage = "";
                                        message = "";
                                        hashMap = new HashMap<K, V>();
                                        hashMap.put("controller", this.controller);
                                        hashMap.put("headLine", "Unesite PIB");
                                        if (this.controller.getCurrentBill().getPerson() == null) {
                                            res = this.controller.showModalDialog("Izbor gotovinskog kupca", ScreensController.SCREEN_BACKOFFICE_TIN_INSERT_AVANS, hashMap, this.rootPane.getScene().getWindow());
                                            if (res == ScreensController.MODAL_RESULT_OK) {
                                                this.tin = (String)hashMap.get("tin");
                                                this.avanstin = (String)hashMap.get("avanstin");
                                                this.ukupanIznosAvansa = (String)hashMap.get("tfSum");
                                                this.refNumber = (String)hashMap.get("tfRefNumber");
                                                if (this.avanstin == null || "avanstin".equals(this.avanstin) && (this.ukupanIznosAvansa == null || this.ukupanIznosAvansa.isEmpty()) || "refundacija".equals(this.avanstin) && (this.ukupanIznosAvansa == null || this.refNumber == null || this.refNumber.isEmpty())) {
                                                    this.controller.alert("Greska", "Morate izabrati avans, refundaciju ili konacni racun ili niste upisali iznos i referentni broj!!!", this.rootPane.getScene().getWindow());
                                                    this.avanstin = null;
                                                    this.avans.setSelected(false);
                                                    return;
                                                }
                                                System.out.println("refundacija provera" + this.avanstin + " iznos avansa" + this.ukupanIznosAvansa);
                                                if ("refundacija".equals(this.avanstin) && (this.ukupanIznosAvansa == null || this.ukupanIznosAvansa.isEmpty() || this.refNumber == null || this.refNumber.isEmpty())) {
                                                    this.controller.alert("Greska", "Ukupan iznos kod refundacije nije unet!!!", this.rootPane.getScene().getWindow());
                                                    this.avanstin = null;
                                                    this.avans.setSelected(false);
                                                    return;
                                                }
                                                System.out.println("refundacija nakon provera");
                                                if ("konacniracun".equals(this.avanstin) && (this.refNumber == null || this.refNumber.isEmpty())) {
                                                    this.avanstin = null;
                                                    this.avans.setSelected(false);
                                                    this.controller.alert("Greska", "Morate uneti referent number sa prethnog avansa ili niste unesli iznos konacnog  racuna", this.rootPane.getScene().getWindow());
                                                    return;
                                                }
                                                refNumberTemp = false;
                                                if (this.refNumber != null && !this.refNumber.isEmpty()) {
                                                    refNumberTemp = Document.findByRefNumber(this.avanstin, this.refNumber, this.controller);
                                                    paid = Document.findByRefNumberSumFull(this.avanstin, this.refNumber, this.controller);
                                                    text = Document.findByRefNumberSumFullText(this.avanstin, this.refNumber, this.controller);
                                                    if (!text.isEmpty()) {
                                                        this.controller.alert("Obavestenje", text, this.rootPane.getScene().getWindow());
                                                    }
                                                    System.out.println("Paid j e" + paid);
                                                    sumWithDiscount = Document.findByRefNumberSumFullWithDiscount(this.avanstin, this.refNumber, this.controller);
                                                    razlika = Double.valueOf(this.ukupanIznosAvansa) - paid;
                                                    System.out.println("Razlika je " + razlika);
                                                    if ("refundacija".equals(this.avanstin) && (razlika > 0.2 || razlika < -0.2)) {
                                                        this.avans.setSelected(false);
                                                        this.controller.alert("Greska", "Iznos za refundaciju nije unet dobar morate uneti zbir svih avansa do sada!!!", this.rootPane.getScene().getWindow());
                                                        return;
                                                    }
                                                    if ("avanstin".equals(this.avanstin) && (pretplata = paid + Double.valueOf(this.ukupanIznosAvansa) - sumWithDiscount) > 0.0) {
                                                        this.avans.setSelected(false);
                                                        this.controller.alert("Greska", "Pokusavate da uplatite iznos koji je veci od ukupnog iznosa racuna!!!", this.rootPane.getScene().getWindow());
                                                        return;
                                                    }
                                                    sumKonacni = 0.0;
                                                    if ("konacniracun".equals(this.avanstin)) {
                                                        sumKonacni = Document.findByRefNumberSum(this.refNumber, this.controller);
                                                        System.out.println("Sum konacni " + sumKonacni);
                                                        if (sumKonacni < -0.2) {
                                                            this.avanstin = null;
                                                            this.avans.setSelected(false);
                                                            this.controller.alert("Greska", "Morate uneti referent number sa prethnog avansa ili nije iznos konacnog  racuna dobar", this.rootPane.getScene().getWindow());
                                                            return;
                                                        }
                                                        this.ukupanIznosAvansa = String.valueOf(sumKonacni);
                                                    }
                                                    if (!refNumberTemp) {
                                                        this.avans.setSelected(false);
                                                        this.controller.alert("Greska", "Morate uneti ispravan referentni number sa prethodnog avansa", this.rootPane.getScene().getWindow());
                                                        return;
                                                    }
                                                }
                                                this.controller.getSettings().setRefNumberTemp(this.refNumber);
                                            } else {
                                                return;
                                            }
                                        }
                                    }
                                    if (!this.currentActiveBill.getPaymentMethod().getCode().equals("WireTransfer")) break block203;
                                    note = "";
                                    hm = new HashMap<String, Object>();
                                    hmTemp = hm;
                                    hm.put("controller", this.controller);
                                    hm.put("personCategory", PersonCategory.BUYER);
                                    hm.put("title", "Obave\u0161tenje");
                                    hm.put("saNaplate", true);
                                    if (this.controller.getCurrentBill().getPerson() == null || !this.controller.getCurrentBill().getPerson().isBuyer(this.controller.getSettings().getConnection())) break block204;
                                    buyerOfferPrice = BuyerOfferPrice.getOfferPrice(this.controller.getCurrentBill().getPerson().getBuyerOfferPriceID(), this.controller.getSettings().getConnection());
                                    if (buyerOfferPrice.getBuyerOfferPriceID() != null) break block205;
                                    hm.put("text", "Da li ste sigurni da komitenta, " + this.controller.getCurrentBill().getPerson().getName() + " (" + this.controller.getCurrentBill().getPerson().getFirstLastName() + "), koji ima " + Settings.getNumberFormat(2, true).format(this.controller.getCurrentBill().getPerson().getDiscount()) + "% popusta \u017eelite da ve\u017eete za ra\u010dun. ");
                                    resultYesNo = this.controller.showModalDialog("", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                                    if (resultYesNo != ScreensController.MODAL_RESULT_NO) ** GOTO lbl138
                                    result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_BUYER, hm, this.rootPane.getScene().getWindow());
                                    if (result == ScreensController.MODAL_RESULT_OK) {
                                        note = this.addNoteToDocument(this.controller, hm, false);
                                        p = (Person)hm.get("person");
                                        if (p.isTaxExempt()) {
                                            TaxExampt.getTaxExamptBill(this.currentActiveBill, this.controller.getSettings().getConnection());
                                        }
                                        personID = p.getPersonID();
                                        this.currentActiveBill.setNapomena(note);
                                        this.currentActiveBill.setPerson(p);
                                        this.currentActiveBill.setDiscountIfNotZero(((Person)hm.get("person")).getDiscount());
                                        this.ukupno = this.controller.getCurrentBill().getFinalSumWithDiscout();
                                        if (this.stampaGotovinskog.isSelected()) {
                                            this.uplaceno = this.ukupno;
                                        }
                                    } else if (this.stampaGotovinskog.isSelected()) {
                                        this.uplaceno = this.ukupno = this.controller.getCurrentBill().getFinalSumWithDiscout();
                                    } else {
                                        this.controller.alert("Obave\u0161tenje", "Morate uneti komitenta ili promenite na\u00e8in pla\u00e6anja", this.rootPane.getScene().getWindow());
                                        return;
lbl138:
                                        // 1 sources

                                        if (resultYesNo == ScreensController.MODAL_RESULT_YES) {
                                            NoteYesNo = this.controller.yesNoDialog("Dodavanje napomene u dokument", "Da li \u017eelite da dodate napomenu za dokument koji kreirate", this.rootPane.getScene().getWindow());
                                            if (NoteYesNo == ScreensController.MODAL_RESULT_YES) {
                                                hm.put("profaktura", false);
                                                this.controller.showModalDialog("Dodavanje napomene", ScreensController.DIALOG_ADD_NOTE, hm, this.rootPane.getScene().getWindow());
                                                note = (String)hm.get("noteText");
                                            }
                                            this.currentActiveBill.setNapomena(note);
                                            p = this.controller.getCurrentBill().getPerson();
                                            personID = p.getPersonID();
                                            if (p.isTaxExempt()) {
                                                TaxExampt.getTaxExamptBill(this.currentActiveBill, this.controller.getSettings().getConnection());
                                            }
                                            this.ukupno = Settings.roundOnTwo(this.controller.getCurrentBill().getFinalSumWithDiscout());
                                        }
                                    }
                                    break block203;
                                }
                                result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_BUYER, hm, this.rootPane.getScene().getWindow());
                                if (result != ScreensController.MODAL_RESULT_OK) break block206;
                                hm.put("text", "Da li ste sigurni da komitenta, " + ((Person)hm.get("person")).getName() + " (" + ((Person)hm.get("person")).getFirstLastName() + "), koji ima " + Settings.getNumberFormat(2, true).format(((Person)hm.get("person")).getDiscount()) + "% popusta \u017eelite da ve\u017eete za ra\u00e8un. ");
                                resultYesNo = this.controller.showModalDialog("", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                                if (resultYesNo != ScreensController.MODAL_RESULT_YES) break block207;
                                personID = ((Person)hm.get("person")).getPersonID();
                                this.currentActiveBill.setPerson((Person)hm.get("person"));
                                this.currentActiveBill.setDiscountIfNotZero(((Person)hm.get("person")).getDiscount());
                                this.ukupno = this.controller.getCurrentBill().getFinalSumWithDiscout();
                                if (this.stampaGotovinskog.isSelected()) {
                                    this.uplaceno = this.ukupno;
                                }
                                break block203;
                            }
                            return;
                        }
                        if (!this.stampaGotovinskog.isSelected()) break block208;
                        this.uplaceno = this.ukupno = this.controller.getCurrentBill().getFinalSumWithDiscout();
                        break block203;
                    }
                    this.controller.alert("Obave\u0161tenje", "Morate uneti komitenta ili promenite na\u00e8in pla\u00e6anja", this.rootPane.getScene().getWindow());
                    return;
                }
                if (this.predracun != null) ** GOTO lbl207
                result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_BUYER, hm, this.rootPane.getScene().getWindow());
                if (result != ScreensController.MODAL_RESULT_OK) ** GOTO lbl202
                if (hm.get("person") != null) {
                    hm.put("text", "Da li ste sigurni da komitenta, " + ((Person)hm.get("person")).getName() + " (" + ((Person)hm.get("person")).getFirstLastName() + "), koji ima " + Settings.getNumberFormat(2, true).format(((Person)hm.get("person")).getDiscount()) + "% popusta \u017eelite da ve\u017eete za ra\u010dun. ");
                } else {
                    hm.put("text", "Da li ste sigurni da ne zelite da izaberete komtenta");
                }
                resultYesNo = this.controller.showModalDialog("", ScreensController.DIALOG_YES_NO, hm, this.rootPane.getScene().getWindow());
                if (resultYesNo == ScreensController.MODAL_RESULT_YES) {
                    note = this.addNoteToDocument(this.controller, hm, false);
                    personTemp = p = (Person)hm.get("person");
                    this.currentActiveBill.setPerson(p);
                    this.currentActiveBill.setNapomena(note);
                    if (hm.get("person") != null) {
                        this.currentActiveBill.setDiscountIfNotZero(((Person)hm.get("person")).getDiscount());
                    }
                    if (p != null && p.isTaxExempt() && p.getPersonVatTypeID() == 2) {
                        TaxExampt.getTaxExamptBill(this.currentActiveBill, this.controller.getSettings().getConnection());
                    }
                    if (this.stampaGotovinskog.isSelected()) {
                        this.uplaceno = this.ukupno;
                    }
                } else {
                    return;
lbl202:
                    // 1 sources

                    if (this.stampaGotovinskog.isSelected()) {
                        this.uplaceno = this.ukupno = this.controller.getCurrentBill().getFinalSumWithDiscout();
                    } else {
                        this.controller.alert("Obave\u0161tenje", "Morate uneti komitenta ili promenite na\u010din pla\u0107anja", this.rootPane.getScene().getWindow());
                        return;
lbl207:
                        // 1 sources

                        this.ukupno = Settings.roundOnTwo(this.controller.getCurrentBill().getFinalSumWithDiscout());
                        if (this.stampaGotovinskog.isSelected()) {
                            this.uplaceno = this.ukupno;
                        }
                        this.predracun = null;
                    }
                }
            }
            if (this.KWSActive) {
                this.productsForSAP = new ArrayList<E>();
                itemList = this.currentActiveBill.getRoundList().get(0).getItemList();
                for (RoundItem ri : itemList) {
                    product = ri.getProductDepartment().getProduct();
                    PaymentTrgovinaController.LOGGER.info(product.toString());
                    this.productsForSAP.add(product);
                }
                try {
                    this.receiptDocumentFromSAP = this.saleInSAP(this.productsForSAP);
                }
                catch (Exception e) {
                    this.controller.alert("Obave\u0161tenje", "Gre\u0160ka prilikom poku\u0161aja komunikacije sa SAPOM!", this.rootPane.getScene().getWindow());
                }
            }
            if (this.currentActiveBill.getPaymentMethod().getParentPaymentMethodID() == 0 && (!this.combinedButton.isSelected() || this.combinedButton.isSelected() && this.ostatak == 0.0)) {
                otpr = PaymentMethod.getByCode("OTP", this.controller.getSettings().getConnection());
                if (otpr == null) {
                    PaymentMethod.createOtpPaymentmethod(this.controller.getSettings().getConnection());
                }
                try {
                    otpr = PaymentMethod.getByCode("OTP", this.controller.getSettings().getConnection());
                    if (this.currentActiveBill.getPaymentMethod().getPaymentMethodID() != otpr.getPaymentMethodID()) {
                        block201: {
                            this.currentActiveBill.setPaid(this.uplaceno);
                            if (this.ukupanIznosAvansa != null && !this.ukupanIznosAvansa.isEmpty() && this.refNumber != null) {
                                try {
                                    this.ukupno = Double.valueOf(this.ukupanIznosAvansa);
                                }
                                catch (Exception e) {
                                    System.out.println("vrednost racuna");
                                }
                            }
                            if ("konacniracun".equals(this.avanstin)) {
                                document = Document.getByID(this.documentId, this.controller.getSettings().getConnection());
                                this.ukupno = document.getPaid();
                            }
                            if (!this.combinedPane.isVisible()) {
                                document = this.controller.getCurrentBill().getPaymentMethod().getCode();
                                ri = -1;
                                switch (document.hashCode()) {
                                    case 2061107: {
                                        if (!document.equals("CASH")) break;
                                        ri = 0;
                                        break;
                                    }
                                    case 2061072: {
                                        if (!document.equals("CARD")) break;
                                        ri = 1;
                                        break;
                                    }
                                    case 64089320: {
                                        if (!document.equals("CHECK")) break;
                                        ri = 2;
                                        break;
                                    }
                                    case 1192479664: {
                                        if (!document.equals("WireTransfer")) break;
                                        ri = 3;
                                        break;
                                    }
                                    case -1990121842: {
                                        if (!document.equals("Voucher")) break;
                                        ri = 4;
                                        break;
                                    }
                                    case 337337630: {
                                        if (!document.equals("MobileMoney")) break;
                                        ri = 5;
                                        break;
                                    }
                                    case 76517104: {
                                        if (!document.equals("Other")) break;
                                        ri = 6;
                                    }
                                }
                                switch (ri) {
                                    case 0: {
                                        this.g = this.uplaceno <= this.ukupno ? this.ukupno : this.uplaceno;
                                        this.kartica = 0.0;
                                        this.cek = 0.0;
                                        this.virman = 0.0;
                                        break;
                                    }
                                    case 1: {
                                        this.g = 0.0;
                                        this.kartica = this.ukupno;
                                        this.cek = 0.0;
                                        this.virman = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = 0.0;
                                        this.instant = 0.0;
                                        this.ostalo = 0.0;
                                        break;
                                    }
                                    case 2: {
                                        this.g = 0.0;
                                        this.kartica = 0.0;
                                        this.cek = this.ukupno;
                                        this.virman = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = 0.0;
                                        this.instant = 0.0;
                                        this.ostalo = 0.0;
                                        break;
                                    }
                                    case 3: {
                                        this.g = 0.0;
                                        this.kartica = 0.0;
                                        this.cek = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = 0.0;
                                        this.instant = 0.0;
                                        this.ostalo = 0.0;
                                        this.prenos = this.uplaceno <= this.ukupno ? this.ukupno : this.uplaceno;
                                        break;
                                    }
                                    case 4: {
                                        this.g = 0.0;
                                        this.kartica = 0.0;
                                        this.cek = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = this.ukupno;
                                        this.instant = 0.0;
                                        this.ostalo = 0.0;
                                        break;
                                    }
                                    case 5: {
                                        this.g = 0.0;
                                        this.kartica = 0.0;
                                        this.cek = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = 0.0;
                                        this.instant = this.ukupno;
                                        this.ostalo = 0.0;
                                        break;
                                    }
                                    case 6: {
                                        this.g = 0.0;
                                        this.kartica = 0.0;
                                        this.cek = 0.0;
                                        this.faktura = 0.0;
                                        this.vaucer = 0.0;
                                        this.instant = 0.0;
                                        this.ostalo = this.ukupno;
                                    }
                                }
                            }
                            if (this.controller.getCurrentBill().getPaymentMethod().getCode().equals("COMBINED")) {
                                this.g = this.gotovina;
                            }
                            try {
                                if (this.selectedAvans) {
                                    this.controller.getBillList().get(this.controller.getActiveBill()).getPaymentMethod().setCode("AVANS");
                                    if (this.refNumber != null && !this.refNumber.isEmpty()) {
                                        this.controller.getBillList().get(this.controller.getActiveBill()).getPaymentMethod().setRefBrojAvans(true);
                                        System.out.println("dosao sam u if ref peayment");
                                    } else {
                                        this.controller.getBillList().get(this.controller.getActiveBill()).getPaymentMethod().setRefBrojAvans(false);
                                    }
                                }
                                if (this.selectedPredracun) {
                                    this.controller.getBillList().get(this.controller.getActiveBill()).getPaymentMethod().setCode("PROF");
                                }
                                PaymentTrgovinaController.LOGGER.info("Unos racuna");
                                this.documentId = Bill.writeBill(this.avanstin, this.controller.getBillList().get(this.controller.getActiveBill()), this.controller.getPointOfSale(), this.cPaymentButton7.isSelected() ? !this.cPaymentButton7.getText().equals("") : false, "", this.stampaGotovinskog.isSelected(), this.controller, this.response, this.body);
                                PaymentTrgovinaController.LOGGER.info("Zavrsen unos racuna");
                                this.selectedPredracun = false;
                            }
                            catch (Exception e) {
                                PaymentTrgovinaController.LOGGER.info(e.getMessage());
                                Log.writeLog(this.controller.getUser(), "Racun u problemu : " + this.documentId, this.controller.getSettings().getConnection());
                                this.controller.alert("Greska", "Nije doslo do upisa racuna", this.rootPane.getScene().getWindow());
                                return;
                            }
                            payments = this.getPayments();
                            if (this.fpd == FiscalPrinterDriver.Lpfr) {
                                this.request = new InvoiceRequest(this.currentActiveBill, payments, this.controller);
                                if (this.ukupanIznosAvansa != null && this.avanstin != null) {
                                    for (Map.Entry<String, Double> set : payments.entrySet()) {
                                        try {
                                            p = new Payment();
                                            p.setPaymentType(set.getKey());
                                            p.setAmount(Double.valueOf(this.ukupanIznosAvansa));
                                            set.setValue(Double.valueOf(this.ukupanIznosAvansa));
                                        }
                                        catch (Exception e) {
                                            return;
                                        }
                                    }
                                    this.request.setAmountSum(Double.valueOf(this.ukupanIznosAvansa));
                                    this.request.setAvans(this.avanstin);
                                }
                                if ("predracun".equals(this.predracun)) {
                                    this.invoiceType = InvoiceType.SALE_PROFORMA;
                                    pm = PaymentMethod.getByCode("PROF", this.controller.getSettings().getConnection());
                                    this.currentActiveBill.setPaymentMethod(pm);
                                    this.proforma.setSelected(false);
                                }
                                if ("konacniracun".equals(this.avanstin)) {
                                    this.invoiceType = InvoiceType.SALE_NORMAL;
                                    this.request.setAvans(this.avanstin);
                                    this.request.setLprfBroj(this.refNumber);
                                    this.avans.setSelected(false);
                                }
                                if (this.avans.isSelected() && !"konacniracun".equals(this.avanstin)) {
                                    this.invoiceType = InvoiceType.AVANS;
                                    if ("refundacija".equals(this.avanstin)) {
                                        System.out.println("refundacija");
                                        this.invoiceType = InvoiceType.REFUND_AVANS;
                                        this.request.setLprfBroj(this.refNumber);
                                    } else {
                                        this.request.setLprfBroj(this.refNumber);
                                    }
                                    this.avans.setSelected(false);
                                }
                                if (this.proforma.isSelected()) {
                                    this.invoiceType = InvoiceType.SALE_PROFORMA;
                                    pm = PaymentMethod.getByCode("PROF", this.controller.getSettings().getConnection());
                                    this.currentActiveBill.setPaymentMethod(pm);
                                    this.proforma.setSelected(false);
                                }
                                if (this.refaction.isSelected()) {
                                    hm = new HashMap<String, Object>();
                                    hm.put("controller", this.controller);
                                    hm.put("headLine", "Unesite broj paso\u0161a:");
                                    this.controller.showModalDialog("Unos podataka kupca", ScreensController.SCREEN_BACKOFFICE_REFACTION_BUYER_INSERT, hm, this.rootPane.getScene().getWindow());
                                    this.refaction.setSelected(false);
                                    this.passport = (String)hm.get("passport");
                                    this.identification = (String)hm.get("identification");
                                }
                                if (this.tin != null && !this.tin.isEmpty()) {
                                    this.request.getBody().setBuyerId(this.tin);
                                }
                                if (this.tin != null && !this.tin.isEmpty()) {
                                    this.request.getBody().setBuyerId(this.tin);
                                }
                                if (this.passport != null && !this.passport.isEmpty()) {
                                    this.request.getBody().setBuyerId(this.passport);
                                }
                                if (this.identification != null && !this.identification.isEmpty()) {
                                    this.request.getBody().setBuyerCostCenterId(this.identification);
                                }
                                if (!this.efaktura.booleanValue()) {
                                    this.response = this.request.getInvoiceResponse(this.invoiceType);
                                    this.body = this.request == null ? new InvoiceBody() : this.request.getBody();
                                    if (this.response == null) {
                                        this.response = new InvoiceResponse();
                                    }
                                    if ((modelStates = this.response.getModelState()) != null) {
                                        System.out.println("Dogodila se greska obrisi ekran");
                                        handler = new BadRequestHandler(this.controller, modelStates, this.rootPane.getScene().getWindow());
                                        handler.handleBadRequest();
                                        Bill.updateDocumentNumber(this.documentId, this.controller);
                                        this.avanstin = null;
                                        this.ukupno = 0.0;
                                        this.ukupanIznosAvansa = null;
                                        this.avans.setSelected(false);
                                        this.selectedAvans = false;
                                        this.efaktura = false;
                                        System.out.println("Stigao sam ObservableList<Present>");
                                        presentList = Present.getPresentList(this.controller);
                                        this.controller.alert("Greska", "Dogodila se greska ka poreskoj pokusajte ponovo sa kucanjem", this.rootPane.getScene().getWindow());
                                        this.avanstin = null;
                                        this.avans.setSelected(false);
                                        this.controller.getBillList().remove(this.controller.getActiveBill());
                                        this.controller.getBillList().clear();
                                        this.controller.setStockRefresh(true);
                                        this.controller.setBillPrinted(true);
                                        if (this.controller.getReservationDocument() != null) {
                                            this.controller.getReservationDocument().setRealized(true);
                                            this.controller.getReservationDocument().update(this.controller);
                                            this.controller.setReservationDocument(null);
                                        }
                                        this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT_TRGOVINA);
                                        return;
                                    }
                                    if (personTemp != null && personTemp.getPIB() != null) {
                                        person1 = Person.getByPIB(personTemp.getPIB(), this.controller.getSettings().getConnection());
                                        eInvoice = (Boolean)hmTemp.get("addEFaktura");
                                        PaymentTrgovinaController.LOGGER.info("PERSON JE - efaktura " + person1.geteFaktura());
                                        PaymentTrgovinaController.LOGGER.info("JBKJS " + person1.getTfJBKJ());
                                        PaymentTrgovinaController.LOGGER.info("Einvoice " + eInvoice);
                                    }
                                    if (this.avanstin == null && this.controller.getObject() != null && this.controller.getObject().getApiKey() != null && !this.controller.getObject().getApiKey().isEmpty() && person1 != null && person1.geteFaktura() != null && person1.geteFaktura().booleanValue() && this.controller.getObject().getIdCompany() != null && !this.controller.getObject().getIdCompany().isEmpty()) {
                                        invoice = new Invoice();
                                        invoiceDto = invoice.createInvoice(this.controller, personTemp, this.response.getInvoiceNumber());
                                        ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                                        try {
                                            json = ow.writeValueAsString((Object)invoiceDto);
                                            System.out.println(json);
                                        }
                                        catch (Exception json) {
                                            // empty catch block
                                        }
                                        invoiceApi = new InvoiceApi();
                                        response = invoiceApi.response(this.controller, invoiceDto);
                                        System.out.println("response " + response);
                                        if (response.isEmpty()) {
                                            this.efaktura = false;
                                            this.controller.alert("Upozorenje nije kreirana e-faktura" + response, response, this.rootPane.getScene().getWindow());
                                            this.controller.getBillList().get(0).getRoundList().get(0).getItemList().clear();
                                            return;
                                        }
                                        if (response.contains("Upozorenje")) {
                                            this.controller.alert("Upozorenje " + response, response, this.rootPane.getScene().getWindow());
                                            this.controller.getBillList().get(0).getRoundList().get(0).getItemList().clear();
                                        } else if (response.contains("Greska")) {
                                            this.controller.getBillList().get(0).getRoundList().get(0).getItemList().clear();
                                            this.controller.alert(response, response, this.rootPane.getScene().getWindow());
                                        } else {
                                            this.efaktura = false;
                                        }
                                        System.out.println("Efaktura je " + this.efaktura);
                                    }
                                    if (this.response.getInvoiceNumber() == null) {
                                        PaymentTrgovinaController.LOGGER.info("Nema odgovora od lprf-a");
                                        Bill.updateDocumentNumber(this.documentId, this.controller);
                                        Log.writeLog(this.controller.getUser(), "Poreska Uprava : Response od poreske uprave je null " + this.documentId, this.controller.getSettings().getConnection());
                                        this.controller.alert("Greska", "Nema odgovora odlprf-a, proverite da li je lprf pokrenut i da li je kartica ubacena, pokusajte ponovo da izdate racun ako postoji problem kontaktirajte tehnicku podrsku 011-44-05-405. ", this.rootPane.getScene().getWindow());
                                        return;
                                    }
                                    PaymentTrgovinaController.LOGGER.info("Update Document id " + this.documentId);
                                    Bill.updateDocument(this.refNumber, this.avanstin, this.currentActiveBill.getPaymentMethod().getCode(), this.body.getBuyerId() != null ? this.body.getBuyerId() : "", this.body.getBuyerCostCenterId() != null ? this.body.getBuyerCostCenterId() : "", this.documentId, this.response.getInvoiceNumber() != null ? this.response.getInvoiceNumber() : null, this.response.getSdcDateTime() != null ? this.response.getSdcDateTime() : "", this.controller);
                                    if ("refundacija".equals(this.avanstin)) {
                                        refExternalNumber = this.refNumber;
                                        Bill.updateDocumentRef(refExternalNumber, this.documentId, this.controller);
                                    }
                                    if (this.inoiceA4 && !this.controller.getSettings().isTrainingMode() && "WireTransfer".equals(this.controller.getCurrentBill().getPaymentMethod().getCode()) && this.predracun == null) {
                                        broj = 1;
                                        if (this.brojKopijaRacuna != null && !this.brojKopijaRacuna.isEmpty()) {
                                            broj = Integer.parseInt(this.brojKopijaRacuna);
                                        }
                                        for (i = 0; i < broj; ++i) {
                                            path = ScreensController.SCREEN_JASPER_BILL;
                                            reportResources = new HashMap<String, Object>();
                                            billPrints = Izvestaji.vatRateDocuemntId(this.controller.getSettings().getConnection(), this.documentId, this.response);
                                            reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                                            reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                                            reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0)));
                                            reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
                                            reportResources.put("qrUrl", this.response.getVerificationUrl());
                                            reportResources.put("controller", this.controller);
                                            reportResources.put("poptpisKupca", "");
                                            person = this.controller.getBillList().get(this.controller.getActiveBill()).getPerson() != null ? Person.getById(this.controller.getBillList().get(this.controller.getActiveBill()).getPerson().getPersonID(), this.controller) : null;
                                            images = Images.getImagesList(this.controller);
                                            napomena1 = Bill.getBillNote(this.documentId, this.controller);
                                            if (!napomena1.isEmpty()) {
                                                napomena1 = "Napomena:" + napomena1 + ". ";
                                            }
                                            if (person != null && !napomena1.isEmpty()) {
                                                napomena1 = napomena1 + person.getNote();
                                            } else if (person != null && napomena1.isEmpty()) {
                                                napomena1 = "Napomena:" + person.getNote();
                                            }
                                            if (!images.isEmpty()) {
                                                reportResources.put("image", ((Images)images.get(0)).getImage());
                                            }
                                            if (person != null) {
                                                reportResources.put("napomena", "Valuta pla\u0107anja: " + person.getCurrencyPaymentDays() + "\n" + napomena1);
                                            } else if (person == null) {
                                                reportResources.put("napomena", napomena1);
                                            }
                                            localDateTime = LocalDateTime.now();
                                            formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                                            formatDateTime = localDateTime.format(formatter);
                                            reportResources.put("dateTime", formatDateTime);
                                            reportResources.put("infoCompany", JasperPrintBill.getInformationCompany(this.controller));
                                            reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany(this.controller));
                                            reportResources.put("typeBill", "====================================================FISKALNI RA\u010cUN===================================================");
                                            reportResources.put("krajRacuna", "==============================================KRAJ FISKALNOG RA\u010cUNA===============================================");
                                            reportResources.put("supplier", JasperPrintBill.getSupplier(this.response, this.body));
                                            reportResources.put("customer", JasperPrintBill.getCusomer(this.documentId, this.controller.getBillList().get(this.controller.getActiveBill()).getPerson(), this.controller));
                                            reportResources.put("nameBill", "PROMET PRODAJA\n" + this.response.getInvoiceNumber());
                                            starter = new JasperStarter(reportResources, path, this.rootPane);
                                            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                                        }
                                    } else if (this.inoiceA4 && this.controller.getSettings().isTrainingMode() && "WireTransfer".equals(this.controller.getCurrentBill().getPaymentMethod().getCode()) && this.predracun == null) {
                                        path = ScreensController.SCREEN_JASPER_BILL_REF;
                                        reportResources = new HashMap<String, Object>();
                                        billPrints = Izvestaji.vatRateDocuemntId(this.controller.getSettings().getConnection(), this.documentId, this.response);
                                        reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                                        reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0)));
                                        reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
                                        reportResources.put("qrUrl", this.response.getVerificationUrl());
                                        reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                                        reportResources.put("poptpisKupca", "");
                                        reportResources.put("controller", this.controller);
                                        images = Images.getImagesList(this.controller);
                                        if (!images.isEmpty()) {
                                            reportResources.put("image", ((Images)images.get(0)).getImage());
                                        }
                                        reportResources.put("napomena", Bill.getBillNote(this.documentId, this.controller));
                                        localDateTime = LocalDateTime.now();
                                        formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                                        formatDateTime = localDateTime.format(formatter);
                                        reportResources.put("dateTime", formatDateTime);
                                        reportResources.put("infoCompany", JasperPrintBill.getInformationCompany(this.controller));
                                        reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany(this.controller));
                                        reportResources.put("typeBill", "=============================================OVO NIJE FISKALNI RA\u010cUN=================================================");
                                        reportResources.put("krajRacuna", "==============================================OVO NIJE FISKALNI RA\u010cUN===============================================");
                                        reportResources.put("krajRacunaRefund", "OVO NIJE FISKALNI RA\u010cUN");
                                        reportResources.put("supplier", JasperPrintBill.getSupplier(this.response, this.body));
                                        reportResources.put("customer", JasperPrintBill.getCusomer(this.documentId, this.controller.getBillList().get(this.controller.getActiveBill()).getPerson(), this.controller));
                                        reportResources.put("nameBill", "OBUKA PRODAJA\n" + this.response.getInvoiceNumber());
                                        starter = new JasperStarter(reportResources, path, this.rootPane);
                                        starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                                    } else if (this.profakturaA4 && !this.controller.getSettings().isTrainingMode() && ("predracun".equals(this.predracun) || "PROF".equals(this.controller.getCurrentBill().getPaymentMethod().getCode()))) {
                                        path = ScreensController.SCREEN_JASPER_BILL;
                                        reportResources = new HashMap<String, Object>();
                                        billPrints = Izvestaji.vatRateDocuemntId(this.controller.getSettings().getConnection(), this.documentId, this.response);
                                        reportResources.put("poptpisKupca", "");
                                        reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                                        reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                                        reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0)));
                                        reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
                                        reportResources.put("qrUrl", this.response.getVerificationUrl());
                                        reportResources.put("controller", this.controller);
                                        images = Images.getImagesList(this.controller);
                                        if (!images.isEmpty()) {
                                            reportResources.put("image", ((Images)images.get(0)).getImage());
                                        }
                                        reportResources.put("napomena", Bill.getBillNote(this.documentId, this.controller));
                                        localDateTime = LocalDateTime.now();
                                        formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                                        formatDateTime = localDateTime.format(formatter);
                                        reportResources.put("dateTime", formatDateTime);
                                        reportResources.put("infoCompany", JasperPrintBill.getInformationCompany(this.controller));
                                        reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany(this.controller));
                                        if ("Predra\u010dun".equals(this.invoiceType.getName())) {
                                            reportResources.put("typeBill", "=============================================OVO NIJE FISKALNI RA\u010cUN=================================================");
                                            reportResources.put("krajRacuna", "==============================================OVO NIJE FISKALNI RA\u010cUN===============================================");
                                        } else {
                                            reportResources.put("typeBill", "====================================================FISKALNI RA\u010cUN===================================================");
                                            reportResources.put("krajRacuna", "=================================================KRAJ FISKALNOG RA\u010cUNA=================================================");
                                        }
                                        reportResources.put("supplier", JasperPrintBill.getSupplier(this.response, this.body));
                                        reportResources.put("customer", JasperPrintBill.getCusomer(this.documentId, this.controller.getBillList().get(this.controller.getActiveBill()).getPerson(), this.controller));
                                        if ("Predra\u010dun".equals(this.invoiceType.getName())) {
                                            reportResources.put("nameBill", "PREDRA\u010cUN PRODAJA\n" + this.response.getInvoiceNumber());
                                        } else {
                                            reportResources.put("nameBill", "PROMET PRODAJA\n" + this.response.getInvoiceNumber());
                                        }
                                        if ("Predra\u010dun".equals(this.invoiceType.getName())) {
                                            for (BillPrint billPrint : ((BillFooter)billPrints.get(0)).getBillPrints()) {
                                                billPrint.setRateValue(BigDecimal.valueOf(0.0));
                                                billPrint.setBasicPrice(BigDecimal.valueOf(0.0));
                                                billPrint.setTotalAmount(BigDecimal.valueOf(0.0));
                                            }
                                        }
                                        starter = new JasperStarter(reportResources, path, this.rootPane);
                                        starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                                        this.predracun = null;
                                    } else if (this.printA4 && !"PROF".equals(this.controller.getCurrentBill().getPaymentMethod().getCode())) {
                                        if (!this.controller.getSettings().isTrainingMode() && !this.selectedAvans) {
                                            path = ScreensController.SCREEN_JASPER_BILL;
                                            reportResources = new HashMap<String, Object>();
                                            billPrints = Izvestaji.vatRateDocuemntId(this.controller.getSettings().getConnection(), this.documentId, this.response);
                                            reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                                            reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                                            reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0)));
                                            reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
                                            reportResources.put("qrUrl", this.response.getVerificationUrl());
                                            reportResources.put("controller", this.controller);
                                            images = Images.getImagesList(this.controller);
                                            if (!images.isEmpty()) {
                                                reportResources.put("image", ((Images)images.get(0)).getImage());
                                            }
                                            reportResources.put("napomena", Bill.getBillNote(this.documentId, this.controller));
                                            localDateTime = LocalDateTime.now();
                                            formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                                            formatDateTime = localDateTime.format(formatter);
                                            reportResources.put("dateTime", formatDateTime);
                                            reportResources.put("infoCompany", JasperPrintBill.getInformationCompany(this.controller));
                                            reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany(this.controller));
                                            reportResources.put("typeBill", "====================================================FISKALNI RA\u010cUN===================================================");
                                            reportResources.put("krajRacuna", "================================================KRAJ FISKALNOG RA\u010cUNA=================================================");
                                            reportResources.put("supplier", JasperPrintBill.getSupplier(this.response, this.body));
                                            reportResources.put("customer", JasperPrintBill.getCusomer(this.documentId, this.controller.getBillList().get(this.controller.getActiveBill()).getPerson(), this.controller));
                                            if ("Predra\u010dun".equals(this.invoiceType.getName())) {
                                                reportResources.put("nameBill", "PREDRA\u010cUN PRODAJA\n" + this.response.getInvoiceNumber());
                                            } else {
                                                reportResources.put("nameBill", "PROMET PRODAJA\n" + this.response.getInvoiceNumber());
                                            }
                                            if ("Predra\u010dun".equals(this.invoiceType.getName())) {
                                                for (BillPrint billPrint : ((BillFooter)billPrints.get(0)).getBillPrints()) {
                                                    billPrint.setRateValue(BigDecimal.valueOf(0.0));
                                                    billPrint.setBasicPrice(BigDecimal.valueOf(0.0));
                                                    billPrint.setTotalAmount(BigDecimal.valueOf(0.0));
                                                }
                                            }
                                            reportResources.put("poptpisKupca", "");
                                            starter = new JasperStarter(reportResources, path, this.rootPane);
                                            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                                        } else if (!this.selectedAvans) {
                                            path = ScreensController.SCREEN_JASPER_BILL_REF;
                                            reportResources = new HashMap<String, Object>();
                                            billPrints = Izvestaji.vatRateDocuemntId(this.controller.getSettings().getConnection(), this.documentId, this.response);
                                            reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                                            reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0)));
                                            reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
                                            reportResources.put("qrUrl", this.response.getVerificationUrl());
                                            reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                                            reportResources.put("poptpisKupca", "");
                                            reportResources.put("controller", this.controller);
                                            images = Images.getImagesList(this.controller);
                                            if (!images.isEmpty()) {
                                                reportResources.put("image", ((Images)images.get(0)).getImage());
                                            }
                                            reportResources.put("napomena", Bill.getBillNote(this.documentId, this.controller));
                                            localDateTime = LocalDateTime.now();
                                            formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                                            formatDateTime = localDateTime.format(formatter);
                                            reportResources.put("dateTime", formatDateTime);
                                            reportResources.put("infoCompany", JasperPrintBill.getInformationCompany(this.controller));
                                            reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany(this.controller));
                                            reportResources.put("typeBill", "=============================================OVO NIJE FISKALNI RA\u010cUN=================================================");
                                            reportResources.put("krajRacuna", "==============================================OVO NIJE FISKALNI RA\u010cUN===============================================");
                                            reportResources.put("krajRacunaRefund", "OVO NIJE FISKALNI RA\u010cUN");
                                            reportResources.put("supplier", JasperPrintBill.getSupplier(this.response, this.body));
                                            reportResources.put("customer", JasperPrintBill.getCusomer(this.documentId, this.controller.getBillList().get(this.controller.getActiveBill()).getPerson(), this.controller));
                                            reportResources.put("nameBill", "OBUKA PRODAJA\n" + this.response.getInvoiceNumber());
                                            starter = new JasperStarter(reportResources, path, this.rootPane);
                                            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                                        }
                                    }
                                }
                            }
                            if (this.KWSActive) {
                                doc = this.insertPrijemnice();
                                PaymentTrgovinaController.LOGGER.info("\nInsertovana prijemnica " + doc);
                                this.insertDetaljaPrijemnice(doc.getDocumentID());
                                PaymentTrgovinaController.LOGGER.info("\nInsert detalja prijemnice" + doc);
                            }
                            try {
                                l = Loyality.getByPerson(this.currentActiveBill.getPerson(), this.controller);
                                doc1 = Document.getByID(this.documentId, this.controller.getSettings().getConnection());
                                currentNumberEntry = l.getCurrentNumberEntry();
                                usedPoints = this.currentActiveBill.getPerson().getLoyality().getPoints();
                                sumWithDiscount = doc1.getSumWithDiscount();
                                newPoints = (int)(sumWithDiscount / l.getBuyingPointsValue());
                                points = l.getPoints();
                                result = 0.0;
                                result = usedPoints > 0.0 ? points - usedPoints + (double)newPoints : points + (double)newPoints;
                                l.setPoints(result);
                                l.setLoyalityID(l.getLoyalityID());
                                l.updatePoints(this.controller.getSettings().getConnection());
                                if (this.controller.getLoyalitySettings().getActualByName(this.controller, "bill.number.discount.active").equals("true")) {
                                    if (l.getNumberEntry() > currentNumberEntry) {
                                        l.setCurrentNumberEntry(currentNumberEntry + 1);
                                    } else {
                                        l.setCurrentNumberEntry(1);
                                    }
                                    l.updateCurencyEntry(this.controller.getSettings().getConnection());
                                }
                                if (!this.controller.getLoyalitySettings().getActualByName(this.controller, "loyalty.limit").equals("true")) break block201;
                                loyaltyLimit = LoyaltyLimit.getLoyaltyLimitByLoyaltyID(l.getLoyalityID(), this.controller);
                                try {
                                    if (loyaltyLimit.isActive()) {
                                        loyaltyLimit.setCurrentValue(doc1.getSumWithDiscount() + loyaltyLimit.getCurrentValue());
                                        loyaltyLimit.updateCurrentValue(this.controller);
                                    }
                                }
                                catch (NullPointerException var22_101) {}
                            }
                            catch (NullPointerException l) {
                                // empty catch block
                            }
                        }
                        PaymentTrgovinaController.LOGGER.info("DOCUMENT PAYMENT documentid " + this.documentId + ", controller.getCurrentBill().getPaymentMethod() " + this.controller.getCurrentBill().getPaymentMethod().getPaymentMethodID() + ", controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID()" + this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID());
                        if (this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() < 1) {
                            switch (this.controller.getCurrentBill().getPaymentMethod().getPaymentMethodID()) {
                                case -1: 
                                case 1: {
                                    DocumentPayment.insert(this.documentId, 1, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 2: {
                                    DocumentPayment.insert(this.documentId, 2, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 3: {
                                    DocumentPayment.insert(this.documentId, 3, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 4: {
                                    DocumentPayment.insert(this.documentId, 4, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 5: {
                                    if (this.gotovina > 0.0) {
                                        DocumentPayment.insert(this.documentId, 1, this.gotovina, this.controller.getSettings().getConnection());
                                    }
                                    if (this.kartica > 0.0) {
                                        DocumentPayment.insert(this.documentId, 2, this.kartica, this.controller.getSettings().getConnection());
                                    }
                                    if (this.cek > 0.0) {
                                        DocumentPayment.insert(this.documentId, 3, this.cek, this.controller.getSettings().getConnection());
                                    }
                                    if (this.prenos > 0.0) {
                                        DocumentPayment.insert(this.documentId, 4, this.prenos, this.controller.getSettings().getConnection());
                                    }
                                    if (this.vaucer > 0.0) {
                                        DocumentPayment.insert(this.documentId, 7, this.vaucer, this.controller.getSettings().getConnection());
                                    }
                                    if (this.instant > 0.0) {
                                        DocumentPayment.insert(this.documentId, 8, this.instant, this.controller.getSettings().getConnection());
                                    }
                                    if (!(this.ostalo > 0.0)) break;
                                    DocumentPayment.insert(this.documentId, 9, this.ostalo, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 7: {
                                    DocumentPayment.insert(this.documentId, 7, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 8: {
                                    DocumentPayment.insert(this.documentId, 8, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 9: {
                                    DocumentPayment.insert(this.documentId, 9, this.ukupno, this.controller.getSettings().getConnection());
                                    break;
                                }
                                case 12: {
                                    DocumentPayment.insert(this.documentId, 12, this.ukupno, this.controller.getSettings().getConnection());
                                }
                            }
                        }
                        if (this.controller.getCurrentBill().getPaymentMethod().getParentPaymentMethodID() == 0 && !this.cPaymentButton7.isSelected() && !this.cPaymentButton6.isSelected()) {
                            this.g = 0.0;
                            this.runTask();
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        System.out.println("Nenad");
                                        switch (PaymentTrgovinaController.this.fpd) {
                                            case FLink: {
                                                HashMap<String, Double> paymentMethods = new HashMap<String, Double>();
                                                if (PaymentTrgovinaController.this.controller.getCurrentBill().getPaymentMethod().getCode().equals("COMBINED")) {
                                                    paymentMethods.put("CASH", PaymentTrgovinaController.this.gotovina);
                                                } else {
                                                    paymentMethods.put("CASH", PaymentTrgovinaController.this.g);
                                                }
                                                paymentMethods.put("CARD", PaymentTrgovinaController.this.kartica);
                                                paymentMethods.put("CHECK", PaymentTrgovinaController.this.cek);
                                                paymentMethods.put("WireTransfer", PaymentTrgovinaController.this.virman);
                                                FiscalPrintFLink fLink = new FiscalPrintFLink(PaymentTrgovinaController.this.controller, paymentMethods);
                                                fLink.printBill();
                                                break;
                                            }
                                            case Lpfr: {
                                                if (PaymentTrgovinaController.this.efaktura.booleanValue()) break;
                                                Document document = Document.getByID(PaymentTrgovinaController.this.documentId, PaymentTrgovinaController.this.controller.getSettings().getConnection());
                                                System.out.println("Vrednost invocieA4" + PaymentTrgovinaController.this.inoiceA4 + " i " + "racun".equals(PaymentTrgovinaController.this.predracun));
                                                if (PaymentTrgovinaController.this.inoiceA4 && PaymentTrgovinaController.this.controller.getCurrentBill() != null && PaymentTrgovinaController.this.controller.getCurrentBill().getPaymentMethod() != null && "WireTransfer".equals(PaymentTrgovinaController.this.controller.getCurrentBill().getPaymentMethod().getCode()) && PaymentTrgovinaController.this.predracun == null) {
                                                    System.out.println("Posle a4 da ne stampa fiskal");
                                                    break;
                                                }
                                                if (PaymentTrgovinaController.this.profakturaA4 && PaymentTrgovinaController.this.controller.getCurrentBill().getPaymentMethod() != null && "PROF".equals(PaymentTrgovinaController.this.controller.getCurrentBill().getPaymentMethod().getCode())) {
                                                    System.out.println("Posle a4 da ne stampa fiskal");
                                                    break;
                                                }
                                                if (PaymentTrgovinaController.this.printA4) break;
                                                PaymentTrgovinaController.this.predracun = null;
                                                ESCPosPrint pPrint = new ESCPosPrint(PaymentTrgovinaController.this.body, PaymentTrgovinaController.this.response, document, PaymentTrgovinaController.this.controller, payments);
                                                pPrint.setAvansTin(PaymentTrgovinaController.this.avanstin);
                                                pPrint.setRefNumber(PaymentTrgovinaController.this.refNumber);
                                                pPrint.printFiscalBill(PaymentTrgovinaController.this.invoiceType, PaymentTrgovinaController.this.currentActiveBill);
                                                System.out.println("Avanstin je " + PaymentTrgovinaController.this.avanstin);
                                                PaymentTrgovinaController.this.avanstin = null;
                                                PaymentTrgovinaController.this.ukupno = 0.0;
                                                PaymentTrgovinaController.this.prenos = 0.0;
                                                PaymentTrgovinaController.this.ukupanIznosAvansa = null;
                                                PaymentTrgovinaController.this.refNumber = null;
                                                PaymentTrgovinaController.this.selectedPaymentMethod = -1;
                                                PaymentTrgovinaController.this.avans.setSelected(false);
                                                System.out.println("Avanstin je " + PaymentTrgovinaController.this.avanstin);
                                            }
                                        }
                                        Document d = Document.getByID(PaymentTrgovinaController.this.documentId, PaymentTrgovinaController.this.controller.getSettings().getConnection());
                                        if (PaymentTrgovinaController.this.BI.equals("") && Boolean.parseBoolean(PaymentTrgovinaController.this.controller.getSettings().getActualByName("excel.microcer"))) {
                                            PaymentTrgovinaController.this.BI = String.valueOf(Document.getMaxFullNumber(PaymentTrgovinaController.this.controller, d) + 1);
                                        }
                                        d.setFullNumber(PaymentTrgovinaController.this.BI);
                                        if (!PaymentTrgovinaController.this.payCardSlipNumber.equals("")) {
                                            d.setPayCardSlipNumber(PaymentTrgovinaController.this.payCardSlipNumber);
                                            DocumentPayCard documentPayCard = new DocumentPayCard();
                                            documentPayCard.setDocument(d);
                                            documentPayCard.setPayCard(PaymentTrgovinaController.this.payCard);
                                            documentPayCard.setValue(d.getSumWithDiscount() * PaymentTrgovinaController.this.payCard.getPercent() / 100.0);
                                            documentPayCard.insert(PaymentTrgovinaController.this.controller);
                                            PaymentTrgovinaController.this.payCard = null;
                                        }
                                        d.setAlternativeFullNumber(FiscalPrinter.getIBFM(PaymentTrgovinaController.this.controller.getSettings().getFiscalFolder()));
                                        d.update(PaymentTrgovinaController.this.controller);
                                        if (Boolean.parseBoolean(PaymentTrgovinaController.this.controller.getSettings().getActualByName("protel.active")) && !PaymentTrgovinaController.this.controller.getSettings().getActualByName("protel.connection.path").equals("")) {
                                            Protel protel = new Protel();
                                            protel.setIpAddress(PaymentTrgovinaController.this.controller.getSettings().getActualByName("protel.connection.path"));
                                            protel.sendPOSTCloseInvoiceFromTMaster(d, PaymentTrgovinaController.this.controller);
                                        }
                                        if (Boolean.parseBoolean(PaymentTrgovinaController.this.controller.getSettings().getActualByName("excel.microcer"))) {
                                            XmlBill.writeSalePOStoERP(d, PaymentTrgovinaController.this.controller);
                                        }
                                        if (PaymentTrgovinaController.this.controller.getSettings().isSrednjaNabavnaCena()) {
                                            for (RoundItem roundItem : PaymentTrgovinaController.this.averageListItems) {
                                                roundItem.getProductDepartment().setAverageValue(Settings.test(roundItem.getProductDepartment().getProduct(), Department.getByPOS(PaymentTrgovinaController.this.controller.getPointOfSale(), PaymentTrgovinaController.this.controller.getSettings().getConnection()), LocalDate.now(), PaymentTrgovinaController.this.controller));
                                                roundItem.getProductDepartment().updateAverageValue(PaymentTrgovinaController.this.controller);
                                            }
                                        }
                                    }
                                    catch (SQLException e) {
                                        LOGGER.severe(e.getMessage());
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                PaymentTrgovinaController.this.controller.alert("Gre\u0161ka prilikom snimanja ra\u010duna!", "Do\u0161lo je do gre\u0161ke prilikom snimanja ra\u010duna. \nPoruka gre\u0161ke: \n" + e.getMessage(), PaymentTrgovinaController.this.rootPane.getScene().getWindow());
                                            }
                                        });
                                        Log.writeLog(PaymentTrgovinaController.this.controller.getUser(), "PointOfSale: " + PaymentTrgovinaController.this.controller.getPointOfSale().getName() + " " + e.getLocalizedMessage(), PaymentTrgovinaController.this.controller.getSettings().getConnection());
                                        e.printStackTrace();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (PaymentTrgovinaController.this.currentActiveBill.getPerson() != null && PaymentTrgovinaController.this.currentActiveBill.getPerson().getLoyality() != null) {
                                        for (int i = 0; i < PaymentTrgovinaController.this.currentActiveBill.getPerson().getDetailsPrintNumber(); ++i) {
                                            FiscalPrinter.printNonFiscalOrder(PaymentTrgovinaController.this.controller, PaymentTrgovinaController.this.currentActiveBill);
                                        }
                                    }
                                }
                            }.start();
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.controller.getCurrentBill().getGiftCard() != null) {
                            res = this.controller.getCurrentBill().getGiftCard().getAmount().compareTo(new BigDecimal(this.controller.getBillList().get(this.controller.getActiveBill()).getSumWithDiscout()));
                            if (res == 0) {
                                this.controller.getCurrentBill().getGiftCard().setAmount(new BigDecimal(0));
                                this.controller.getCurrentBill().getGiftCard().updateAmount(this.controller);
                            } else if (res == 1) {
                                this.controller.getCurrentBill().getGiftCard().setAmount(this.controller.getCurrentBill().getGiftCard().getAmount().subtract(new BigDecimal(this.controller.getBillList().get(this.controller.getActiveBill()).getSumWithDiscout())));
                                this.controller.getCurrentBill().getGiftCard().updateAmount(this.controller);
                            } else if (res == -1) {
                                this.controller.getCurrentBill().getGiftCard().setAmount(new BigDecimal(0));
                                this.controller.getCurrentBill().getGiftCard().updateAmount(this.controller);
                            }
                            this.controller.getCurrentBill().setGiftCard(null);
                        }
                        this.stampaGotovinskog.setSelected(false);
                        this.predracun = null;
                        if (this.controller.getSettings().isSrednjaNabavnaCena()) {
                            this.averageListItems = this.controller.getBillList().get(this.controller.getActiveBill()).getLastRound().getItemList();
                        }
                        this.avanstin = null;
                        this.ukupno = 0.0;
                        this.ukupanIznosAvansa = null;
                        this.avans.setSelected(false);
                        this.selectedAvans = false;
                        this.efaktura = false;
                        System.out.println("Stigao sam ObservableList<Present>");
                        presentList = Present.getPresentList(this.controller);
                        if (presentList != null) {
                            for (Present present : presentList) {
                                if (present.isActivePresent() && present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout() && this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo()) {
                                    FiscalPrinter.printNonFiscalPresent(this.controller, present);
                                }
                                if (!present.isActiveDiscount()) continue;
                            }
                        }
                        if (this.controller.getReservationDocument() != null) {
                            realized = true;
                            for (DocumentDetails ddDetails : DocumentDetails.getObeservableList(this.controller.getReservationDocument().getDocumentID(), this.controller.getSettings().getConnection())) {
                                for (RoundItem roundItem : this.controller.getBillList().get(this.controller.getActiveBill()).getLastRound().getItemList()) {
                                    if (ddDetails.isClosed() || roundItem.getProductDepartment().getProduct().getProductID() != ddDetails.getProductID()) continue;
                                    if (roundItem.getQuantity() >= ddDetails.getQuantity()) {
                                        ddDetails.setClosed(true);
                                        ddDetails.setQuantity(roundItem.getQuantity());
                                        ddDetails.update(this.controller);
                                        continue;
                                    }
                                    broj = ddDetails.getQuantity();
                                    ddDetails.setClosed(true);
                                    ddDetails.setQuantity(roundItem.getQuantity());
                                    ddDetails.update(this.controller);
                                    ddDetails.setQuantity(broj - roundItem.getQuantity());
                                    ddDetails.setClosed(false);
                                    ddDetails.insert(this.controller.getSettings().getConnection());
                                }
                                if (ddDetails.isClosed() || !realized) continue;
                                realized = false;
                            }
                            if (realized) {
                                this.controller.getReservationDocument().setRealized(realized);
                                this.controller.getReservationDocument().update(this.controller);
                                this.controller.setReservationDocument(null);
                            }
                        }
                        System.out.println("Obavestenje fronta, brisanje racuna");
                        this.controller.getBillList().remove(this.controller.getActiveBill());
                        this.controller.setStockRefresh(true);
                        this.controller.setBillPrinted(true);
                        break block202;
                    }
                    isTrainingMode = this.controller.getSettings().isTrainingMode();
                    method = this.currentActiveBill.getPaymentMethod();
                    amount = this.currentActiveBill.getFinalSumWithDiscout();
                    payments = new HashMap<String, Double>();
                    payments.put("WireTransfer", amount);
                    proformaType = InvoiceType.SALE_PROFORMA;
                    if (isTrainingMode) {
                        proformaType = InvoiceType.SALE_TRAINING;
                    }
                    if (this.fpd == FiscalPrinterDriver.Lpfr && !this.efaktura.booleanValue()) {
                        this.request = new InvoiceRequest(this.currentActiveBill, payments, this.controller);
                        this.response = this.request.getInvoiceResponse(proformaType);
                        this.body = this.request == null ? new InvoiceBody() : this.request.getBody();
                        modelStates = this.response.getModelState();
                        if (modelStates != null) {
                            handler = new BadRequestHandler(this.controller, modelStates, this.rootPane.getScene().getWindow());
                            handler.handleBadRequest();
                            return;
                        }
                    }
                    documentId = Bill.writeBill(this.avanstin, this.controller.getBillList().get(this.controller.getActiveBill()), this.controller.getPointOfSale(), this.cPaymentButton7.isSelected(), "", this.stampaGotovinskog.isSelected(), this.controller, this.response, this.body);
                    if (this.fpd == FiscalPrinterDriver.Lpfr && !this.efaktura.booleanValue()) {
                        document = Document.getByID(documentId, this.controller.getSettings().getConnection());
                        if (this.printA4) {
                            path = ScreensController.SCREEN_JASPER_FISCAL_BILL;
                            reportResources = ReportMapModel.getReportMap(this.controller);
                            reportResources.put("datas", A4PrintUtils.getItemsList(this.body));
                            reportResources.put("rates", A4PrintUtils.getRatesList(this.response));
                            reportResources.put("pfrDate", NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime()));
                            reportResources.put("person", this.currentActiveBill.getPerson());
                            reportResources.put("payments", A4PrintUtils.getPaymentsList(this.body));
                            reportResources.put("controller", this.controller);
                            reportResources.put("header", A4PrintUtils.a4PrintHeader(this.response));
                            reportResources.put("adtionalHeader", A4PrintUtils.a4PrintHeaderAditional(this.response, this.body, this.invoiceType));
                            reportResources.put("invoiceType", (Object)this.invoiceType);
                            reportResources.put("response", this.response);
                            reportResources.put("body", this.body);
                            starter = new JasperStarter(reportResources, path, this.rootPane);
                            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
                        } else {
                            pPrint = new ESCPosPrint(this.body, this.response, document, this.controller, payments);
                            pPrint.setAvansTin(this.avanstin);
                            pPrint.printFiscalBill(proformaType, this.currentActiveBill);
                        }
                    }
                    System.out.println("Efktura kraj " + this.efaktura);
                    this.efaktura = false;
                    presentList = Present.getPresentList(this.controller);
                    if (presentList != null) {
                        for (Present present : presentList) {
                            if (present.isActivePresent() && present.getBillSumFrom() <= this.controller.getCurrentBill().getSumWithDiscout() && this.controller.getCurrentBill().getSumWithDiscout() <= present.getBillSumTo()) {
                                FiscalPrinter.printNonFiscalPresent(this.controller, present);
                            }
                            if (!present.isActiveDiscount()) continue;
                        }
                    }
                    this.controller.getBillList().remove(this.controller.getActiveBill());
                    this.controller.setStockRefresh(true);
                    if (this.controller.getReservationDocument() != null) {
                        this.controller.getReservationDocument().setRealized(true);
                        this.controller.getReservationDocument().update(this.controller);
                        this.controller.setReservationDocument(null);
                    }
                }
                catch (SQLException e) {
                    PaymentTrgovinaController.LOGGER.severe(e.getMessage());
                    this.controller.alert("Gre\u0161ka prilikom snimanja ra\u010duna!", "Do\u0161lo je do gre\u0161ke prilikom snimanja ra\u010duna. \nPoruka gre\u0161ke: \n" + e.getMessage(), this.rootPane.getScene().getWindow());
                    Log.writeLog(this.controller.getUser(), "PointOfSale: " + this.controller.getPointOfSale().getName() + " " + e.getLocalizedMessage(), this.controller.getSettings().getConnection());
                }
            }
        }
        this.postButton.setDisable(false);
        if (this.controller.getVrstaPrograma() == 6) {
            this.controller.getScreen(ScreensController.SCREEN_PEKARA, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT_TRGOVINA);
        } else {
            this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_PAYMENT_TRGOVINA);
        }
    }

    private List<BillPrint> getBillTax(Map<String, BillPrint> billPrintMap) {
        ArrayList<BillPrint> billPrints = new ArrayList<BillPrint>();
        for (Map.Entry<String, BillPrint> hm : billPrintMap.entrySet()) {
            billPrints.add(hm.getValue());
        }
        return billPrints;
    }

    private String getBillFooter(BillFooter billFooter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" " + billFooter.getSum());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getSumTax());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getPayment());
        stringBuilder.append("\n");
        stringBuilder.append(" " + NPrintUtil.textDatefromISO8601(this.response.getSdcDateTime()));
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentNumber());
        stringBuilder.append("\n");
        stringBuilder.append(" " + this.response.getInvoiceCounter());
        return stringBuilder.toString();
    }

    private String getBillFooterNameFild() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Za uplatu: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Porez ukupno: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Na\u010dina placanja: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Prf vreme: ");
        stringBuilder.append("\n");
        stringBuilder.append(" PFR broj ra\u010duna: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Broja\u010d ra\u010duna: ");
        return stringBuilder.toString();
    }

    private Prijemnica insertPrijemnice() {
        Prijemnica document = new Prijemnica();
        try {
            Bill bill = this.controller.getBillList().get(this.controller.getActiveBill());
            document.setDeliveryDate(new Date());
            document.setPaymentDate(new Date());
            document.setNumber(Document.getNextNumberForType(3, this.controller));
            document.setDepartmentID(1);
            document.setComment(bill.getNapomena());
            document.setDobavljac(bill.getPerson() == null ? new Person() : bill.getPerson());
            document.setExternalNumber(this.receiptDocumentFromSAP);
            document.setDependentExpenses(0.0);
            document.setSum(bill.getFinalSumWithDiscout());
            document.setSumWithDiscount(bill.getSumWithDiscout());
            document.setDiscount(this.discount);
            document.setRealized(false);
            Person pers = new Person();
            pers.setPersonID(1L);
            document.setDobavljac(pers);
            document.insert(this.controller, new Date());
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return document;
    }

    private void insertDetaljaPrijemnice(long documentId) {
        Bill bill = this.controller.getBillList().get(this.controller.getActiveBill());
        ArrayList<PrijemnicaDetailes> detaljiPrijemnice = new ArrayList<PrijemnicaDetailes>();
        for (Product p : this.productsForSAP) {
            try {
                LOGGER.info("\nDetlji prijemnice: ");
                PrijemnicaDetailes pd = new PrijemnicaDetailes();
                pd.setDocumentID(documentId);
                pd.setProduct(Product.getByID(p.getProductID(), this.controller));
                pd.setProductID(p.getProductID());
                pd.setProductCode(pd.getProduct().getCode());
                pd.setProductName(pd.getProduct().getName());
                pd.setSellPrice(p.getPrice());
                pd.setNewSellPrice(p.getPrice());
                LOGGER.info("\nDetlji prijemnice: " + pd);
                try {
                    Vat vat = this.getVatForPrijemnica(1);
                    if (vat.getCode().equals("GRUPA_DJ")) {
                        pd.setVat(p.getVatValue() == 0.0 ? 1.0 : p.getVatValue());
                        LOGGER.info("\nDetlji prijemnice: " + pd);
                    } else {
                        pd.getProduct().setVatID(vat.getVatID());
                        pd.setVat(vat.getValue());
                        LOGGER.info("\nDetlji prijemnice: " + pd);
                    }
                }
                catch (Exception e) {
                    LOGGER.info("greska kod poreza");
                    pd.setVat(p.getVatValue());
                }
                LOGGER.info("\nDetlji prijemnice: " + pd + "sledi jedinica mere");
                try {
                    pd.setJedinicaMere(Unit.getUnitById(p.getUnitID(), this.controller.getSettings().getConnection()).getCode());
                }
                catch (Exception e) {
                    pd.setJedinicaMere("KG");
                    LOGGER.info("greska kg");
                }
                LOGGER.info("\nDetlji prijemnice: " + pd);
                if (p.getPurchacePrice() != 0.0) {
                    pd.setPurchasePriceWithoutRabat(p.getPurchacePrice());
                    pd.setPurchasePrice(p.getPurchacePrice());
                    pd.setPrice(p.getPurchacePrice() * pd.getVat());
                    pd.setPriceWithDiscount(pd.getPrice() - pd.getPrice() * pd.getDiscount() / 100.0);
                }
                LOGGER.info("\nDetlji prijemnice: " + pd);
                pd.setMargin(pd.getPriceWithDiscount() > 0.0 ? (pd.getNewSellPrice() - pd.getPriceWithDiscount()) / pd.getPriceWithDiscount() * 100.0 : (pd.getNewSellPrice() - p.getNabavnaCena()) / p.getNabavnaCena() * 100.0);
                pd.setProductName(p.getName());
                pd.setQuantity(1.0);
                detaljiPrijemnice.add(pd);
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                LOGGER.info("\nGreska pri kreiranju detalja prijemnnice za product " + e.getMessage());
            }
        }
        for (PrijemnicaDetailes pd : detaljiPrijemnice) {
            LOGGER.info("Insert detalja prijemnice" + pd.toString());
            try {
                pd.insert(this.controller);
            }
            catch (Exception e) {
                LOGGER.info("Poku\u0161aj inserta detalja prijemnice" + e.getMessage());
            }
        }
    }

    private Vat getVatForPrijemnica(int pvtId) {
        Connection connection = this.controller.getSettings().getConnection();
        PersonVatType pvt = PersonVatType.getById(connection, pvtId);
        String codeString = "GRUPA_DJ";
        switch (pvt.getName()) {
            case "Poljoprivredno gazdinstvo": {
                codeString = "GRUPA_P";
                break;
            }
            case "PDV obveznik": {
                codeString = "GRUPA_DJ";
                break;
            }
            case "Nije PDV obveznik": {
                codeString = "GRUPA_A";
                break;
            }
        }
        return Vat.getByCode(codeString, connection);
    }

    @FXML
    private void gotovinskiClick() {
    }

    private void fillPaymentMethodButtons() {
        ArrayList<PaymentMethod> list = PaymentMethod.getList(this.controller.getSettings().getConnection());
        for (int i = 0; i < list.size(); ++i) {
            try {
                ToggleButton btn = this.fillPaymentButton(i, list.get(i).getName(), list.get(i).isIsDefault());
                if (btn.isSelected()) {
                    this.currentActiveBill.setPaymentMethod(list.get(i));
                }
                if (list.get(i).getCode().equals("WireTransfer") || list.get(i).getCode().equals("PROF")) {
                    btn.setToggleGroup(this.paymentMethodToggleGroup);
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            this.stampaGotovinskog.setToggleGroup(this.paymentMethodToggleGroup);
        }
    }

    private void fillPayCardButtons() {
        ObservableList<PayCard> list = PayCard.getListActive(this.controller);
        for (int i = 0; i < list.size(); ++i) {
            try {
                ToggleButton btn = this.fillPayCardButton(i, ((PayCard)list.get(i)).getName());
                btn.setToggleGroup(this.payCardToggleGroup);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    private ToggleButton fillPaymentButton(int index, String name, boolean isDefault) {
        ToggleButton btnForList = new ToggleButton();
        switch (index) {
            case 0: {
                btnForList = this.paymentButton9;
                this.paymentButton9.setText(name);
                this.paymentButton9.setSelected(isDefault);
                break;
            }
            case 1: {
                btnForList = this.paymentButton0;
                this.paymentButton0.setText(name);
                this.paymentButton0.setSelected(isDefault);
                break;
            }
            case 2: {
                btnForList = this.paymentButton1;
                this.paymentButton1.setText(name);
                this.paymentButton1.setSelected(isDefault);
                break;
            }
            case 3: {
                btnForList = this.paymentButton2;
                this.paymentButton2.setText(name);
                this.paymentButton2.setSelected(isDefault);
                break;
            }
            case 4: {
                btnForList = this.paymentButton3;
                this.paymentButton3.setText(name);
                this.paymentButton3.setSelected(isDefault);
                break;
            }
            case 5: {
                btnForList = this.paymentButton4;
                this.paymentButton4.setText(name);
                this.paymentButton4.setSelected(isDefault);
                break;
            }
            case 6: {
                btnForList = this.paymentButton5;
                this.paymentButton5.setText(name);
                this.paymentButton5.setSelected(isDefault);
                break;
            }
            case 7: {
                btnForList = this.paymentButton6;
                this.paymentButton6.setText(name);
                this.paymentButton6.setSelected(isDefault);
                break;
            }
            case 8: {
                btnForList = this.paymentButton7;
                this.paymentButton7.setText(name);
                this.paymentButton7.setSelected(isDefault);
                break;
            }
            case 9: {
                btnForList = this.paymentButton8;
                this.paymentButton8.setText(name);
                this.paymentButton8.setSelected(isDefault);
            }
        }
        return btnForList;
    }

    private ToggleButton fillPayCardButton(int index, String name) {
        ToggleButton btnForPayCard = new ToggleButton();
        switch (index) {
            case 0: {
                btnForPayCard = this.cPaymentButton0;
                this.cPaymentButton0.setText(name);
                this.cPaymentButton0.setSelected(false);
                break;
            }
            case 1: {
                btnForPayCard = this.cPaymentButton1;
                this.cPaymentButton1.setText(name);
                break;
            }
            case 2: {
                btnForPayCard = this.cPaymentButton2;
                this.cPaymentButton2.setText(name);
                break;
            }
            case 3: {
                btnForPayCard = this.cPaymentButton3;
                this.cPaymentButton3.setText(name);
                break;
            }
            case 4: {
                btnForPayCard = this.refaction;
                this.refaction.setText(name);
                break;
            }
            case 5: {
                btnForPayCard = this.cPaymentButton5;
                this.cPaymentButton5.setText(name);
                break;
            }
            case 6: {
                btnForPayCard = this.cPaymentButton6;
                this.cPaymentButton6.setText(name);
                break;
            }
            case 7: {
                btnForPayCard = this.cPaymentButton7;
                this.cPaymentButton7.setText(name);
            }
        }
        return btnForPayCard;
    }

    public void runTask() {
        double wndwWidth = 300.0;
        this.prenos = 0.0;
        Label updateLabel = new Label("Stampa ra\u010duna u toku...");
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((Object[])new Node[]{updateLabel, progress});
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(this.rootPane.getScene().getWindow());
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }

    public void runTask1() {
        double wndwWidth = 300.0;
        this.prenos = 0.0;
        Label updateLabel = new Label("Krenite sa kucanjem...");
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((Object[])new Node[]{updateLabel, progress});
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(this.rootPane.getScene().getWindow());
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }

    private String addNoteToDocument(ScreensController controller, HashMap<String, Object> hm, boolean profaktura) {
        boolean addNote = (Boolean)hm.get("addNote");
        if (addNote) {
            hm.put("profaktura", profaktura);
            controller.showModalDialog("Dodavanje napomene", ScreensController.DIALOG_ADD_NOTE, hm, this.rootPane.getScene().getWindow());
            return (String)hm.get("noteText");
        }
        return "";
    }

    @FXML
    private void openCashBox() {
        Printer printer = (Printer)Printer.getAllActivePrinter(this.controller.getSettings().getConnection()).get(0);
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)printer.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            escPos.pulsePin(EscPos.PinConnector.Pin_2, 100, 100);
            escPos.cut(EscPos.CutMode.FULL);
            escPos.close();
        }
        catch (Exception e) {
            LOGGER.info("Greska kod otvaranja fioke");
        }
    }

    private Map<String, Double> getPayments() {
        HashMap<String, Double> payments = new HashMap<String, Double>();
        if (this.g > 0.0) {
            payments.put("Cash", this.g);
        }
        if (this.kartica > 0.0) {
            payments.put("Card", this.kartica);
        }
        if (this.cek > 0.0) {
            payments.put("Check", this.cek);
        }
        if (this.faktura > 0.0) {
            payments.put("WireTransfer", this.faktura);
        }
        if (this.vaucer > 0.0) {
            payments.put("Voucher", this.vaucer);
        }
        if (this.instant > 0.0) {
            payments.put("MobileMoney", this.instant);
        }
        if (this.ostalo > 0.0) {
            payments.put("Other", this.ostalo);
        }
        if (this.prenos > 0.0) {
            payments.put("WireTransfer", this.prenos);
        }
        return payments;
    }

    private String saleInSAP(List<Product> products) {
        StringHolder MESSAGE = new StringHolder();
        StringHolder RECEIPT_DOCUMENT = new StringHolder();
        try {
            ZRETAIL_SALE_ITEMS_LINE[] saleItemsLines = this.saleClient.getSaleResponseFromSAP(products, MESSAGE, RECEIPT_DOCUMENT);
            if (saleItemsLines == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(MESSAGE.value + "\n");
                stringBuilder.append("Artikal koji je napravio problem je: \n");
                stringBuilder.append(RECEIPT_DOCUMENT.value);
                this.controller.alert("Obavestenje", stringBuilder.toString(), this.rootPane.getScene().getWindow());
                LOGGER.info(stringBuilder.toString() + "saleItemsLines" + saleItemsLines);
            }
        }
        catch (Exception e) {
            LOGGER.info("Gre\u0161ka u metodi saleInSAP" + e.getMessage());
            throw e;
        }
        return RECEIPT_DOCUMENT.value;
    }

    @FXML
    public void prenosClicked(MouseEvent mouseEvent) {
        if (this.gotovina != 0.0 || this.cek != 0.0 || this.vaucer != 0.0 || this.instant != 0.0 || this.ostalo != 0.0) {
            if (this.ostatak != 0.0) {
                this.prenos = this.ostatak;
            }
            this.ostatak = 0.0;
            this.labelOstatakValue.setText(this.numberFormat.format(this.ostatak));
            this.labelPrenosValue.setText(this.numberFormat.format(this.prenos));
            this.selectedPaymentMethod = 6;
            this.stringValue = this.numberFormat.format(this.prenos);
            this.unselectCombined();
            this.labelPrenosValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelPrenosValue.getStyleClass().remove((Object)"backGroundTransparent");
        } else {
            this.selectedPaymentMethod = 6;
            this.unselectCombined();
            this.labelPrenosValue.getStyleClass().add((Object)"backGroundGreen");
            this.labelPrenosValue.getStyleClass().remove((Object)"backGroundTransparent");
        }
    }

    @FXML
    public void toggleButtonaAvans(ActionEvent actionEvent) {
        this.stampaGotovinskog.setSelected(false);
        this.refaction.setSelected(false);
        this.proforma.setSelected(false);
        this.selectedAvans = this.avans.isSelected();
    }
}

