/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.trgovina;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Nivelacija;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.product.Product;

public class NivelacijaDetailes {
    private long DocumentDetailsID;
    private long DocumentID;
    private long ProductID;
    private String ProductCode;
    private String ProductName;
    private double Quantity;
    private double Price;
    private double Discount;
    private double PriceWithDiscount;

    public long getDocumentDetailsID() {
        return this.DocumentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.DocumentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public static ObservableList<NivelacijaDetailes> getlist(Nivelacija nivelacija, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select \td.DocumentDetailsID,\td.DocumentID,\td.ProductID,\tp.Code,\tp.Name,\td.Quantity,    d.Price,    d.Discount,    d.PriceWithDiscount  from documentdetails d  left join product p on p.ProductID = d.ProductID where DocumentID = ? order by p.Code";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, nivelacija.getDocumentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NivelacijaDetailes pd = new NivelacijaDetailes();
                pd.DocumentDetailsID = rs.getLong("DocumentDetailsID");
                pd.DocumentID = rs.getLong("DocumentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.ProductCode = rs.getString("Code");
                pd.ProductName = rs.getString("Name");
                pd.Quantity = rs.getDouble("Quantity");
                pd.Price = rs.getDouble("Price");
                pd.Discount = rs.getDouble("Discount");
                pd.PriceWithDiscount = rs.getDouble("PriceWithDiscount");
                list.add((Object)pd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.DocumentDetailsID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.update(controller);
    }

    public void updateWithDiscount(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setDiscount(this.Discount);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public long insertWithDiscount(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setDiscount(this.Discount);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }
}

