/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.trgovina;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;

public class Nivelacija {
    private long DocumentID;
    private int DepartmentID;
    private int Number;
    private String Note;
    private Date Date;
    private String Status;
    private String ProdajnoMesto;

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documnetID) {
        this.DocumentID = documnetID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmnetID) {
        this.DepartmentID = departmnetID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public String getStatus() {
        return this.Status;
    }

    public void setStatus(String status) {
        this.Status = status;
    }

    public String getProdajnoMesto() {
        return this.ProdajnoMesto;
    }

    public void setProdajnoMesto(String prodajnoMesto) {
        this.ProdajnoMesto = prodajnoMesto;
    }

    public String getNote() {
        return this.Note;
    }

    public void setNote(String note) {
        this.Note = note;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }

    public static ObservableList<Nivelacija> getList(Date dateFrom, Date dateTo, Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.*, ds.Name as StatusName   from document d join documentstatus ds on ds.DocumentStatusID = d.DocumentStatusID where d.DocumentTypeID = 15   and d.Date >= ?    and d.Date < DATE_ADD(?,INTERVAL 1 DAY)    and d.DepartmentID = ? order by Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Nivelacija n = new Nivelacija();
                n.DocumentID = rs.getLong("DocumentID");
                n.Number = rs.getInt("Number");
                n.Date = rs.getTimestamp("Date");
                n.Status = rs.getString("StatusName");
                n.Note = rs.getString("Note");
                n.DepartmentID = rs.getInt("DepartmentID");
                n.ProdajnoMesto = new PointOfSale(rs.getInt("PointOfSaleID"), connection).getName();
                list.add((Object)n);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return list;
    }
}

