/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.trgovina;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.GeneratePlstFile;
import rs.petcom.master.dal.product.Product;
import rs.petcom.renameconnection.ChangeConnection;

public class Barcode {
    private long BarCodeID;
    private String BarCode;
    private long ProductID;
    private Boolean isWeight;
    private static final Logger LOGGER = Logger.getLogger("global");

    public Barcode(long barCodeID, String barCode) {
        this.BarCodeID = barCodeID;
        this.BarCode = barCode;
    }

    public Barcode(long barCodeID, String barCode, long productID) {
        this.BarCodeID = barCodeID;
        this.BarCode = barCode;
        this.ProductID = productID;
    }

    public Barcode() {
    }

    public static Set<GeneratePlstFile> getPlst(ScreensController controller) {
        HashSet<GeneratePlstFile> generatePlstFileList = new HashSet<GeneratePlstFile>();
        String sql = "select * from barcode b \ninner join product p on p.ProductID = b.ProductID \ninner  join pricelistdetails p2 \non p2.ProductID = p.ProductID \nwhere IsWeight = true order by p2.PriceListDetailsID desc ";
        try {
            PreparedStatement preparedStatement = controller.getSettings().getConnection().prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GeneratePlstFile generatePlstFile = new GeneratePlstFile();
                Long idProduct = resultSet.getLong("ProductID");
                String code = resultSet.getString("BarCode");
                String price = resultSet.getString("Price");
                String[] priceTmep = price.split("\\.");
                String basicPrice = priceTmep[0];
                String descimalPrice = priceTmep[1];
                int basicPriceLength = basicPrice.length();
                String finishPrice = "";
                finishPrice = basicPriceLength < 4 && basicPriceLength > 2 ? "0" + basicPrice : (basicPriceLength < 3 && basicPriceLength > 1 ? "00" + basicPrice : (basicPriceLength < 2 && basicPriceLength > 0 ? "000" + basicPrice : basicPrice));
                finishPrice = finishPrice + descimalPrice;
                String barCode = "028" + resultSet.getString("BarCode") + "00000";
                String productName = resultSet.getString("Name");
                generatePlstFile.setCodeProduct(code);
                generatePlstFile.setNameProduct(productName);
                generatePlstFile.setPrice(finishPrice);
                generatePlstFile.setBarCode(barCode);
                generatePlstFile.setExpirationDate("000");
                generatePlstFile.setGroupDetartment("01");
                generatePlstFile.setTypeProduct("00");
                generatePlstFile.setNumberCountPackage("00");
                generatePlstFile.setIdProduct(idProduct);
                if (generatePlstFileList.contains(generatePlstFile)) continue;
                generatePlstFileList.add(generatePlstFile);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return generatePlstFileList;
    }

    public static Set<GeneratePlstFile> getPlu(ScreensController controller) {
        HashSet<GeneratePlstFile> generatePlstFileList = new HashSet<GeneratePlstFile>();
        String sql = "select * from barcode b \ninner join product p on p.ProductID = b.ProductID \ninner  join pricelistdetails p2 \non p2.ProductID = p.ProductID \nwhere IsWeight = true order by p2.PriceListDetailsID desc ";
        try {
            PreparedStatement preparedStatement = controller.getSettings().getConnection().prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GeneratePlstFile generatePlstFile = new GeneratePlstFile();
                Long idProduct = resultSet.getLong("ProductID");
                String code = resultSet.getString("BarCode");
                char[] codeArray = code.toCharArray();
                StringBuilder codeBuilder = new StringBuilder();
                for (int i = 0; i < codeArray.length; ++i) {
                    if (codeArray[i] == '0') continue;
                    codeBuilder.append(codeArray[i]);
                }
                String price = resultSet.getString("Price");
                String[] priceTmep = price.split("\\.");
                String basicPrice = priceTmep[0];
                String descimalPrice = priceTmep[1];
                int basicPriceLength = basicPrice.length();
                String finishPrice = "";
                if (basicPriceLength > 0) {
                    finishPrice = basicPrice;
                }
                finishPrice = finishPrice + descimalPrice;
                String barCode = resultSet.getString("BarCode");
                String productName = resultSet.getString("Name");
                productName = productName.replaceAll("[\\t ]", "");
                generatePlstFile.setCodeProduct(codeBuilder.toString());
                generatePlstFile.setNameProduct(productName);
                generatePlstFile.setPrice(finishPrice);
                generatePlstFile.setBarCode(codeBuilder.toString());
                generatePlstFile.setExpirationDate("000");
                generatePlstFile.setGroupDetartment("01");
                generatePlstFile.setTypeProduct("00");
                generatePlstFile.setNumberCountPackage("00");
                generatePlstFile.setIdProduct(idProduct);
                if (generatePlstFileList.contains(generatePlstFile)) continue;
                generatePlstFileList.add(generatePlstFile);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return generatePlstFileList;
    }

    public long getBarCodeID() {
        return this.BarCodeID;
    }

    public void setBarCodeID(long barCodeID) {
        this.BarCodeID = barCodeID;
    }

    public String getBarCode() {
        return this.BarCode;
    }

    public void setBarCode(String barCode) {
        this.BarCode = barCode;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public Boolean getIsWeight() {
        return this.isWeight;
    }

    public void setIsWeight(Boolean isWeight) {
        this.isWeight = isWeight;
    }

    public String toString() {
        return this.BarCode;
    }

    public static String getBarCode(long productID, Connection connection) {
        String query = "select * from barcode bc where bc.ProductID = ? order by bc.BarCodeID asc limit 1";
        String bc = "";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                bc = rs.getString("BarCode");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bc;
    }

    public static Barcode getBarCodeObject(long productID, Connection connection) {
        String query = "select * from barcode bc where bc.ProductID = ? order by bc.BarCodeID limit 1";
        Barcode b = new Barcode();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            b.setBarCodeID(rs.getLong("BarCodeID"));
            b.setBarCode(rs.getString("BarCode"));
            b.setProductID(rs.getLong("ProductID"));
            b.setIsWeight(rs.getBoolean("IsWeight"));
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            return null;
        }
        return b;
    }

    public static ObservableList<Barcode> getBarCodes(Product product, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from barcode bc where bc.ProductID = ? and bc.BarCode <> ? order by bc.BarCodeID";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, product.getProductID());
            ps.setString(2, Barcode.getBarCode(product.getProductID(), connection));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Barcode b = new Barcode();
                b.setBarCodeID(rs.getLong("BarCodeID"));
                b.setBarCode(rs.getString("BarCode"));
                b.setProductID(rs.getLong("ProductID"));
                b.setIsWeight(rs.getBoolean("IsWeight"));
                list.add((Object)b);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void update(ScreensController controller) throws SQLException {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`barcode` SET `BarCode` = ?, `IsWeight` = ? WHERE  `BarCodeID` = ?";
        PreparedStatement ps = controller.getSettings().isSinhorinizacija() ? controller.getServerConnection().prepareStatement(query) : controller.getSettings().getConnection().prepareStatement(query);
        ps.setString(1, this.BarCode);
        ps.setBoolean(2, this.isWeight);
        ps.setLong(3, this.BarCodeID);
        ps.executeUpdate();
        ps.close();
    }

    public void updateClient(Connection connection) {
        String query = "UPDATE `barcode` SET `BarCode` = ?, `IsWeight` = ? WHERE  `BarCodeID` = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, this.BarCode);
            ps.setBoolean(2, this.isWeight);
            ps.setLong(3, this.BarCodeID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateById(ScreensController controller) throws SQLException {
        String query = "UPDATE `" + controller.getSettings().getDatabase() + "`.`barcode` SET `BarCode` = ?  WHERE  `BarCodeID` = ?";
        PreparedStatement ps = controller.getSettings().isSinhorinizacija() ? controller.getServerConnection().prepareStatement(query) : controller.getSettings().getConnection().prepareStatement(query);
        ps.setString(1, this.BarCode);
        ps.setLong(2, this.BarCodeID);
        ps.executeUpdate();
        ps.close();
    }

    public void updateByBarCode(String barCode, Connection connection) throws SQLException {
        String query = "update barcode bc set bc.BarCode = ? where bc.BarCode = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setString(1, barCode);
        ps.setString(2, this.BarCode);
        ps.executeUpdate();
        ps.close();
    }

    public void delete1(ScreensController controller) throws SQLException {
        ChangeConnection.getConnectionAdmin(controller);
        String query = "DELETE FROM `barcode` WHERE  `BarCodeID`=?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setLong(1, this.BarCodeID);
        ChangeConnection.getConnectionUser(controller);
        ps.executeUpdate();
        ps.close();
    }

    public void delete(Connection connection) throws SQLException {
        String query = "DELETE FROM `barcode` WHERE  `BarCodeID`=?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.BarCodeID);
        ps.executeUpdate();
        ps.close();
    }

    public void insertNewBarCode(Connection connection) throws SQLException {
        String query = "INSERT INTO `barcode` (`BarCode`, `ProductID`, `IsWeight`) VALUES (?, ?, ?);";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setString(1, this.BarCode);
        ps.setLong(2, this.ProductID);
        ps.setBoolean(3, this.isWeight);
        LOGGER.info(ps.toString());
        ps.executeUpdate();
        ps.close();
    }

    public void insertNewBarCodeFromServer(Connection connection) throws SQLException {
        String query = "INSERT INTO `barcode` (`BarCodeID`, `BarCode`, `ProductID`, `IsWeight`) VALUES (?, ?, ?, ?);";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.BarCodeID);
        ps.setString(2, this.BarCode);
        ps.setLong(3, this.ProductID);
        ps.setBoolean(4, this.isWeight);
        ps.executeUpdate();
        ps.close();
    }

    public static boolean barcodeExsists(String barCode, String filter, Connection connection) throws SQLException {
        String query = "SELECT COUNT(bc.BarCodeID) AS bcQuantity FROM barcode bc WHERE bc.BarCode = ? " + filter;
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setString(1, barCode);
        ResultSet rs = ps.executeQuery();
        rs.next();
        int bcQuantity = rs.getInt("bcQuantity");
        return bcQuantity > 0;
    }
}

