/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice.fiscal;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class NalogIspravkeController
implements ControlledScreen {
    ScreensController controller;
    PointOfSale sviPosovi = new PointOfSale(0, "Sva prodajna mesta");
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private ComboBox<PointOfSale> cbPos;
    @FXML
    private BorderPane reportPane;
    @FXML
    TableView<Document> reciptTable;
    @FXML
    TableColumn<Document, Integer> colBroj;
    @FXML
    TableColumn<Document, Date> colDatum;
    @FXML
    TableColumn<Document, Double> colBillValue;
    @FXML
    TableView<Document> reciptTableNI;
    @FXML
    TableColumn<Document, Integer> colBrojNI;
    @FXML
    TableColumn<Document, Date> colDatumNI;
    @FXML
    TableColumn<Document, Double> colBillValueNI;
    @FXML
    Label lblValue;
    @FXML
    Label lblDiscount;
    @FXML
    Label lblValueWithDiscount;
    @FXML
    Label lblValueNacinPlacanja;
    @FXML
    TableView<DocumentDetails> tableStavke;
    @FXML
    TableColumn<Document, String> tcNaziv;
    @FXML
    TableColumn<Document, Double> tcKol;
    @FXML
    TableColumn<Document, Double> tcCena;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateFrom.setValue((Object)LocalDate.now());
        this.colDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.colDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.colBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.colBillValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.colBillValue.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
        this.colBrojNI.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.colBillValueNI.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.colBillValueNI.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
        this.reciptTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Document>(){

            public void onChanged(ListChangeListener.Change<? extends Document> c) {
                Document d = (Document)NalogIspravkeController.this.reciptTable.getSelectionModel().getSelectedItem();
                if (d != null) {
                    NalogIspravkeController.this.lblValue.setText(Settings.getNumberFormat(2, true).format(d.getSum()));
                    NalogIspravkeController.this.lblDiscount.setText(Settings.getNumberFormat(2, true).format(d.getDiscount()));
                    NalogIspravkeController.this.lblValueWithDiscount.setText(Settings.getNumberFormat(2, true).format(d.getSumWithDiscount()));
                    NalogIspravkeController.this.lblValueNacinPlacanja.setText(PaymentMethod.getByID(d.getPaymentMethodID(), NalogIspravkeController.this.controller.getSettings().getConnection()).getName());
                    NalogIspravkeController.this.tableStavke.setItems(DocumentDetails.getObeservableList(d.getDocumentID(), NalogIspravkeController.this.controller.getSettings().getConnection()));
                }
            }
        });
        this.tcNaziv.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcKol.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcKol.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(4, true).format(item));
                }
            }
        });
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcCena.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat(2, true).format(item));
                }
            }
        });
        this.popuniFilterPosova();
        this.popuniDokumente();
        this.popuniDokumenteNI();
    }

    @FXML
    private void dateFromChange() {
        this.popuniDokumente();
        this.popuniDokumenteNI();
    }

    @FXML
    private void createCorrection() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("document", this.reciptTable.getSelectionModel().getSelectedItem());
        hm.put("user", this.controller.getUser());
        hm.put("controller", this.controller);
        int result = this.controller.showModalDialog("Nalog za ispravku", ScreensController.SCREEN_BACKOFFICE_FISCAL_CORRECTION_DIALOG, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.popuniDokumente();
            this.popuniDokumenteNI();
        }
    }

    @FXML
    private void printCorrection() {
        String reportFileName = "rs/petcom/backoffice/jasper/NalogZaIspravku.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("documetnId", ((Document)this.reciptTableNI.getSelectionModel().getSelectedItem()).getDocumentID());
        Document document = Document.getByID(((Document)this.reciptTableNI.getSelectionModel().getSelectedItem()).getDocumentID(), this.controller.getSettings().getConnection());
        PointOfSale pos = new PointOfSale(document.getPointOfSaleID(), this.controller.getSettings().getConnection());
        rs.petcom.master.dal.Object o = rs.petcom.master.dal.Object.getById(pos.getObjectID(), this.controller);
        Address address = Address.getByID(o.getAddressID(), this.controller.getSettings().getConnection());
        Person p = Person.getByCode("1", this.controller.getSettings().getConnection());
        hm.put("object", o);
        hm.put("address", address);
        hm.put("person", p);
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("document", document);
        hm.put("parentDocumentId", Document.getParentID(document.getDocumentID(), this.controller.getSettings().getConnection()).getDocumentID());
        hm.put("datumRacuna", document.getDate());
        hm.put("nacinPlacanja", PaymentMethod.getByID(document.getPaymentMethodID(), this.controller.getSettings().getConnection()).getName());
        String[] note = document.getNote().split("[\n]");
        hm.put("ImePrezime", note[2].split(":")[1]);
        hm.put("JMBG", note[3].split(":")[1]);
        hm.put("BI", note[1].split(":")[1]);
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Nalog za ispravku", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void popuniFilterPosova() {
        ObservableList listaPosova = FXCollections.observableArrayList();
        listaPosova.add((Object)this.sviPosovi);
        for (PointOfSale pos : PointOfSale.getPosList(this.controller.getObject(), this.controller.getSettings().getConnection())) {
            listaPosova.add((Object)pos);
        }
        this.cbPos.setItems(listaPosova);
        this.cbPos.getSelectionModel().select(0);
    }

    private void popuniDokumente() {
        this.reciptTable.setItems(Document.getObeservableList(3, 0, this.controller.getObject(), (PointOfSale)this.cbPos.getSelectionModel().getSelectedItem(), Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()), true, false, this.controller.getSettings().getConnection()));
    }

    private void popuniDokumenteNI() {
        this.reciptTableNI.setItems(Document.getObeservableListNI(3, 0, this.controller.getObject(), (PointOfSale)this.cbPos.getSelectionModel().getSelectedItem(), Settings.fromLocalDate((LocalDate)this.dateFrom.getValue()), true, false, this.controller.getSettings().getConnection()));
    }
}

