/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice.fiscal;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentRelationship;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class NInalogDialogController
implements DialogController {
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    ScreensController controller;
    HashMap<String, Object> parameters;
    Document document;
    @FXML
    BorderPane rootPane;
    @FXML
    TextField tfBrojIsecka;
    @FXML
    DatePicker dcDatumIsecka;
    @FXML
    TextField tfIBFM;
    @FXML
    TextField tfIme;
    @FXML
    TextField tfJMBG;

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FXML
    private void confirm(ActionEvent actionEvent) {
        Date datumRacuna = this.document.getDate();
        long docId = this.document.getDocumentID();
        this.document.setDocumentTypeID(DocumentType.getByCode("NI", this.controller.getSettings().getConnection()).getDocumentTypeID());
        this.document.setNumber(Document.getNextNumber(12, this.document.getPointOfSaleID(), this.controller));
        this.document.setDate(new Date());
        this.document.setFullNumber(this.tfBrojIsecka.getText());
        this.document.setAlternativeFullNumber(this.tfIBFM.getText());
        this.document.setSysDTCreated(new Date());
        this.document.setSysDTEdit(null);
        if (this.tfJMBG.getText().trim() != "") {
            if (this.tfJMBG.getLength() != 13) {
                this.controller.alert("Upozorenje", "Niste uneli odgovaraju\u0107i JMBG", this.rootPane.getScene().getWindow());
                return;
            }
            this.document.setNote("Broj fiskalnog ise\u010dka: " + this.tfBrojIsecka.getText() + "\nDatum fiskalnog ise\u010dka: " + Settings.getDateFromatter().format(Settings.fromLocalDate((LocalDate)this.dcDatumIsecka.getValue())) + "\nIme i prezime: " + this.tfIme.getText() + "\nJMBG: " + this.tfJMBG.getText());
            this.document.insert(this.controller);
        } else {
            this.document.setNote("Broj fiskalnog ise\u010dka: " + this.tfBrojIsecka.getText() + "\nDatum fiskalnog ise\u010dka: " + Settings.getDateFromatter().format(Settings.fromLocalDate((LocalDate)this.dcDatumIsecka.getValue())) + "\nIme i prezime: " + this.tfIme.getText() + "\nJMBG: " + this.tfJMBG.getText());
            this.document.insert(this.controller);
        }
        DocumentRelationship dr = new DocumentRelationship();
        dr.setRelationshipTypeID(2);
        dr.setDocumentParentID(docId);
        dr.setDocumentChildID(this.document.getDocumentID());
        dr.setActive(true);
        dr.setSysDTCreated(new Date());
        dr.setSysUserAddID(((User)this.parameters.get("user")).getUserID());
        dr.insert(this.controller.getSettings().getConnection());
        String reportFileName = "rs/petcom/backoffice/jasper/NalogZaIspravku.jasper";
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("documetnId", dr.getDocumentChildID());
        PointOfSale pos = new PointOfSale(this.document.getPointOfSaleID(), this.controller.getSettings().getConnection());
        rs.petcom.master.dal.Object o = rs.petcom.master.dal.Object.getById(pos.getObjectID(), this.controller);
        Address address = Address.getByID(o.getAddressID(), this.controller.getSettings().getConnection());
        Person p = Person.getByCode("1", this.controller.getSettings().getConnection());
        hm.put("object", o);
        hm.put("address", address);
        hm.put("person", p);
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        hm.put("document", this.document);
        hm.put("parentDocumentId", dr.getDocumentParentID());
        hm.put("datumRacuna", datumRacuna);
        hm.put("nacinPlacanja", PaymentMethod.getByID(this.document.getPaymentMethodID(), this.controller.getSettings().getConnection()).getName());
        hm.put("ImePrezime", this.tfIme.getText());
        hm.put("JMBG", this.tfJMBG.getText());
        hm.put("BI", this.tfBrojIsecka.getText());
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, Object> hm2 = new HashMap<String, Object>();
            hm2.put("report", (Object)printViewPane);
            this.controller.showModalDialog("Nalog za ispravku", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @Override
    public void setParameter(HashMap<String, Object> parameters) {
        this.parameters = parameters;
        this.controller = (ScreensController)parameters.get("controller");
        this.document = (Document)parameters.get("document");
        if (this.document != null) {
            this.dcDatumIsecka.setValue((Object)Settings.fromDate(this.document.getDate()));
            this.tfBrojIsecka.setText(this.document.getFullNumber());
            this.tfIBFM.setText(this.document.getAlternativeFullNumber());
        }
        this.tfBrojIsecka.getProperties().put((Object)"vkType", (Object)"numeric");
        this.tfIme.getProperties().put((Object)"vkType", (Object)"text");
        this.tfJMBG.getProperties().put((Object)"vkType", (Object)"text");
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }
}

