/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.WarehouseCentral;

public class WerehouseCentralControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    WarehouseCentral selectedWarehouse;
    HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<WarehouseCentral> tableCompany;
    @FXML
    private TableColumn<WarehouseCentral, String> columnCode;
    @FXML
    private TableColumn<WarehouseCentral, String> columnName;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.loadTable();
    }

    public void initialize() {
        this.tableCompany.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<WarehouseCentral>(){

            public void changed(ObservableValue<? extends WarehouseCentral> observable, WarehouseCentral oldValue, WarehouseCentral newValue) {
                WerehouseCentralControllerTrgovina.this.selectedWarehouse = newValue;
            }
        });
        this.tableCompany.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.hMap.put("selectedWarehouse", null);
        this.controller.showModalDialog("Kreiranje novog objekta", ScreensController.DIALOG_ADD_WAREHOUSE, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tableCompany.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedWarehouse != null) {
            this.hMap.put("selectedWarehouse", this.selectedWarehouse);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena objekta", ScreensController.DIALOG_ADD_WAREHOUSE, this.hMap, this.rootPane.getScene().getWindow());
            this.selectedWarehouse = (WarehouseCentral)this.hMap.get("selectedObject");
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati objekat iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
        this.hMap.remove("selectedCompany");
    }

    @FXML
    private void actionExcel() {
    }

    private void loadTable() {
        this.tableCompany.getSelectionModel().clearSelection();
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tableCompany.setItems(WarehouseCentral.getList(this.controller));
    }
}

