/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.Product;

public class VatNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult = 0;
    private HashMap<String, Object> parameter;
    private Vat selectedVat;
    private ToggleGroup group = new ToggleGroup();
    private List<Vat> vatLista;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfValue1;
    @FXML
    private TextField tfValue2;
    @FXML
    private TextField tfValue3;
    @FXML
    private TextField tfCode;
    @FXML
    private CheckBox cbActive;
    @FXML
    private RadioButton rbFirst;
    @FXML
    private RadioButton rbSecond;
    @FXML
    private RadioButton rbThird;
    @FXML
    private RadioButton rbFourth;
    @FXML
    private RadioButton rbFifth;
    @FXML
    private Label lblNaziv;
    @FXML
    private Label lblVrednost1;
    @FXML
    private Label lblVrednost2;
    @FXML
    private Label lblVrednost3;
    @FXML
    private Label lblKod;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.title.setText((String)parameter.get("title"));
        this.selectedVat = (Vat)parameter.get("selectedVat");
        if (this.selectedVat != null) {
            this.tfName.setText(this.selectedVat.getName());
            this.tfValue1.setText(String.valueOf(this.selectedVat.getValue()));
            this.tfValue2.setText(String.valueOf(this.selectedVat.getValue2()));
            this.tfValue3.setText(String.valueOf(this.selectedVat.getValue3()));
            this.tfCode.setText(this.selectedVat.getCode());
            this.cbActive.setSelected(this.selectedVat.isActive());
        }
        if (this.parameter.get("title").equals("Izaberite poresku stopu")) {
            this.tfName.setVisible(false);
            this.tfValue1.setVisible(false);
            this.tfValue2.setVisible(false);
            this.tfValue3.setVisible(false);
            this.tfCode.setVisible(false);
            this.cbActive.setVisible(false);
            this.lblNaziv.setVisible(false);
            this.lblVrednost1.setVisible(false);
            this.lblVrednost2.setVisible(false);
            this.lblVrednost3.setVisible(false);
            this.lblKod.setVisible(false);
            RadioButton[] radioButtonArray = new RadioButton[]{this.rbFirst, this.rbSecond, this.rbThird, this.rbFourth, this.rbFifth};
            this.vatLista = (List)parameter.get("vatLista");
            for (int i = 0; i < this.vatLista.size(); ++i) {
                radioButtonArray[i].setToggleGroup(this.group);
                radioButtonArray[i].setVisible(true);
                radioButtonArray[i].setText(this.vatLista.get(i).getName());
            }
            radioButtonArray[0].setSelected(true);
        }
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (this.parameter.get("title").equals("Izaberite poresku stopu")) {
            RadioButton selectedRB = (RadioButton)this.group.getSelectedToggle();
            Vat vat = null;
            for (Vat v : this.vatLista) {
                if (!v.getName().equals(selectedRB.getText())) continue;
                vat = v;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("title", "Promena PDV-a za sve artikle");
            hashMap.put("text", "Da li ste sigurni da \u017eelite da izmenite PDV za sve artikle?");
            int result = this.controller.showModalDialog("Promena PDV-a za sve artikle", ScreensController.DIALOG_YES_NO, hashMap, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_YES) {
                Product.changePDV(vat.getVatID(), this.controller.getSettings().getConnection());
            }
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
            return;
        }
        if (!this.validate()) {
            return;
        }
        Vat vat = new Vat();
        vat.setName(this.tfName.getText().trim());
        vat.setValue(Double.parseDouble(this.tfValue1.getText()));
        vat.setValue2(Double.parseDouble(this.tfValue2.getText()));
        vat.setValue3(Double.parseDouble(this.tfValue3.getText()));
        vat.setCode(this.tfCode.getText().trim());
        vat.setActive(this.cbActive.isSelected());
        if (this.selectedVat == null) {
            vat.insertVat(this.controller.getSettings().getConnection());
            this.parameter.put("vat", vat);
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        } else {
            vat.updateVat(this.selectedVat.getVatID(), this.controller.getSettings().getConnection());
            this.parameter.put("vat", vat);
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        }
    }

    private boolean validate() {
        if (this.tfName.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: naziv", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfValue1.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: vrednost 1", this.rootPane.getScene().getWindow());
            return false;
        }
        try {
            Double.parseDouble(this.tfValue1.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.controller.alert("Upozorenje", "Neispravan unos za polje: vrednost 1!", this.rootPane.getScene().getWindow());
            this.tfValue1.setText("");
            return false;
        }
        if (this.tfValue2.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: vrednost 2", this.rootPane.getScene().getWindow());
            return false;
        }
        try {
            Double.parseDouble(this.tfValue2.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.controller.alert("Upozorenje", "Neispravan unos za polje: vrednost 2!", this.rootPane.getScene().getWindow());
            this.tfValue2.setText("");
            return false;
        }
        if (this.tfValue3.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: vrednost 3", this.rootPane.getScene().getWindow());
            return false;
        }
        try {
            Double.parseDouble(this.tfValue3.getText().trim());
        }
        catch (NumberFormatException ex) {
            this.controller.alert("Upozorenje", "Neispravan unos za polje: vrednost 3!", this.rootPane.getScene().getWindow());
            this.tfValue3.setText("");
            return false;
        }
        if (this.tfCode.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: kod", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }
}

