/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;

public class PrinterInsertEditController
implements DialogController {
    private ScreensController controller;
    private Connection connection;
    private Printer printer;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblTitle;
    @FXML
    private TextField tfPrinterName;
    @FXML
    private TextField tfWinPrinterName;
    @FXML
    private TextField tfNumOfCharacters;
    @FXML
    private TextField tfNumOfCopies;
    @FXML
    private TextField tfPaperWidth;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.printer = (Printer)parameter.get("printer");
        this.connection = this.controller.getSettings().getConnection();
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.tfNumOfCharacters.setOnKeyReleased(this.digitEventHandler());
        this.tfNumOfCopies.setOnKeyReleased(this.digitEventHandler());
        this.loadAllTextFields();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    void actionConfirm(ActionEvent event) {
        if (this.allFieldsPopulated()) {
            this.loadPrinterFields();
            this.printer.updatePrinter(this.connection);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else {
            this.controller.alert("Upozorenje", "Popunite sva polja", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    void actionCancel(ActionEvent event) {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void loadAllTextFields() {
        this.tfPrinterName.setText(this.printer.getName());
        this.tfWinPrinterName.setText(this.printer.getServerName());
        this.tfPaperWidth.setText(String.valueOf(this.printer.getPaperwidth()));
        this.tfNumOfCharacters.setText(String.valueOf(this.printer.getNumOfCharacters()));
        this.tfNumOfCopies.setText(String.valueOf(this.printer.getCopies()));
    }

    private EventHandler<KeyEvent> digitEventHandler() {
        EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent key) {
                TextField tf = null;
                if (tf == null) {
                    tf = (TextField)key.getSource();
                }
                if (!PrinterInsertEditController.this.isDigit(key.getText()) || key.isShiftDown()) {
                    tf.undo();
                    return;
                }
            }
        };
        return handler;
    }

    private boolean isDigit(String key) {
        if (key == null) {
            return false;
        }
        if (key.trim().isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(key.trim());
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean allFieldsPopulated() {
        if (this.tfPrinterName.getText().trim().isEmpty()) {
            return false;
        }
        if (this.tfWinPrinterName.getText().trim().isEmpty()) {
            return false;
        }
        if (this.tfPaperWidth.getText().trim().isEmpty()) {
            return false;
        }
        if (this.tfNumOfCopies.getText().trim().isEmpty()) {
            return false;
        }
        return !this.tfNumOfCharacters.getText().trim().isEmpty();
    }

    private void loadPrinterFields() {
        int LIMIT = 36;
        int numOfCharacters = Integer.parseInt(this.tfNumOfCharacters.getText().trim());
        if (numOfCharacters > 36) {
            this.printer.setName("Pos Printer 80 mm");
            this.printer.setPaperwidth(80);
        } else {
            this.printer.setName("Pos Printer 57 mm");
            this.printer.setPaperwidth(57);
        }
        this.printer.setServerName(this.tfWinPrinterName.getText());
        this.printer.setCopies(Integer.parseInt(this.tfNumOfCopies.getText()));
        this.printer.setNumOfCharacters(Integer.parseInt(this.tfNumOfCharacters.getText()));
    }
}

