/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.PosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Printer;

public class PrinterController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<Printer> printerList;
    Printer selectedPrinter;
    @FXML
    private TableView<Printer> tablePrinter;
    @FXML
    private TableColumn<Printer, String> tcPrinterName;
    @FXML
    private TableColumn<Printer, String> tcWinPrinterName;
    @FXML
    private TableColumn<Printer, Integer> tcPaperWidth;
    @FXML
    private TableColumn<Printer, Integer> tcNumOfCharacters;
    @FXML
    private TableColumn<Printer, Integer> tcNumOfCopies;
    @FXML
    private Label title;
    @FXML
    private BorderPane rootPane;

    @FXML
    void actionNewPrinter(ActionEvent event) {
    }

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.setColumnsDatas();
        this.loadPrinterList();
    }

    @Override
    public void setParameter(Object parameter) {
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
    }

    @FXML
    public void printerCommit(ActionEvent event) {
    }

    @FXML
    void actionEditPrinter(ActionEvent event) {
        Printer printer = (Printer)this.tablePrinter.getSelectionModel().getSelectedItem();
        if (printer != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("printer", printer);
            this.controller.showModalDialog("Izmena \u0161tampa\u010da", ScreensController.SCREEN_BACKOFFICE_PRINTER_INSERT_EDIT, hm, this.rootPane.getScene().getWindow());
        }
        this.loadPrinterList();
    }

    @FXML
    void actionTestPrint(ActionEvent event) {
        PosPrint posPrint = new PosPrint(this.controller, null);
        posPrint.printNarrowTestToPos();
    }

    private void loadPrinterList() {
        this.tablePrinter.getItems().clear();
        this.printerList = Printer.getAllActivePrinter(this.controller.getSettings().getConnection());
        this.tablePrinter.setItems(this.printerList);
    }

    private void setColumnsDatas() {
        this.tcPrinterName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcWinPrinterName.setCellValueFactory((Callback)new PropertyValueFactory("ServerName"));
        this.tcNumOfCharacters.setCellValueFactory((Callback)new PropertyValueFactory("numOfCharacters"));
        this.tcNumOfCopies.setCellValueFactory((Callback)new PropertyValueFactory("Copies"));
        this.tcPaperWidth.setCellValueFactory((Callback)new PropertyValueFactory("Paperwidth"));
        this.tcPaperWidth.setCellFactory(col -> new TableCell<Printer, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                String text = "";
                if (item != null) {
                    text = item + " mm";
                }
                this.setText(text);
            }
        });
    }
}

