/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;

public class PointOfSaleNewDialogTrgovinaController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    private PointOfSale selectedPOS;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCode;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private CheckBox cbActive;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPOS = (PointOfSale)parameter.get("selectedPOS");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        for (Department department : Department.getList(this.controller.getObject(), this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((Object)department);
            this.cbDepartment.getSelectionModel().select(0);
        }
        this.fillData();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void fillData() {
        if (this.selectedPOS != null) {
            this.tfName.setText(this.selectedPOS.getName());
            this.tfCode.setText(this.selectedPOS.getCode());
            this.cbActive.setSelected(this.selectedPOS.isActive());
        } else {
            this.tfName.setText("");
            this.tfCode.setText("");
            this.cbActive.setSelected(false);
        }
    }

    @FXML
    public void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameter.put("selectedPOS", null);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void post() {
        if (this.selectedPOS != null) {
            this.selectedPOS.setCode(this.tfCode.getText().trim());
            this.selectedPOS.setName(this.tfName.getText().trim());
            this.selectedPOS.setActive(this.cbActive.isSelected());
            this.selectedPOS.setSysUserEditID(this.controller.getUser().getUserID());
            this.selectedPOS.update(this.controller);
            this.selectedPOS.updatePOSDepartment((Department)this.cbDepartment.getSelectionModel().getSelectedItem(), this.controller);
        } else if (this.tfCode.getText().equals("") || this.tfName.getText().equals("")) {
            this.controller.alert("Obavestenje", "Tekstualna polju ne mogu biti prazna", this.rootPane.getScene().getWindow());
        } else {
            this.selectedPOS = new PointOfSale();
            this.selectedPOS.setCode(this.tfCode.getText().trim());
            this.selectedPOS.setName(this.tfName.getText().trim());
            this.selectedPOS.setActive(this.cbActive.isSelected());
            this.selectedPOS.setSysUserAddID(this.controller.getUser().getUserID());
            this.selectedPOS.setObjectID(this.controller.getObject().getObjectID());
            this.selectedPOS.insert(this.controller);
            this.selectedPOS.insertPOSDepartment((Department)this.cbDepartment.getSelectionModel().getSelectedItem(), this.controller);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

