/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PersonSelectCashBuyerDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameters;
    private ObservableList<CashBuyer> cashBuyersList = FXCollections.observableArrayList();
    private ObservableList<Person> personCashBuyerList = FXCollections.observableArrayList();
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Person> tableCashBuyer;
    @FXML
    private TableColumn<Person, String> tcName;
    @FXML
    private TableColumn<Person, String> tcPIB;
    @FXML
    private TableColumn<Person, String> tcAddress;
    @FXML
    private TableColumn<Person, String> tcMB;
    @FXML
    private CheckBox checkAddNote;

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcAddress.setCellValueFactory((Callback)new PropertyValueFactory("Address"));
        this.tcMB.setCellValueFactory((Callback)new PropertyValueFactory("MB"));
        this.tcPIB.setCellValueFactory((Callback)new PropertyValueFactory("PIB"));
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.parameters = parameter;
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadPersonTable();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.confirm();
        }
    }

    @FXML
    private void newPerson() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        int result = ScreensController.MODAL_RESULT_CANCEL;
        hm.put("personCategory", PersonCategory.BUYER);
        result = this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_PERSON_CASHBUYER, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadPersonTable();
        }
        if (hm.get("person") != null) {
            Person person = (Person)hm.get("person");
            this.tfFilter.setText(person.getName());
        }
    }

    @FXML
    private void confirm() {
        boolean addNote = false;
        if (this.tableCashBuyer.getSelectionModel().getSelectedItem() != null) {
            if (this.checkAddNote.isSelected()) {
                addNote = true;
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.parameters.put("addNote", addNote);
            this.parameters.put("person", this.tableCashBuyer.getSelectionModel().getSelectedItem());
            this.parameters.put("nefiskalnaOtpremnica", false);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        } else {
            this.controller.alert("Greska kod izbora kupca", "Morate izabrati kupca iz tabele", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameters.put("nefiskalnaOtpremnica", false);
        Node source = (Node)actionEvent.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private void loadPersonTable() {
        this.cashBuyersList.clear();
        this.personCashBuyerList = Person.getPersonsForCashbuyersList(this.controller);
        this.cashBuyersList = CashBuyer.getCashBuyerList(this.controller.getSettings().getConnection());
        this.tableCashBuyer.setItems(this.personCashBuyerList);
        this.filter();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.personCashBuyerList, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(p -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            try {
                if (p.getName().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getMB().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getPIB().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                if (p.getAddress().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableCashBuyer.comparatorProperty());
        this.tableCashBuyer.setItems((ObservableList)sortedData);
    }
}

