/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.SQLException;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.person.PersonVatType;

public class PersonNewDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    @FXML
    Label title;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCurrencyPayment;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfPopust;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfPhone;
    @FXML
    private TextField tfEmail;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<PersonVatType> cbVatType;
    @FXML
    private ComboBox<BuyerOfferPrice> cbBuyerOfferPriceList;
    @FXML
    private ComboBox<PersonCategory> cbCategory;
    @FXML
    private CheckBox cbTaxExempt;
    private ObservableList<PersonVatType> vatTypeList = FXCollections.observableArrayList();
    private Person selectedPerson;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        BuyerOfferPrice buyerOfferPrice = new BuyerOfferPrice();
        buyerOfferPrice.setName("Redovni cenovnik");
        buyerOfferPrice.setBuyerOfferPriceID(new Long(-1L));
        this.cbBuyerOfferPriceList.getItems().add((Object)buyerOfferPrice);
        for (BuyerOfferPrice bop : BuyerOfferPrice.getList(this.controller.getObject().getObjectID(), this.controller.getSettings().getConnection())) {
            this.cbBuyerOfferPriceList.getItems().add((Object)bop);
        }
        this.cbBuyerOfferPriceList.getSelectionModel().select(0);
        this.fillPersonCategory();
        this.vatTypeList = PersonVatType.getList(this.controller.getSettings().getConnection());
        this.cbVatType.getItems().addAll(this.vatTypeList);
        this.cbVatType.getSelectionModel().select(0);
        String currency = this.parameter.get("personCategory").equals("Firma") ? this.controller.getSettings().getSetting("valuta.placanja", null) : "0";
        this.tfCurrencyPayment.setText(currency);
        this.tfPopust.setText("0");
        this.selectedPerson = (Person)parameter.get("selectedPerson");
        if (this.selectedPerson != null) {
            this.title.setText(this.parameter.get("personCategory").equals("Firma") || this.parameter.get("personCategory").equals("Kupac") ? "Izmena podataka kupca" : "Izmena podataka dobavlja\u010da");
            this.fillPersonData();
        } else {
            this.title.setText(this.parameter.get("personCategory").equals("Firma") ? "Kreiranje novog kupca" : (this.parameter.get("personCategory").equals("Kupac") ? "Kreiranje novog kupca" : "Kreiranje novog dobavlja\u010da"));
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbCategory.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((PersonCategory)PersonNewDialogController.this.cbCategory.getSelectionModel().getSelectedItem()).getName().equals("Kupac")) {
                    PersonNewDialogController.this.tfName.setDisable(true);
                    PersonNewDialogController.this.tfPIB.setDisable(true);
                    PersonNewDialogController.this.tfCurrencyPayment.setDisable(true);
                } else {
                    PersonNewDialogController.this.tfName.setDisable(false);
                    PersonNewDialogController.this.tfPIB.setDisable(false);
                    PersonNewDialogController.this.tfCurrencyPayment.setDisable(false);
                }
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (this.selectedPerson == null) {
            this.selectedPerson = new Person();
            this.selectedPerson.setPersonCategoryID(((PersonCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getPersonCategoryID());
            if (this.selectedPerson.getPersonCategoryID() == 4 || this.selectedPerson.getPersonCategoryID() == 6 || this.selectedPerson.getPersonCategoryID() == 3) {
                this.selectedPerson.setPersonTypeID(2);
            } else {
                this.selectedPerson.setPersonTypeID(1);
            }
            if (!this.validate()) {
                return;
            }
            int personVatTypeId = this.cbVatType.getSelectionModel().getSelectedItem() != null ? ((PersonVatType)this.cbVatType.getSelectionModel().getSelectedItem()).getPersonVatTypeID() : 1;
            this.selectedPerson.setPersonVatTypeID(personVatTypeId);
            this.selectedPerson.setFirstName("");
            this.selectedPerson.setLastName("");
            if (this.tfName.isDisable()) {
                this.selectedPerson.setName("");
            } else {
                this.selectedPerson.setName(this.tfName.getText().trim());
            }
            this.selectedPerson.setAddress(this.tfAddress.getText().trim());
            this.selectedPerson.setCity(this.tfCity.getText().trim());
            this.selectedPerson.setZIP(this.tfZip.getText().trim());
            this.selectedPerson.setPIB(this.tfPIB.getText().trim());
            this.selectedPerson.setMB(this.tfMB.getText().trim());
            this.selectedPerson.setPhone(this.tfPhone.getText().trim());
            this.selectedPerson.seteMail(this.tfEmail.getText().trim());
            this.selectedPerson.setActive(true);
            this.selectedPerson.setTaxExempt(this.cbTaxExempt.isSelected());
            try {
                this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
            }
            catch (NullPointerException e) {
                this.selectedPerson.setBuyerOfferPriceID(0L);
            }
            this.selectedPerson.setSysUserAddID(this.controller.getUser().getUserID());
            try {
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyPayment.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setCurrencyPaymentDays(0);
            }
            try {
                this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setDiscount(0.0);
            }
            this.selectedPerson.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
            if (this.selectedPerson.getPersonCategoryID() == 4) {
                CashBuyer buyer = new CashBuyer();
                buyer.setName(this.tfName.getText());
                buyer.setPIB(this.tfPIB.getText());
                buyer.setMB(this.tfMB.getText());
                buyer.setAddress(this.tfAddress.getText());
                buyer.setCity(this.tfCity.getText());
                buyer.setZIP(this.tfZip.getText());
                buyer.setSysUserAddID(this.controller.getUser().getSysUserAddID());
                try {
                    buyer.insert(this.controller.getSettings().getConnection());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            CashBuyer buyer;
            if (this.selectedPerson.getPersonCategoryID() == 4 && (buyer = CashBuyer.getByPib(this.selectedPerson.getPIB(), this.controller)) != null) {
                buyer.setName(this.tfName.getText());
                buyer.setPIB(this.tfPIB.getText());
                buyer.setMB(this.tfMB.getText());
                buyer.setAddress(this.tfAddress.getText());
                buyer.setCity(this.tfCity.getText());
                buyer.setZIP(this.tfZip.getText());
                buyer.setSysUserAddID(this.controller.getUser().getSysUserAddID());
                try {
                    buyer.update(this.controller.getSettings().getConnection());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.selectedPerson.getPersonCategoryID() == 4 || this.selectedPerson.getPersonCategoryID() == 6) {
                this.selectedPerson.setPersonTypeID(2);
            } else {
                this.selectedPerson.setPersonTypeID(1);
            }
            this.selectedPerson.setPersonCategoryID(((PersonCategory)this.cbCategory.getSelectionModel().getSelectedItem()).getPersonCategoryID());
            if (!this.validate()) {
                return;
            }
            int personVatTypeId = this.cbVatType.getSelectionModel().getSelectedItem() != null ? ((PersonVatType)this.cbVatType.getSelectionModel().getSelectedItem()).getPersonVatTypeID() : 1;
            this.selectedPerson.setPersonVatTypeID(personVatTypeId);
            this.selectedPerson.setFirstName("");
            this.selectedPerson.setLastName("");
            this.selectedPerson.setName(this.tfName.getText().trim());
            this.selectedPerson.setAddress(this.tfAddress.getText().trim());
            this.selectedPerson.setCity(this.tfCity.getText().trim());
            this.selectedPerson.setZIP(this.tfZip.getText().trim());
            this.selectedPerson.setPIB(this.tfPIB.getText().trim());
            if (!this.tfPhone.getText().trim().equals("")) {
                this.selectedPerson.setPhone(this.tfPhone.getText().trim());
            }
            if (!this.tfEmail.getText().trim().equals("")) {
                this.selectedPerson.seteMail(this.tfEmail.getText().trim());
            }
            this.selectedPerson.setMB(this.tfMB.getText().trim());
            this.selectedPerson.setActive(true);
            this.selectedPerson.setTaxExempt(this.cbTaxExempt.isSelected());
            try {
                this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
            }
            catch (NullPointerException e) {
                this.selectedPerson.setBuyerOfferPriceID(0L);
            }
            this.selectedPerson.setSysUserAddID(this.controller.getUser().getUserID());
            try {
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyPayment.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setCurrencyPaymentDays(0);
            }
            try {
                this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setDiscount(0.0);
            }
            this.selectedPerson.updateDobavljaci(this.controller.getUser(), this.controller.getSettings().getConnection());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void fillPersonData() {
        if (this.selectedPerson != null) {
            this.tfName.setText(this.selectedPerson.getName());
            this.tfAddress.setText(this.selectedPerson.getAddress());
            this.tfZip.setText(this.selectedPerson.getZIP());
            this.tfCity.setText(this.selectedPerson.getCity());
            this.tfPIB.setText(this.selectedPerson.getPIB());
            this.tfPhone.setText(this.selectedPerson.getPhone() != null ? this.selectedPerson.getPhone() : "");
            this.tfEmail.setText(this.selectedPerson.geteMail() != null ? this.selectedPerson.geteMail() : "");
            this.tfCurrencyPayment.setText(String.valueOf(this.selectedPerson.getCurrencyPaymentDays()));
            this.tfMB.setText(this.selectedPerson.getMB());
            this.tfPopust.setText(String.valueOf(this.selectedPerson.getDiscount()));
            for (PersonVatType personVatType : this.cbVatType.getItems()) {
                if (this.selectedPerson.getPersonVatTypeID() != personVatType.getPersonVatTypeID()) continue;
                this.cbVatType.getSelectionModel().select((Object)personVatType);
            }
            for (BuyerOfferPrice bop : this.cbBuyerOfferPriceList.getItems()) {
                if (this.selectedPerson.getBuyerOfferPriceID() != bop.getBuyerOfferPriceID().longValue()) continue;
                this.cbBuyerOfferPriceList.getSelectionModel().select((Object)bop);
            }
            for (PersonCategory personCategory : this.cbCategory.getItems()) {
                if (personCategory.getPersonCategoryID() != this.selectedPerson.getPersonCategoryID()) continue;
                this.cbCategory.getSelectionModel().select((Object)personCategory);
            }
            this.cbTaxExempt.setSelected(this.selectedPerson.isTaxExempt());
        } else {
            this.tfName.setText("");
            this.tfAddress.setText("");
            this.tfZip.setText("");
            this.tfCity.setText("");
            this.tfPIB.setText("");
            this.tfEmail.setText("");
            this.tfPhone.setText("");
            this.tfCurrencyPayment.setText("");
            this.tfMB.setText("");
            this.tfPopust.setText("");
        }
    }

    private boolean validate() {
        if (this.selectedPerson.getPersonCategoryID() == 4) {
            if (this.tfName.getText() == null || this.tfName.getText().trim().isEmpty()) {
                this.controller.alert("Upozorenje", "Popunite polje: naziv", this.rootPane.getScene().getWindow());
                return false;
            }
            if (this.tfAddress.getText() == null || this.tfAddress.getText().trim().isEmpty()) {
                this.controller.alert("Upozorenje", "Popunite polje: adresa", this.rootPane.getScene().getWindow());
                return false;
            }
            if (this.tfCity.getText() == null || this.tfCity.getText().trim().isEmpty()) {
                this.controller.alert("Upozorenje", "Popunite polje: mesto", this.rootPane.getScene().getWindow());
                return false;
            }
            if ((this.tfPIB.getText() == null || this.tfPIB.getText().trim().isEmpty()) && !this.parameter.get("personCategory").equals("Kupac")) {
                this.controller.alert("Upozorenje", "Popunite polje: PIB", this.rootPane.getScene().getWindow());
                return false;
            }
        }
        if (this.selectedPerson.getPersonCategoryID() == 3 && (this.tfName.getText() == null || this.tfName.getText().trim().isEmpty())) {
            this.controller.alert("Upozorenje", "Popunite polje: naziv", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }

    private void fillPersonCategory() {
        if (this.parameter.get("personCategory").equals("Firma")) {
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Firma", this.controller.getSettings().getConnection()));
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Interna-firma", this.controller.getSettings().getConnection()));
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()));
            this.cbCategory.getSelectionModel().select(0);
        } else if (this.parameter.get("personCategory").equals("Kupac")) {
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Kupac", this.controller.getSettings().getConnection()));
            this.cbCategory.getSelectionModel().select(0);
            this.tfName.setDisable(true);
            this.tfPIB.setDisable(true);
            this.tfCurrencyPayment.setDisable(true);
        } else if (this.parameter.get("personCategory").equals("Interna-firma")) {
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Interna-firma", this.controller.getSettings().getConnection()));
            this.cbCategory.getSelectionModel().select(0);
        } else {
            this.cbCategory.getItems().add((Object)PersonCategory.getByName("Dobavlja\u010d", this.controller.getSettings().getConnection()));
            this.cbCategory.getSelectionModel().select(0);
        }
    }
}

