/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Person;

public class PersonNewCashBuyerDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    private Person selectedPerson;
    private EventHandler<KeyEvent> handler;
    @FXML
    private Label title;
    @FXML
    private Label lblPIBmessage;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfMB;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Button btnPibConfirm;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnConfirm;
    @FXML
    private TextArea taNote;
    @FXML
    private CheckBox cbTaxExampt;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPerson = (Person)parameter.get("selectedPerson");
        this.btnPibConfirm.setDisable(true);
        this.taNote.setWrapText(true);
        if (this.selectedPerson == null) {
            this.disableAllFields();
        }
        if (this.selectedPerson != null) {
            this.title.setText("Izmena komitenta (gotovinsko placanje)");
            this.cbTaxExampt.setSelected(this.selectedPerson.isTaxExempt());
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.tfName.isDisable()) {
            this.tfPIB.requestFocus();
            this.handler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode() == KeyCode.ENTER) {
                        PersonNewCashBuyerDialogController.this.confirmPIB();
                    }
                }
            };
            this.tfPIB.addEventHandler(KeyEvent.KEY_PRESSED, this.handler);
        }
        this.fillPersonData();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (this.selectedPerson != null) {
            this.selectedPerson.setName(this.tfName.getText().trim());
            this.selectedPerson.setAddress(this.tfAddress.getText().trim());
            this.selectedPerson.setCity(this.tfCity.getText().trim());
            this.selectedPerson.setZIP(this.tfZip.getText().trim());
            this.selectedPerson.setPIB(this.tfPIB.getText());
            this.selectedPerson.setMB(this.tfMB.getText().trim());
            this.selectedPerson.setPersonTypeID(2);
            this.selectedPerson.setPersonCategoryID(7);
            this.selectedPerson.setActive(true);
            this.selectedPerson.setSysUserAddID(this.controller.getUser().getSysUserAddID());
            this.selectedPerson.setPersonVatTypeID(1);
            this.selectedPerson.setBuyerOfferPriceID(-1L);
            this.selectedPerson.setActive(true);
            this.selectedPerson.setNote(this.taNote.getText());
            this.selectedPerson.setTaxExempt(this.cbTaxExampt.isSelected());
            if (!this.validate()) {
                return;
            }
            this.selectedPerson.update(this.controller.getUser(), this.controller.getSettings().getConnection());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        } else {
            Person person = new Person();
            person.setName(this.tfName.getText().trim());
            person.setAddress(this.tfAddress.getText().trim());
            person.setZIP(this.tfZip.getText().trim());
            person.setCity(this.tfCity.getText().trim());
            person.setPIB(this.tfPIB.getText().trim());
            person.setMB(this.tfMB.getText().trim());
            person.setPersonTypeID(2);
            person.setPersonCategoryID(7);
            person.setActive(true);
            person.setSysUserAddID(this.controller.getUser().getSysUserAddID());
            person.setPersonVatTypeID(1);
            person.setBuyerOfferPriceID(-1L);
            person.setCode("");
            person.setPhone("");
            person.seteMail("");
            person.setNote(this.taNote.getText());
            person.setTaxExempt(this.cbTaxExampt.isSelected());
            if (!this.validate()) {
                return;
            }
            try {
                person.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        }
    }

    @FXML
    public void confirmPIB() {
        Connection connection;
        String pib = this.tfPIB.getText();
        Person p = Person.getByPIB(pib, connection = this.controller.getSettings().getConnection());
        if (p != null) {
            this.controller.alert("Kupac postoji u bazi", "Kupac sa unetim pibom ve\u0107 postoji u bazi", this.rootPane.getScene().getWindow());
            this.parameter.put("person", p);
            ((Stage)this.btnConfirm.getScene().getWindow()).close();
        } else {
            this.enableAllFields();
            System.out.println("Nemaaaaa");
        }
    }

    private void fillPersonData() {
        if (this.selectedPerson != null) {
            this.tfName.setText(this.selectedPerson.getName());
            this.tfAddress.setText(this.selectedPerson.getAddress());
            this.tfZip.setText(this.selectedPerson.getZIP());
            this.tfCity.setText(this.selectedPerson.getCity());
            this.tfPIB.setText(this.selectedPerson.getPIB());
            this.tfMB.setText(this.selectedPerson.getMB());
            this.taNote.setText(this.selectedPerson.getNote());
        }
    }

    private boolean validate() {
        if (this.tfName.getText() == null || this.tfName.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: naziv", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfAddress.getText() == null || this.tfAddress.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: adresa", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfCity.getText() == null || this.tfCity.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: mesto", this.rootPane.getScene().getWindow());
            return false;
        }
        if ((this.tfPIB.getText() == null || this.tfPIB.getText().trim().isEmpty()) && !this.parameter.get("personCategory").equals("Kupac")) {
            this.controller.alert("Upozorenje", "Popunite polje: PIB", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }

    private void disableAllFields() {
        this.tfName.setDisable(true);
        this.tfAddress.setDisable(true);
        this.tfCity.setDisable(true);
        this.tfMB.setDisable(true);
        this.tfZip.setDisable(true);
        this.btnConfirm.setDisable(true);
        this.taNote.setDisable(true);
        this.cbTaxExampt.setDisable(true);
        this.btnPibConfirm.setDisable(false);
    }

    private void enableAllFields() {
        this.tfName.setDisable(false);
        this.taNote.setDisable(false);
        this.tfAddress.setDisable(false);
        this.tfCity.setDisable(false);
        this.tfMB.setDisable(false);
        this.tfZip.setDisable(false);
        this.cbTaxExampt.setDisable(false);
        this.btnConfirm.setDisable(false);
        this.btnPibConfirm.setDisable(true);
        this.lblPIBmessage.setVisible(false);
        this.tfPIB.removeEventHandler(KeyEvent.KEY_PRESSED, this.handler);
    }
}

