/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonVatType;

public class PersonNewBuyerDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult;
    private HashMap<String, Object> parameter;
    private EventHandler<KeyEvent> handler;
    private boolean porez;
    @FXML
    Label title;
    @FXML
    Label lblMessage;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCurrencyPayment;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfPopust;
    @FXML
    private TextField tfFirstName;
    @FXML
    private TextField tfLastName;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfPhone;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfJBKJ;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<PersonVatType> cbVatType;
    @FXML
    private ComboBox<BuyerOfferPrice> cbBuyerOfferPriceList;
    @FXML
    private CheckBox cbTaxExempt;
    @FXML
    private CheckBox cbJBKJ;
    @FXML
    private CheckBox cbFaktura;
    @FXML
    private Button btnConfirmPib;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnConfirm;
    @FXML
    private TextArea taNote;
    private Boolean eFaktura;
    private ObservableList<PersonVatType> vatTypeList = FXCollections.observableArrayList();
    private Person selectedPerson;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.btnConfirmPib.setDisable(true);
        this.taNote.setWrapText(true);
        BuyerOfferPrice buyerOfferPrice = new BuyerOfferPrice();
        buyerOfferPrice.setName("Redovni cenovnik");
        buyerOfferPrice.setBuyerOfferPriceID(new Long(-1L));
        this.cbBuyerOfferPriceList.getItems().add((Object)buyerOfferPrice);
        for (BuyerOfferPrice bop : BuyerOfferPrice.getList(this.controller.getObject().getObjectID(), this.controller.getSettings().getConnection())) {
            this.cbBuyerOfferPriceList.getItems().add((Object)bop);
        }
        this.cbBuyerOfferPriceList.getSelectionModel().select(0);
        this.vatTypeList = PersonVatType.getList(this.controller.getSettings().getConnection());
        this.cbVatType.getItems().addAll(this.vatTypeList);
        this.cbVatType.getSelectionModel().select(0);
        String currency = this.parameter.get("personCategory").equals("Firma") ? this.controller.getSettings().getSetting("valuta.placanja", null) : "0";
        this.tfCurrencyPayment.setText(currency);
        this.tfPopust.setText("0");
        this.selectedPerson = (Person)parameter.get("selectedPerson");
        if (this.selectedPerson == null) {
            this.disableAllFields();
            this.tfPIB.requestFocus();
        }
        if (this.selectedPerson != null) {
            this.title.setText("Izmena komitenta (virmansko placanje)");
        }
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.tfName.isDisable()) {
            this.handler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode() == KeyCode.ENTER) {
                        PersonNewBuyerDialogController.this.confirmPIB();
                    }
                }
            };
            this.tfPIB.addEventHandler(KeyEvent.KEY_PRESSED, this.handler);
        }
        this.fillPersonData();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void confirm(ActionEvent event) {
        if (this.selectedPerson != null) {
            int personVatTypeId = this.cbVatType.getSelectionModel().getSelectedItem() != null ? ((PersonVatType)this.cbVatType.getSelectionModel().getSelectedItem()).getPersonVatTypeID() : 1;
            this.selectedPerson.setName(this.tfName.getText().trim());
            this.selectedPerson.setAddress(this.tfAddress.getText().trim());
            this.selectedPerson.setCity(this.tfCity.getText().trim());
            this.selectedPerson.setZIP(this.tfZip.getText().trim());
            this.selectedPerson.setPIB(this.tfPIB.getText().trim());
            this.selectedPerson.setMB(this.tfMB.getText().trim());
            this.selectedPerson.setFirstName(this.tfFirstName.getText());
            this.selectedPerson.setLastName(this.tfLastName.getText());
            this.selectedPerson.setPhone(this.tfPhone.getText().trim());
            this.selectedPerson.seteMail(this.tfEmail.getText().trim());
            this.selectedPerson.setTaxExempt(this.cbTaxExempt.isSelected());
            this.selectedPerson.setSysUserEditID(this.controller.getUser().getUserID());
            this.selectedPerson.setNote(this.taNote.getText());
            this.selectedPerson.setTfJBKJ(this.tfJBKJ.getText().trim());
            this.selectedPerson.seteFaktura(this.eFaktura);
            try {
                this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setDiscount(0.0);
            }
            try {
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyPayment.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setCurrencyPaymentDays(0);
            }
            try {
                this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
            }
            catch (NullPointerException e) {
                this.selectedPerson.setBuyerOfferPriceID(0L);
            }
            if (!this.validate()) {
                return;
            }
            this.selectedPerson.update(this.controller.getUser(), this.controller.getSettings().getConnection());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        } else {
            int personVatTypeId;
            int n = personVatTypeId = this.cbVatType.getSelectionModel().getSelectedItem() != null ? ((PersonVatType)this.cbVatType.getSelectionModel().getSelectedItem()).getPersonVatTypeID() : 1;
            if (this.porez) {
                personVatTypeId = 2;
            }
            this.selectedPerson = new Person();
            if (!this.validate()) {
                return;
            }
            this.selectedPerson.setPersonTypeID(2);
            this.selectedPerson.setPersonCategoryID(4);
            this.selectedPerson.setPersonVatTypeID(personVatTypeId);
            this.selectedPerson.setFirstName(this.tfFirstName.getText());
            this.selectedPerson.setLastName(this.tfLastName.getText());
            this.selectedPerson.setName(this.tfName.getText().trim());
            this.selectedPerson.setAddress(this.tfAddress.getText().trim());
            this.selectedPerson.setCity(this.tfCity.getText().trim());
            this.selectedPerson.setZIP(this.tfZip.getText().trim());
            this.selectedPerson.setPIB(this.tfPIB.getText().trim());
            this.selectedPerson.setMB(this.tfMB.getText().trim());
            this.selectedPerson.setPhone(this.tfPhone.getText().trim());
            this.selectedPerson.seteMail(this.tfEmail.getText().trim());
            this.selectedPerson.setActive(true);
            this.selectedPerson.setTaxExempt(this.cbTaxExempt.isSelected());
            this.selectedPerson.setNote(this.taNote.getText());
            this.selectedPerson.setTfJBKJ(this.tfJBKJ.getText().trim());
            this.selectedPerson.seteFaktura(this.eFaktura);
            try {
                this.selectedPerson.setBuyerOfferPriceID(((BuyerOfferPrice)this.cbBuyerOfferPriceList.getSelectionModel().getSelectedItem()).getBuyerOfferPriceID());
            }
            catch (NullPointerException e) {
                this.selectedPerson.setBuyerOfferPriceID(0L);
            }
            this.selectedPerson.setSysUserAddID(this.controller.getUser().getUserID());
            try {
                this.selectedPerson.setCurrencyPaymentDays(Integer.parseInt(this.tfCurrencyPayment.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setCurrencyPaymentDays(0);
            }
            try {
                this.selectedPerson.setDiscount(Double.parseDouble(this.tfPopust.getText()));
            }
            catch (NumberFormatException e) {
                this.selectedPerson.setDiscount(0.0);
            }
            this.selectedPerson.insert(this.controller.getUser(), this.controller.getSettings().getConnection());
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
        }
    }

    @FXML
    private void confirmPIB() {
        Connection connection = this.controller.getSettings().getConnection();
        Person p = Person.getByPIB(this.tfPIB.getText(), connection);
        if (p != null) {
            String name = p.getName();
            if (p.getPersonCategoryID() == 7) {
                int result = this.controller.yesNoDialog("Kupac " + name + " postoji u bazi", "Kupac sa unetim pibom ve\u0107 postoji u bazi i evidentiran je kao gotovinski kupac. Da li \u017eelite da omogu\u0107ite kupcu kupovinu preko virmana ", this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_YES) {
                    p.setPersonCategoryID(4);
                    p.setBuyerOfferPriceID(-1L);
                    p.update(this.controller.getUser(), connection);
                }
            } else if (p.getPersonCategoryID() == 2 || p.getPersonCategoryID() == 4) {
                this.controller.alert("Kupac " + name + " postoji u bazi", "Kupac sa unetim pibom ve\u0107 postoji u bazi ", this.rootPane.getScene().getWindow());
                this.parameter.put("person", p);
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.btnConfirmPib.getScene().getWindow()).close();
        } else {
            this.enableAllFields();
        }
    }

    private void fillPersonData() {
        if (this.selectedPerson != null) {
            this.tfName.setText(this.selectedPerson.getName());
            this.tfAddress.setText(this.selectedPerson.getAddress());
            this.tfZip.setText(this.selectedPerson.getZIP());
            this.tfCity.setText(this.selectedPerson.getCity());
            this.tfPIB.setText(this.selectedPerson.getPIB());
            this.tfPhone.setText(this.selectedPerson.getPhone() != null ? this.selectedPerson.getPhone() : "");
            this.tfEmail.setText(this.selectedPerson.geteMail() != null ? this.selectedPerson.geteMail() : "");
            this.tfCurrencyPayment.setText(String.valueOf(this.selectedPerson.getCurrencyPaymentDays()));
            this.tfFirstName.setText(this.selectedPerson.getFirstName());
            this.tfLastName.setText(this.selectedPerson.getLastName());
            this.tfMB.setText(this.selectedPerson.getMB());
            this.tfPopust.setText(String.valueOf(this.selectedPerson.getDiscount()));
            this.taNote.setText(this.selectedPerson.getNote());
            this.eFaktura = this.selectedPerson.geteFaktura();
            if (this.selectedPerson.getTfJBKJ() != null && !"".equals(this.selectedPerson.getTfJBKJ())) {
                this.tfJBKJ.setText(this.selectedPerson.getTfJBKJ());
                this.cbJBKJ.setSelected(true);
            } else {
                this.tfJBKJ.setText("");
            }
            for (PersonVatType personVatType : this.cbVatType.getItems()) {
                if (this.selectedPerson.getPersonVatTypeID() != personVatType.getPersonVatTypeID()) continue;
                this.cbVatType.getSelectionModel().select((Object)personVatType);
            }
            for (BuyerOfferPrice bop : this.cbBuyerOfferPriceList.getItems()) {
                if (this.selectedPerson.getBuyerOfferPriceID() != bop.getBuyerOfferPriceID().longValue()) continue;
                this.cbBuyerOfferPriceList.getSelectionModel().select((Object)bop);
            }
            this.cbTaxExempt.setSelected(this.selectedPerson.isTaxExempt());
        } else {
            this.tfName.setText("");
            this.tfAddress.setText("");
            this.tfZip.setText("");
            this.tfCity.setText("");
            this.tfPIB.setText("");
            this.tfEmail.setText("");
            this.tfPhone.setText("");
            this.tfCurrencyPayment.setText("");
            this.tfFirstName.setText("");
            this.tfLastName.setText("");
            this.tfMB.setText("");
            this.tfPopust.setText("");
            this.tfPIB.requestFocus();
        }
    }

    private boolean validate() {
        if (this.tfName.getText() == null || this.tfName.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: naziv", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfAddress.getText() == null || this.tfAddress.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: adresa", this.rootPane.getScene().getWindow());
            return false;
        }
        if (this.tfCity.getText() == null || this.tfCity.getText().trim().isEmpty()) {
            this.controller.alert("Upozorenje", "Popunite polje: mesto", this.rootPane.getScene().getWindow());
            return false;
        }
        if ((this.tfPIB.getText() == null || this.tfPIB.getText().trim().isEmpty()) && !this.parameter.get("personCategory").equals("Kupac")) {
            this.controller.alert("Upozorenje", "Popunite polje: PIB", this.rootPane.getScene().getWindow());
            return false;
        }
        return true;
    }

    private void disableAllFields() {
        this.tfName.setDisable(true);
        this.tfAddress.setDisable(true);
        this.tfCity.setDisable(true);
        this.tfMB.setDisable(true);
        this.tfZip.setDisable(true);
        this.tfPopust.setDisable(true);
        this.tfPhone.setDisable(true);
        this.tfCurrencyPayment.setDisable(true);
        this.tfFirstName.setDisable(true);
        this.tfLastName.setDisable(true);
        this.tfEmail.setDisable(true);
        this.tfJBKJ.setDisable(true);
        this.cbBuyerOfferPriceList.setDisable(true);
        this.cbVatType.setDisable(true);
        this.cbTaxExempt.setDisable(true);
        this.btnConfirm.setDisable(true);
        this.btnConfirmPib.setDisable(false);
    }

    private void enableAllFields() {
        this.tfName.setDisable(false);
        this.tfAddress.setDisable(false);
        this.tfCity.setDisable(false);
        this.tfMB.setDisable(false);
        this.tfZip.setDisable(false);
        this.tfPopust.setDisable(false);
        this.tfPhone.setDisable(false);
        this.tfCurrencyPayment.setDisable(false);
        this.tfFirstName.setDisable(false);
        this.tfLastName.setDisable(false);
        this.tfEmail.setDisable(false);
        this.cbBuyerOfferPriceList.setDisable(false);
        this.cbVatType.setDisable(false);
        this.cbTaxExempt.setDisable(false);
        this.lblMessage.setVisible(false);
        this.btnConfirm.setDisable(false);
        this.btnConfirmPib.setDisable(true);
        this.tfPIB.removeEventHandler(KeyEvent.KEY_PRESSED, this.handler);
    }

    public void confirmActionCheck(ActionEvent actionEvent) {
        if (this.cbJBKJ.isSelected()) {
            this.porez = true;
        } else {
            this.porez = false;
            this.tfJBKJ.setText("");
        }
        this.tfJBKJ.setDisable(false);
    }

    public void confirmPorez(ActionEvent actionEvent) {
        this.porez = true;
    }

    public void confirmfaktura(ActionEvent actionEvent) {
        this.eFaktura = this.cbFaktura.isSelected() ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }
}

