/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;

public class PaymentMethodPickerController
implements DialogController {
    private ScreensController controller;
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private HashMap<String, Object> parameters;
    private PaymentMethod selectedPaymentMethod;
    private int selectedPaymentMethodID;
    private Person personFaktura = null;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<PaymentMethod> cbPaymentMethod;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedPaymentMethodID = (Integer)parameter.get("selectedPaymentMethodID");
        this.fillPaymentMethod();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent evt) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        Node source = (Node)evt.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    public void confirm() {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.parameters.put("paymentMethod", this.cbPaymentMethod.getSelectionModel().getSelectedItem());
        if (((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getCode().equals("F")) {
            this.parameters.put("controller", this.controller);
            this.parameters.put("personCategory", PersonCategory.BUYER);
            int result = this.controller.showModalDialog("Izbor komitenta", ScreensController.DIALOG_SELECT_PERSON_TRGOVINA, this.parameters, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.personFaktura = (Person)this.parameters.get("person");
                this.parameters.put("personFaktura", this.personFaktura);
            }
        }
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillPaymentMethod() {
        for (PaymentMethod paMethod : PaymentMethod.getFakturaPaymentList(this.controller)) {
            if (paMethod.getPaymentMethodID() == this.selectedPaymentMethodID) continue;
            this.cbPaymentMethod.getItems().add((Object)paMethod);
            this.cbPaymentMethod.getSelectionModel().select(0);
        }
    }
}

