/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;

public class PaymentMethodController
implements ControlledScreen {
    private ScreensController controller;
    private PaymentMethod selectedPaymentMethod;
    HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<PaymentMethod> tablePaymentMethod;
    @FXML
    private TableColumn<PaymentMethod, String> columnCode;
    @FXML
    private TableColumn<PaymentMethod, String> columnName;
    @FXML
    private TableColumn<PaymentMethod, String> columnActive;
    @FXML
    private TableColumn<PaymentMethod, String> columnDefault;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
        this.loadTable();
    }

    public void initialize() {
        this.tablePaymentMethod.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PaymentMethod>(){

            public void changed(ObservableValue<? extends PaymentMethod> observable, PaymentMethod oldValue, PaymentMethod newValue) {
                PaymentMethodController.this.selectedPaymentMethod = newValue;
            }
        });
        this.tablePaymentMethod.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.hMap.put("selectedPaymentMethod", null);
        this.controller.showModalDialog("Kreiranje novog nacina placanja", ScreensController.DIALOG_ADD_NEW_PAYMENT_METHOD, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tablePaymentMethod.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedPaymentMethod != null) {
            this.hMap.put("selectedPaymentMethod", this.selectedPaymentMethod);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena nacina placanja", ScreensController.DIALOG_ADD_NEW_PAYMENT_METHOD, this.hMap, this.rootPane.getScene().getWindow());
            this.selectedPaymentMethod = (PaymentMethod)this.hMap.get("selectedPaymentMethod");
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati nacin placanja iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
        this.hMap.remove("selectedPaymentMethod");
    }

    @FXML
    private void actionExcel() {
    }

    private void loadTable() {
        this.tablePaymentMethod.getSelectionModel().clearSelection();
        this.columnCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnActive.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PaymentMethod, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<PaymentMethod, String> p) {
                if (p.getValue() != null) {
                    return new SimpleStringProperty(((PaymentMethod)p.getValue()).isActive() ? "DA" : "NE");
                }
                return new SimpleStringProperty("<no name>");
            }
        });
        this.columnDefault.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PaymentMethod, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<PaymentMethod, String> p) {
                if (p.getValue() != null) {
                    return new SimpleStringProperty(((PaymentMethod)p.getValue()).isIsDefault() ? "DA" : "NE");
                }
                return new SimpleStringProperty("<no name>");
            }
        });
        this.tablePaymentMethod.setItems(PaymentMethod.getList(this.controller));
    }
}

