/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DocumentPayCard;
import rs.petcom.master.dal.PayCard;

public class PayCardsController
implements ControlledScreen {
    private ScreensController controller;
    private ObservableList<PayCard> payCardsList = FXCollections.observableArrayList();
    private PayCard selectedPayCard;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label title;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<PayCard> tvPayCard;
    @FXML
    private TableColumn<PayCard, String> tcName;
    @FXML
    private TableColumn<PayCard, Double> tcPercent;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                PayCardsController.this.loadPayCardsList();
            }
        });
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.loadPayCardsList();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.tcPercent.setCellValueFactory((Callback)new PropertyValueFactory("percent"));
        this.tvPayCard.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedPayCard = newValue;
        });
    }

    @FXML
    public void payCardNew(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedPayCard", null);
        this.controller.showModalDialog("Kreiranje platne kartice", ScreensController.DIALOG_ADD_PAYCARD, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadPayCardsList();
    }

    @FXML
    public void payCardDelete(ActionEvent event) {
        if (this.selectedPayCard == null) {
            this.controller.alert("Upozorenje", "Izaberite platnu karticu koju \u017eelite da obrisete", this.rootPane.getScene().getWindow());
            return;
        }
        for (DocumentPayCard documentPayCard : DocumentPayCard.getListByPayCardID(this.controller, this.selectedPayCard.getPayCardId())) {
            documentPayCard.getDocument().updatePayCardSlipNumber(this.controller);
        }
        this.selectedPayCard.deleteDocumentPayCard(this.controller);
        this.selectedPayCard.delete(this.controller);
        this.loadPayCardsList();
    }

    @FXML
    public void payCardUpdate(ActionEvent event) {
        if (this.selectedPayCard == null) {
            this.controller.alert("Upozorenje", "Izaberite kupca koga \u017eelite da izmenite", this.rootPane.getScene().getWindow());
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("selectedPayCard", this.selectedPayCard);
        this.controller.showModalDialog("Izmena podataka", ScreensController.DIALOG_ADD_PAYCARD, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadPayCardsList();
    }

    @FXML
    private void getExcel() {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje izve\u0161taja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                PayCardsController.this.writeToExcel();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        taskUpdateStage.hide();
                    }
                });
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Uspe\u0161no ste kreirali izve\u0161taj.", this.rootPane.getScene().getWindow());
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka!", "Do\u0161lo je do gre\u0161ke prilikom izdavanja izve\u0161taja.", this.rootPane.getScene().getWindow());
        });
    }

    private void writeToExcel() {
        String xlsxTitle = this.selectedPayCard.getName();
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(xlsxTitle);
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Naziv");
        header.createCell(1).setCellValue("Procenat");
        header.createCell(2).setCellValue("Aktivan");
        sheet.setColumnWidth(0, 4100);
        sheet.setColumnWidth(1, 4100);
        sheet.setColumnWidth(2, 4100);
        int index = 1;
        for (PayCard payCard : this.tvPayCard.getItems()) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(payCard.getName());
            row.createCell(1).setCellValue(payCard.getPercent());
            row.createCell(2).setCellValue(payCard.isActive());
            ++index;
        }
        try {
            File theDir = new File(this.controller.getSettings().getJasperToPDF() + xlsxTitle.replace(" ", "_"));
            if (!theDir.exists()) {
                try {
                    theDir.mkdir();
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(theDir + File.separator + xlsxTitle.replace(" ", "_").concat(".xlsx"));
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPayCardsList() {
        this.payCardsList = PayCard.getList(this.controller, this.tfFilter.getText().trim());
        this.tvPayCard.setItems(this.payCardsList);
    }
}

