/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.sql.Connection;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Description;

public class OpisniSelectDialogController
implements DialogController {
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, Object> parameters;
    Connection connection;
    Description description;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Description> table;
    @FXML
    private TableColumn<Description, Integer> tcId;
    @FXML
    private TableColumn<Description, String> tcName;

    @FXML
    public void cancel(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void confirm(ActionEvent actionEvent) {
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        this.description = (Description)this.table.getSelectionModel().getSelectedItem();
        this.parameters.put("description", this.description);
        ((Stage)((Node)actionEvent.getSource()).getScene().getWindow()).close();
    }

    @FXML
    public void mouseClick(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            this.description = (Description)this.table.getSelectionModel().getSelectedItem();
            this.parameters.put("description", this.description);
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
    }

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameters = parameter;
        this.description = (Description)parameter.get("description");
        this.connection = (Connection)parameter.get("connection");
        this.populateTable();
        this.tcId.setCellValueFactory((Callback)new PropertyValueFactory("DescriptionID"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                OpisniSelectDialogController.this.populateTable();
            }
        });
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return this.parameters;
    }

    @Override
    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    private void populateTable() {
        this.table.setItems(Description.getObeservableList(this.tfFilter.getText(), this.connection));
        if (this.table.getItems().size() > 0) {
            this.table.getSelectionModel().select(0);
        }
    }
}

