/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.AddressType;
import rs.petcom.master.dal.person.Contact;
import rs.petcom.master.dal.person.PersonVatType;

public class ObjectNewDialogTrgovinaController
implements DialogController {
    ScreensController controller;
    int modalResult;
    HashMap<String, Object> parameter;
    rs.petcom.master.dal.Object selectedObject;
    ObservableList<Contact> contactList;
    Address address;
    File fileLogo;
    File fileMemorandum;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TabPane tabPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfCompanyName;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfZip;
    @FXML
    private TextField tfState;
    @FXML
    private TextField tfBank;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfMunicipality;
    @FXML
    private TextField tfBankAccount;
    @FXML
    private TextField tfApiKey;
    @FXML
    private TextField tfIdCompany;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbDailyReportActive;
    @FXML
    private CheckBox cbSellWithoutStock;
    @FXML
    private CheckBox cbFifoPurchacePrice;
    @FXML
    private CheckBox cbBarcodeOutputDocVisible;
    @FXML
    private CheckBox cbOtpremnicaUskaStampaDetaljiFirme;
    @FXML
    private CheckBox cbBarCodeFrontSlova;
    @FXML
    private CheckBox cbUniqueCode;
    @FXML
    private CheckBox cbOnlyNumberCode;
    @FXML
    private CheckBox cbAutoIncrementCode;
    @FXML
    private CheckBox cbMemorandum;
    @FXML
    private CheckBox cbProtelActive;
    @FXML
    private CheckBox cbReservationFront;
    @FXML
    private CheckBox cbScaleFront;
    @FXML
    private CheckBox cbGotBillPrint;
    @FXML
    private CheckBox cbPrinatA4;
    @FXML
    private CheckBox cbPointsLoyality;
    @FXML
    private CheckBox cbDocumentLock;
    @FXML
    private CheckBox cb24hworkDay;
    @FXML
    private CheckBox cbKWSActive;
    @FXML
    private TextField tfBrojFakture;
    @FXML
    private TextField tfBrojVPFakture;
    @FXML
    private TextField tfBrojProfakture;
    @FXML
    private TextField tfBrojOtpremnice;
    @FXML
    private TextField tfBrojGotovinskog;
    @FXML
    private TextField tfBrojWebRacuna;
    @FXML
    private TextField tfBrojKopijaFaktura;
    @FXML
    private TextField tfBrojKopijaVPFaktura;
    @FXML
    private TextField tfBrojKopijaProfakture;
    @FXML
    private TextField tfBrojKopijaOtpremnice;
    @FXML
    private TextField tfBrojKopijaGotovinskog;
    @FXML
    private TextField tfBrojKopijaWebRacuna;
    @FXML
    private TextField tfMicrocerFolder;
    @FXML
    private TextField tfProtelConnectionPath;
    @FXML
    private TextArea taNapomenaFaktura;
    @FXML
    private TextArea taNapomenaVPFaktura;
    @FXML
    private TextArea taNapomenaProfaktura;
    @FXML
    private TextArea taNapomenaOtpremnica;
    @FXML
    private TextArea taNapomenaWebRacuna;
    @FXML
    private TextArea taNapomenaGotovinskog;
    @FXML
    private ImageView ivLogo;
    @FXML
    private ImageView ivMemorandum;
    @FXML
    private ComboBox<AddressType> cbAddressType;
    @FXML
    private ComboBox<PersonVatType> cbObjectVatType;
    @FXML
    private Tab tabPodesavanjeArtikla;
    @FXML
    private Tab tabWebRacun;
    @FXML
    private Tab tabMemorandum;
    @FXML
    private CheckBox cbAutomatskaStampaFakture;
    @FXML
    private CheckBox cbAutomatskaStampaVPFakture;
    @FXML
    private CheckBox cbAutomatskaStampaProfakture;
    @FXML
    private CheckBox cbAutomatskaStampaOtpremnice;
    @FXML
    private CheckBox cbAutomatskaStampaGotovinskog;
    @FXML
    private CheckBox cbAutomatskaStampaWebRacuna;
    @FXML
    private CheckBox cbMicrocer;
    @FXML
    private CheckBox cbMicrocerBills;

    @Override
    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.selectedObject = (rs.petcom.master.dal.Object)parameter.get("selectedObject");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.selectedObject != null) {
            this.tabPane.getTabs().remove((Object)this.tabPodesavanjeArtikla);
        }
        this.tfName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ObjectNewDialogTrgovinaController.this.tfCompanyName.setText(newValue);
            }
        });
        this.cbUniqueCode.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    ObjectNewDialogTrgovinaController.this.cbOnlyNumberCode.setDisable(false);
                    ObjectNewDialogTrgovinaController.this.cbAutoIncrementCode.setDisable(false);
                } else {
                    ObjectNewDialogTrgovinaController.this.cbOnlyNumberCode.setDisable(true);
                    ObjectNewDialogTrgovinaController.this.cbAutoIncrementCode.setDisable(true);
                }
            }
        });
        this.cbAddressType.setDisable(true);
        this.fillDataObject(this.selectedObject);
        this.fillTabExcel();
        this.fillTabFaktura();
        this.fillTabVPFaktura();
        this.fillTabProfaktura();
        this.fillTabOtpremnica();
        this.fillTabGotovinskiRacun();
        this.fillTabWebRacun();
        this.fillTabMemorandum();
    }

    @Override
    public HashMap<String, Object> getParameter() {
        return null;
    }

    @Override
    public int getModalResult() {
        return 0;
    }

    @Override
    public void setModalResult(int modalResult) {
    }

    @FXML
    private void actionLogoSearch() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import slike");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("JPG files (*.jpg)", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG files (*.png)", new String[]{"*.png"})});
        this.fileLogo = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (this.fileLogo != null) {
            try {
                this.ivLogo.setImage(new Image((InputStream)new FileInputStream(this.fileLogo.getAbsolutePath())));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void actionMemorandumSearch() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import slike");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("JPG files (*.jpg)", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG files (*.png)", new String[]{"*.png"})});
        this.fileMemorandum = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (this.fileMemorandum != null) {
            try {
                this.ivMemorandum.setImage(new Image((InputStream)new FileInputStream(this.fileMemorandum.getAbsolutePath())));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void cancel() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        this.parameter.put("selectedObject", null);
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void deleteLogo() {
        for (Images images : Images.getImagesList(this.controller)) {
            if (!images.getName().equals("logo")) continue;
            images.delete(this.controller);
        }
        this.ivLogo.setImage(null);
    }

    @FXML
    private void deleteMemorandum() {
        for (Images images : Images.getImagesList(this.controller)) {
            if (!images.getName().equals("memorandum")) continue;
            images.delete(this.controller);
        }
        this.ivMemorandum.setImage(null);
    }

    @FXML
    public void post() {
        Settings settingsDR = new Settings(String.valueOf(this.cbDailyReportActive.isSelected()), "dnevni.izvestaj.aktivan");
        settingsDR.update(this.controller);
        Settings settingsBcDoc = new Settings(String.valueOf(this.cbBarcodeOutputDocVisible.isSelected()), "barkod.vidljiv.izlazni.dokumenti");
        settingsBcDoc.update(this.controller);
        Settings settingsSWS = new Settings(String.valueOf(this.cbSellWithoutStock.isSelected()), "sell.without.stock");
        settingsSWS.update(this.controller);
        Settings settingsFifo = new Settings(String.valueOf(this.cbFifoPurchacePrice.isSelected()), "fifo_nabavna_cena");
        settingsFifo.update(this.controller);
        Settings settingsUskaStampa = new Settings(String.valueOf(this.cbOtpremnicaUskaStampaDetaljiFirme.isSelected()), "otpremnica.uska-stampa.detalji.firme");
        settingsUskaStampa.update(this.controller);
        Settings settingsBarCodeSlova = new Settings(String.valueOf(this.cbBarCodeFrontSlova.isSelected()), "barcode.front.slova");
        settingsBarCodeSlova.update(this.controller);
        Settings settingsProtelActive = new Settings(String.valueOf(this.cbProtelActive.isSelected()), "protel.active");
        settingsProtelActive.update(this.controller);
        Settings settingsScaleFront = new Settings(String.valueOf(this.cbScaleFront.isSelected()), "scale.button.is.visible");
        settingsScaleFront.update(this.controller);
        Settings settingsReservationFront = new Settings(String.valueOf(this.cbReservationFront.isSelected()), "rezervacija.front.vidljivo.dugme");
        settingsReservationFront.update(this.controller);
        Settings settingsGotBillPrint = new Settings(String.valueOf(this.cbGotBillPrint.isSelected()), "got.bill.print");
        settingsGotBillPrint.update(this.controller);
        Settings prinatA4 = new Settings(String.valueOf(this.cbPrinatA4.isSelected()), "print.A4");
        prinatA4.update(this.controller);
        Settings settingsPointsLoyality = new Settings(String.valueOf(this.cbPointsLoyality.isSelected()), "loyalty.point.action");
        settingsPointsLoyality.update(this.controller);
        Settings settingsDocumentLocked = new Settings(String.valueOf(this.cbDocumentLock.isSelected()), "documentLock.active");
        settingsDocumentLocked.update(this.controller);
        Settings settings24hWorkDay = new Settings(String.valueOf(this.cb24hworkDay.isSelected()), "24h.radno.vreme");
        settings24hWorkDay.update(this.controller);
        Settings settingdKWS = new Settings(String.valueOf(this.cbKWSActive.isSelected()), "KWS.aktivan");
        settingdKWS.update(this.controller);
        Settings settingsProtelConnectionPath = new Settings(this.tfProtelConnectionPath.getText() != null ? this.tfProtelConnectionPath.getText().trim() : "localhost", "protel.connection.path");
        settingsProtelConnectionPath.update(this.controller);
        Settings settingsMicrocer = new Settings(String.valueOf(this.cbMicrocer.isSelected()), "excel.microcer");
        settingsMicrocer.update(this.controller);
        Settings settingsMicrocerBills = new Settings(String.valueOf(this.cbMicrocerBills.isSelected()), "excel.microcer.bills");
        settingsMicrocerBills.update(this.controller);
        Settings settingsMicrocerFolder = new Settings(this.tfMicrocerFolder.getText() != null ? this.tfMicrocerFolder.getText().trim() : "", "excel.microcer.folder");
        settingsMicrocerFolder.update(this.controller);
        if (this.selectedObject != null) {
            rs.petcom.master.dal.Object object = new rs.petcom.master.dal.Object();
            object.setName(this.tfName.getText());
            object.setCode(this.tfCode.getText());
            object.setApiKey(this.tfApiKey.getText());
            object.setIdCompany(this.tfIdCompany.getText());
            object.setRegionID(this.selectedObject.getRegionID());
            object.setObjectVatTypeID(((PersonVatType)this.cbObjectVatType.getSelectionModel().getSelectedItem()).getPersonVatTypeID());
            object.setActive(true);
            object.setCompanyConfigID(1L);
            object.setPIB(this.tfPIB.getText());
            object.setMB(this.tfMB.getText());
            object.setAddressID(this.selectedObject.getAddressID());
            object.setBank(this.tfBank.getText());
            object.setBankAccount(this.tfBankAccount.getText());
            object.setObjectID(this.selectedObject.getObjectID());
            object.update(this.controller);
            Address address = new Address();
            address.setAddressTypeID(((AddressType)this.cbAddressType.getSelectionModel().getSelectedItem()).getAddressTypeID());
            address.setAddress(this.tfAddress.getText());
            address.setCity(this.tfCity.getText());
            address.setState(this.tfState.getText());
            address.setZip(this.tfZip.getText());
            address.setIsPrimary(true);
            address.setActive(this.cbActive.isSelected());
            address.setMunicipality(this.tfMunicipality.getText());
            address.setAddressID(this.selectedObject.getAddressID());
            address.update(this.controller);
        }
        Settings settingsF = new Settings(this.taNapomenaFaktura.getText(), "napomena.faktura");
        settingsF.update(this.controller);
        Settings settingsBrojKopijaF = new Settings(this.tfBrojKopijaFaktura.getText(), "broj.kopija.faktura");
        settingsBrojKopijaF.update(this.controller);
        Settings settingsAutomatskaStampaF = new Settings(String.valueOf(this.cbAutomatskaStampaFakture.isSelected()), "automatska.stampa.faktura");
        settingsAutomatskaStampaF.update(this.controller);
        DocumentType documentTypeF = new DocumentType();
        documentTypeF.setFirstNumber(Integer.parseInt(this.tfBrojFakture.getText()));
        documentTypeF.setCode("F");
        documentTypeF.update(this.controller);
        Settings settingsVPF = new Settings(this.taNapomenaVPFaktura.getText(), "napomena.vp.faktura");
        settingsVPF.update(this.controller);
        Settings settingsBrojKopijaVPF = new Settings(this.tfBrojKopijaVPFaktura.getText(), "broj.kopija.veleprodajnefaktura");
        settingsBrojKopijaVPF.update(this.controller);
        Settings settingsAutomatskaStampaVPF = new Settings(String.valueOf(this.cbAutomatskaStampaVPFakture.isSelected()), "automatska.stampa.veleprodajnefaktura");
        settingsAutomatskaStampaVPF.update(this.controller);
        DocumentType documentTypeVPF = new DocumentType();
        documentTypeVPF.setFirstNumber(Integer.parseInt(this.tfBrojVPFakture.getText()));
        documentTypeVPF.setCode("VPF");
        documentTypeVPF.update(this.controller);
        Settings settingsPF = new Settings(this.taNapomenaProfaktura.getText(), "napomena.profaktura");
        settingsPF.update(this.controller);
        Settings settingsBrojKopijaPF = new Settings(this.tfBrojKopijaProfakture.getText(), "broj.kopija.profaktura");
        settingsBrojKopijaPF.update(this.controller);
        Settings settingsAutomatskaStampaPF = new Settings(String.valueOf(this.cbAutomatskaStampaProfakture.isSelected()), "automatska.stampa.profaktura");
        settingsAutomatskaStampaPF.update(this.controller);
        DocumentType documentTypePF = new DocumentType();
        documentTypePF.setFirstNumber(Integer.parseInt(this.tfBrojProfakture.getText()));
        documentTypePF.setCode("PROF");
        documentTypePF.update(this.controller);
        Settings settingsOT = new Settings(this.taNapomenaOtpremnica.getText(), "napomena.otpremnica");
        settingsOT.update(this.controller);
        Settings settingsBrojKopijaOT = new Settings(this.tfBrojKopijaOtpremnice.getText(), "broj.kopija.otpremnica");
        settingsBrojKopijaOT.update(this.controller);
        Settings settingsAutomatskaStampaOT = new Settings(String.valueOf(this.cbAutomatskaStampaOtpremnice.isSelected()), "automatska.stampa.otpremnica");
        settingsAutomatskaStampaOT.update(this.controller);
        DocumentType documentTypeOT = new DocumentType();
        documentTypeOT.setFirstNumber(Integer.parseInt(this.tfBrojOtpremnice.getText()));
        documentTypeOT.setCode("OT");
        documentTypeOT.update(this.controller);
        Settings settingsGR = new Settings(this.taNapomenaGotovinskog.getText(), "napomena.gotovinski.kupac");
        settingsGR.update(this.controller);
        Settings settingsBrojKopijaGR = new Settings(this.tfBrojKopijaGotovinskog.getText(), "broj.kopija.gotovinski");
        settingsBrojKopijaGR.update(this.controller);
        Settings settingsAutomatskaStampaGR = new Settings(String.valueOf(this.cbAutomatskaStampaGotovinskog.isSelected()), "automatska.stampa.gotovinski");
        settingsAutomatskaStampaGR.update(this.controller);
        DocumentType documentTypeGR = new DocumentType();
        documentTypeGR.setFirstNumber(Integer.parseInt(this.tfBrojOtpremnice.getText()));
        documentTypeGR.setCode("GR");
        documentTypeGR.update(this.controller);
        Settings settingsWR = new Settings(this.taNapomenaWebRacuna.getText(), "napomena.web.racun");
        settingsWR.update(this.controller);
        Settings settingsBrojKopijaWR = new Settings(this.tfBrojKopijaWebRacuna.getText(), "broj.kopija.web.racuna");
        settingsBrojKopijaWR.update(this.controller);
        Settings settingsAutomatskaStampaWR = new Settings(String.valueOf(this.cbAutomatskaStampaWebRacuna.isSelected()), "automatska.stampa.web.racuna");
        settingsAutomatskaStampaWR.update(this.controller);
        DocumentType documentTypeWR = new DocumentType();
        documentTypeWR.setFirstNumber(Integer.parseInt(this.tfBrojOtpremnice.getText()));
        documentTypeWR.setCode("WR");
        documentTypeWR.update(this.controller);
        Settings settingsM = new Settings(String.valueOf(this.cbMemorandum.isSelected()), "company.memorandum.boolean");
        settingsM.update(this.controller);
        if (this.cbMemorandum.isSelected() && this.fileMemorandum != null) {
            for (Images images : Images.getImagesList(this.controller)) {
                if (images.getName().equals("memorandum")) {
                    images.setName("memorandum");
                    try {
                        images.setImage(new FileInputStream(this.fileMemorandum.getAbsolutePath()));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    images.updateImage(this.controller);
                    continue;
                }
                if (!images.getName().equals("login")) continue;
                Images memorandum = new Images();
                memorandum.setName("memorandum");
                try {
                    memorandum.setImage(new FileInputStream(this.fileMemorandum.getAbsolutePath()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                memorandum.insertImage(this.controller);
            }
        }
        if (this.fileLogo != null) {
            for (Images images : Images.getImagesList(this.controller)) {
                if (images.getName().equals("logo")) {
                    images.setName("logo");
                    try {
                        images.setImage(new FileInputStream(this.fileLogo.getAbsolutePath()));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    images.updateImage(this.controller);
                    continue;
                }
                if (!images.getName().equals("login")) continue;
                Images logo = new Images();
                logo.setName("logo");
                try {
                    logo.setImage(new FileInputStream(this.fileLogo.getAbsolutePath()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                logo.insertImage(this.controller);
            }
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void fillDataObject(rs.petcom.master.dal.Object selectedObject) {
        this.cbDailyReportActive.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("dnevni.izvestaj.aktivan")));
        this.cbSellWithoutStock.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("sell.without.stock")));
        this.cbFifoPurchacePrice.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("fifo_nabavna_cena")));
        this.cbOtpremnicaUskaStampaDetaljiFirme.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("otpremnica.uska-stampa.detalji.firme")));
        this.cbBarCodeFrontSlova.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("barcode.front.slova")));
        this.cbProtelActive.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("protel.active")));
        this.cbReservationFront.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("rezervacija.front.vidljivo.dugme")));
        this.cbScaleFront.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("scale.button.is.visible")));
        this.tfProtelConnectionPath.setText(this.controller.getSettings().getActualByName("protel.connection.path"));
        this.cbBarcodeOutputDocVisible.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("barkod.vidljiv.izlazni.dokumenti")));
        this.cbGotBillPrint.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("got.bill.print")));
        this.cbPrinatA4.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4")));
        this.cbPointsLoyality.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("loyalty.point.action")));
        this.cbDocumentLock.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active")));
        this.cb24hworkDay.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("24h.radno.vreme")));
        this.cbKWSActive.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("KWS.aktivan")));
        if (selectedObject != null) {
            this.address = Address.getByID(selectedObject.getAddressID(), this.controller.getSettings().getConnection());
            this.tfName.setText(selectedObject.getName());
            this.tfCode.setText(selectedObject.getCode());
            this.tfCompanyName.setText(CompanyConfig.getByID(selectedObject.getCompanyConfigID(), this.controller).getName());
            this.tfPIB.setText(selectedObject.getPIB());
            this.tfMB.setText(selectedObject.getMB());
            this.tfAddress.setText(this.address.getAddress());
            this.tfZip.setText(this.address.getZip());
            this.tfState.setText(this.address.getState());
            this.tfCity.setText(this.address.getCity());
            this.tfMunicipality.setText(this.address.getMunicipality());
            this.tfBank.setText(selectedObject.getBank());
            this.tfBankAccount.setText(selectedObject.getBankAccount());
            this.cbActive.setSelected(selectedObject.isActive());
            for (AddressType addressType : AddressType.getList(this.controller)) {
                this.cbAddressType.getItems().add((Object)addressType);
                if (addressType.getAddressTypeID() != this.address.getAddressTypeID()) continue;
                this.cbAddressType.getSelectionModel().select((Object)addressType);
            }
            for (PersonVatType personVatType : PersonVatType.getList(this.controller.getSettings().getConnection())) {
                this.cbObjectVatType.getItems().add((Object)personVatType);
                if (personVatType.getPersonVatTypeID() != selectedObject.getObjectVatTypeID()) continue;
                this.cbObjectVatType.getSelectionModel().select((Object)personVatType);
            }
        } else {
            this.tfName.setText("");
            this.tfCode.setText("");
            this.tfCompanyName.setText("");
            this.tfPIB.setText("");
            this.tfMB.setText("");
            this.tfAddress.setText("");
            this.tfZip.setText("");
            this.tfState.setText("");
            this.tfCity.setText("");
            this.tfMunicipality.setText("");
            this.tfBank.setText("");
            this.tfBankAccount.setText("");
            this.tfApiKey.setText("");
            this.tfIdCompany.setText("");
            this.cbActive.setSelected(true);
            for (AddressType addressType : AddressType.getList(this.controller)) {
                this.cbAddressType.getItems().add((Object)addressType);
                this.cbAddressType.getSelectionModel().select(0);
            }
            for (PersonVatType personVatType : PersonVatType.getList(this.controller.getSettings().getConnection())) {
                this.cbObjectVatType.getItems().add((Object)personVatType);
                this.cbObjectVatType.getSelectionModel().select(0);
            }
        }
    }

    private void fillTabExcel() {
        if (this.controller.getSettings().getActualByName("excel.microcer").equals("true")) {
            this.cbMicrocer.setSelected(true);
        }
        if (this.controller.getSettings().getActualByName("excel.microcer.bills").equals("true")) {
            this.cbMicrocerBills.setSelected(true);
        }
        this.tfMicrocerFolder.setText(this.controller.getSettings().getActualByName("excel.microcer.folder"));
    }

    private void fillTabFaktura() {
        DocumentType documentTypes = DocumentType.getByCode("F", this.controller.getSettings().getConnection());
        this.tfBrojFakture.setText("" + documentTypes.getFirstNumber());
        this.taNapomenaFaktura.setText(this.controller.getSettings().getActualByName("napomena.faktura"));
        this.tfBrojKopijaFaktura.setText(this.controller.getSettings().getActualByName("broj.kopija.faktura"));
        if (this.controller.getSettings().getActualByName("automatska.stampa.faktura").equals("true")) {
            this.cbAutomatskaStampaFakture.setSelected(true);
        }
    }

    private void fillTabVPFaktura() {
        DocumentType documentTypes = DocumentType.getByCode("VPF", this.controller.getSettings().getConnection());
        this.tfBrojVPFakture.setText("" + documentTypes.getFirstNumber());
        this.taNapomenaVPFaktura.setText(this.controller.getSettings().getActualByName("napomena.vp.faktura"));
        this.tfBrojKopijaVPFaktura.setText(this.controller.getSettings().getActualByName("broj.kopija.veleprodajnefaktura"));
        if (this.controller.getSettings().getActualByName("automatska.stampa.veleprodajnefaktura").equals("true")) {
            this.cbAutomatskaStampaVPFakture.setSelected(true);
        }
    }

    private void fillTabProfaktura() {
        DocumentType documentTypes = DocumentType.getByCode("PROF", this.controller.getSettings().getConnection());
        this.tfBrojProfakture.setText("" + documentTypes.getFirstNumber());
        this.taNapomenaProfaktura.setText(this.controller.getSettings().getActualByName("napomena.profaktura"));
        this.tfBrojKopijaProfakture.setText(this.controller.getSettings().getActualByName("broj.kopija.profaktura"));
        if (this.controller.getSettings().getActualByName("automatska.stampa.profaktura").equals("true")) {
            this.cbAutomatskaStampaProfakture.setSelected(true);
        }
    }

    private void fillTabOtpremnica() {
        DocumentType documentTypes = DocumentType.getByCode("OT", this.controller.getSettings().getConnection());
        this.tfBrojOtpremnice.setText("" + documentTypes.getFirstNumber());
        this.taNapomenaOtpremnica.setText(this.controller.getSettings().getActualByName("napomena.otpremnica"));
        this.tfBrojKopijaOtpremnice.setText(this.controller.getSettings().getActualByName("broj.kopija.otpremnica"));
        if (this.controller.getSettings().getActualByName("automatska.stampa.otpremnica").equals("true")) {
            this.cbAutomatskaStampaOtpremnice.setSelected(true);
        }
    }

    private void fillTabGotovinskiRacun() {
        DocumentType documentTypes = DocumentType.getByCode("GR", this.controller.getSettings().getConnection());
        this.tfBrojGotovinskog.setText("" + documentTypes.getFirstNumber());
        this.taNapomenaGotovinskog.setText(this.controller.getSettings().getActualByName("napomena.gotovinski.kupac"));
        this.tfBrojKopijaGotovinskog.setText(this.controller.getSettings().getActualByName("broj.kopija.gotovinski"));
        if (this.controller.getSettings().getActualByName("automatska.stampa.gotovinski").equals("true")) {
            this.cbAutomatskaStampaGotovinskog.setSelected(true);
        }
    }

    private void fillTabWebRacun() {
        if (this.controller.getSettings().getActualByName("napomena.web.racun") != null) {
            DocumentType documentTypes = DocumentType.getByCode("WR", this.controller.getSettings().getConnection());
            this.tfBrojWebRacuna.setText("" + documentTypes.getFirstNumber());
            this.taNapomenaWebRacuna.setText(this.controller.getSettings().getActualByName("napomena.web.racun"));
            this.tfBrojKopijaWebRacuna.setText(this.controller.getSettings().getActualByName("broj.kopija.web.racuna"));
            if (this.controller.getSettings().getActualByName("automatska.stampa.web.racuna").equals("true")) {
                this.cbAutomatskaStampaWebRacuna.setSelected(true);
            }
        } else {
            this.tabPane.getTabs().remove((Object)this.tabWebRacun);
        }
    }

    private void fillTabMemorandum() {
        if (this.controller.getSettings().getActualByName("company.memorandum.boolean") != null) {
            this.cbMemorandum.setSelected(Boolean.parseBoolean(this.controller.getSettings().getActualByName("company.memorandum.boolean")));
        }
        for (Images images : Images.getImagesList(this.controller)) {
            if (images.getName().equals("logo")) {
                this.ivLogo.setImage(new Image(images.getImage()));
            }
            if (!images.getName().equals("memorandum")) continue;
            this.ivMemorandum.setImage(new Image(images.getImage()));
        }
    }

    public static void main(String[] args) {
    }
}

