/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.person.Address;

public class ObjectConfigControllerTrgovina
implements ControlledScreen {
    ScreensController controller;
    ObservableList<rs.petcom.master.dal.Object> objectList;
    rs.petcom.master.dal.Object selectedObject;
    HashMap<String, Object> hMap;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<rs.petcom.master.dal.Object> tableObject;
    @FXML
    private TableColumn<rs.petcom.master.dal.Object, String> columnName;
    @FXML
    private TableColumn<rs.petcom.master.dal.Object, String> columnAddress;
    @FXML
    private TableColumn<rs.petcom.master.dal.Object, String> columnCity;
    @FXML
    private TableColumn<rs.petcom.master.dal.Object, String> columnApiKey;
    @FXML
    private TableColumn<rs.petcom.master.dal.Object, String> columnIdCompany;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.loadTable();
    }

    public void initialize() {
        this.tableObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<rs.petcom.master.dal.Object>(){

            public void changed(ObservableValue<? extends rs.petcom.master.dal.Object> observable, rs.petcom.master.dal.Object oldValue, rs.petcom.master.dal.Object newValue) {
                ObjectConfigControllerTrgovina.this.selectedObject = newValue;
            }
        });
        this.tableObject.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.actionChange();
                }
            });
            return row;
        });
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        this.hMap.put("controller", this.controller);
        this.hMap.put("selectedObject", null);
        this.controller.showModalDialog("Kreiranje novog objekta", ScreensController.DIALOG_ADD_OBJECT, this.hMap, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.tableObject.getSelectionModel().clearSelection();
        this.loadTable();
    }

    @FXML
    private void actionChange() {
        if (this.selectedObject != null) {
            this.hMap.put("selectedObject", this.selectedObject);
            this.hMap.put("controller", this.controller);
            this.controller.showModalDialog("Izmena objekta", ScreensController.DIALOG_ADD_OBJECT, this.hMap, this.rootPane.getScene().getWindow());
            this.selectedObject = (rs.petcom.master.dal.Object)this.hMap.get("selectedObject");
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati objekat iz tabele!", this.rootPane.getScene().getWindow());
        }
        this.loadTable();
    }

    @FXML
    private void actionExcel() {
    }

    private void loadTable() {
        this.tableObject.getSelectionModel().clearSelection();
        this.objectList = rs.petcom.master.dal.Object.getList(this.controller.getSettings().getConnection());
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.columnApiKey.setCellValueFactory((Callback)new PropertyValueFactory("apiKey"));
        this.columnIdCompany.setCellValueFactory((Callback)new PropertyValueFactory("idCompany"));
        this.columnAddress.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<rs.petcom.master.dal.Object, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<rs.petcom.master.dal.Object, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Address.getByID(((rs.petcom.master.dal.Object)param.getValue()).getAddressID(), ObjectConfigControllerTrgovina.this.controller.getSettings().getConnection())).name("Address").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.columnCity.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<rs.petcom.master.dal.Object, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<rs.petcom.master.dal.Object, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Address.getByID(((rs.petcom.master.dal.Object)param.getValue()).getAddressID(), ObjectConfigControllerTrgovina.this.controller.getSettings().getConnection())).name("City").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tableObject.setItems(this.objectList);
    }
}

