/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.person.Address;

public class ObjectConfigController
implements ControlledScreen {
    ScreensController controller;
    ObservableList<Object> objectList = FXCollections.observableArrayList();
    Object selectedObject;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfCompanyName;
    @FXML
    private TextField tfCode;
    @FXML
    private TextField tfPIB;
    @FXML
    private TextField tfMB;
    @FXML
    private TextField tfBankAccount;
    @FXML
    private TextField tfBank;
    @FXML
    private TextField tfAddress;
    @FXML
    private TextField tfCity;
    @FXML
    private TextField tfState;
    @FXML
    private TextField tfZIP;
    @FXML
    private TextField tfMunicipality;
    @FXML
    private CheckBox cbActive;
    @FXML
    private TableView<Object> tableObject;
    @FXML
    private TableColumn<Object, Integer> tcID;
    @FXML
    private TableColumn<Object, String> tcName;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        this.loadObjectList();
        if (this.controller.getVrstaPrograma() == 4) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/master/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/master/css/trgovina/tabpaneTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/master/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(java.lang.Object parameter) {
    }

    @Override
    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcID.setCellValueFactory((Callback)new PropertyValueFactory("ObjectID"));
        this.tableObject.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedObject = newValue;
            this.fillObjectData();
        });
    }

    @FXML
    public void objectCommit(ActionEvent event) {
        if (this.selectedObject != null) {
            this.selectedObject.setName(this.tfName.getText());
            this.selectedObject.setCode(this.tfCode.getText());
            this.selectedObject.setPIB(this.tfPIB.getText());
            this.selectedObject.setMB(this.tfMB.getText());
            this.selectedObject.setBankAccount(this.tfBankAccount.getText());
            this.selectedObject.setBank(this.tfBank.getText());
            Address adresa = Address.getByID(this.selectedObject.getAddressID(), this.controller.getSettings().getConnection());
            adresa.setAddress(this.tfAddress.getText());
            adresa.setCity(this.tfCity.getText());
            adresa.setState(this.tfState.getText());
            adresa.setZip(this.tfZIP.getText());
            adresa.setMunicipality(this.tfMunicipality.getText());
            adresa.update(this.controller);
            this.selectedObject.setActive(this.cbActive.isSelected());
            this.selectedObject.update(this.controller);
        }
        this.emptyObjectData();
        this.loadObjectList();
        this.fillObjectData();
    }

    private void loadObjectList() {
        this.objectList = Object.getList(this.controller.getSettings().getConnection());
        this.tableObject.setItems(this.objectList);
    }

    private void fillObjectData() {
        if (this.selectedObject != null) {
            this.tfName.setText(this.selectedObject.getName());
            this.tfCompanyName.setText(CompanyConfig.getByID(this.selectedObject.getCompanyConfigID(), this.controller).getName());
            this.tfCode.setText(this.selectedObject.getCode());
            this.tfPIB.setText(this.selectedObject.getPIB());
            this.tfMB.setText(this.selectedObject.getMB());
            this.tfBankAccount.setText(this.selectedObject.getBankAccount());
            this.tfBank.setText(this.selectedObject.getBank());
            Address adresa = Address.getByID(this.selectedObject.getAddressID(), this.controller.getSettings().getConnection());
            this.tfAddress.setText(adresa.getAddress());
            this.tfCity.setText(adresa.getCity());
            this.tfState.setText(adresa.getState());
            this.tfZIP.setText(adresa.getZip());
            this.tfMunicipality.setText(adresa.getMunicipality());
            this.cbActive.setSelected(this.selectedObject.isActive());
        }
    }

    private void emptyObjectData() {
        try {
            this.tfName.setText("");
            this.tfCompanyName.setText("");
            this.tfCode.setText("");
            this.tfPIB.setText("");
            this.tfMB.setText("");
            this.tfBankAccount.setText("");
            this.tfBank.setText("");
            this.tfAddress.setText("");
            this.tfCity.setText("");
            this.tfState.setText("");
            this.tfZIP.setText("");
            this.tfMunicipality.setText("");
            this.cbActive.setSelected(false);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

