/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.controller.backoffice;

import java.time.LocalDate;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.LogRecordModel;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;

public class LogRecordController
implements ControlledScreen {
    private ScreensController controller;
    private HashMap<String, Object> hMap;
    private LogRecordModel logRecord;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dpDateFrom;
    @FXML
    private DatePicker dpDateTo;
    @FXML
    private TableView<LogRecordModel> tblLogRecord;
    @FXML
    private TableColumn<LogRecordModel, String> colLogRecordDate;
    @FXML
    private TableColumn<LogRecordModel, String> colLogRecordUserName;
    @FXML
    private TableColumn<LogRecordModel, String> colLogRecordDescription;

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @Override
    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @Override
    public void setParameter(Object parameter) {
        this.hMap = (HashMap)parameter;
        this.logRecord = new LogRecordModel(this.controller);
        this.dpDateFrom.setValue((Object)this.initialDateForDatePicker());
        this.dpDateTo.setValue((Object)this.initialDateForDatePicker());
        this.dpDateFrom.valueProperty().addListener((observable, oldValue, newValue) -> this.loadTable());
        this.dpDateTo.valueProperty().addListener((observable, oldValue, newValue) -> this.loadTable());
        this.colLogRecordDate.setCellValueFactory((Callback)new PropertyValueFactory("logRecordDateTime"));
        this.colLogRecordUserName.setCellValueFactory((Callback)new PropertyValueFactory("userName"));
        this.colLogRecordDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.loadTable();
    }

    @Override
    public Object getParameter() {
        return null;
    }

    private LocalDate initialDateForDatePicker() {
        return Settings.fromDate(WorkDay.getLastOpenWD(this.controller).getDate());
    }

    private void loadTable() {
        LocalDate dateFrom = (LocalDate)this.dpDateFrom.getValue();
        LocalDate dateTo = (LocalDate)this.dpDateTo.getValue();
        ObservableList<LogRecordModel> logRecordsList = this.logRecord.getLogRcordsBetweenDates(dateFrom, dateTo);
        this.tblLogRecord.getItems().clear();
        this.tblLogRecord.setItems(logRecordsList);
    }
}

